/*
		       Endeavour Data Types & Enums
 */

#ifndef EDVTYPES_H
#define EDVTYPES_H

#include <glib.h>


/*
 *	Object Types:
 */
typedef enum {
	EDV_OBJECT_TYPE_UNKNOWN			= 0,
	EDV_OBJECT_TYPE_FILE			= 1,
	EDV_OBJECT_TYPE_DIRECTORY		= 2,
	EDV_OBJECT_TYPE_LINK			= 3,
	EDV_OBJECT_TYPE_DEVICE_BLOCK		= 4,
	EDV_OBJECT_TYPE_DEVICE_CHARACTER	= 5,
	EDV_OBJECT_TYPE_FIFO			= 6,
	EDV_OBJECT_TYPE_SOCKET			= 7
} edv_object_type;

/*
 *	Permission Flags:
 */
typedef enum {
	EDV_PERMISSION_UEXECUTE		= (1 << 0),
	EDV_PERMISSION_UREAD		= (1 << 1),
	EDV_PERMISSION_UWRITE		= (1 << 2),

	EDV_PERMISSION_GEXECUTE		= (1 << 3),
	EDV_PERMISSION_GREAD		= (1 << 4),
	EDV_PERMISSION_GWRITE		= (1 << 5),

	EDV_PERMISSION_AEXECUTE		= (1 << 6),
	EDV_PERMISSION_AREAD		= (1 << 7),
	EDV_PERMISSION_AWRITE		= (1 << 8),

	EDV_PERMISSION_SETUID		= (1 << 9),
	EDV_PERMISSION_SETGID		= (1 << 10),
	EDV_PERMISSION_STICKY		= (1 << 11)
} edv_permission_flags;


/*
 *	Operation ID Flags:
 */
typedef enum {
	EDV_OPID_ALLOW_MULTIPLE		= (1 << 0),	/* Allow more than one
							 * per bar */
	EDV_OPID_NO_OP			= (1 << 1)	/* Does not perform an
							 * operation (ie
							 * separators) */
} edv_opid_flags;


/*
 *	Delete Methods:
 */
typedef enum {
	EDV_DELETE_METHOD_MOVE_TO_RECBIN	= 0,
	EDV_DELETE_METHOD_PURGE			= 1
} edv_delete_method;


/*
 *	MIME Type Classes:
 */
typedef enum {
	EDV_MIMETYPE_CLASS_SYSTEM	= 0,	/* System object type */
	EDV_MIMETYPE_CLASS_FORMAT	= 1,	/* File format */
	EDV_MIMETYPE_CLASS_PROGRAM      = 2,	/* Program object */
	EDV_MIMETYPE_CLASS_UNIQUE       = 3	/* Unique object */
} edv_mimetype_class;


/*
 *	MIME Type Handlers:
 */
typedef enum {
	EDV_MIMETYPE_HANDLER_COMMAND		= 0,	/* Use Command */
	EDV_MIMETYPE_HANDLER_EDV_ARCHIVER	= 1,	/* Use Archiver */
	EDV_MIMETYPE_HANDLER_EDV_IMAGE_BROWSER	= 2,	/* Use Image Browser */
	EDV_MIMETYPE_HANDLER_EDV_RECYCLE_BIN	= 3	/* Use Recycle Bin */
} edv_mimetype_handler;


/*
 *	History types:
 */
typedef enum {
	EDV_HISTORY_UNKNOWN			= 0,
	EDV_HISTORY_SYNC_DISKS			= 1,
	EDV_HISTORY_SYNC_RECBIN			= 2,

	EDV_HISTORY_DISK_OBJECT_CREATE		= 10,
	EDV_HISTORY_DISK_OBJECT_COPY		= 11,
	EDV_HISTORY_DISK_OBJECT_MOVE		= 12,	/* Or rename */
	EDV_HISTORY_DISK_OBJECT_LINK		= 13,
	EDV_HISTORY_DISK_OBJECT_CHOWN		= 14,
	EDV_HISTORY_DISK_OBJECT_CHMOD		= 15,
	EDV_HISTORY_DISK_OBJECT_DATE		= 16,
	EDV_HISTORY_DISK_OBJECT_DOWNLOAD	= 17,
	EDV_HISTORY_DISK_OBJECT_DELETE		= 18,

	EDV_HISTORY_RECYCLED_OBJECT_RECOVER	= 20,
	EDV_HISTORY_RECYCLED_OBJECT_PURGE	= 21,
	EDV_HISTORY_RECYCLED_OBJECT_PURGE_ALL	= 22,

	EDV_HISTORY_ARCHIVE_OBJECT_ADD		= 30,
	EDV_HISTORY_ARCHIVE_OBJECT_EXTRACT	= 31,
	EDV_HISTORY_ARCHIVE_OBJECT_DELETE	= 32
} edv_history_type;


#endif	/* EDVTYPES_H */
