/*
			      Keymap List
 */

#ifndef KEYMAPLIST_H
#define KEYMAPLIST_H

#include <gtk/gtk.h>


typedef struct _keymap_key_struct		keymap_key_struct;
typedef struct _keymap_list_struct		keymap_list_struct;


/*
 *	Flags:
 */
typedef enum {
	KEYMAP_LIST_EDITABLE			= (1 << 0),
	KEYMAP_LIST_AUTO_CHECK_CONFLICTS	= (1 << 1),
	KEYMAP_LIST_CONFIRM_SET_DEFAULT_KEYS	= (1 << 2)
} keymap_list_flags;


/*
 *	Keymap Key:
 */
struct _keymap_key_struct {

	guint		keyval,		/* Key value */
			state;		/* Modifiers */

	gpointer	data;		/* User data */

};
#define KEYMAP_KEY(p)	((keymap_key_struct *)(p))


/*
 *	Keymap List:
 */
struct _keymap_list_struct {

	GtkWidget	*toplevel,		/* GtkBox */
			*clist,
			*buttons_box,
			*value_entry,
			*scan_btn,
			*clear_btn,
			*check_conflicts_btn,
			*defaults_btn;

	keymap_list_flags	flags;
	GtkOrientation	orientation;

	/* Called whenever a Keymap Key is set, cleared, or set to
	 * default value
	 */
	void		(*changed_cb)(
		keymap_list_struct *,	/* Keymap List */
		gpointer		/* Data */
	);
	gpointer	changed_data;

	/* Called whenever a Keymap Key has been set */
	void		(*key_set_cb)(
		keymap_list_struct *,	/* Keymap List */
		keymap_key_struct *,	/* Keymap Key */
		gpointer		/* Data */
	);
	gpointer	key_set_data;

	/* Called whenever a Keymap Key has been cleared */
	void		(*key_cleared_cb)(
		keymap_list_struct *,	/* Keymap List */
		keymap_key_struct *,	/* Keymap Key */
		gpointer		/* Data */
	);
	gpointer	key_cleared_data;

	/* Called to request default key value for the specified Keymap
	 * Key, the function should update the specified key
	 */
	void		(*key_default_request_cb)(
		keymap_list_struct *,	/* Keymap List */
		keymap_key_struct *,	/* Keymap Key */
		gpointer		/* Data */
	);
	gpointer	key_default_request_data;

};
#define KEYMAP_LIST(p)		((keymap_list_struct *)(p))


/* Operations */
extern void KeymapListScanKey(keymap_list_struct *kmlist, gint row);
extern void KeymapListClearKey(keymap_list_struct *kmlist, gint row);
extern void KeymapListSetDefaultKeys(keymap_list_struct *kmlist);
extern void KeymapListCheckConflicts(keymap_list_struct *kmlist);


/* Keymap Key */
extern keymap_key_struct *KeymapKeyNew(
	guint keyval, guint state, gpointer data
);
extern keymap_key_struct *KeymapKeyCopy(keymap_key_struct *km);
extern void KeymapKeyDelete(keymap_key_struct *km);


/* Keymap List */
extern keymap_list_struct *KeymapListNew(
	GtkWidget *parent,
	GtkOrientation orientation
);
extern void KeymapListSetEditable(
	keymap_list_struct *kmlist, gboolean editable
);
extern void KeymapListSetAutoCheckConflicts(
	keymap_list_struct *kmlist, gboolean check
);
extern void KeymapListSetOrientation(
	keymap_list_struct *kmlist, GtkOrientation orientation
);
extern void KeymapListSetChangedCB(
	keymap_list_struct *kmlist,
	void (*cb)(keymap_list_struct *, gpointer),
	gpointer data
);
extern void KeymapListSetKeySetCB(
	keymap_list_struct *kmlist,
	void (*cb)(keymap_list_struct *, keymap_key_struct *, gpointer),
	gpointer data
);
extern void KeymapListSetKeyClearedCB(
	keymap_list_struct *kmlist,
	void (*cb)(keymap_list_struct *, keymap_key_struct *, gpointer),
	gpointer data
);
extern void KeymapListSetKeyDefaultRequestCB(
	keymap_list_struct *kmlist,
	void (*cb)(keymap_list_struct *, keymap_key_struct *, gpointer),
	gpointer data
);
extern gint KeymapListInsert( 
	keymap_list_struct *kmlist, gint row,
	guint8 **icon_data, const gchar *name,
	keymap_key_struct *km			/* Shared */
);
extern gint KeymapListAppend(
	keymap_list_struct *kmlist,
	guint8 **icon_data, const gchar *name,
	keymap_key_struct *km			/* Shared */
);
extern void KeymapListSet(
	keymap_list_struct *kmlist, gint row,
	guint8 **icon_data, const gchar *name,
	keymap_key_struct *km			/* Shared */
);
extern void KeymapListSetKey(
	keymap_list_struct *kmlist, gint row,
	keymap_key_struct *km			/* Shared */
);
extern void KeymapListClear(keymap_list_struct *kmlist);
extern keymap_key_struct *KeymapListGet(
	keymap_list_struct *kmlist, gint row
);
extern void KeymapListUpdateWidgets(keymap_list_struct *kmlist);
extern void KeymapListMap(keymap_list_struct *kmlist);
extern void KeymapListUnmap(keymap_list_struct *kmlist);
extern void KeymapListDelete(keymap_list_struct *kmlist);


#endif	/* KEYMAPLIST_H */
