/*
                          File Operation Dialog

	Used for the querying of copying, moving, linking, chowning,
	and changing permissions of files.
 */

#ifndef FOPDLG_H
#define FOPDLG_H

#include <gtk/gtk.h>
#include "edvtypes.h"
#include "edvobj.h"


/*
 *	Operations:
 */
typedef enum {
	EDV_FOPDLG_OP_MOVE		= 0,
	EDV_FOPDLG_OP_COPY		= 1,
	EDV_FOPDLG_OP_LINK		= 2,
	EDV_FOPDLG_OP_CHMOD		= 3,
	EDV_FOPDLG_OP_CHOWN		= 4
} edv_fopdlg_op;

/*
 *	File Operation Dialog:
 */
typedef struct _edv_fopdlg_struct	edv_fopdlg_struct;
struct _edv_fopdlg_struct {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gboolean	processing;
	gint		busy_count,
			freeze_count;
	gpointer	core_ptr;

	GtkWidget	*main_vbox,
			*icon_fixed,
			*icon_pm,
			*label,			/* Describing source objects */

			*target_entry,		/* For move, copy, and link destinations */

			*target_browse_btn,

			*target_chmod_parent,	/* Parent containing chmode check widgets */
			*target_uread_check,
			*target_uwrite_check,
			*target_uexecute_check,
			*target_gread_check,
			*target_gwrite_check,
			*target_gexecute_check,
			*target_aread_check,
			*target_awrite_check,
			*target_aexecute_check,
			*target_setuid_check,
			*target_setgid_check,
			*target_sticky_check,

			*target_chown_parent,	/* Parent containing chown widgets */
			*target_owner_entry,	/* For chowning */
			*target_owner_btn,
			*target_group_entry,
			*target_group_btn,

			*move_btn,
			*copy_btn,
			*link_btn,
			*chmod_btn,
			*chown_btn,

			*cancel_btn;

	/* Reference toplevel for transiency, shared */
	GtkWidget	*ref_toplevel;

	/* Operation that we are querying values for */
	edv_fopdlg_op	op;

	/* Source list of objects */
	edv_object_struct	**src_obj;
	gint			src_obj_total;

	/* Source directory (relative/current location) */
	gchar		*src_dir;

};
#define EDV_FOPDLG(p)		((edv_fopdlg_struct *)(p))


extern edv_fopdlg_struct *EDVFOPDlgNew(gpointer core_ptr);
extern void EDVFOPDlgReset(edv_fopdlg_struct *d);
extern void EDVFOPDlgSetBusy(edv_fopdlg_struct *d, gboolean is_busy);
extern gboolean EDVFOPDlgIsMapped(edv_fopdlg_struct *d);
extern void EDVFOPDlgMapValues(
	edv_fopdlg_struct *d,
	edv_fopdlg_op op,	/* One of EDV_FOPDLG_OP_* */
	edv_object_struct **src_obj,	/* Source list, will be coppied */
	gint src_obj_total,
	const gchar *src_dir,
	GtkWidget *toplevel
);
extern void EDVFOPDlgUnmap(edv_fopdlg_struct *d);
extern void EDVFOPDlgDelete(edv_fopdlg_struct *d);


#endif	/* FOPDLG_H */
