/*
			Endeavour Archive Operations
 */

#ifndef EDVARCHOP_H
#define EDVARCHOP_H

#include <gtk/gtk.h>
#include "endeavour.h"


extern const gchar *EDVArchOPGetError();

extern gint EDVArchOPDelete(
	edv_core_struct *core_ptr,
	const gchar *arch_obj,
	edv_archive_object_struct *obj_stat,
	GtkWidget *toplevel,
	gboolean show_progress, gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVArchOPAdd(
	edv_core_struct *core_ptr, const gchar *arch_obj,
	gchar **tar_path, gint total_tar_paths,
	gchar ***new_obj_path, gint *total_new_obj_paths,
	GtkWidget *toplevel,
	gboolean show_progress, gboolean interactive, gboolean *yes_to_all,
	gboolean recursive, gint compression, gboolean dereference_links
);
extern gint EDVArchOPExtract(
	edv_core_struct *core_ptr,
	const gchar *arch_obj,
	edv_archive_object_struct **src_aobj, gint total_src_aobjs,
	const gchar *dest_path,
	gchar ***new_obj_rtn, gint *total_new_obj_rtns,
	GtkWidget *toplevel,
	gboolean show_progress, gboolean interactive, gboolean *yes_to_all,
	gboolean preserve_directories,
	gboolean preserve_timestamps
);


#endif	/* EDVARCHOP_H */
