/*
			       Zip Tools IO
 */

#ifndef ZIPTOOLSIO_H
#define ZIPTOOLSIO_H

#include <glib.h>
#include "../lib/endeavour2.h"


/*
 *      Zip Tool Lock States:
 */
typedef enum {
	ZIP_TOOL_LOCK_STATE_UNLOCKED,
	ZIP_TOOL_LOCK_STATE_LOCKED,
	ZIP_TOOL_LOCK_STATE_LOCKED_PASSWORD
} zip_tool_lock_state;


extern gchar *ZipToolLastError(void);

extern gint ZipToolMount(edv_device_struct *dev_ptr);
extern gint ZipToolUnmount(edv_device_struct *dev_ptr);
extern zip_tool_lock_state ZipToolDeviceIsProtected(
	edv_device_struct *dev_ptr
);
extern gint ZipToolLock(
	edv_device_struct *dev_ptr, const gchar *password
);
extern gint ZipToolUnlock(
	edv_device_struct *dev_ptr, const gchar *password
);
extern gint ZipToolSpinDown(edv_device_struct *dev_ptr);
extern gint ZipToolEject(edv_device_struct *dev_ptr);

#endif	/* ZIPTOOLSIO_H */
