/*
 *	Displays the properties of an object using Endeavour's
 *	Properties Dialog.
 */

#include <string.h>
#include <errno.h>
#include <sys/stat.h>
#include <glib.h>
#include <endeavour2.h>

int main(int argc, char *argv[])
{
	gint status;
	edv_context_struct *ctx = EDVContextNew();
	EDVContextLoadConfigurationFile(ctx, NULL);

	if(argc > 1)
	{
	    const gchar	*path = argv[1],
			*page_name = (argc > 2) ? argv[2] : NULL;
	    struct stat lstat_buf;

	    /* Check if object exists locally */
	    if(!lstat(path, &lstat_buf))
	    {
		/* Map the Properties Dialog for the object specified
		 * by path
		 */
		EDVWindowPropertiesDialogNewWithPage(
		    ctx,		/* Context */
		    path,		/* Object Path */
		    page_name		/* Page Name */
		);
		status = 0;
	    }
	    else
	    {
		/* Unable to stat object locally */
		const gchar *s = strerror(errno);
		if(s == NULL)
		    s = "No such file";
		g_printerr("%s: %s.\n", path, s);
		status = 1;
	    }
	}
	else
	{
	    g_print("Usage: %s <path> [page_name]\n", argv[0]);
	    status = 0;
	}

	EDVContextSync(ctx);
	EDVContextDelete(ctx);

	return(status);
}
