/*
 *                          GDK RGB Buffer Blitting
 */

#ifndef BLITTING_H
#define BLITTING_H

#include <glib.h>


/*
 *	Pixel op codes:
 */
#define BLIT_PIXEL_OP_SET			0
#define BLIT_PIXEL_OP_SET_ALPHA			1
#define BLIT_PIXEL_OP_ALPHA			2
#define BLIT_PIXEL_OP_ADD			3
#define BLIT_PIXEL_OP_SUBTRACT			4
#define BLIT_PIXEL_OP_BLEND			5
#define BLIT_PIXEL_OP_MULTIPLY			6


extern void BlitClearRGBA(
	gint pixel_op,
	guint32 *tar, gint tar_width, gint tar_height, gint tar_bpl,
	guint32 v
);
extern void BlitImageScaleRGBA(
	gint pixel_op,
	guint32 *tar,
	gint tar_x, gint tar_y, gint tar_width, gint tar_height,
	gint tar_bpl,
	const guint32 *src,
	gint src_x, gint src_y, gint src_width, gint src_height,
	gint src_bpl,
	gfloat zoom_x, gfloat zoom_y	/* Applied to src size */
);


#endif	/* BLITTING_H */
