(* This file is part of EdiTeX, an editor of mathematical
 * expressions based on TeX syntax.
 * 
 * Copyright (C) 2002-2003 Luca Padovani <lpadovan@cs.unibo.it>,
 *                    2003 Paolo Marinelli <pmarinel@cs.unibo.it>.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the project's home page
 * http://helm.cs.unibo.it/editex/
 * or send an email to <lpadovan@cs.unibo.it>
 *)

val default_dictionary_path : string
val default_mathml_stylesheet_path : string
val default_tex_stylesheet_path : string

val create :
  ?alt_lexer:bool ->
  dictionary_uri: string ->
  mml_uri: string ->
  tml_uri: string ->
  log:(int -> string -> unit) -> I_mathml_editor.t

val freeze : editor:I_mathml_editor.t -> bool
val thaw : editor:I_mathml_editor.t -> bool

val reset : editor:I_mathml_editor.t -> unit
val push : editor:I_mathml_editor.t -> ch:char -> unit
val drop : editor:I_mathml_editor.t -> alt:bool -> unit

val cursor_hide : editor:I_mathml_editor.t -> unit
val cursor_show : editor:I_mathml_editor.t -> unit

val get_tex : editor:I_mathml_editor.t -> string
val get_tml : editor:I_mathml_editor.t -> Gdome.document
val get_mml : editor:I_mathml_editor.t -> Gdome.document

