/* This file is part of EdiTeX, an editor of mathematical
 * expressions based on TeX syntax.
 * 
 * Copyright (C) 2002-2003 Luca Padovani <lpadovan@cs.unibo.it>,
 *                    2003 Paolo Marinelli <pmarinel@cs.unibo.it>.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the project's home page
 * http://helm.cs.unibo.it/editex/
 * or send an email to <lpadovan@cs.unibo.it>
 */

#ifndef __TDocument_hh__
#define __TDocument_hh__

#include "dom.hh"
#include "TNode.hh"

class TDocument : private DOM::EventListener
{
public:
  TDocument(void);
  ~TDocument();

  void  reset(void);
  TNode create(const std::string&, unsigned = 0) const;
  TNode createG(unsigned id = 0) const { return create("g", id); };
  TNode createC(const std::string&, unsigned = 0) const;
  TNode createT(const std::string&, const std::string&, unsigned = 0) const;
  TNode createI(const std::string& text, unsigned id = 0) const { return createT("i", text, id); };
  TNode createN(const std::string& text, unsigned id = 0) const { return createT("n", text, id); };
  TNode createO(const std::string& text, unsigned id = 0) const { return createT("o", text, id); };
  TNode createS(unsigned id = 0) const { return createT("s", "", id); };

  DOM::Document document(void) const { return doc; };

  TNode getNodeById(unsigned) const;
  TNode root(void) { return doc.get_documentElement(); };
  TNode dirtyNode(void) const { return dirty; };
  void  clearDirty(void) { dirty = DOM::Element(0); };

  void  serialize(const char*) const;

private:
  DOM::Document doc;
  DOM::Element dirty;

  virtual void handleEvent(const DOM::Event&);
  static std::string makeId(unsigned);
  static TNode getNodeByIdAux(const TNode&, const std::string&);
  static unsigned nodeDepth(const DOM::Node&);
  static DOM::Node findCommonAncestor(const DOM::Node&, const DOM::Node&);
  static DOM::Node findIdNode(const DOM::Node&);
};

#endif // __TDocument_hh__
