/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

/*******************************************************************************
 Esta funcion inicializa unas cuantas variables globales usadas durante la busqueda
 *******************************************************************************/
void buscar_inicializar(void)
{
	buscar_indice = 0;
	buscar_buscando=FALSE;
	buscar_terminado=FALSE;
}

/*******************************************************************************
 Esta funcion muestra la bentana de busqueda y pone en en la entrada
 de busqueda el texto seleccionado
 *******************************************************************************/
void buscar_buscar(void)
{
	GtkWidget *ventana,*boton;
	GtkTextBuffer *buffer;
	gchar *seleccion;
	GtkEntry *buscar;
	GtkTextIter start_pos, end_pos;

	if ((!buscar_buscando) && (proyecto.xml!=NULL) && ((edit_actual!=NULL) || (ejecutables.grep))) {
		ventana=glade_xml_get_widget(buscar_ventana,"buscar_ventana");
		if (edit_actual!=NULL) {
			boton=glade_xml_get_widget(buscar_ventana,"boton_buscar_current_file");
			gtk_widget_set_sensitive(boton,TRUE);
			if (!ejecutables.grep) {
				boton=glade_xml_get_widget(buscar_ventana,"boton_buscar_multiple_files");
				gtk_widget_set_sensitive(boton,FALSE);
			}
			buffer=GTK_TEXT_BUFFER(edit_actual->datos);
			if (gtk_text_buffer_get_selection_bounds(buffer, &start_pos, &end_pos)) {
				seleccion=gtk_text_buffer_get_text(buffer,&start_pos,&end_pos, FALSE);
				buscar=GTK_ENTRY(glade_xml_get_widget(buscar_ventana,"buscar_entrada"));
				if (seleccion != NULL) {
					gtk_entry_set_text(buscar,seleccion);
					g_free(seleccion);
					gtk_widget_grab_focus(glade_xml_get_widget(buscar_ventana,"buscar_boton"));
				} else {
					gtk_widget_grab_focus(GTK_WIDGET(buscar));
				}
			}
		} else {
			boton=glade_xml_get_widget(buscar_ventana,"boton_buscar_multiple_files");
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(boton),TRUE);
			boton=glade_xml_get_widget(buscar_ventana,"boton_buscar_current_file");
			gtk_widget_set_sensitive(boton,FALSE);
			gtk_widget_grab_focus(glade_xml_get_widget(buscar_ventana,"buscar_entrada"));
		}

		gtk_widget_show(ventana);
		buscar_indice=0;
		edit_actualizar();
		buscar_buscando=TRUE;
		buscar_terminado=FALSE;
	}
}

/*******************************************************************************
 Realiza la busqueda de la siguiente coincidencia en el texto
 *******************************************************************************/
void buscar_siguiente(GtkWidget *widget)
{
	GtkEntry *entrada;
	GtkWidget *fuente,*boton;
	GtkTextMark *cursor_position_mark;
	GtkTextIter cursor_position_iter;
	GtkTextIter selection_start;
	GtkTextIter selection_end;
	GtkTextMark *selection_mark;
	gchar *texto;
	GtkTextBuffer *buffer;
	gboolean text_found = FALSE;
	gboolean case_sensitive = FALSE;

	buffer=GTK_TEXT_BUFFER(edit_actual->datos);
	entrada=GTK_ENTRY(glade_xml_get_widget(buscar_ventana,"buscar_entrada"));
	texto=gtk_editable_get_chars(GTK_EDITABLE(entrada),0,-1);
	fuente=glade_xml_get_widget(buscar_ventana,"sensibilidad_boton_busqueda");
	case_sensitive = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente));
	//Si la busqueda es "from cursor", no empezaria desde la posicion 0 sino 
	//desde la posicion actual
	if (estado_botones.from_cursor == TRUE) {
		cursor_position_mark = gtk_text_buffer_get_insert (buffer);
		gtk_text_buffer_get_iter_at_mark(buffer, &cursor_position_iter, cursor_position_mark);
	} else {
		gtk_text_buffer_get_start_iter(buffer, &cursor_position_iter);
		boton = glade_xml_get_widget(buscar_ventana,"cursor_boton_zona_busqueda");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(boton),TRUE);
	}	 
	if (case_sensitive) {
		if (estado_botones.forwards) {
			text_found = buscar_cadena_forward(buffer, &cursor_position_iter, NULL, texto, &selection_start, &selection_end, SENSIBLE_MAYUSCULAS);
		} else {
			text_found = buscar_cadena_backward(buffer,  NULL, &cursor_position_iter, texto, &selection_start, &selection_end, SENSIBLE_MAYUSCULAS);
		}
	} else {
		if (estado_botones.forwards) {
			text_found = buscar_cadena_forward(buffer, &cursor_position_iter, NULL, texto, &selection_start, &selection_end, 0);
		} else {
			text_found = buscar_cadena_backward(buffer,  NULL, &cursor_position_iter, texto, &selection_start, &selection_end, 0);
		}
	}
	if (text_found == TRUE) {
		buscar_indice= gtk_text_iter_get_offset(&selection_end);
		cursor_position_mark = gtk_text_buffer_create_mark(buffer, NULL, &selection_end, TRUE);
		gtk_text_view_scroll_to_mark(GTK_TEXT_VIEW(edit_actual->editor), cursor_position_mark, 0, TRUE, 1,0.5);
		gtk_text_buffer_get_iter_at_mark(buffer,&cursor_position_iter ,cursor_position_mark);
		gtk_text_buffer_place_cursor(buffer, &cursor_position_iter);
		gtk_text_buffer_delete_mark(buffer, cursor_position_mark);
		edit_actualizar_fila();
		selection_mark = gtk_text_buffer_get_selection_bound(buffer);
		gtk_text_buffer_move_mark(buffer, selection_mark, &selection_start);
	} else {
		buscar_terminado=TRUE;
	}
	g_free(texto);
}

/*******************************************************************************
 Busca la siguiente coincidencia y la reemplaza
 *******************************************************************************/
void buscar_reemplazar(GtkWidget *widget)
{
	GtkEntry *entrada;
	gchar *texto;
	GtkTextBuffer *buffer;
	gboolean selection_deleted = FALSE;

//	edit_actualizar();
	buffer=GTK_TEXT_BUFFER(edit_actual->datos);
	entrada=GTK_ENTRY(glade_xml_get_widget(buscar_ventana,"reemplazar_entrada"));
	texto=gtk_editable_get_chars(GTK_EDITABLE(entrada),0,-1);

	widget = gtk_widget_get_toplevel(widget);
	buscar_siguiente(widget);

	selection_deleted = gtk_text_buffer_delete_selection(buffer, TRUE, TRUE);
	if ((selection_deleted) && (!buscar_terminado)) {
		buscar_indice--;
		gtk_text_buffer_insert_at_cursor(buffer, texto, -1);
	}
	g_free(texto);
}

/*******************************************************************************
 Hace una busqueda por todo el texto y reemplaza las coincidencias
 *******************************************************************************/
void buscar_reemplazar_todo(GtkWidget *widget)
{
	do {
		buscar_reemplazar(widget);
	} while (!buscar_terminado);
}

/*************************************************************************************
 Esta funcion busca un nodo como hijo de otro nodo que se le pasa como
parametro y te devuelve un puntero a ese nodo, o NULL en caso de que no exista
**************************************************************************************/
xmlNodePtr buscar_nodo_xml (xmlNodePtr padre, gchar *nombre_nodo)
{ 
	xmlNodePtr nodo = NULL;
	
	if (padre != NULL) {
		/*Nos situamos en el primer hijo*/
		nodo = padre->xmlChildrenNode;
		while (nodo != NULL) {
			if (!strcmp (nodo->name, nombre_nodo))
				return nodo;
			else 
				nodo = nodo->next;
		}
	}
	return nodo;
}

/***********************************************************************************************
Esta funcion realiza la busqueda de un texto introducido por el usuario por los 
ficheros elegidos por el usuario en la ventana de busqueda. Presenta los resultados
en la ventana de mensajes y cierra la ventana de busqueda.
**********************************************************************************************/
int buscar_busqueda(GtkWidget *ventana_busqueda)
{
	GtkEntry *entrada;
	GtkWidget *widget;
	gchar *texto_escapado, *comando, *archivos, *tmp;
	gchar *nombre, *nombre_completo, *lista_others = NULL, *lista_others_tmp = NULL;
	gboolean estado;
	xmlNodePtr xmlnode;
	gsize bytes_read, bytes_written;
	GError *error;
	G_CONST_RETURN char *locale;

	//Recogemos el texto a buscar y las opciones de busqueda
	//Guardamos la cadena de busqueda en una variable global para usarla desde
	//otras partes
	if (texto_busqueda_actual != NULL)
		g_free(texto_busqueda_actual);
	entrada = GTK_ENTRY(glade_xml_get_widget(buscar_ventana,"buscar_entrada"));
	texto_busqueda_actual = gtk_editable_get_chars(GTK_EDITABLE(entrada),0,-1);
	//case sensitive
	widget = glade_xml_get_widget(buscar_ventana,"sensibilidad_boton_busqueda");
	estado_botones.sensitive = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
	//archivo actual o multiples archivos
	widget = glade_xml_get_widget(buscar_ventana,"boton_buscar_current_file");
	estado = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
	estado_botones.current = estado;
	estado_botones.multiple = (!estado);
	widget = glade_xml_get_widget (buscar_ventana, "boton_buscar_forwards");
	estado = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
	estado_botones.forwards = estado;
	estado_botones.backwards = (!estado);	
	if (estado_botones.current) { //Archivo actual
		widget = glade_xml_get_widget(buscar_ventana,"todo_boton_zona_busqueda");
		estado = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
		estado_botones.all_document = estado;
		estado_botones.from_cursor = (!estado);
		//Buscamos con el codigo viejo
		buscar_siguiente(ventana_busqueda);
		if (buscar_terminado) {
			edit_mensaje(_("No more maches."));
		}
	} else { //multiples archivos
		//activamos el flag de busqueda
		widget = glade_xml_get_widget(buscar_ventana,"boton_buscar_all_sources");
		estado_botones.sources = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
		widget = glade_xml_get_widget(buscar_ventana,"boton_buscar_all_headers");
		estado_botones.headers = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
		widget = glade_xml_get_widget(buscar_ventana,"boton_buscar_all_others");
		estado_botones.others = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
		//Generamos el comando GREP para realizar la busqueda, comprobando que se haya elegido
		//algun grupo de ficheros
		if ((!estado_botones.sources) && (!estado_botones.headers) && (!estado_botones.others))	{
			//avisar al usuario que tiene que elegir un grupo por lo menos
			return (-1);
		}
		//Generamos la lista de archivos en los que buscar
		archivos = g_strdup("");
		if (estado_botones.sources) { 
			g_free(archivos);
			archivos = g_strconcat ("*.c *.cpp *.c++ *.cc ",NULL);
		}		
		if (estado_botones.headers) {
			tmp =g_strdup(archivos);
			g_free(archivos);
			archivos = g_strconcat (tmp,"*.h *.hh ",NULL);
			g_free(tmp);
		}
		if (estado_botones.others) {
			tmp = g_strdup(archivos);
			g_free(archivos);
			xmlnode = buscar_nodo_xml(proyecto.xml->xmlRootNode, "otros");
			if (xmlnode != NULL) {
				//Nos situamos en el primer hijo
				xmlnode = xmlnode->xmlChildrenNode;
				if (xmlnode != NULL) {
					do {  //concatenamos todos los nombres de archivos de OTHERS
						nombre = xmlNodeGetContent (xmlnode);
						nombre_completo = pro_nombre_completo_archivo(nombre, FALSE, LOCALE);
						if (lista_others != NULL) {   //el primer elemento no pasa por aqui
							lista_others_tmp = g_strdup(lista_others);
							g_free(lista_others);
							lista_others = g_strconcat(lista_others_tmp," ", nombre_completo, NULL);
						} else {
							lista_others = g_strconcat(nombre_completo, NULL);
						}
						g_free(nombre);
						g_free(nombre_completo);
						if (lista_others_tmp != NULL)
							g_free(lista_others_tmp);
						xmlnode = xmlnode->next;
					} while (xmlnode != NULL);
				} //fin del if
			} //fin del if
			archivos = g_strconcat (tmp, lista_others, NULL);
			g_free(tmp);
			g_free(lista_others);
		}			
		//texto_busqueda_actual is UTF-8, but the files have locale charset, so we must convert it before passing
		//it to grep.
		g_get_charset(&locale);
		tmp = texto_busqueda_actual;
		texto_busqueda_actual = g_convert(tmp, strlen(tmp), locale, "UTF-8", &bytes_read, &bytes_written, &error);
		g_free(tmp);
		//"escapamos" la cadena a buscar, para que no tenga caracteres con un significado especial para GREP
		texto_escapado = buscar_escapar_cadena_grep (texto_busqueda_actual);
		g_print(_("Searching for: %s"),texto_busqueda_actual);
		if (estado_botones.sensitive)
			comando = g_strdup_printf ("grep -Hn '%s' %s\n", texto_escapado,archivos);
		else
			comando = g_strdup_printf ("grep -Hni '%s' %s\n", texto_escapado,archivos);
		//Cerramos la ventana de busqueda y mostramos la de mensajes
		gen_cerrar_ventana(ventana_busqueda);
		edit_mensaje("");
		widget=glade_xml_get_widget(david_ventana,"mensajes_togglebutton");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),TRUE);
		//Nos situamos en el directorio de los Sources
		tmp=pro_nombre_completo_archivo("cualquier_cosa.c",TRUE, UTF8);
		g_free(tmp);
		//Y ejecutamos el comando
		if (gen_comando(comando,NULL)==-1) {
			g_print(_("error\n"));
		} else {
			g_print(_("Search Finished\n"));
		}
		
		buscar_buscando = FALSE;
		g_free(comando);
		g_free(archivos);
		g_free(texto_escapado);
	}	
	return 0;
}

/******************************************************************************************
Esta funcion se encarga de "escapar" los metacaracteres que tienen un
significado especial para GREP al hacer una busqueda. Hay que liberar la
variable que devuelve cuando no se vaya a usar mas.
******************************************************************************************/
gchar *buscar_escapar_cadena_grep (char *cadena_original)
{
	gchar *cadena_escapada = NULL;
	guint cont = 0, cont_escapada = 0;
	guint numero_caracteres = 0;

	//Primero contamos el numero de caracteres especiales que tiene la cadena original
	while (cadena_original[cont] != '\0') {
		switch (cadena_original[cont]) {
			case '\'':
				  //este caso es especial 
				numero_caracteres = numero_caracteres +3;	
				break;
			case '[':
			case ']':
			case '.':
			case '$':
			case '\\':
			case '^':
			case '-':	
				numero_caracteres++;
				break;
		} //fin del switch
		cont++;
	} //fin del while 
	
	//reservamos memoria para la nueva cadena_escapada
	cadena_escapada = g_malloc(strlen(cadena_original)+numero_caracteres+1);
	
	//Y ahora gbuscar_nodo_xmleneramos la cadena_escapada
	cont = 0;
	while (cadena_original[cont] != '\0') {
		switch (cadena_original[cont]) {
			case '\'':
				cadena_escapada[cont_escapada++]='\'';
				cadena_escapada[cont_escapada++]='\\';
				cadena_escapada[cont_escapada++]='\'';
				cadena_escapada[cont_escapada] = cadena_original[cont];  
				break;
			case '[':
			case ']':
			case '.':
			case '$':
			case '\\':
			case '^':
			case '-':
				cadena_escapada[cont_escapada++] = '\\';
				cadena_escapada[cont_escapada] = cadena_original[cont];
				break;
			default:
				cadena_escapada[cont_escapada] = cadena_original[cont];
				break;
		}//fin del switch				
		cont++;
		cont_escapada++;
	}//fin del while
	//Por ultimo, le ponemos el '\0' a la cadena_escapada
	cadena_escapada[cont_escapada]='\0';

	return (cadena_escapada);
}

/* This function makes a forward search of cadena in buffer. limite_inicial and limite_final are de initial and final limits wher the search will	*
 * done. If NULL the function will search from the begeaning to the end of the buffer. If a mach is found it will return TRUE, and inicio	*
 * and fin will be the limits of the mach in the buffer in the way [inicio,fin). If not mach is found the function will return FALSE and		*
 * inicio and fin will point to the end of the buffer or limite_final. inicio and fin must be allocated before the function is called.				*/
gboolean buscar_cadena_forward(GtkTextBuffer *buffer,GtkTextIter *limite_inicial,GtkTextIter *limite_final,gchar *cadena,GtkTextIter *inicio,GtkTextIter *fin,gint flags)
{
	GtkTextIter sup,inf;
	gint cont;
	gunichar caracter;
	GtkTextIter posicion;
	gint offset;
	gchar *primero,*ultimo,*actual;
	gboolean cadena_encontrada;
	
	DEBUG_MSG(->buscar_cadena_forward);
	gtk_text_buffer_get_bounds(buffer,&sup,&inf);
	if (limite_inicial!=NULL) {
		memcpy(&sup,limite_inicial,sizeof(GtkTextIter));
	}
	if (limite_final!=NULL) {
		memcpy(&inf,limite_final,sizeof(GtkTextIter));
	}
	
	primero=cadena;
	for (cont=0;cadena[cont]!=0;cont++);
	ultimo=g_utf8_find_prev_char(cadena,&(cadena[cont]));
	actual=primero;
	cadena_encontrada=FALSE;
	memcpy(&posicion,&sup,sizeof(GtkTextIter));
	offset=gtk_text_iter_get_offset(&inf);
	while ((gtk_text_iter_get_offset(&posicion)!=offset) && (!cadena_encontrada)) {
		caracter=g_utf8_get_char(actual);
		if ((caracter==gtk_text_iter_get_char(&posicion)) & (flags & SENSIBLE_MAYUSCULAS)) {
			if (actual==ultimo) {
				cadena_encontrada=TRUE;
			} else {
				actual=g_utf8_find_next_char(actual,NULL);
			}
		} else {
			if ((g_unichar_tolower(caracter)==g_unichar_tolower(gtk_text_iter_get_char(&posicion))) & (!(flags & SENSIBLE_MAYUSCULAS))) {
				if (actual==ultimo) {
					cadena_encontrada=TRUE;
				} else {
					actual=g_utf8_find_next_char(actual,NULL);
				}
			} else {
				actual=primero;
			}
		}
		gtk_text_iter_forward_chars(&posicion,1);
	}
	
	if (cadena_encontrada) {
		memcpy(fin,&posicion,sizeof(GtkTextIter));
		memcpy(inicio,&posicion,sizeof(GtkTextIter));
		gtk_text_iter_backward_chars(inicio,g_utf8_strlen(cadena,-1));
		DEBUG_MSG(<-buscar_cadena_forward TRUE);
		return TRUE;
	}
	
	memcpy(fin,&limite_final,sizeof(GtkTextIter));
	memcpy(inicio,fin,sizeof(GtkTextIter));

	DEBUG_MSG(<-buscar_cadena_forward FALSE);
	
	return FALSE;
}

/* This function makes a backward search of cadena in buffer. limite_inicial and limite_final are de initial and final limits wher the search will	*
 * done. If NULL the function will search from the begeaning to the end of the buffer. If a mach is found it will return TRUE, and inicio	*
 * and fin will be the limits of the mach in the buffer in the way [inicio,fin). If not mach is found the function will rs
eturn FALSE and		*
 * inicio and fin will point to the end of the buffer or limite_final. inicio and fin must be allocated before the function is called.				*/
gboolean buscar_cadena_backward(GtkTextBuffer *buffer,GtkTextIter *limite_inicial,GtkTextIter *limite_final,gchar *cadena,GtkTextIter *inicio,GtkTextIter *fin,gint flags)
{
	GtkTextIter sup,inf;
	gint cont;
	gunichar caracter;
	GtkTextIter posicion;
	gint offset;
	gchar *primero,*ultimo,*actual;
	gboolean cadena_encontrada;
	
	DEBUG_MSG(->buscar_cadena_backward);
	gtk_text_buffer_get_bounds(buffer,&sup,&inf);
	if (limite_inicial!=NULL) {
		memcpy(&sup,limite_inicial,sizeof(GtkTextIter));
	}
	if (limite_final!=NULL) {
		memcpy(&inf,limite_final,sizeof(GtkTextIter));
	}
	
	primero=cadena;
	for (cont=0;cadena[cont]!=0;cont++);
	ultimo=g_utf8_find_prev_char(cadena,&(cadena[cont]));
	actual=ultimo;
	memcpy(&posicion,&inf,sizeof(GtkTextIter));
	offset=gtk_text_iter_get_offset(&sup);
	cadena_encontrada=FALSE;
	while ((gtk_text_iter_get_offset(&posicion)!=offset) && (!cadena_encontrada)) {
		caracter=g_utf8_get_char(actual);
		if ((caracter==gtk_text_iter_get_char(&posicion)) & (flags & SENSIBLE_MAYUSCULAS)) {
			if (actual==primero) {
				cadena_encontrada=TRUE;
			} else {
				actual=g_utf8_find_prev_char(cadena,actual);
			}
		} else {
			if ((g_unichar_tolower(caracter)==g_unichar_tolower(gtk_text_iter_get_char(&posicion))) & (!(flags & SENSIBLE_MAYUSCULAS))) {
				if (actual==primero) {
					cadena_encontrada=TRUE;
				} else {
					actual=g_utf8_find_prev_char(cadena,actual);
				}
			} else {
				actual=ultimo;
			}
		}
		if (!cadena_encontrada) {
			gtk_text_iter_backward_chars(&posicion,1);
		}
	}
	
	if (cadena_encontrada) {
		memcpy(fin,&posicion,sizeof(GtkTextIter));
		memcpy(inicio,&posicion,sizeof(GtkTextIter));
		gtk_text_iter_forward_chars(inicio,g_utf8_strlen(cadena,-1));
		DEBUG_MSG(<-buscar_cadena_backward TRUE);
		return TRUE;
	}
	
	memcpy(fin,&limite_final,sizeof(GtkTextIter));
	memcpy(inicio,fin,sizeof(GtkTextIter));

	DEBUG_MSG(<-buscar_cadena_backward FALSE);
	
	return FALSE;
}
