/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

/*******************************************************************************
 Esta funcion es la que decide que programa o archivo es detectado en cada
 fase de la autodeteccion, y va rellentando las estructuras necesarias
 *******************************************************************************/
void det_autodetectar(xmlDocPtr doc,gboolean crear,guint estado)
{
	GtkProgressBar *barra;
	gfloat total,actual;
	gchar *detectado;
	xmlNodePtr nodo;
	FILE *archivo;
	gchar *nombre;
	static gchar *programas,*tmp;
	static gboolean error;
	GtkWidget *ventana;
	GtkWidget *widget;
	gboolean aplicacion;
	gint cont;
	GtkWidget *ventana_inicio;
	gchar *nombre_utf8;
	gsize read, written;
	GError *locale_error;
	
	DEBUG_MSG(->det_autodetectar);
	total=ULTIMA_FASE_AUTODETECCION;
	actual=estado;
	detectado=NULL;
	nombre=NULL;
	archivo=NULL;
	aplicacion=FALSE;
	
	if (estado==1) {
		error=FALSE;
		programas=g_strdup_printf(_("The following programs were not found:\n"));
		tmp=programas;
	}

	nodo=doc->xmlRootNode;
	if ((crear) && (estado==0)) {
		DEBUG_MSG(creando preferencias de autodeteccion);
		xmlNewChild(nodo,NULL,"programas",NULL);
		xmlNewChild(nodo,NULL,"includes",NULL);
		xmlNewChild(nodo,NULL,"librerias",NULL);
		nodo=buscar_nodo_xml(doc->xmlRootNode,"includes");
		for (cont=0;cont<LTOTALES;cont++) {
			xmlNewChild(nodo,NULL,pro_nombre_librerias_xml[cont],NULL);
		}
		nodo=buscar_nodo_xml(doc->xmlRootNode,"librerias");
		for (cont=0;cont<LTOTALES;cont++) {
			xmlNewChild(nodo,NULL,pro_nombre_librerias_xml[cont],NULL);
		}
		xmlNewChild(nodo,NULL,"electric_fence",NULL);
	}
	barra=GTK_PROGRESS_BAR(glade_xml_get_widget(autodetect_ventana,"progreso_barra_autodetect"));

	switch (estado) {
		case 0:
			ejecutables.which=FALSE;
			ejecutables.which=det_prog("which which 2>/dev/stdout");
			break;
		case 1+LGTK2:
		case 1+LGOBJECT2:
		case 1+LGLIB2:
		case 1+LGMODULE2:
		case 1+LGTHREAD2:
		case 1+LESD:
		case 1+LAUDIOFILE:
		case 1+LXML2:
		case 1+LGNOME2:
		case 1+LGNOMEUI2:
		case 1+LBONOBO2:
		case 1+LBONOBOUI2:
		case 1+LBONOBO_ACTIVATION2:
		case 1+LGNOMEPRINT2:
		case 1+LGNOMEPRINTUI2:
		case 1+LGNOME_MIME_DATA2:
		case 1+LPANGO:
		case 1+LPANGOXFT:
		case 1+LPANGOFT2:
		case 1+LGNOME_VFS2:
		case 1+LGNOME_VFS_MODULE2:
		case 1+LORBIT2:
		case 1+LORBIT_COSNAMING2:
		case 1+LLINC:
		case 1+LGDK2:
		case 1+LGDK_X112:
		case 1+LGDK_PIXBUF2:
		case 1+LGDK_PIXBUF_XLIB2:
		case 1+LATK:
		case 1+LGCONF2:
		case 1+LGNOMECANVAS2:
		case 1+LLIBART2:
		case 1+LLIBGLADE2:
		case 1+LGTK_X112:
		case 1+LIMLIB:
		case 1+LIMLIBGDK:
		case 1+LPANGOX:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->xmlRootNode,"includes");
			nodo=buscar_nodo_xml(nodo,pro_nombre_librerias_xml[estado-1]);
			detectado=g_strdup_printf("`pkg-config %s --cflags`",pro_nombre_librerias[estado-1]);
			break;
		case 1+LX11:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->xmlRootNode,"includes");
			nodo=buscar_nodo_xml(nodo,pro_nombre_librerias_xml[LX11]);
			if (preferencias.inc[LX11]!=NULL) {
				nombre=g_strdup_printf("%s/X.h",&(preferencias.inc[LX11][2]));
			}
			if (nombre != NULL) {
				nombre_utf8 = g_strdup(nombre);
				g_free(nombre);
				nombre = g_locale_from_utf8(nombre_utf8, -1, &read, &written, &locale_error);
				g_free(nombre_utf8);
			}
			archivo=fopen(nombre,"r");
			if (archivo==NULL) {
				DEBUG_MSG(no se encontro X.h);
				detectado=det_inc("X.h");
			} else {
				fclose(archivo);
				detectado=g_strdup(preferencias.inc[LX11]);
			}
			break;
		case 1+LGETTEXT:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->xmlRootNode,"includes");
			nodo=buscar_nodo_xml(nodo,pro_nombre_librerias_xml[estado-1]);
			detectado=NULL;
			break;
		case LTOTALES+1+LGTK2:
		case LTOTALES+1+LGOBJECT2:
		case LTOTALES+1+LGLIB2:
		case LTOTALES+1+LGMODULE2:
		case LTOTALES+1+LGTHREAD2:
		case LTOTALES+1+LESD:
		case LTOTALES+1+LAUDIOFILE:
		case LTOTALES+1+LXML2:
		case LTOTALES+1+LGNOME2:
		case LTOTALES+1+LGNOMEUI2:
		case LTOTALES+1+LBONOBO2:
		case LTOTALES+1+LBONOBOUI2:
		case LTOTALES+1+LBONOBO_ACTIVATION2:
		case LTOTALES+1+LGNOMEPRINT2:
		case LTOTALES+1+LGNOMEPRINTUI2:
		case LTOTALES+1+LGNOME_MIME_DATA2:
		case LTOTALES+1+LPANGO:
		case LTOTALES+1+LPANGOXFT:
		case LTOTALES+1+LPANGOFT2:
		case LTOTALES+1+LGNOME_VFS2:
		case LTOTALES+1+LGNOME_VFS_MODULE2:
		case LTOTALES+1+LORBIT2:
		case LTOTALES+1+LORBIT_COSNAMING2:
		case LTOTALES+1+LLINC:
		case LTOTALES+1+LGDK2:
		case LTOTALES+1+LGDK_X112:
		case LTOTALES+1+LGDK_PIXBUF2:
		case LTOTALES+1+LGDK_PIXBUF_XLIB2:
		case LTOTALES+1+LATK:
		case LTOTALES+1+LGCONF2:
		case LTOTALES+1+LGNOMECANVAS2:
		case LTOTALES+1+LLIBART2:
		case LTOTALES+1+LLIBGLADE2:
		case LTOTALES+1+LGTK_X112:
		case LTOTALES+1+LIMLIB:
		case LTOTALES+1+LIMLIBGDK:
		case LTOTALES+1+LPANGOX:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->xmlRootNode,"librerias");
			nodo=buscar_nodo_xml(nodo,pro_nombre_librerias_xml[estado-1-LTOTALES]);
			detectado=g_strdup_printf("`pkg-config %s --libs`",pro_nombre_librerias[estado-1-LTOTALES]);
			break;
		case LTOTALES+1+LX11:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->xmlRootNode,"librerias");
			nodo=buscar_nodo_xml(nodo,pro_nombre_librerias_xml[LX11]);
			if (preferencias.lib[LX11]!=NULL) {
				nombre=g_strdup_printf("%s/libX11.so",&(preferencias.lib[LX11][2]));
			}
			if (nombre != NULL) {
				nombre_utf8 = g_strdup(nombre);
				g_free(nombre);
				nombre = g_locale_from_utf8(nombre_utf8, -1, &read, &written, &locale_error);
				g_free(nombre_utf8);
			}
			archivo=fopen(nombre,"r");
			if (archivo==NULL) {
				DEBUG_MSG(no se encontro libX11.so);
				detectado=det_lib("libX11.so");
			} else {
				fclose(archivo);
				detectado=g_strdup(preferencias.lib[LX11]);
			}
			break;
		case LTOTALES+1+LGETTEXT:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->xmlRootNode,"librerias");
			nodo=buscar_nodo_xml(nodo,pro_nombre_librerias_xml[estado-1-LTOTALES]);
			detectado=NULL;
			break;
		case LTOTALES+LTOTALES+1:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->xmlRootNode,"librerias");
			nodo=buscar_nodo_xml(nodo,"electric_fence");
			if (preferencias.lib_electric_fence!=NULL) {
				nombre=g_strdup_printf("%s/libefence.so",&(preferencias.lib_electric_fence[2]));
			}
			if (nombre != NULL) {
				nombre_utf8 = g_strdup(nombre);
				g_free(nombre);
				nombre = g_locale_from_utf8(nombre_utf8, -1, &read, &written, &locale_error);
				g_free(nombre_utf8);
			}
			archivo=fopen(nombre,"r");
			if (archivo==NULL) {
				DEBUG_MSG(no se encontro libefence.so);
				detectado=det_lib("libefence.so");
			} else {
				fclose(archivo);
				detectado=g_strdup(preferencias.lib_electric_fence);
			}
			break;
		case LTOTALES+LTOTALES+2:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->xmlRootNode,"programas");
			DEBUG_MSG(buscando gcc);
			if (det_prog("gcc --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"gcc","1");
				ejecutables.gcc=TRUE;
			} else {
				xmlSetProp(nodo,"gcc","0");
				ejecutables.gcc=FALSE;
			}
			break;
		case LTOTALES+LTOTALES+3:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->xmlRootNode,"programas");
			DEBUG_MSG(buscando make);
			if (det_prog("make --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"make","1");
				ejecutables.make=TRUE;
			} else {
				xmlSetProp(nodo,"make","0");
				ejecutables.make=FALSE;
			}
			break;
		case LTOTALES+LTOTALES+4:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->xmlRootNode,"programas");
			DEBUG_MSG(buscando aclocal);
			if (det_prog("aclocal --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"aclocal","1");
				ejecutables.aclocal=TRUE;
			} else {
				xmlSetProp(nodo,"aclocal","0");
				ejecutables.aclocal=FALSE;
				programas=g_strdup_printf("%s\taclocal\n",tmp);
				g_free(tmp);
				tmp=programas;
				error=TRUE;
			}
			break;
		case LTOTALES+LTOTALES+5:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->xmlRootNode,"programas");
			DEBUG_MSG(buscando automake);
			if (det_prog("automake --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"automake","1");
				ejecutables.automake=TRUE;
			} else {
				xmlSetProp(nodo,"automake","0");
				ejecutables.automake=FALSE;
				programas=g_strdup_printf("%s\tautomake\n",tmp);
				g_free(tmp);
				tmp=programas;
				error=TRUE;
			}
			break;
		case LTOTALES+LTOTALES+6:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->xmlRootNode,"programas");
			DEBUG_MSG(buscando autoconf);
			if (det_prog("autoconf --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"autoconf","1");
				ejecutables.autoconf=TRUE;
			} else {
				xmlSetProp(nodo,"autoconf","0");
				ejecutables.autoconf=FALSE;
				programas=g_strdup_printf("%s\tautoconf\n",tmp);
				g_free(tmp);
				tmp=programas;
				error=TRUE;
			}
			break;
		case LTOTALES+LTOTALES+7:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->xmlRootNode,"programas");
			DEBUG_MSG(buscando glade);
			if (det_prog("glade-2 --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"glade","1");
				ejecutables.glade=TRUE;
			} else {
				xmlSetProp(nodo,"glade","0");
				ejecutables.glade=FALSE;
			}
			break;
		case LTOTALES+LTOTALES+8:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->xmlRootNode,"programas");
			DEBUG_MSG(buscando exuberant-ctags);
			//The executable could be called ctags-exuberant or just ctags, depending on the distribution used.
			if (det_prog("ctags-exuberant --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"ctags","1");
				ejecutables.ctags=TRUE;
			} else if (det_prog("ctags --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"ctags","1");
				ejecutables.ctags=TRUE;
			} else {
				xmlSetProp(nodo,"ctags","0");
				ejecutables.ctags=FALSE;
				programas=g_strdup_printf("%s\texuberant-ctags\n",tmp);
				g_free(tmp);
				tmp=programas;
				error=TRUE;
			}
			break;
		case LTOTALES+LTOTALES+9:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->xmlRootNode,"programas");
			DEBUG_MSG(buscando autoheader);
			if (det_prog("autoheader --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"autoheader","1");
				ejecutables.autoheader=TRUE;
			} else {
				xmlSetProp(nodo,"autoheader","0");
				ejecutables.autoheader=FALSE;
				programas=g_strdup_printf("%s\tautoheader\n",tmp);
				g_free(tmp);
				tmp=programas;
				error=TRUE;
			}
			break;
		case LTOTALES+LTOTALES+10:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->xmlRootNode,"programas");
			DEBUG_MSG(buscando lpr);
			if (det_prog("lpr --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"lpr","1");
				ejecutables.lpr=TRUE;
			} else {
				xmlSetProp(nodo,"lpr","0");
				ejecutables.lpr=FALSE;
			}
			break;
		case LTOTALES+LTOTALES+11:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->xmlRootNode,"programas");
			DEBUG_MSG(buscando pkg-config);
			if (det_prog("pkg-config --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"pkg-config","1");
				ejecutables.pkg_config=TRUE;
			} else {
				xmlSetProp(nodo,"pkg-config","0");
				ejecutables.pkg_config=FALSE;
				programas=g_strdup_printf("%s\tpkg-config\n",tmp);
				g_free(tmp);
				tmp=programas;
				error=TRUE;
			}
			break;
		case LTOTALES+LTOTALES+12:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->xmlRootNode,"programas");
			DEBUG_MSG(buscando gdb);
			if (det_prog("gdb 2> /dev/stdout")) {
				xmlSetProp(nodo,"gdb","1");
				ejecutables.gdb=TRUE;
			} else {
				xmlSetProp(nodo,"gdb --version","0");
				ejecutables.gdb=FALSE;
			}
			break;
		case LTOTALES+LTOTALES+13:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->xmlRootNode,"programas");
			DEBUG_MSG(buscando ddd);
			if (det_prog("ddd --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"ddd","1");
				ejecutables.ddd=TRUE;
			} else {
				xmlSetProp(nodo,"ddd","0");
				ejecutables.ddd=FALSE;
			}
			break;
		case LTOTALES+LTOTALES+14:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->xmlRootNode,"programas");
			DEBUG_MSG(buscando grep);
			if (det_prog("grep --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"grep","1");
				ejecutables.grep=TRUE;
			} else {
				xmlSetProp(nodo,"grep","0");
				ejecutables.grep=FALSE;
			}
			break;
		case LTOTALES+LTOTALES+15:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->xmlRootNode,"programas");
			if (det_prog("memprof --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"memprof","1");
				ejecutables.memprof=TRUE;
			} else {
				xmlSetProp(nodo,"memprof","0");
				ejecutables.memprof=FALSE;
			}
			break;
		case LTOTALES+LTOTALES+16:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->xmlRootNode,"programas");
			if (det_prog("gnome-terminal --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"gnome_terminal","1");
				ejecutables.gnome_terminal=TRUE;
			} else {
				xmlSetProp(nodo,"gnome_terminal","0");
				ejecutables.gnome_terminal=FALSE;
			}
			break;
		case LTOTALES+LTOTALES+17:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->xmlRootNode,"programas");
			if (det_prog("cvs --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"cvs","1");
				ejecutables.cvs=TRUE;
			} else {
				xmlSetProp(nodo,"cvs","0");
				ejecutables.cvs=FALSE;
			}
			break;
	}

	if ((estado>=1) && (!aplicacion)) {
		g_free(nombre);
		xmlNodeSetContent(nodo,detectado);
		g_free(detectado);
		gtk_progress_bar_update(barra,actual/total);
	}
	if (aplicacion) {
		gtk_progress_bar_update(barra,actual/total);
	}
	
	if ((error) && (estado==ULTIMA_FASE_AUTODETECCION)) {
		 //There are some missing applications
		programas=g_strdup_printf(_("%s\nThey are needed for DiaSCE to work properly. Install them and make sure they are in your path."),tmp);
		g_free(tmp);
		widget = glade_xml_get_widget (david_ventana, "david_ventana");
		ventana=gnome_error_dialog_parented(programas, GTK_WINDOW(widget));
		ventana_inicio=glade_xml_get_widget(autodetect_ventana,"autodetect_ventana");
          gtk_widget_destroy(ventana_inicio);
          gnome_dialog_run_and_close(GNOME_DIALOG(ventana));
	} else if (estado == ULTIMA_FASE_AUTODETECCION) {
		ventana_inicio=glade_xml_get_widget(autodetect_ventana,"autodetect_ventana");
		gtk_widget_destroy(ventana_inicio);
	}
	if (estado==ULTIMA_FASE_AUTODETECCION) {
		g_free(programas);
	}
	DEBUG_MSG(<-det_autodetectar);
}

/*******************************************************************************
 Detecta la localizacion de una libreria y devuelve el parametro -L que
 hay que pasar al gcc
 *******************************************************************************/
gchar *det_lib(gchar *nombre)
{
	gchar *lib;
	FILE *tuberia;
	gchar *comando;
	guint mas;
	gchar letra;
	gchar *resultado,*tmp;
	guint cont;
	guint inicio;
	guint total;

	resultado=g_strdup("");
	tmp=resultado;
	lib=NULL;
	total=0;
	comando=g_strdup_printf("find /opt/gnome/lib /lib /usr/lib /usr/X11R6/lib /usr/share/lib /usr/local/lib -name %s 2> /dev/stdout",nombre);
	tuberia=popen(comando,"r");
	do {
		mas=fread(&letra,1,1,tuberia);
		if (mas) {
			total++;
			resultado=g_strdup_printf("%s%c",tmp,letra);
			g_free(tmp);
			tmp=resultado;
		}
	} while (mas);
	pclose(tuberia);
	cont=0;
	do {
		if (resultado[cont]=='/') {
			inicio=cont;
			for (;resultado[cont]!='\n';cont++);
			for (;resultado[cont]!='/';cont--);
			resultado[cont]=0;
			lib=g_strdup_printf("-L%s",&(resultado[inicio]));
		} else {
			for (;resultado[cont]!='\n';cont++);
			cont++;
		}
	} while ((cont!=total) && (lib==NULL));
	g_free(resultado);

	return lib;
}

/*******************************************************************************
 Detecta la localizacion de un archivo de cabecera y devuelve el parametro
 -I que hay que pasar al gcc
 *******************************************************************************/
gchar *det_inc(gchar *nombre)
{
	gchar *inc;
	FILE *tuberia;
	gchar *comando;
	guint mas;
	gchar letra;
	gchar *resultado,*tmp;
	guint cont;
	guint inicio;
	guint total;
	
	resultado=g_strdup("");
	tmp=resultado;
	inc=NULL;
	total=0;
	comando=g_strdup_printf("find /opt/gnome/include /opt/gnome/lib /usr/include /usr/lib /usr/X11R6/include /usr/share/include /usr/local/include -name %s 2> /dev/stdout",nombre);
	tuberia=popen(comando,"r");
	do {
		mas=fread(&letra,1,1,tuberia);
		if (mas) {
			total++;
			resultado=g_strdup_printf("%s%c",tmp,letra);
			g_free(tmp);
			tmp=resultado;
		}
	} while (mas);
	pclose(tuberia);
	cont=0;
	do {
		if (resultado[cont]=='/') {
			inicio=cont;
			for (;resultado[cont]!='\n';cont++);
			for (;resultado[cont]!='/';cont--);
			resultado[cont]=0;
			inc=g_strdup_printf("-I%s",&(resultado[inicio]));
		} else {
			for (;resultado[cont]!='\n';cont++);
			cont++;
		}
	} while ((cont!=total) && (inc==NULL));
	g_free(resultado);
	return inc;
}

/*******************************************************************************
 Devuelve verdadero o falso dependiendo de si un programa puede
 ser ejecutado por DiaSCE o no
 *******************************************************************************/
gboolean det_prog(gchar *nombre)
{
	FILE *tuberia;
	gint salida;
	gchar letra;
	gchar *cadena;
	gchar *temporal;
	guint mas;
	gboolean error;
	gint cont;
	gchar *comando;
	gchar *parametro;
	
	if (ejecutables.which) {
		comando=g_strdup_printf("which %s",nombre);
		parametro=strstr(comando,"--version");
		if (parametro!=NULL) {
			for (cont=0;cont<9;cont++) {
				parametro[cont]=' ';
			}
		}
		DEBUG_MSG(usando which para detectar);
	} else {
		comando=g_strdup(nombre);
		DEBUG_MSG(detectando sin which);
	}
	tuberia=popen(comando,"r");
	temporal=NULL;
	cadena=NULL;
	do {
		mas=fread(&letra,1,1,tuberia);
		if (mas) {
			if (temporal!=NULL) {
				cadena=g_strdup_printf("%s%c",temporal,letra);
				g_free(temporal);
				temporal=cadena;
			} else {
				cadena=g_strdup_printf("%c",letra);
				temporal=cadena;
			}
		}
	} while ((mas) && (letra!='\n'));
	error=FALSE;
	if (cadena!=NULL) {
		for (cont=0;(cadena[cont]!=':') && (cadena[cont]!=0);cont++);
		if (cadena[cont]==':') {
			cont++;
		}
		for (;(cadena[cont]!=':') && (cadena[cont]!=0);cont++);
		if (cadena[cont]==':') {
			cont+=2;
			error=(strcmp(&cadena[cont],"command not found\n")!=0);
		} else error=TRUE;
		g_free(cadena);
	}
	salida=pclose(tuberia);
	g_free(comando);
	
	return error;
}
