/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

void pro_inicializar(void)
{
	proyecto.xml=NULL;
	proyecto.xml_viejo=NULL;
	proyecto.archivo=NULL;
	pro_proyecto_cargar=NULL;
}

void pro_crear(void)
{
	xmlNodePtr xmlnode;

	DEBUG_MSG(->pro_crear);
	proyecto.xml=xmlNewDoc("1.0");
	xmlnode=xmlNewNode(NULL,"Proyecto_david");
	(proyecto.xml)->root=xmlnode;
	xmlNewProp(xmlnode,"version",VERSION_PROYECTO);
	
	xmlNewChild(xmlnode,NULL,"general",NULL);
	xmlNewChild(xmlnode,NULL,"archivos",NULL);
	xmlNewChild(xmlnode,NULL,"librerias",NULL);
	xmlNewChild(xmlnode,NULL,"avisos",NULL);
	xmlNewChild(xmlnode,NULL,"compilar",NULL);
	xmlNewChild(xmlnode,NULL,"fuentes",NULL);
	xmlNewChild(xmlnode,NULL,"cabeceras",NULL);
	xmlNewChild(xmlnode,NULL,"otros",NULL);
	
	//propiedades de general
	xmlnode=xmlnode->childs;
	xmlNewProp(xmlnode,"nombre","");
	xmlNewProp(xmlnode,"version","0.1");
	xmlNewProp(xmlnode,"autor",preferencias.nombre);
	xmlNewProp(xmlnode,"e-mail",preferencias.e_mail);
	xmlNewProp(xmlnode,"lenguaje","0");	// 0=C, 1=C++
	
	//propiedades de archivos
	xmlnode=xmlnode->next;
	xmlNewProp(xmlnode,"nombre","");
	xmlNewProp(xmlnode,"proyecto",preferencias.directorio);
	xmlNewProp(xmlnode,"fuentes","src/");
	xmlNewProp(xmlnode,"pixmaps","pixmaps/");
	xmlNewProp(xmlnode,"glade","0");
	xmlNewProp(xmlnode,"glade_file","");
	xmlNewProp(xmlnode,"crear_h","1");
	xmlNewProp(xmlnode,"cabecera","1");
	xmlNewProp(xmlnode,"defines","0");
	
	//propiedades de librerias
	xmlnode=xmlnode->next;
	xmlNewProp(xmlnode,"gtk","0");
	xmlNewProp(xmlnode,"xml","0");
	xmlNewProp(xmlnode,"orbit","0");
	xmlNewProp(xmlnode,"x11","0");
	xmlNewProp(xmlnode,"gnome","0");
	xmlNewProp(xmlnode,"glib","0");
	xmlNewProp(xmlnode,"gettext","0");
	xmlNewProp(xmlnode,"gnomeui","0");
	xmlNewProp(xmlnode,"gnorba","0");
	xmlNewProp(xmlnode,"audiofile","0");
	xmlNewProp(xmlnode,"esd","0");
	xmlNewProp(xmlnode,"gmodule","0");
	xmlNewProp(xmlnode,"imlib","0");
	xmlNewChild(xmlnode,NULL,"otras",NULL);
	xmlNewChild(xmlnode,NULL,"path",NULL);
	xmlNewChild(xmlnode,NULL,"includes",NULL);
	xmlnode=xmlnode->childs;
	xmlNodeSetContent(xmlnode,"");
	xmlnode=xmlnode->next;
	xmlNodeSetContent(xmlnode,"");
	xmlnode=xmlnode->next;
	xmlNodeSetContent(xmlnode,"");
	xmlnode=xmlnode->parent;
	
	//propiedades de avisos
	xmlnode=xmlnode->next;
	xmlNewProp(xmlnode,"w00","1");
	xmlNewProp(xmlnode,"w01","0");
	xmlNewProp(xmlnode,"w02","0");
	xmlNewProp(xmlnode,"w03","0");
	xmlNewProp(xmlnode,"w04","0");
	xmlNewProp(xmlnode,"w05","0");
	xmlNewProp(xmlnode,"w06","0");
	xmlNewProp(xmlnode,"w07","0");
	xmlNewProp(xmlnode,"w08","0");
	xmlNewProp(xmlnode,"w09","0");
	xmlNewProp(xmlnode,"w10","0");
	xmlNewProp(xmlnode,"w11","0");
	xmlNewProp(xmlnode,"w12","0");
	xmlNewProp(xmlnode,"w13","0");
	xmlNewProp(xmlnode,"w14","0");
	xmlNewProp(xmlnode,"w15","0");
	xmlNewProp(xmlnode,"w16","0");
	xmlNewProp(xmlnode,"w17","0");
	xmlNewProp(xmlnode,"w18","0");
	xmlNewProp(xmlnode,"w19","0");
	xmlNewProp(xmlnode,"w20","0");
	xmlNewProp(xmlnode,"w21","0");
	
	//propiedades de compilar
	xmlnode=xmlnode->next;
	xmlNewProp(xmlnode,"optimizacion","0");
	xmlNewProp(xmlnode,"depuracion","2");
	xmlNewProp(xmlnode,"electric_fence","0");
	xmlNodeSetContent(xmlnode,"");
	
	autoconfiguracion=autoconfiguracion | AUTO_CONF | AUTO_MAKE | ACLOCAL | AUTO_HEADER | CONFIGURE;

	DEBUG_MSG(<-pro_crear);
}

void pro_actualizar(GtkWidget *widget)
{
	GtkWidget *fuente;
	xmlNodePtr xmlnode;
	gchar *texto;
	gchar *nombre_proyecto;
	gchar *carpeta_proyecto;
	gchar *carpeta_fuentes;
	gchar *carpeta_pixmaps;
	gchar *carpeta_datos;
	gint nivel;
	guint cont;
	gchar *directorio;
	gchar *glade_file;

	DEBUG_MSG(->pro_actualizar);
	widget=gtk_widget_get_toplevel(widget);
	xmlnode=(proyecto.xml)->root->childs;
	
	//propiedades generales
	fuente=lookup_widget(widget,"nombre_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	nombre_proyecto=texto;
	xmlSetProp(xmlnode,"nombre",texto);
	
	fuente=lookup_widget(widget,"version_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlSetProp(xmlnode,"version",texto);
	g_free(texto);
	
	fuente=lookup_widget(widget,"autor_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlSetProp(xmlnode,"autor",texto);
	g_free(texto);
	
	fuente=lookup_widget(widget,"email_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlSetProp(xmlnode,"e-mail",texto);
	g_free(texto);
	
	fuente=lookup_widget(widget,"c_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"lenguaje","0");
	} else {
		xmlSetProp(xmlnode,"lenguaje","1");
	}
	
	//propiedades archivos
	xmlnode=xmlnode->next;
	fuente=lookup_widget(widget,"ejecutable_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	if (texto[0]==0) {
		xmlSetProp(xmlnode,"nombre",nombre_proyecto);
	} else {
		xmlSetProp(xmlnode,"nombre",texto);
	}
	g_free(texto);
	
	fuente=lookup_widget(widget,"proyecto_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	if (texto[0]==0) {
		directorio=g_strdup(preferencias.directorio);
	} else {
		for (cont=0;texto[cont]!=0;cont++);
		if (texto[cont-1]!='/') {
			directorio=g_strdup_printf("%s/",texto);
		} else {
			directorio=g_strdup(texto);
		}
	}
	xmlSetProp(xmlnode,"proyecto",directorio);
	carpeta_proyecto=g_strdup(directorio);
	g_free(directorio);
	g_free(texto);
	
	fuente=lookup_widget(widget,"fuentes_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	for (cont=0;texto[cont]!=0;cont++);
	if ((cont!=0) && (texto[cont-1]!='/')) {
		directorio=g_strdup_printf("%s/",texto);
	} else {
		directorio=g_strdup(texto);
	}
	xmlSetProp(xmlnode,"fuentes",directorio);
	carpeta_fuentes=g_strdup_printf("%s%s",carpeta_proyecto,directorio);
	g_free(directorio);
	g_free(texto);

	fuente=lookup_widget(widget,"pixmaps_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	for (cont=0;texto[cont]!=0;cont++);
	if ((cont!=0) && (texto[cont-1]!='/')) {
		directorio=g_strdup_printf("%s/",texto);
	} else {
		directorio=g_strdup(texto);
	}
	g_free(texto);
	xmlSetProp(xmlnode,"pixmaps",directorio);
	carpeta_pixmaps=g_strdup_printf("%s%s",carpeta_proyecto,directorio);
	g_free(directorio);
	
	fuente=lookup_widget(widget,"glade_proyecto_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"glade","1");
	} else {
		xmlSetProp(xmlnode,"glade","0");
	}
	
	fuente=lookup_widget(widget,"glade_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	if (texto[0]==0) {
		xmlSetProp(xmlnode,"glade","0");
	}
	for (cont=0;texto[cont]!=0;cont++);
	for (;(texto[cont]!='/') && (cont!=0);cont--);
	if (texto[cont]=='/') {
		glade_file=g_strdup_printf("%s",&(texto[cont+1]));
	} else {
		glade_file=g_strdup_printf("%s",texto);
	}
	xmlSetProp(xmlnode,"glade_file",glade_file);
	g_free(glade_file);
	g_free(texto);

	fuente=lookup_widget(widget,"crear_h_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"crear_h","1");
	} else {
		xmlSetProp(xmlnode,"crear_h","0");
	}

	fuente=lookup_widget(widget,"cabecera_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"cabecera","1");
	} else {
		xmlSetProp(xmlnode,"cabecera","0");
	}

	fuente=lookup_widget(widget,"defines_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"defines","1");
	} else {
		xmlSetProp(xmlnode,"defines","0");
	}

	//propiedades librerias
	xmlnode=xmlnode->next;

	pro_actualizar_librerias_lincado(widget);	

	xmlnode=xmlnode->childs;
	fuente=lookup_widget(widget,"otras_libs_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);
	xmlnode=xmlnode->next;
	fuente=lookup_widget(widget,"path_libs_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);
	xmlnode=xmlnode->next;
	fuente=lookup_widget(widget,"path_cab_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);
	xmlnode=xmlnode->parent;

	
	//propiedades avisos
	xmlnode=xmlnode->next;
	
	fuente=lookup_widget(widget,"w00_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w00","1");
	} else {
		xmlSetProp(xmlnode,"w00","0");
	}
	
	fuente=lookup_widget(widget,"w01_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w01","1");
	} else {
		xmlSetProp(xmlnode,"w01","0");
	}
	
	fuente=lookup_widget(widget,"w02_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w02","1");
	} else {
		xmlSetProp(xmlnode,"w02","0");
	}
	
	fuente=lookup_widget(widget,"w03_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w03","1");
	} else {
		xmlSetProp(xmlnode,"w03","0");
	}
	
	fuente=lookup_widget(widget,"w04_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w04","1");
	} else {
		xmlSetProp(xmlnode,"w04","0");
	}
	
	fuente=lookup_widget(widget,"w05_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w05","1");
	} else {
		xmlSetProp(xmlnode,"w05","0");
	}
	
	fuente=lookup_widget(widget,"w06_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w06","1");
	} else {
		xmlSetProp(xmlnode,"w06","0");
	}
	
	fuente=lookup_widget(widget,"w07_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w07","1");
	} else {
		xmlSetProp(xmlnode,"w07","0");
	}
	
	fuente=lookup_widget(widget,"w08_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w08","1");
	} else {
		xmlSetProp(xmlnode,"w08","0");
	}
	
	fuente=lookup_widget(widget,"w09_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w09","1");
	} else {
		xmlSetProp(xmlnode,"w09","0");
	}
	
	fuente=lookup_widget(widget,"w10_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w10","1");
	} else {
		xmlSetProp(xmlnode,"w10","0");
	}
	
	fuente=lookup_widget(widget,"w11_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w11","1");
	} else {
		xmlSetProp(xmlnode,"w11","0");
	}
	
	fuente=lookup_widget(widget,"w12_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w12","1");
	} else {
		xmlSetProp(xmlnode,"w12","0");
	}
	
	fuente=lookup_widget(widget,"w13_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w13","1");
	} else {
		xmlSetProp(xmlnode,"w13","0");
	}
	
	fuente=lookup_widget(widget,"w14_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w14","1");
	} else {
		xmlSetProp(xmlnode,"w14","0");
	}
	
	fuente=lookup_widget(widget,"w15_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w15","1");
	} else {
		xmlSetProp(xmlnode,"w15","0");
	}
	
	fuente=lookup_widget(widget,"w16_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w16","1");
	} else {
		xmlSetProp(xmlnode,"w16","0");
	}
	
	fuente=lookup_widget(widget,"w17_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w17","1");
	} else {
		xmlSetProp(xmlnode,"w17","0");
	}
	
	fuente=lookup_widget(widget,"w18_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w18","1");
	} else {
		xmlSetProp(xmlnode,"w18","0");
	}
	
	fuente=lookup_widget(widget,"w19_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w19","1");
	} else {
		xmlSetProp(xmlnode,"w19","0");
	}
	
	fuente=lookup_widget(widget,"w20_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w20","1");
	} else {
		xmlSetProp(xmlnode,"w20","0");
	}
	
	fuente=lookup_widget(widget,"w21_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w21","1");
	} else {
		xmlSetProp(xmlnode,"w21","0");
	}
	
	//propiedades compilar
	xmlnode=xmlnode->next;
	
	fuente=lookup_widget(widget,"optimizar_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		fuente=lookup_widget(widget,"nivel_optimizacion");
		nivel=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(fuente));
		texto=g_strdup_printf("%i",nivel);
		xmlSetProp(xmlnode,"optimizacion",texto);
		g_free(texto);
	} else {
		xmlSetProp(xmlnode,"optimizacion","0");
	}
	
	fuente=lookup_widget(widget,"depuracion_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		fuente=lookup_widget(widget,"nivel_depuracion");
		nivel=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(fuente));
		texto=g_strdup_printf("%i",nivel);
		xmlSetProp(xmlnode,"depuracion",texto);
		g_free(texto);
	} else {
		xmlSetProp(xmlnode,"depuracion","0");
	}
	
	fuente=lookup_widget(widget,"electric_fence_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"electric_fence","1");
	} else {
		xmlSetProp(xmlnode,"electric_fence","0");
	}

	fuente=lookup_widget(widget,"opciones_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);
	
	if (proyecto.archivo!=NULL) {
		g_free(proyecto.archivo);
	}
	proyecto.archivo=g_strdup_printf("%s%s.davidprj",carpeta_proyecto,nombre_proyecto);
	carpeta_datos=g_strdup_printf("%sdata",carpeta_proyecto);
	mkdir(carpeta_proyecto,0x1ed);
	mkdir(carpeta_fuentes,0x1ed);
	mkdir(carpeta_pixmaps,0x1ed);
	mkdir(carpeta_datos,0x1ed);
	g_free(carpeta_proyecto);
	g_free(carpeta_fuentes);
	g_free(carpeta_pixmaps);
	g_free(carpeta_datos);
	g_free(nombre_proyecto);
	pro_guardar();

	DEBUG_MSG(<-pro_actualizar);
}

void pro_mostrar(GtkWidget *widget)
{
	GtkWidget *fuente;
	xmlNodePtr xmlnode;
	gchar *texto;

	DEBUG_MSG(->pro_mostrar);
	xmlnode=(proyecto.xml)->root->childs;
	
	//propiedades generales
	fuente=lookup_widget(widget,"nombre_entrada");
	texto=xmlGetProp(xmlnode,"nombre");
	gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	g_free(texto);
	
	fuente=lookup_widget(widget,"version_entrada");
	texto=xmlGetProp(xmlnode,"version");
	gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	g_free(texto);
	
	fuente=lookup_widget(widget,"autor_entrada");
	texto=xmlGetProp(xmlnode,"autor");
	gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	g_free(texto);
	
	fuente=lookup_widget(widget,"email_entrada");
	texto=xmlGetProp(xmlnode,"e-mail");
	gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	g_free(texto);
	
	texto=xmlGetProp(xmlnode,"lenguaje");
	switch (texto[0]) {
		case '0':
			fuente=lookup_widget(widget,"c_boton");
			break;
		case '1':
			fuente=lookup_widget(widget,"cpp_boton");
			break;
	};
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),TRUE);
	g_free(texto);
	
	//propiedades archivos
	xmlnode=xmlnode->next;
	fuente=lookup_widget(widget,"ejecutable_entrada");
	texto=xmlGetProp(xmlnode,"nombre");
	gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	g_free(texto);
	
	fuente=lookup_widget(widget,"proyecto_entrada");
	texto=xmlGetProp(xmlnode,"proyecto");
	gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	g_free(texto);
	
	fuente=lookup_widget(widget,"fuentes_entrada");
	texto=xmlGetProp(xmlnode,"fuentes");
	gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	g_free(texto);
	
	fuente=lookup_widget(widget,"pixmaps_entrada");
	texto=xmlGetProp(xmlnode,"pixmaps");
	gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	g_free(texto);

	fuente=lookup_widget(widget,"glade_proyecto_boton");
	texto=xmlGetProp(xmlnode,"glade");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"glade_entrada");
	texto=xmlGetProp(xmlnode,"glade_file");
	gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	if (texto==NULL) {
		fuente=lookup_widget(widget,"glade_proyecto_boton");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),FALSE);
	}
	g_free(texto);
	
	fuente=lookup_widget(widget,"crear_h_boton");
	texto=xmlGetProp(xmlnode,"crear_h");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"cabecera_boton");
	texto=xmlGetProp(xmlnode,"cabecera");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"defines_boton");
	texto=xmlGetProp(xmlnode,"defines");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	//propiedades librerias
	xmlnode=xmlnode->next;
	
	pro_mostrar_librerias_lincado(widget);

	xmlnode=xmlnode->childs;
	fuente=lookup_widget(widget,"otras_libs_entrada");
	texto=xmlNodeGetContent(xmlnode);
	if (texto!=NULL) {
		gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	}
	g_free(texto);
	xmlnode=xmlnode->next;
	fuente=lookup_widget(widget,"path_libs_entrada");
	texto=xmlNodeGetContent(xmlnode);
	if (texto!=NULL) {
		gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	}
	g_free(texto);
	xmlnode=xmlnode->next;
	fuente=lookup_widget(widget,"path_cab_entrada");
	texto=xmlNodeGetContent(xmlnode);
	if (texto!=NULL) {
		gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	}
	g_free(texto);
	xmlnode=xmlnode->parent;

	//propiedades avisos
	xmlnode=xmlnode->next;
	
	fuente=lookup_widget(widget,"w00_boton");
	texto=xmlGetProp(xmlnode,"w00");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"w01_boton");
	texto=xmlGetProp(xmlnode,"w01");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"w02_boton");
	texto=xmlGetProp(xmlnode,"w02");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"w03_boton");
	texto=xmlGetProp(xmlnode,"w03");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"w04_boton");
	texto=xmlGetProp(xmlnode,"w04");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"w05_boton");
	texto=xmlGetProp(xmlnode,"w05");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"w06_boton");
	texto=xmlGetProp(xmlnode,"w06");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"w07_boton");
	texto=xmlGetProp(xmlnode,"w07");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"w08_boton");
	texto=xmlGetProp(xmlnode,"w08");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"w09_boton");
	texto=xmlGetProp(xmlnode,"w09");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"w10_boton");
	texto=xmlGetProp(xmlnode,"w10");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"w11_boton");
	texto=xmlGetProp(xmlnode,"w11");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"w12_boton");
	texto=xmlGetProp(xmlnode,"w12");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"w13_boton");
	texto=xmlGetProp(xmlnode,"w13");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"w14_boton");
	texto=xmlGetProp(xmlnode,"w14");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"w15_boton");
	texto=xmlGetProp(xmlnode,"w15");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"w16_boton");
	texto=xmlGetProp(xmlnode,"w16");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"w17_boton");
	texto=xmlGetProp(xmlnode,"w17");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"w18_boton");
	texto=xmlGetProp(xmlnode,"w18");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"w19_boton");
	texto=xmlGetProp(xmlnode,"w19");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"w20_boton");
	texto=xmlGetProp(xmlnode,"w20");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"w21_boton");
	texto=xmlGetProp(xmlnode,"w21");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	//propiedades compilar
	xmlnode=xmlnode->next;
	
	fuente=lookup_widget(widget,"optimizar_boton");
	texto=xmlGetProp(xmlnode,"optimizacion");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	if ((texto[0]-48)!=0) {
		fuente=lookup_widget(widget,"nivel_optimizacion");
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(fuente),texto[0]-48);
	}
	g_free(texto);
	
	fuente=lookup_widget(widget,"depuracion_boton");
	texto=xmlGetProp(xmlnode,"depuracion");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	if ((texto[0]-48)!=0) {
		fuente=lookup_widget(widget,"nivel_depuracion");
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(fuente),texto[0]-48);
	}
	g_free(texto);
	
	fuente=lookup_widget(widget,"electric_fence_boton");
	texto=xmlGetProp(xmlnode,"electric_fence");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"opciones_entrada");
	texto=xmlNodeGetContent(xmlnode);
	if (texto!=NULL) {
		gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	}
	g_free(texto);

	DEBUG_MSG(<-pro_mostrar);
}

void pro_guardar(void)
{
	FILE *archivo;
	gchar *nombre;
	gchar *comando;
	gchar *libs;
	
	DEBUG_MSG(->pro_guardar);
	xmlSaveFile(proyecto.archivo,proyecto.xml);
	libs=pro_librerias_lincado();
	if (libs[LGETTEXT]=='1') {
		nombre=pro_nombre_completo_archivo("ABOUT-NLS",TRUE);
		comando=g_strdup_printf("cp /usr/share/gettext/ABOUT-NLS %s 2> /dev/stdout\n",nombre);
		gen_comando(comando,NULL);
		g_free(comando);
		g_free(nombre);
		comando=g_strdup_printf("cp /usr/share/gettext/intl . -r 2> /dev/stdout\n");
		gen_comando(comando,NULL);
		g_free(comando);
		comando=g_strdup_printf("cp /usr/share/gettext/po . -r 2> /dev/stdout\n");
		gen_comando(comando,NULL);
		g_free(comando);
	}
	g_free(libs);
	nombre=pro_nombre_completo_archivo("install-sh",FALSE);
	comando=g_strdup_printf("cp %s/share/automake/install-sh %s 2> /dev/stdout\n",prefix_automake,nombre);
	gen_comando(comando,NULL);
	g_free(comando);
	g_free(nombre);
	nombre=pro_nombre_completo_archivo("install.sh",FALSE);
	comando=g_strdup_printf("cp %s/share/automake/install.sh %s 2> /dev/stdout\n",prefix_automake,nombre);
	gen_comando(comando,NULL);
	g_free(comando);
	g_free(nombre);
	nombre=pro_nombre_completo_archivo("mkinstalldirs",FALSE);
	comando=g_strdup_printf("cp %s/share/automake/mkinstalldirs %s 2> /dev/stdout\n",prefix_automake,nombre);
	gen_comando(comando,NULL);
	g_free(comando);
	g_free(nombre);
	nombre=pro_nombre_completo_archivo("missing",FALSE);
	comando=g_strdup_printf("cp %s/share/automake/missing %s 2> /dev/stdout\n",prefix_automake,nombre);
	gen_comando(comando,NULL);
	g_free(comando);
	g_free(nombre);
	//Comprobamos que no exista el fichero INSTALL antes de copiarlo
	nombre=pro_nombre_completo_archivo("INSTALL",FALSE);
	archivo = fopen(nombre,"r"); 
	g_free(nombre);
	if (archivo == NULL) {
		nombre=pro_nombre_completo_archivo("INSTALL",FALSE);
		comando=g_strdup_printf("cp %s/share/automake/INSTALL %s 2> /dev/stdout\n",prefix_automake,nombre);
		gen_comando(comando,NULL);
		g_free(comando);
		g_free(nombre);
	} else {
		fclose (archivo);
	}
	nombre=pro_nombre_completo_archivo("COPYING",FALSE);
	comando=g_strdup_printf("cp %s/share/automake/COPYING %s 2> /dev/stdout\n",prefix_automake,nombre);
	gen_comando(comando,NULL);
	g_free(comando);
	g_free(nombre);
	nombre=pro_nombre_completo_archivo("config.guess",FALSE);
	comando=g_strdup_printf("cp %s/share/automake/config.guess %s 2> /dev/stdout\n",prefix_automake,nombre);
	gen_comando(comando,NULL);
	g_free(comando);
	g_free(nombre);
	nombre=pro_nombre_completo_archivo("config.sub",FALSE);
	comando=g_strdup_printf("cp %s/share/automake/config.sub %s 2> /dev/stdout\n",prefix_automake,nombre);
	gen_comando(comando,NULL);
	g_free(comando);
	g_free(nombre);
	nombre=pro_nombre_completo_archivo("NEWS",FALSE);
	archivo=fopen(nombre,"a");
	fclose(archivo);
	g_free(nombre);
	nombre=pro_nombre_completo_archivo("README",FALSE);
	archivo=fopen(nombre,"a");
	fclose(archivo);
	g_free(nombre);
	nombre=pro_nombre_completo_archivo("AUTHORS",FALSE);
	archivo=fopen(nombre,"a");
	fclose(archivo);
	g_free(nombre);
	nombre=pro_nombre_completo_archivo("ChangeLog",FALSE);
	archivo=fopen(nombre,"a");
	fclose(archivo);
	g_free(nombre);
	aut_crear_makefile();
	aut_crear_makefile_src();
	aut_crear_configure_ac();
	aut_crear_potfiles_in();
	aut_crear_acconfig_h();
	nombre=pro_nombre_completo_archivo("configure.ac",TRUE);
	g_free(nombre);
	if (autoconfiguracion & ACLOCAL) {
		gen_comando("aclocal 2> /dev/stdout\n",NULL);
	}
	if (autoconfiguracion & AUTO_CONF) {
		nombre=pro_nombre_completo_archivo("config.cache",TRUE);
		if (gen_existe_fichero(nombre)) {
			gen_comando("rm config.cache 2> /dev/stdout\n",NULL);
		}
		g_free(nombre);
		gen_comando("autoconf 2> /dev/stdout\n",NULL);
	}
	if (autoconfiguracion & AUTO_HEADER) {
		gen_comando("autoheader 2> /dev/stdout\n",NULL);
	}
	if (autoconfiguracion & AUTO_MAKE) {
		gen_comando("automake 2> /dev/stdout\n",NULL);
	}
	if (autoconfiguracion & CONFIGURE) {
		gen_comando("./configure 2> /dev/stdout\n",NULL);
	}
	autoconfiguracion=0;

	DEBUG_MSG(<-pro_guardar);
}

gboolean pro_abrir(void)
{
	xmlNodePtr nodo;
	gchar *version;
	gchar *glade_file;
	gchar *nombre_proyecto;
	gchar *path_proyecto;
	gint cont;
	gboolean guardar;
	
	DEBUG_MSG(->pro_abrir);
	guardar=FALSE;
	proyecto.xml=xmlParseFile(proyecto.archivo);
	if ((!proyecto.xml) || (!(proyecto.xml)->root) || (!(proyecto.xml)->root->name) ||
		(g_strcasecmp((proyecto.xml)->root->name,"Proyecto_david")!=0)) {
			DEBUG_MSG(<-pro_abrir);
			return FALSE;
	}

	nodo=proyecto.xml->root->childs->next;
	path_proyecto=g_strdup(proyecto.archivo);
	for (cont=0;path_proyecto[cont]!=0;cont++);
	for (;path_proyecto[cont]!='/';cont--);
	path_proyecto[cont+1]=0;
	xmlSetProp(nodo,"proyecto",path_proyecto);
	g_free(path_proyecto);
	xmlSaveFile(proyecto.archivo,proyecto.xml);
	
	nodo=proyecto.xml->root;
	version=xmlGetProp(nodo,"version");
	if (!g_strcasecmp(version,"0.1")) {
		xmlSetProp(nodo,"version","0.3");
		nodo=nodo->childs->next;
		xmlNewProp(nodo,"pixmaps","pixmaps/");
		xmlNewProp(nodo,"glade","0");
		nombre_proyecto=pro_nombre();
		glade_file=g_strdup_printf("%s.glade",nombre_proyecto);
		xmlNewProp(nodo,"glade_file",glade_file);
		nodo=nodo->next;
		xmlNewProp(nodo,"gettext","0");
		guardar=TRUE;
		g_free(nombre_proyecto);
		g_free(glade_file);
	}
	g_free(version);
	nodo=proyecto.xml->root;
	version=xmlGetProp(nodo,"version");
	if (!g_strcasecmp(version,"0.3")) {
		xmlSetProp(nodo,"version","0.4");
		nodo=nodo->childs->next;
		xmlNewProp(nodo,"crear_h","1");
		xmlNewProp(nodo,"cabecera","1");
		xmlNewProp(nodo,"defines","0");
		guardar=TRUE;
	}
	g_free(version);
	nodo=proyecto.xml->root;
	version=xmlGetProp(nodo,"version");
	if (!g_strcasecmp(version,"0.4")) {
		xmlSetProp(nodo,"version","0.5");
		nodo=nodo->childs->next->next;
		xmlNewProp(nodo,"gnomeui","0");
		xmlNewProp(nodo,"gnorba","0");
		guardar=TRUE;
	}
	g_free(version);
	nodo=proyecto.xml->root;
	version=xmlGetProp(nodo,"version");
	if (!g_strcasecmp(version,"0.5")) {
		xmlSetProp(nodo,"version","0.6");
		nodo=nodo->childs->next->next;
		xmlNewProp(nodo,"audiofile","0");
		xmlNewProp(nodo,"esd","0");
		xmlNewProp(nodo,"gmodule","0");
		xmlNewProp(nodo,"imlib","0");
		guardar=TRUE;
	}
	g_free(version);
	nodo=proyecto.xml->root;
	version=xmlGetProp(nodo,"version");
	if (!g_strcasecmp(version,"0.6")) {
		xmlSetProp(nodo,"version","0.99");
		nodo=nodo->childs->next->next->next->next;
		xmlNewProp(nodo,"electric_fence","0");
		guardar=TRUE;
	}
	g_free(version);
	autoconfiguracion=0;
	
	if (guardar) pro_guardar();
	edit_cambiar_reglas_coloreado();
	edit_aplicar_reglas_coloreado(edit_editor);
	edit_aplicar_reglas_coloreado(edit_funciones);
	DEBUG_MSG(<-pro_abrir);
	return TRUE;
}

void pro_anadir(gchar *nombre)
{
	xmlNodePtr xmlnode;
	guint tipo;
	
	DEBUG_MSG(->pro_anadir);
	tipo=gen_tipo_archivo(nombre);
	switch (tipo) {
		case 0:
			xmlnode=buscar_nodo_xml(proyecto.xml->root,"otros");
			xmlNewChild(xmlnode,NULL,"otro",nombre);
			break;
		case 1:
			xmlnode=buscar_nodo_xml(proyecto.xml->root,"fuentes");
			xmlNewChild(xmlnode,NULL,"fuente",nombre);
			aut_crear_makefile_src();
			break;
		case 2:
			xmlnode=buscar_nodo_xml(proyecto.xml->root,"cabeceras");
			xmlNewChild(xmlnode,NULL,"cabecera",nombre);
			aut_crear_makefile_src();
			break;
	};
	DEBUG_MSG(<-pro_anadir);
}

gchar *pro_nombre(void)
{
	xmlNodePtr xmlnode;
	char *nombre;
	
	if (proyecto.xml!=NULL) {
		xmlnode=(proyecto.xml)->root->childs;
		nombre=xmlGetProp(xmlnode,"nombre");
	} else {
		nombre=NULL;
	}
	
	return nombre;
}

gchar *pro_fuentes(xmlNodePtr *xmlnode)
{
	if ((*xmlnode)==NULL) {
		(*xmlnode)=buscar_nodo_xml(proyecto.xml->root,"fuentes");
		(*xmlnode)=(*xmlnode)->childs;
	} else {
		(*xmlnode)=(*xmlnode)->next;
	}
	if ((*xmlnode)!=NULL) {
		return xmlNodeGetContent(*xmlnode);
	} else {
		return NULL;
	}
}

gchar *pro_cabeceras(xmlNodePtr *xmlnode)
{
	if ((*xmlnode)==NULL) {
		(*xmlnode)=buscar_nodo_xml(proyecto.xml->root,"cabeceras");
		(*xmlnode)=(*xmlnode)->childs;
	} else {
		(*xmlnode)=(*xmlnode)->next;
	}
	if ((*xmlnode)!=NULL) {
		return xmlNodeGetContent(*xmlnode);
	} else {
		return NULL;
	}
}

gchar *pro_otros(xmlNodePtr *xmlnode)
{
	if ((*xmlnode)==NULL) {
		(*xmlnode)=buscar_nodo_xml(proyecto.xml->root,"otros");
		(*xmlnode)=(*xmlnode)->childs;
	} else {
		(*xmlnode)=(*xmlnode)->next;
	}
	if ((*xmlnode)!=NULL) {
		return xmlNodeGetContent(*xmlnode);
	} else {
		return NULL;
	}
}

gchar *pro_nombre_completo_archivo(gchar *nombre,gboolean cambiar_directorio)
{
	xmlNodePtr xmlnode;
	gchar *path1,*path2;
	gchar *path;
	guint tipo;
	gchar *archivo;
	
	DEBUG_MSG(->pro_nombre_completo_archivo);
	path=NULL;
	xmlnode=(proyecto.xml)->root->childs->next;
	path1=xmlGetProp(xmlnode,"proyecto");
	path2=xmlGetProp(xmlnode,"fuentes");
	tipo=gen_tipo_archivo(nombre);
	switch (tipo) {
		case 0:
			path=g_strdup_printf("%s",path1);
			break;
		case 1:
		case 2:
			path=g_strdup_printf("%s%s",path1,path2);
			break;
	};
	if (cambiar_directorio) {
		chdir(path);
		g_free(path);
		archivo=g_strdup_printf("%s",nombre);
	} else {
		archivo=g_strdup_printf("%s%s",path,nombre);
		g_free(path);
	}
	g_free(path1);
	g_free(path2);

	DEBUG_MSG(<-pro_nombre_completo_archivo);
	return archivo;
}

gchar *pro_librerias_lincado(void)
{
	xmlNodePtr xmlnode;
	gchar *librerias,*tmp;
	gchar *lib;

	DEBUG_MSG(->pro_librerias_lincado);
	if (proyecto.xml!=NULL) {
		xmlnode=buscar_nodo_xml(proyecto.xml->root,"librerias");
		if (xmlnode==NULL) {
			DEBUG_MSG(el archivo del proyecto no es correcto);
		}
		lib=xmlGetProp(xmlnode,"xml");
		librerias=g_strdup_printf("%s",lib);
		tmp=librerias;
		g_free(lib);
		lib=xmlGetProp(xmlnode,"gtk");
		librerias=g_strdup_printf("%s%s",tmp,lib);
		g_free(tmp);
		tmp=librerias;
		g_free(lib);
		lib=xmlGetProp(xmlnode,"orbit");
		librerias=g_strdup_printf("%s%s",tmp,lib);
		g_free(tmp);
		tmp=librerias;
		g_free(lib);
		lib=xmlGetProp(xmlnode,"x11");
		librerias=g_strdup_printf("%s%s",tmp,lib);
		g_free(tmp);
		tmp=librerias;
		g_free(lib);
		lib=xmlGetProp(xmlnode,"gnome");
		librerias=g_strdup_printf("%s%s",tmp,lib);
		g_free(tmp);
		tmp=librerias;
		g_free(lib);
		lib=xmlGetProp(xmlnode,"glib");
		librerias=g_strdup_printf("%s%s",tmp,lib);
		g_free(tmp);
		tmp=librerias;
		g_free(lib);
		lib=xmlGetProp(xmlnode,"gettext");
		librerias=g_strdup_printf("%s%s",tmp,lib);
		g_free(tmp);
		tmp=librerias;
		g_free(lib);
		lib=xmlGetProp(xmlnode,"gnomeui");
		librerias=g_strdup_printf("%s%s",tmp,lib);
		g_free(tmp);
		tmp=librerias;
		g_free(lib);
		lib=xmlGetProp(xmlnode,"gnorba");
		librerias=g_strdup_printf("%s%s",tmp,lib);
		g_free(tmp);
		tmp=librerias;
		g_free(lib);
		lib=xmlGetProp(xmlnode,"audiofile");
		librerias=g_strdup_printf("%s%s",tmp,lib);
		g_free(tmp);
		tmp=librerias;
		g_free(lib);
		lib=xmlGetProp(xmlnode,"esd");
		librerias=g_strdup_printf("%s%s",tmp,lib);
		g_free(tmp);
		tmp=librerias;
		g_free(lib);
		lib=xmlGetProp(xmlnode,"gmodule");
		librerias=g_strdup_printf("%s%s",tmp,lib);
		g_free(tmp);
		tmp=librerias;
		g_free(lib);
		lib=xmlGetProp(xmlnode,"imlib");
		librerias=g_strdup_printf("%s%s",tmp,lib);
		g_free(tmp);
		tmp=librerias;
		g_free(lib);
		// esta linea en el cambio de nodo es porque el electric fence no esta con el resto de las librerias
		xmlnode=xmlnode->next->next;
		lib=xmlGetProp(xmlnode,"electric_fence");
		librerias=g_strdup_printf("%s%s",tmp,lib);
		g_free(tmp);
		tmp=librerias;
		g_free(lib);
	} else {
		librerias=NULL;
	}
	
	DEBUG_MSG(<-pro_librerias_lincado);
	return librerias;
}

gchar *pro_opciones_compilacion(void)
{

	xmlNodePtr xmlnode;
	gchar *opciones;
	gchar *estado;
	gchar *temporal;

	temporal=NULL;
	opciones=NULL;

	xmlnode=(proyecto.xml)->root->childs;
	estado=xmlGetProp(xmlnode,"lenguaje");
	switch (estado[0]-48) {
		case 0:
			opciones=g_strdup("gcc");
			break;
		case 1:
			opciones=g_strdup("c++");
			break;
	};
	temporal=opciones;
	g_free(estado);
	
	xmlnode=buscar_nodo_xml(proyecto.xml->root,"compilar");
	estado=xmlNodeGetContent(xmlnode);
	if (estado!=NULL) {
		opciones=g_strdup_printf("%s %s",temporal,estado);
		g_free(temporal);
		temporal=opciones;
	}
	g_free(estado);

	estado=xmlGetProp(xmlnode,"depuracion");
	if (estado[0]!='0') {
		opciones=g_strdup_printf("%s -g%s",temporal,estado);
		g_free(temporal);
		temporal=opciones;
	}
	g_free(estado);

	estado=xmlGetProp(xmlnode,"optimizacion");
	opciones=g_strdup_printf("%s -O%s",temporal,estado);
	g_free(temporal);
	temporal=opciones;
	g_free(estado);

	xmlnode=xmlnode->prev;
	estado=xmlGetProp(xmlnode,"w00");
	if (estado[0]=='1') {
		opciones=g_strdup_printf("%s -Wall",temporal);
		g_free(temporal);
		temporal=opciones;
	}
	g_free(estado);

	xmlnode=xmlnode->prev;
	estado=xmlNodeGetContent(xmlnode);
	if (estado!=NULL) {
		opciones=g_strdup_printf("%s %s",temporal,estado);
		g_free(temporal);
		temporal=opciones;
	}
	g_free(estado);

	opciones=g_strdup_printf("%s %s",temporal,"-I. -I/usr/include");
	g_free(temporal);
	temporal=opciones;

	estado=xmlGetProp(xmlnode,"gtk");
	if (estado[0]=='1') {
		opciones=g_strdup_printf("%s %s",temporal,preferencias.inc_gtk);
		g_free(temporal);
		temporal=opciones;
	}
	g_free(estado);

	estado=xmlGetProp(xmlnode,"xml");
	if (estado[0]=='1') {
		opciones=g_strdup_printf("%s %s",temporal,preferencias.inc_xml);
		g_free(temporal);
		temporal=opciones;
	}
	g_free(estado);

	estado=xmlGetProp(xmlnode,"orbit");
	if (estado[0]=='1') {
		opciones=g_strdup_printf("%s %s",temporal,preferencias.inc_orbit);
		g_free(temporal);
		temporal=opciones;
	}
	g_free(estado);

	estado=xmlGetProp(xmlnode,"x11");
	if (estado[0]=='1') {
		opciones=g_strdup_printf("%s %s",temporal,preferencias.inc_x11);
		g_free(temporal);
		temporal=opciones;
	}
	g_free(estado);

	estado=xmlGetProp(xmlnode,"gnome");
	if (estado[0]=='1') {
		opciones=g_strdup_printf("%s %s",temporal,preferencias.inc_gnome);
		g_free(temporal);
		temporal=opciones;
	}
	g_free(estado);

	estado=xmlGetProp(xmlnode,"glib");
	if (estado[0]=='1') {
		opciones=g_strdup_printf("%s %s",temporal,preferencias.inc_glib);
		g_free(temporal);
		temporal=opciones;
	}
	g_free(estado);
	
	estado=xmlGetProp(xmlnode,"gnorba");
	if (estado[0]=='1') {
		opciones=g_strdup_printf("%s %s",temporal,preferencias.inc_gnorba);
		g_free(temporal);
		temporal=opciones;
	}
	g_free(estado);
	
	xmlnode=xmlnode->childs->next->next;
	estado=xmlNodeGetContent(xmlnode);
	if (estado!=NULL) {
		opciones=g_strdup_printf("%s %s",temporal,estado);
		g_free(temporal);
		temporal=opciones;
	}
	g_free(estado);

	opciones=g_strdup_printf("%s -c",temporal);
	g_free(temporal);

	return opciones;
}

void pro_eliminar(gchar *nombre)
{
	guint tipo;
	xmlNodePtr xmlnode;
	gchar *contenido;

	xmlnode=buscar_nodo_xml(proyecto.xml->root,"fuentes");
	tipo=gen_tipo_archivo(nombre);
	switch (tipo) {
		case 0:
			xmlnode=xmlnode->next->next;
			break;
		case 1:
			break;
		case 2:
			xmlnode=xmlnode->next;
			break;
	};
	xmlnode=xmlnode->childs;
	contenido=xmlNodeGetContent(xmlnode);
	while (g_strcasecmp(contenido,nombre)) {
		xmlnode=xmlnode->next;
		contenido=xmlNodeGetContent(xmlnode);
	};
	xmlUnlinkNode(xmlnode);
	xmlFreeNode(xmlnode);
	pro_guardar();
	if (tipo!=0) {
		aut_crear_makefile_src();
	}
}

gboolean pro_existe_archivo(gchar *nombre)
{
	guint tipo;
	xmlNodePtr xmlnode;
	gchar *contenido;
	
	xmlnode=buscar_nodo_xml(proyecto.xml->root,"fuentes");
	tipo=gen_tipo_archivo(nombre);
	switch (tipo) {
		case 0:
			xmlnode=xmlnode->next->next;
			break;
		case 1:
			break;
		case 2:
			xmlnode=xmlnode->next;
			break;
	}
	xmlnode=xmlnode->childs;
	if (xmlnode!=NULL) {
		do {
			contenido=xmlNodeGetContent(xmlnode);
			xmlnode=xmlnode->next;
		} while ((xmlnode!=NULL) && (strcmp(contenido,nombre)));
		if (strcmp(contenido,nombre)) {
			return FALSE;
		} else {
			return TRUE;
		}
	} else {
		return FALSE;
	}
}

gchar *pro_version(void)
{
	xmlNodePtr nodo;
	gchar *version;
	
	if (proyecto.xml!=NULL) {
		nodo=(proyecto.xml)->root->childs;
		version=xmlGetProp(nodo,"version");
	} else {
		version=NULL;
	}
	return version;
}

gchar *pro_lenguaje(void)
{
	xmlNodePtr nodo;
	gchar *lenguaje;

	if (proyecto.xml!=NULL)	{
		nodo=(proyecto.xml)->root->childs;
		lenguaje=xmlGetProp(nodo,"lenguaje");
	} else {
		lenguaje=NULL;
	}
	
	return lenguaje;
}

gchar *pro_librerias_usuario(void)
{
	xmlNodePtr nodo;
	gchar *librerias,*tmp1,*tmp2;

	if (proyecto.xml!=NULL) {	
		nodo=buscar_nodo_xml(proyecto.xml->root,"librerias");
		nodo=buscar_nodo_xml(nodo,"otras");
		tmp1=xmlNodeGetContent(nodo);
		nodo=nodo->next;
		tmp2=xmlNodeGetContent(nodo);
		if ((tmp1==NULL) && (tmp2==NULL)) {
			return NULL;
		}
		if (tmp1==NULL) {
			tmp1=g_strdup("");
		}
		if (tmp2==NULL) {
			tmp2=g_strdup("");
		}
		librerias=g_strdup_printf("USER_LIBS=\"%s %s\"",tmp1,tmp2);
		g_free(tmp1);
		g_free(tmp2);
	} else {
		librerias=NULL;
	}
	
	return librerias;
	
}

gchar *pro_opciones_cflags(void)
{
	xmlNodePtr nodo;
	gchar *opciones,*tmp,*tmp1,*tmp2,*tmp3;
	
	DEBUG_MSG(->pro_opciones_cflags);
	nodo=buscar_nodo_xml(proyecto.xml->root,"compilar");
	if (nodo==NULL) {
		DEBUG_MSG(el archivo del proyecto no es correcto);
	}
	tmp1=xmlGetProp(nodo,"optimizacion");
	tmp2=xmlGetProp(nodo,"depuracion");
	tmp3=xmlNodeGetContent(nodo);
	
	opciones=g_strdup("");
	tmp=opciones;
	if (tmp2[0]!='0') {
		opciones=g_strdup_printf(" -g%s",tmp2);
		g_free(tmp);
		tmp=opciones;
	}
	if (tmp1[0]!='0') {
		opciones=g_strdup_printf("%s -O%s",tmp,tmp1);
		g_free(tmp);
		tmp=opciones;
	}
	if (tmp3!=NULL) {
		opciones=g_strdup_printf("%s %s",tmp,tmp3);
		g_free(tmp);
	}
	g_free(tmp1);
	g_free(tmp2);
	g_free(tmp3);
	
	DEBUG_MSG(<-pro_opciones_cflags);
	return opciones;
}

gchar *pro_includes(void)
{
	xmlNodePtr nodo;
	gchar *includes;
	
	nodo=buscar_nodo_xml(proyecto.xml->root,"librerias");
	nodo=buscar_nodo_xml(nodo,"includes");
	includes=xmlNodeGetContent(nodo);
	return includes;
}

gchar *pro_warnings(void)
{
	xmlNodePtr nodo;
	gchar *w,*tmp,*estado;
	
	nodo=buscar_nodo_xml(proyecto.xml->root,"avisos");
	w=g_strdup("");
	tmp=w;
	
	estado=xmlGetProp(nodo,"w00");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wall",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w01");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -W",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w02");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wtraditional",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w03");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wundef",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w04");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wshadow",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w05");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wpointer-arith",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w06");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wbad-function-cast",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w07");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wcast-qual",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w08");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wcast-align",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w09");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wwrite-strings",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w10");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wconversion",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w11");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wsign-compare",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w12");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Waggregate-return",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w13");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wstrict-prototypes",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w14");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wmissing-prototypes",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w15");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wmissing-declarations",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w16");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wredundant-decls",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w17");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wnested-esterns",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w18");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Winline",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w19");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wold-style-cast",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w20");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Woverloaded-virtual",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w21");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wsynth",tmp);
		g_free(tmp);
		tmp=w;
	}
	
	return w;
}

gchar *pro_srcdir(void)
{
	xmlNodePtr nodo;
	gchar *srcdir;
	gint cont;
	
	nodo=(proyecto.xml)->root->childs->next;
	srcdir=xmlGetProp(nodo,"fuentes");
	for (cont=0;srcdir[cont]!=0;cont++);
	srcdir[cont-1]=0;
	return srcdir;
}

gchar *pro_prodir(void)
{
	xmlNodePtr nodo;
	gchar *prodir;
	gint cont;
	
	nodo=(proyecto.xml)->root->childs->next;
	prodir=xmlGetProp(nodo,"proyecto");
	for (cont=0;prodir[cont]!=0;cont++);
	prodir[cont-1]=0;
	return prodir;
}

gchar *pro_pixdir(void)
{
	xmlNodePtr nodo;
	gchar *pixdir;
	gint cont;
	
	nodo=(proyecto.xml)->root->childs->next;
	pixdir=xmlGetProp(nodo,"pixmaps");
	for (cont=0;pixdir[cont]!=0;cont++);
	pixdir[cont-1]=0;
	return pixdir;
}

gchar *pro_glade_file(void)
{
	xmlNodePtr nodo;
	gchar *glade_file,*glade;

	if (proyecto.xml!=NULL) {
		nodo=(proyecto.xml)->root->childs->next;
		glade=xmlGetProp(nodo,"glade");
		glade_file=xmlGetProp(nodo,"glade_file");
		if (glade[0]=='0') {
			g_free(glade_file);
			glade_file=NULL;
		}
		g_free(glade);
	} else {
		glade_file=NULL;
	}
	return glade_file;
}

gchar *pro_ejecutable(void)
{
	xmlNodePtr nodo;
	gchar *ejecutable;

	nodo=(proyecto.xml)->root->childs->next;
	ejecutable=xmlGetProp(nodo,"nombre");
	return ejecutable;
}

gchar *pro_cabecera_gnu(void)
{
	gchar *cabecera;
	xmlNodePtr nodo;
	gchar *crear_cabecera;
	gchar *nombre,*autor,*e_mail;
	int fecha;
	struct tm *s_fecha;
	time_t tiempo;
	
	DEBUG_MSG(->pro_cabecera_gnu);
	nodo=proyecto.xml->root->childs->next;
	crear_cabecera=xmlGetProp(nodo,"cabecera");
	if (crear_cabecera[0]=='0') {
		g_free(crear_cabecera);
		cabecera=NULL;
		DEBUG_MSG(<-pro_cabedera_gnu);
		return cabecera;
	}
	g_free(crear_cabecera);
	nodo=nodo->prev;
	nombre=xmlGetProp(nodo,"nombre");
	autor=xmlGetProp(nodo,"autor");
	e_mail=xmlGetProp(nodo,"e-mail");
	tiempo=time(NULL);
	s_fecha=gmtime(&tiempo);
	fecha=(s_fecha->tm_year)+1900;
	cabecera=g_strdup_printf(
"/*
 * %s
 * Copyright (C) %i  %s
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * %s
 * %s
 */

"	,nombre,fecha,autor,autor,e_mail);
	g_free(nombre);
	g_free(autor);
	g_free(e_mail);
	DEBUG_MSG(<-pro_cabecera_gnu);
	return cabecera;
}

gboolean pro_crear_h(void)
{
	xmlNodePtr nodo;
	gchar *estado;
	
	nodo=proyecto.xml->root->childs->next;
	estado=xmlGetProp(nodo,"crear_h");
	if (estado[0]=='1') {
		g_free(estado);
		return TRUE;
	} else {
		g_free(estado);
		return FALSE;
	}
}

gboolean pro_defines(void)
{
	xmlNodePtr nodo;
	gchar *estado;
	
	nodo=proyecto.xml->root->childs->next;
	estado=xmlGetProp(nodo,"defines");
	if (estado[0]=='1') {
		g_free(estado);
		return TRUE;
	} else {
		g_free(estado);
		return FALSE;
	}
}

void pro_actualizar_librerias_lincado(GtkWidget *widget)
{
	GtkWidget *fuente;
	xmlNodePtr xmlnode;

	widget=gtk_widget_get_toplevel(widget);
		xmlnode=buscar_nodo_xml(proyecto.xml->root,"librerias");
	
	fuente=lookup_widget(widget,"gtk_libs_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"gtk","1");
	} else {
		xmlSetProp(xmlnode,"gtk","0");
	}
	
	fuente=lookup_widget(widget,"xml_libs_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"xml","1");
	} else {
		xmlSetProp(xmlnode,"xml","0");
	}
	
	fuente=lookup_widget(widget,"orbit_libs_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"orbit","1");
	} else {
		xmlSetProp(xmlnode,"orbit","0");
	}
	
	fuente=lookup_widget(widget,"x11_libs_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"x11","1");
	} else {
		xmlSetProp(xmlnode,"x11","0");
	}
	
	fuente=lookup_widget(widget,"gnome_libs_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"gnome","1");
	} else {
		xmlSetProp(xmlnode,"gnome","0");
	}
	
	fuente=lookup_widget(widget,"glib_libs_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"glib","1");
	} else {
		xmlSetProp(xmlnode,"glib","0");
	}
	
	fuente=lookup_widget(widget,"gettext_libs_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"gettext","1");
	} else {
		xmlSetProp(xmlnode,"gettext","0");
	}

	fuente=lookup_widget(widget,"gnomeui_libs_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"gnomeui","1");
	} else {
		xmlSetProp(xmlnode,"gnomeui","0");
	}

	fuente=lookup_widget(widget,"gnorba_libs_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"gnorba","1");
	} else {
		xmlSetProp(xmlnode,"gnorba","0");
	}

	fuente=lookup_widget(widget,"audiofile_libs_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"audiofile","1");
	} else {
		xmlSetProp(xmlnode,"audiofile","0");
	}

	fuente=lookup_widget(widget,"esd_libs_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"esd","1");
	} else {
		xmlSetProp(xmlnode,"esd","0");
	}

	fuente=lookup_widget(widget,"gmodule_libs_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"gmodule","1");
	} else {
		xmlSetProp(xmlnode,"gmodule","0");
	}

	fuente=lookup_widget(widget,"imlib_libs_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"imlib","1");
	} else {
		xmlSetProp(xmlnode,"imlib","0");
	}
}

void pro_mostrar_librerias_lincado(GtkWidget *widget)
{
	GtkWidget *fuente;
	xmlNodePtr xmlnode;
	gchar *texto;

	pro_forzando_librerias=TRUE;
	xmlnode=buscar_nodo_xml(proyecto.xml->root,"librerias");
	
	fuente=lookup_widget(widget,"gtk_libs_boton");
	texto=xmlGetProp(xmlnode,"gtk");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"xml_libs_boton");
	texto=xmlGetProp(xmlnode,"xml");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"orbit_libs_boton");
	texto=xmlGetProp(xmlnode,"orbit");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"x11_libs_boton");
	texto=xmlGetProp(xmlnode,"x11");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"gnome_libs_boton");
	texto=xmlGetProp(xmlnode,"gnome");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"glib_libs_boton");
	texto=xmlGetProp(xmlnode,"glib");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"gettext_libs_boton");
	texto=xmlGetProp(xmlnode,"gettext");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"gnomeui_libs_boton");
	texto=xmlGetProp(xmlnode,"gnomeui");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"gnorba_libs_boton");
	texto=xmlGetProp(xmlnode,"gnorba");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"audiofile_libs_boton");
	texto=xmlGetProp(xmlnode,"audiofile");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"esd_libs_boton");
	texto=xmlGetProp(xmlnode,"esd");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"gmodule_libs_boton");
	texto=xmlGetProp(xmlnode,"gmodule");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=lookup_widget(widget,"imlib_libs_boton");
	texto=xmlGetProp(xmlnode,"imlib");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);

	pro_forzando_librerias=FALSE;
}
