/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

/*******************************************************************************
 Inicializa las variables globales del arbol cefv
 *******************************************************************************/
void cefv_inicializar(void)
{
	lista_cefv=NULL;
}

/*******************************************************************************
 Creea el arbol cefv con las secciones bacias
 *******************************************************************************/
void cefv_crear(void)
{
	GtkCTree *ctree;
	gchar *texto1[]={_("Clases")};
	gchar *texto2[]={_("Functions")};
	gchar *texto3[]={_("Unions")};
	gchar *texto4[]={_("Structures")};
	gchar *texto5[]={_("Variables")};
	gchar *texto6[]={_("Enumerations")};
	gchar *texto7[]={_("Types")};

	DEBUG_MSG(->cefv_crear);
	
	ctree=GTK_CTREE(lookup_widget(david_ventana,"cefv_arbol"));
	gtk_ctree_remove_node(ctree,NULL);
	cefv_clases=gtk_ctree_insert_node(ctree,NULL,NULL,texto1,3,pixmaps[CLASES],NULL,pixmaps[CLASES],NULL,FALSE,FALSE);
	cefv_funciones=gtk_ctree_insert_node(ctree,NULL,NULL,texto2,3,pixmaps[FUNCIONES],NULL,pixmaps[FUNCIONES],NULL,FALSE,FALSE);
	cefv_uniones=gtk_ctree_insert_node(ctree,NULL,NULL,texto3,3,pixmaps[UNIONES],NULL,pixmaps[UNIONES],NULL,FALSE,FALSE);
	cefv_estructuras=gtk_ctree_insert_node(ctree,NULL,NULL,texto4,3,pixmaps[ESTRUCURAS],NULL,pixmaps[ESTRUCURAS],NULL,FALSE,FALSE);
	cefv_bariables=gtk_ctree_insert_node(ctree,NULL,NULL,texto5,3,pixmaps[BARIABLES],NULL,pixmaps[BARIABLES],NULL,FALSE,FALSE);
	cefv_enumeraciones=gtk_ctree_insert_node(ctree,NULL,NULL,texto6,3,pixmaps[ENUMERACIONES],NULL,pixmaps[ENUMERACIONES],NULL,FALSE,FALSE);
	cefv_tipos=gtk_ctree_insert_node(ctree,NULL,NULL,texto7,3,pixmaps[TIPOS],NULL,pixmaps[TIPOS],NULL,FALSE,FALSE);
	
	cefv_lista_combo=NULL;
	cefv_congelar_lista_combo=TRUE;
	DEBUG_MSG(<-cefv_crear);
}

/*******************************************************************************
 Aade una entrada al arbol cefv
 El parametro pasado es una cadena correspondiente a una linea del
 archivo tags creado por exuberant-ctags
 *******************************************************************************/
void cefv_anadir(gchar *tag_line)
{
	struct s_lista_cefv *nodo_lista;
	GtkCTree *ctree;
	gchar *texto[1];
	gchar *archivo,*definicion,*texto_rama;
	guint cont,inicio;
	gchar *tipo;
	
	if (lista_cefv==NULL) {
		lista_cefv=g_malloc(sizeof(struct s_lista_cefv));
		nodo_lista=lista_cefv;
		nodo_lista->anterior=NULL;
	} else {
		nodo_lista=lista_cefv;
		while (nodo_lista->siguiente!=NULL) {
			nodo_lista=nodo_lista->siguiente;
		}
		nodo_lista->siguiente=g_malloc(sizeof(struct s_lista_cefv));
		nodo_lista->siguiente->anterior=nodo_lista;
		nodo_lista=nodo_lista->siguiente;
	}
	cont=0;
	inicio=0;
	for (;tag_line[cont]!='\t';cont++);
	tag_line[cont]=0;
	texto_rama=g_strdup_printf("%s",tag_line+inicio);
	cont++;
	inicio=cont;
	for (;tag_line[cont]!='\t';cont++);
	tag_line[cont]=0;
	archivo=g_strdup_printf("%s",tag_line+inicio);
	cont+=3;
	inicio=cont;
	for (;(tag_line[cont]!='\t') || (tag_line[cont-1]!='"') || (tag_line[cont-2]!=';') || (tag_line[cont-3]!='/') || (tag_line[cont-4]!='$');cont++);
	tag_line[cont-4]=0;
	definicion=g_strdup_printf("%s",tag_line+inicio);
	cont++;
	inicio=cont;
	tag_line[cont+1]=0;
	tipo=g_strdup_printf("%s",tag_line+inicio);

	nodo_lista->siguiente=NULL;
	nodo_lista->hijos=NULL;
	nodo_lista->archivo=archivo;
	nodo_lista->definicion=definicion;
	nodo_lista->rama=texto_rama;

	ctree=GTK_CTREE(lookup_widget(david_ventana,"cefv_arbol"));
	texto[0]=nodo_lista->rama;
	switch (tipo[0]) {
		case 'c':
			nodo_lista->nodo=gtk_ctree_insert_node(ctree,cefv_clases,NULL,texto,3,pixmaps[CLASES],NULL,pixmaps[CLASES],NULL,FALSE,FALSE);
			break;
		case 's':
			nodo_lista->nodo=gtk_ctree_insert_node(ctree,cefv_estructuras,NULL,texto,3,pixmaps[ESTRUCURAS],NULL,pixmaps[ESTRUCURAS],NULL,FALSE,FALSE);
			break;
		case 'f':
			nodo_lista->nodo=gtk_ctree_insert_node(ctree,cefv_funciones,NULL,texto,3,pixmaps[FUNCIONES],NULL,pixmaps[FUNCIONES],NULL,TRUE,FALSE);
			cefv_lista_combo=g_list_insert_sorted(cefv_lista_combo,g_strdup(nodo_lista->rama),(GCompareFunc)&strcmp);
			break;
		case 'v':
			nodo_lista->nodo=gtk_ctree_insert_node(ctree,cefv_bariables,NULL,texto,3,pixmaps[BARIABLES],NULL,pixmaps[BARIABLES],NULL,TRUE,FALSE);
			break;
		case 'g':
			nodo_lista->nodo=gtk_ctree_insert_node(ctree,cefv_enumeraciones,NULL,texto,3,pixmaps[ENUMERACIONES],NULL,pixmaps[ENUMERACIONES],NULL,TRUE,FALSE);
			break;
		case 'u':
			nodo_lista->nodo=gtk_ctree_insert_node(ctree,cefv_uniones,NULL,texto,3,pixmaps[UNIONES],NULL,pixmaps[UNIONES],NULL,FALSE,FALSE);
			break;
		case 't':
			nodo_lista->nodo=gtk_ctree_insert_node(ctree,cefv_tipos,NULL,texto,3,pixmaps[TIPOS],NULL,pixmaps[TIPOS],NULL,TRUE,FALSE);
			break;
		case 'm':
			g_free(nodo_lista->definicion);
			g_free(nodo_lista->archivo);
			nodo_lista->definicion=nodo_lista->anterior->definicion;
			nodo_lista->archivo=nodo_lista->anterior->archivo;
			nodo_lista->nodo=gtk_ctree_insert_node(ctree,nodo_lista->anterior->nodo,NULL,texto,0,pixmaps[MIEMBRO],NULL,pixmaps[MIEMBRO],NULL,TRUE,FALSE);
			nodo_lista->anterior->siguiente=NULL;
			nodo_lista->siguiente=nodo_lista->anterior->hijos;
			nodo_lista->anterior->hijos=nodo_lista;
			nodo_lista->anterior=NULL;
			if (nodo_lista->siguiente!=NULL) {
				nodo_lista->siguiente->anterior=nodo_lista;
			}
			break;
	}
	g_free(tipo);
}

/*******************************************************************************
 Analiza un archivo llamano a exuberant-ctags y aadiendo todas las entradas
 en el arbol cefv
 *******************************************************************************/
int cefv_analizar_archivo(gchar *nombre)
{
	GtkCTree *arbol;
	FILE *archivo,*tuberia;
	gchar *tags;
	gchar *tmp;
	gchar *comando;
	guint size;
	guint cont;
	guint comienzo_tag;
	gchar *tag;
	gint tipo;
	GtkWidget *combo;
     int retorno;

	DEBUG_MSG(->cefv_analizar_archivo);
	
	arbol=GTK_CTREE(lookup_widget(david_ventana,"cefv_arbol"));
	tipo=gen_tipo_archivo(nombre);
	if ((tipo==1) || (tipo==2)) {
		tmp=pro_nombre_completo_archivo(nombre,TRUE);
		g_free(tmp);
		// nos aseguramos de que no exista un archibo tags
		retorno = remove ("tags");
		//we try ctags-exuberant and ctags, as the name is different depending on the distribution used.
#ifdef _LINUX
		comando=g_strdup_printf("ctags-exuberant --excmd=p --c-types=-edn --sort=no %s",nombre);
#endif
#ifdef _FREEBSD
		comando=g_strdup_printf("exctags --excmd=p --c-types=-edn --sort=no %s",nombre);
#endif
		tuberia=popen(comando,"r");
		pclose(tuberia);
		archivo=fopen("tags","a+");
		fseek(archivo,0,SEEK_END);
		size=ftell(archivo);
		if (size == 0) {
			//"ctags-exuberant" did not work, we try now "ctags"
			fclose (archivo);
			retorno = remove ("tags");
			g_free(comando);
			comando=g_strdup_printf("ctags --excmd=p --c-types=-edn --sort=no %s",nombre);
			tuberia=popen(comando,"r");
			pclose(tuberia);
			archivo=fopen("tags","a+");
			fseek(archivo,0,SEEK_END);
			size=ftell(archivo);
			if (size == 0) {
				//Both calls failed, so exuberant-ctags is not installed or working correctly
				fclose (archivo);
				retorno = remove ("tags");
				g_printerr(_("An error ocurred while executing exuberant-ctags. DiaSCE can't work if exuberant-ctags doesn't work properly. Fix that problem before continuing using DiaSCE. The command line used to call exuberant-ctags was:\n%s\n"),comando);
				g_free(comando);
				DEBUG_MSG(<-cefv_analizar_archivo 1);
				return -1;
			}
		}
		g_free(comando);
		tags=g_malloc(size);
		fseek(archivo,0,SEEK_SET);
		fread(tags,size,1,archivo);
		fclose(archivo);
		//ya no necesitamos el archivo tags, asi que lo borramos
		retorno = remove ("tags");
		
		cont=0;
		do {
			for (;(tags[cont]!='\n') && (cont<size);cont++);
			cont++;
		} while ((tags[cont]=='!') && (cont!=size));
		if (cont==size) {
			DEBUG_MSG(<-cefv_analizar_archivo);
			return 0;
		}
		
		cefv_eliminar_archivo(nombre);

		gtk_clist_freeze(GTK_CLIST(arbol));
		do {
			comienzo_tag=cont;
			for (;tags[cont]!='\n';cont++);
			tags[cont]=0;
			tag=g_strdup_printf("%s",tags+comienzo_tag);
			cefv_anadir(tag);
			g_free(tag);
			cont++;
		} while (cont!=size);
		g_free(tags);
	}
	gtk_ctree_sort_node(arbol,cefv_clases);
	gtk_ctree_sort_node(arbol,cefv_estructuras);
	gtk_ctree_sort_node(arbol,cefv_funciones);
	gtk_ctree_sort_node(arbol,cefv_bariables);
	gtk_ctree_sort_node(arbol,cefv_enumeraciones);

	if ((!cefv_congelar_lista_combo) && (cefv_lista_combo!=NULL)) {
		cefv_congelar_lista_combo=TRUE;
		combo=lookup_widget(david_ventana,"funciones_combo");
		gtk_combo_set_popdown_strings(GTK_COMBO(combo),cefv_lista_combo);
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),"");
		cefv_congelar_lista_combo=FALSE;
	}

	DEBUG_MSG(<-cefv_analizar_archivo);
	return 0;
}

/*******************************************************************************
 Elimina todas las entradas correspondientes a un mismo archivo del
 arbol cefv
 *******************************************************************************/
void cefv_eliminar_archivo(gchar *nombre)
{
	GtkCTree *ctree;
	struct s_lista_cefv *nodo_cefv,*eliminar,*hijos;
	GList *lista_combo;
	
	DEBUG_MSG(->cefv_eliminar_archivo);
	ctree=GTK_CTREE(lookup_widget(david_ventana,"cefv_arbol"));
	gtk_clist_freeze(GTK_CLIST(ctree));
	nodo_cefv=lista_cefv;
	while (nodo_cefv!=NULL) {
		if (!strcmp(nodo_cefv->archivo,nombre)) {
			eliminar=nodo_cefv;
			gtk_ctree_remove_node(ctree,nodo_cefv->nodo);
			if (nodo_cefv->siguiente!=NULL) {
				nodo_cefv->siguiente->anterior=nodo_cefv->anterior;
			}
			if (nodo_cefv->anterior!=NULL) {
				nodo_cefv->anterior->siguiente=nodo_cefv->siguiente;
			} else {
				lista_cefv=nodo_cefv->siguiente;
			}
			g_free(nodo_cefv->definicion);
			
			lista_combo=g_list_find_custom(cefv_lista_combo,nodo_cefv->rama,(GCompareFunc)&strcasecmp);
			cefv_lista_combo=g_list_remove_link(cefv_lista_combo,lista_combo);
			g_list_free_1(lista_combo);
			
			g_free(nodo_cefv->rama);
			g_free(nodo_cefv->archivo);
			if (nodo_cefv->hijos!=NULL) {
				hijos=nodo_cefv->hijos;
				do {
					if (hijos->siguiente!=NULL) {
						g_free(hijos->rama);
						hijos=hijos->siguiente;
						g_free(hijos->anterior);
					} else {
						g_free(hijos->rama);
						g_free(hijos);
						hijos=NULL;
					}
				} while (hijos!=NULL);
				nodo_cefv->hijos=NULL;
			}
			nodo_cefv=nodo_cefv->siguiente;
			g_free(eliminar);
		} else {
			nodo_cefv=nodo_cefv->siguiente;
		}
	}
	DEBUG_MSG(<-cefv_eliminar_archivo);
}
