/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.functions;

import java.util.Vector;
import org.apache.xpath.Expression;
import org.apache.xpath.functions.Function3Args;
import org.apache.xpath.functions.WrongNumberArgsException;

public class FunctionMultiArgs
extends Function3Args {
    Expression[] m_args;

    public boolean canTraverseOutsideSubtree() {
        if (super.canTraverseOutsideSubtree()) {
            return true;
        }
        int n = this.m_args.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.m_args[n2].canTraverseOutsideSubtree()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void checkNumberArgs(int n) throws WrongNumberArgsException {
    }

    public void fixupVariables(Vector vector, int n) {
        super.fixupVariables(vector, n);
        if (this.m_args != null) {
            int n2 = 0;
            while (n2 < this.m_args.length) {
                this.m_args[n2].fixupVariables(vector, n);
                ++n2;
            }
        }
    }

    public void setArg(Expression expression, int n) throws WrongNumberArgsException {
        if (n < 3) {
            super.setArg(expression, n);
        } else if (this.m_args == null) {
            this.m_args = new Expression[1];
            this.m_args[0] = expression;
        } else {
            Expression[] expressionArray = new Expression[this.m_args.length + 1];
            System.arraycopy(this.m_args, 0, expressionArray, 0, this.m_args.length);
            expressionArray[this.m_args.length] = expression;
            this.m_args = expressionArray;
        }
    }
}

