#ifndef _SCREEN_CPP_
#define _SCREEN_CPP_

#include <stdio.h>
#include <string.h>

#include "screen.h"

Screen::Screen() {
  mem = new char[TXTWIDTH*TXTHEIGHT];
  clear();
}

Screen::~Screen() {
  delete[] mem;
}


bool Screen::valid(int x, int y) {
  if (x<TXTWIDTH-1 && x>=0 && y<TXTHEIGHT && y>=0) return true;
  else return false;
}

void Screen::internalPut(int x, int y, char c) {
  mem[x + y*TXTWIDTH] = c;
}


char Screen::get(int x, int y) { return mem[x + y*TXTWIDTH]; }

void Screen::put(int x, int y, char c, bool update) {
  if (valid(x,y)) {
    internalPut(x,y,c);
    if (update) {
      printf("\ec");
      this->update();
    }
  }
}

void Screen::text(int x, int y, const char * txt) {
  if (valid(x,y) && txt!=0) {
    char * start = mem + x + y*TXTWIDTH;
    int len = strlen(txt);
    if (len>0) {
      for (int i=0; i<len; i++) start[i] = txt[i];
    }
  }
}

void Screen::draw(int x1, int y1, int x2, int y2) {
  if (valid(x1,y1) && valid(x2,y2)) {
    char c = '*';
    if (y1==y2) c = '-';
    if (x1==x2) c = '|';
    int dx = x2-x1;
    int dy = y2-y1;
    double s = 0;
    if (dx!=0) s = dy*1.0/dx;
    if      (dx > 0) for (int x=x1; x<x2+1; x++) internalPut(x, int(y1+s*(x-x1)), c);
    else if (dx < 0) for (int x=x1; x>x2-1; x--) internalPut(x, int(y1+s*(x-x1)), c);
    else if (dy > 0) for (int y=y1; y<y2+1; y++) internalPut(x1, y, c);
    else             for (int y=y1; y>y2-1; y--) internalPut(x1, y, c);
  }
}

void Screen::clear() {
  for (int i=0; i<TXTWIDTH*TXTHEIGHT; i++) {
    if (i%TXTWIDTH == TXTWIDTH-1)
      mem[i] = '\n'; // a line contains TXTWIDTH-1 characters
    else
      mem[i] = ' ';
  }
  mem[TXTWIDTH*TXTHEIGHT-1] = 0;
}

int Screen::width() { return TXTWIDTH-2; }

void Screen::update() {
  printf(mem);
}



#endif
