#ifndef _KDEEVENTCONTENT_H_
#define _KDEEVENTCONTENT_H_

#include <qlistview.h>
#include <qstring.h>
#include <qtimer.h>

#define COLS 8


class Part;
class KdeEventEditor;



// ***********************
// **                   **
// **     NoteItem      **
// **                   **
// ***********************



class NoteItem : public QListViewItem
{
 public:
  NoteItem( QListView * parent, QString a1, QString a2, QString a3, QString a4, QString a5, QString a6, QString a7, QString a8 );
  
  void setOpen( bool );
  void setup();
  
  QString fullName();
  QString text(int) const;

  const QPixmap *pixmap( int i ) const;
  void setPixmap( QPixmap *p );
  
 private:
  NoteItem * p;
  QPixmap *pix;
  QString val[COLS];
};



// ***********************
// **                   **
// **    SymbolItem     **
// **                   **
// ***********************


class SymbolItem : public QListViewItem
{
 public:
  SymbolItem( QListViewItem *parent );
  SymbolItem( QListView *parent );
  SymbolItem( QListView * parent, QString a1, QString a2, QString a3, QString a4, QString a5, QString a6, QString a7 );
  
  const QPixmap *pixmap( int i ) const;
  void setPixmap( QPixmap *p );
  
 private:
  QPixmap *pix;
  QString val[COLS];
};


// ***********************
// **                   **
// **   MidiEventItem   **
// **                   **
// ***********************


class MidiEventItem : public QListViewItem
{
 public:
  MidiEventItem( QListViewItem *parent );
  MidiEventItem( QListView *parent );
  MidiEventItem( QListView * parent, QString a1, QString a2, QString a3, QString a4, QString a5, QString a6, QString a7 );
  
  const QPixmap *pixmap( int i ) const;
  void setPixmap( QPixmap *p );
  
 private:
  QPixmap *pix;
  QString val[COLS];
};



// ***********************
// **                   **
// **  MasterEventItem  **
// **                   **
// ***********************


class MasterEventItem : public QListViewItem
{
 public:
  MasterEventItem( QListViewItem *parent );
  MasterEventItem( QListView *parent );
  MasterEventItem( QListView * parent, QString a1, QString a2, QString a3, QString a4, QString a5, QString a6, QString a7 );
  
  const QPixmap *pixmap( int i ) const;
  void setPixmap( QPixmap *p );
  
 private:
  QPixmap *pix;
  QString val[COLS];
};


// ***********************
// **                   **
// **   OrnamentItem    **
// **                   **
// ***********************


class OrnamentItem : public QListViewItem
{
 public:
  OrnamentItem( QListViewItem *parent );
  OrnamentItem( QListView *parent );
  OrnamentItem( QListView * parent, QString a1, QString a2, QString a3, QString a4, QString a5, QString a6, QString a7 );
  
  const QPixmap *pixmap( int i ) const;
  void setPixmap( QPixmap *p );
  
 private:
  QPixmap *pix;
  QString val[COLS];
};




// *******************************
// **                           **
// **        EventContent       **
// **                           **
// *******************************


class KdeEventContent : public QListView
{
  Q_OBJECT

 private:
  KdeEventEditor * _editor;
  Part * _part;

 public:
  KdeEventContent( KdeEventEditor * qte, Part * pt, QWidget * parent = 0 );

 public slots:
  void ok(int);
  void setNote( const QString & );
  void slotNoteSelected(QListViewItem*);
  void openNote();

 signals:
  void noteSelected( const QString & );

 protected:
  void contentsDragEnterEvent( QDragEnterEvent *e );
  void contentsDragMoveEvent( QDragMoveEvent *e );
  void contentsDragLeaveEvent( QDragLeaveEvent *e );
  void contentsDropEvent( QDropEvent *e );
  void contentsMouseMoveEvent( QMouseEvent *e );
  void contentsMousePressEvent( QMouseEvent *e );
  void contentsMouseReleaseEvent( QMouseEvent *e );

 private:
  //QString fullPath(QListViewItem* item);
  //bool dirsOnly;
  QListViewItem *oldCurrent;
  QListViewItem *dropItem;
  QTimer* autoopen_timer;
  QPoint presspos;
  bool mousePressed;
};


#endif
