#ifndef _CONVERTTRACK_H_
#define _CONVERTTRACK_H_

#include "operation.h"

class Song;
class Track;

/** This class converts a track of a type to a track of another type. Therefore a new (empty) track is created.
 * The content is kept and passed to the new track. The presentation is hidden and a new one is created.
 * On undo/redo, the presentations hide and show (I experienced segfaults, deleting widgets by myself!)
 * The old track is kept in memory.
 * When this object is removed, either _old or _new should be removed (depending on the actual state (undone, redone,...)
 * Therefore the pointer _delete is introduced, pointing to either _new or _old
 */
class ConvertTrack : public Operation
{
 private:
  Song * _song;
  Track * _old;
  Track * _new;
  Track * _delete;

 public:
  ConvertTrack(int,Track*,Song*);
  ConvertTrack(const ConvertTrack&);
  ~ConvertTrack();

  void undo();
  void redo();


  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};



#endif
