#ifndef _RIEMANNEVENT_H_
#define _RIEMANNEVENT_H_

#include "event.h"
#include "riemann.h"
#include "harmony.h"

/**
 * Instances of this class are riemannevents. They do not need a (graphical) presentation of their own. They can be displayed
 * graphically within the presentation of the parts, they belong to.
 **/

class RiemannEvent : public Event
{
 private:
  Key    _base_key; // base key: The Tonika, e.g. A - the base stays the same until a modulation is done!
  Genus  _base_gen; // the base key's genus, e.g. Major
  Key    _key;      // chord key, e.g. E (quint to A)
  Genus  _genus;    // chord genus, e.g Major

  int _bass;
  char * _value;

  static Key key(const char *);
  static Genus genus(const char *);
  static int step(const char *);

 public:
  /**
   * Default Constructor
   **/
  RiemannEvent( );

  /**
   * Destructor
   **/
  ~RiemannEvent( );

  /**
   * Copy Constructor
   **/
  RiemannEvent(const RiemannEvent&);

  /**
   * Constructor defining a riemannevent
   **/
  RiemannEvent(Position pos, Harmony * harmony = 0);

  /**
   * sets the base, genus and bass
   **/
  void set(const char*, const char*, const char*);

  /**
   * Implementation of the print method
   **/
  virtual ostream & print(int,ostream&) const;

  /**
   * Implementation of the flush method
   **/
  virtual void flush(const char*) const;

  /**
   * Implementation of the copy method
   **/
  virtual Element * copy() const;

  /**
   * Implementation of the value shown inside the editors' infobox
   **/
  virtual const char * value();

  /**
   * Implementation of the load method
   **/
  static Element * load(char*,ifstream*&,Element*);

};


#endif
