#!/usr/bin/env python

# BloGTK Version 1.0
# Preview System Routines - preview.py
# (C)2004 Jay Reding
# Code released under the terms of the BSD License. (See file LICENSE)

import pygtk
import gtk
import gtk.glade
import gnome
import gtkhtml2
import pango
import os

def previewEntry(mainGlade, view):

   # 0.7 - This code controls our preview code. We're going to use the gtkhtml2 widget for
   # previewing. It's a fairly buggy piece of code, but it works well enough for basic
   # preview functions.

   # 0.7 - Pull the title from our form
   titleEntry = mainGlade.get_widget('titleEntry')
   title = titleEntry.get_text()

   # 0.7 - Pull our entry body from our form
   bodyView = mainGlade.get_widget('bodyView')
   buffer = bodyView.get_buffer()
   startiter = buffer.get_start_iter()
   enditer = buffer.get_end_iter()
   body = buffer.get_text(startiter, enditer, include_hidden_chars=1)

   # 0.95 - Pull our extended entry from our form
   extendedView = mainGlade.get_widget('extendedView')
   buffer = extendedView.get_buffer()
   startiter = buffer.get_start_iter()
   enditer = buffer.get_end_iter()
   extended = buffer.get_text(startiter, enditer, include_hidden_chars=1)

   document = gtkhtml2.Document()

   document.clear()
   document.open_stream('text/html')
   document.write_stream('<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n')
   document.write_stream('<html xmlns=\"http://www.w3.org/1999/xhtml\">\n')
   document.write_stream('<head>\n')
   document.write_stream('<title>' + title + '</title>\n')
   document.write_stream('<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n')
   document.write_stream('</head>\n')
   document.write_stream('<body>\n')
   document.write_stream('<b>' + title + '</b><br/>')
   document.write_stream(body + '\n' + '<br/><br />')
   if extended == "":
      pass
   else:
      document.write_stream('<b>Extended Entry:</b><br/>')
      document.write_stream(extended + '\n')
   document.write_stream('</body>\n')
   document.write_stream('</html>')
   document.close_stream()

   view.set_document(document)
