/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastien.laout@tuxfamily.org                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef GLOBAL_H
#define GLOBAL_H

class DebugWindow;
class Container;
class ContainerSystemTray;
class KGlobalAccel;
class ClickCursorFeedback;
class QString;

/** Handle all global variables of the BasKet project.
  * This file only declare classes : developer should include
  * the .h files of variables he use.
  * @author Sbastien Laot
  */
class Global
{
  public:
	static DebugWindow          *debugWindow;
	static Container            *mainContainer;
	static ContainerSystemTray  *tray;
	static KGlobalAccel         *globalAccel;
	static ClickCursorFeedback  *clickCursorFeedback;

	static QString basketsFolder(); // Return e.g. "/home/username/.kde/share/apps/basket/"
};

#endif // GLOBAL_H
