/****************************************************************
**
** Attal : Lords of Doom
**
** Date : 05/12/2003
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "attalSettings.h"

FightSettings AttalSettings::getFightSettings ()
{
	QSettings settings;
	FightSettings ret;

	ret.IsAnimationEnabled = settings.readBoolEntry ("/Attal/FightSettings/IsAnimationEnabled", true);
	ret.AreCellsVisible = settings.readBoolEntry ("/Attal/FightSettings/AreCellsVisible", true);
	ret.AnimationSpeed = settings.readNumEntry ("/Attal/FightSettings/AnimationSpeed", 1);

	return ret;
}

void AttalSettings::setFightSettings (FightSettings& fightSettings)
{
	QSettings settings;

	settings.writeEntry ("/Attal/FightSettings/IsAnimationEnabled", fightSettings.IsAnimationEnabled);
	settings.writeEntry ("/Attal/FightSettings/AreCellsVisible", fightSettings.AreCellsVisible);
	settings.writeEntry ("/Attal/FightSettings/AnimationSpeed", fightSettings.AnimationSpeed);
}

StrategyModeSettings AttalSettings::getStrategyModeSettings ()
{
	QSettings settings;
	StrategyModeSettings ret;

	ret.IsAnimationEnabled = settings.readBoolEntry ("/Attal/StrategyModeSettings/IsAnimationEnabled", true);
	ret.IsMapVisible = settings.readBoolEntry ("/Attal/StrategyModeSettings/IsMapVisible", true);
	ret.IsSoundOn = settings.readBoolEntry ("/Attal/StrategyModeSettings/IsSoundOn", 1);

	return ret;
}

void AttalSettings::setStrategyModeSettings (StrategyModeSettings& strategyModeSettings)
{
	QSettings settings;

	settings.writeEntry ("/Attal/StrategyModeSettings/IsAnimationEnabled", strategyModeSettings.IsAnimationEnabled);
	settings.writeEntry ("/Attal/StrategyModeSettings/IsMapVisible", strategyModeSettings.IsMapVisible);
	settings.writeEntry ("/Attal/StrategyModeSettings/IsSoundOn", strategyModeSettings.IsSoundOn);
}
