/****************************************************************
**
** Attal : Lords of Doom
**
** optionsDialog.cpp
**
** Author(s) : Nickolay Semenov
**
** Date : 23/08/2004
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qlayout.h>

#include "optionsDialog.h"
#include "libClient/gui.h"
 
OptionsDialog::OptionsDialog ( QWidget* parent, const char* name  )
	: QDialog ( parent, name, true )
{
	QVBoxLayout* vlayout = new QVBoxLayout ( );
	
	vlayout->setMargin ( 20 );
	vlayout->setSpacing ( 10 );
	
	_animationCheckBox = new QCheckBox ( tr ("Enable animation"), this );
	
	vlayout->addWidget ( _animationCheckBox );
	
	QHBoxLayout* hlayout = new QHBoxLayout ( );
	
	hlayout->setMargin ( 10 );
	hlayout->setSpacing ( 10 );
	
	QButton* okButton = new QPushButton ( this );
	okButton->setText ( tr ("Ok") );
	
	QButton* cancelButton = new QPushButton ( this );
	cancelButton->setText ( tr ( "Cancel" ) );
	
	hlayout->addWidget ( okButton );
	
	hlayout->addWidget ( cancelButton );
	
	connect ( okButton, SIGNAL ( clicked () ), this , SLOT ( accept () ) );  
	
	connect ( cancelButton, SIGNAL ( clicked () ), this , SLOT ( reject () ) );  
	
	QVBoxLayout* mainlayout = new  QVBoxLayout ( this );
	
	mainlayout->addLayout ( vlayout );
	
	mainlayout->addLayout ( hlayout );
	
	mainlayout->activate ();
	
	FIXEDSIZE ( this );
}

void OptionsDialog::accept ()
{
	_animationIsOn = _animationCheckBox->isChecked ();	
	
	QDialog::accept ();
}

void OptionsDialog::setAnimation ( bool isOn )
{
	_animationCheckBox->setChecked ( isOn );
}

