/*****************************************************************************/
/*****************************************************************************/
/**                                                                         **/
/**  Antenna Visualization Toolkit                                          **/
/**                                                                         **/
/**  Adrian Agogino  agogino@ece.utexas.edu                                 **/
/**  Ken Harker      kharker@cs.utexas.edu                                  **/
/**                                                                         **/
/**  May 1998                                                               **/
/**                                                                         **/
/*****************************************************************************/
/*****************************************************************************/


#ifndef PCARD_H
#define PCARD_H

#include <stdio.h>
#include "ant.h"


/*****************************************************************************/
/*****************************************************************************/
/**                                                                         **/
/**                          Function Prototypes                            **/
/**                                                                         **/
/*****************************************************************************/
/*****************************************************************************/


void  PrintTube(FILE *, Tube *, int);
void  PrintTubeOffset(FILE *, Tube *, int, double, double, double);
void  WriteCardFile(char *, Ant *, int, double);
void  WriteMultAntsFile(char *, int, double);
void  WriteVolumeCardFile(char *, Ant *, int, double);
bool  CardToTube(char *, Tube *);
void  ReadCardFile(char *, Ant *);
void  ParseFieldData(FILE *, Ant *, bool, bool);
void  ParseVolumeData(FILE *, Ant *, bool, bool);

#endif


/*****************************************************************************/
/*****************************************************************************/
/**                                                                         **/
/**                            End of pcard.h                               **/
/**                                                                         **/
/*****************************************************************************/
/*****************************************************************************/



