	{ I. Vatton 	 1994-2003  }

{ Variables used in ifdefs: PAGE, BLACK_WHITE, US_PAPER, LINK_NUMBER, LANDSDSCAPE}

PRESENTATION HTML;

VIEWS
   Formatted_view,
   Structure_view merge with Structure_view,
   Links_view merge with Links_view,
   Alternate_view merge with Alternate_view,
   Table_of_contents;

#ifdef US_PAPER
#define PAGE
#endif

#if defined(PAGE) || defined(LANDSCAPE)
PRINT
   Formatted_view;
#endif

#define STRUCT_INDENT 1.5
#define TAG_FONTSIZE 12 pt
#define DOC_FONTSIZE 12 pt
#define TAG_Weight Bold
#define TAG_Visibility 7

#ifdef BLACK_WHITE
#define TAG_Color Black
#define ATTR_Color Black
#define ATTRVALUE_Color Black
#define INVALID_Color Black
#define UNKNOWNTAG_Color Black
#define LINK_Color Black
#else
#define TAG_Color DarkIndigo1
#define ATTR_Color DarkIndigo1
#define ATTRVALUE_Color DarkMagenta2
#define INVALID_Color Red
#define UNKNOWNTAG_Color Red
#define LINK_Color DarkIndigo1
#endif

#define TAG_Font Helvetica
#define ATTR_Style Roman
#define ATTR_Weight Normal
#define ATTR_Style_Links_view Italics
#define ATTR_Visibility 6
#define INPUT_Font Courier
#define COMMENT_Font Helvetica
#define COMMENT_Style Italics
#define COMMENT_Weight Normal
#define INVALID_Style Roman
#define INVALID_Weight Normal
#define INVALID_Font Helvetica
#define TableHSpace 0.2
#define TableVSpace 0.3
#define VSpaceBeforeH1 0.5
#define VSpaceBeforeH2 0.5
#define VSpaceBeforeH3 0.5
#define VSpaceBeforeH4 0.5
#define VSpaceBeforeH5 0.5
#define VSpaceBeforeH6 0.5
#define VSpaceInToC 0.2
#define LIST_INDENT 1.3
#define LIST_NUMBER_WIDTH 0.2
#define LIST_SHIFT 1
#define DEFINITION_INDENT 2.3

COUNTERS
   ItemCounter : Rank of List_Item init Start Reinit ItemValue;
#ifdef PAGE
   CptPage : Rank of Page(Formatted_view);
   CptLinksPage : Rank of Page(Links_view);
   CptToCPage : Rank of Page(Table_of_contents);
#endif
#ifdef LINK_NUMBER
   AnchorCounter : Set 0 on HTML add 1 on Anchor with ExternalLink
				 add 1 on Quotation with ExternalLink
				 add 1 on Block_Quote with ExternalLink
				 add 1 on INS with ExternalLink
				 add 1 on DEL with ExternalLink;
#endif
   H2Counter : Set 0 on H1 add 1 on H2;
   H3Counter : Set 0 on H1 set 0 on H2 add 1 on H3;
   H4Counter : Set 0 on H1 set 0 on H2 set 0 on H3 add 1 on H4;
   H5Counter : Set 0 on H1 set 0 on H2 set 0 on H3 set 0 on H4 add 1 on H5;
   H6Counter : Set 0 on H1 set 0 on H2 set 0 on H3 set 0 on H4 set 0 on H5 add 1 on H6;

DEFAULT
	BEGIN
	HorizRef: Enclosed . HRef;
	VertRef: * . Left;
	Width: Enclosed . Width;
	Height: Enclosed . Height;
	VertPos: Top = Previous . Bottom;
	HorizPos: Left = Enclosing . Left;
	Hyphenate: Enclosing =;
	LineSpacing: Enclosing =;
	LineWeight: Enclosing =;
	LineBreak: Yes;
	PageBreak: Yes;
	Visibility: Enclosing =;
	Font: Enclosing =;
	Style: Enclosing =;
	Weight: Enclosing =;
	Underline: Enclosing =;
	Thickness: Enclosing =;
	Size: Enclosing =;
	Direction: Enclosing =;
	UnicodeBidi: Enclosing =;
	Adjust: Enclosing =;
	Indent: Enclosing =;
	Depth: Enclosing =;
	FillPattern: nopattern;
        Opacity: Enclosing =;
        FillOpacity: Enclosing =;
        StrokeOpacity: Enclosing =;
	END;

BOXES

#ifdef LINK_NUMBER
 AnchorNumInFormattedView:
	BEGIN
	Content: (Text ' [' Value(AnchorCounter, Arabic) Text ']');
	Visibility: Creator =;
	HorizPos: Left = Creator . Right;
	VertPos: HRef = Creator . HRef;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 BlockNumInFormattedView:
	BEGIN
	Content: (Text ' [' Value(AnchorCounter, Arabic) Text ']');
	Visibility: Creator =;
	HorizPos: Left = Creator . Right;
	VertPos: HRef = Creator . HRef;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 AnchorNumInLinkView:
	BEGIN
	Content: (Text '[' Value(AnchorCounter, Arabic) Text ']  ');
	Visibility: 0;
	IN Links_view
		Visibility: Creator =;
	END;

 TargetPageNumber:
	BEGIN
	Content: (Text ' (page ' Value(PageNumber(Formatted_view), Arabic) Text ')');
	Visibility: 0;
	END;

 SeeTargetPage:
	BEGIN
	Copy (TargetPageNumber);
	Visibility: Creator =;
	HorizPos: Left = Creator . Right;
	VertPos: HRef = Creator . HRef;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;
#endif

 H2_section_number:
	BEGIN
	Content: (Value(H2Counter, Arabic) Text '  ');
	Visibility: Creator =;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: Creator =;
#ifdef PAGE
	Foreground: Creator =;
#else
	Foreground: ATTR_Color;
#endif
	Background: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 H2_section_number_right:
	BEGIN
	Content: (Text '  ' Value(H2Counter, Arabic));
	Visibility: Creator =;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: Creator =;
#ifdef PAGE
	Foreground: Creator =;
#else
	Foreground: ATTR_Color;
#endif
	Background: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 H3_section_number:
	BEGIN
	Content: (Value(H2Counter, Arabic) Text '.'
		  Value(H3Counter, Arabic) Text '  ');
	Visibility: Creator =;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: Creator =;
#ifdef PAGE
	Foreground: Creator =;
#else
	Foreground: ATTR_Color;
#endif
	Background: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 H3_section_number_right:
	BEGIN
	Content: (Text '  ' Value(H2Counter, Arabic) Text '.'
		  Value(H3Counter, Arabic));
	Visibility: Creator =;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: Creator =;
#ifdef PAGE
	Foreground: Creator =;
#else
	Foreground: ATTR_Color;
#endif
	Background: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 H4_section_number:
	BEGIN
	Content: (Value(H2Counter, Arabic) Text '.'
		  Value(H3Counter, Arabic) Text '.'
		  Value(H4Counter, Arabic) Text '  ');
	Visibility: Creator =;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: Creator =;
#ifdef PAGE
	Foreground: Creator =;
#else
	Foreground: ATTR_Color;
#endif
	Background: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 H4_section_number_right:
	BEGIN
	Content: (Text '  ' Value(H2Counter, Arabic) Text '.'
		  Value(H3Counter, Arabic) Text '.'
		  Value(H4Counter, Arabic));
	Visibility: Creator =;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: Creator =;
#ifdef PAGE
	Foreground: Creator =;
#else
	Foreground: ATTR_Color;
#endif
	Background: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 H5_section_number:
	BEGIN
	Content: (Value(H2Counter, Arabic) Text '.'
		  Value(H3Counter, Arabic) Text '.'
		  Value(H4Counter, Arabic) Text '.'
		  Value(H5Counter, Arabic) Text '  ');
	Visibility: Creator =;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: Creator =;
#ifdef PAGE
	Foreground: Creator =;
#else
	Foreground: ATTR_Color;
#endif
	Background: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 H5_section_number_right:
	BEGIN
	Content: (Text '  ' Value(H2Counter, Arabic) Text '.'
		  Value(H3Counter, Arabic) Text '.'
		  Value(H4Counter, Arabic) Text '.'
		  Value(H5Counter, Arabic));
	Visibility: Creator =;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: Creator =;
#ifdef PAGE
	Foreground: Creator =;
#else
	Foreground: ATTR_Color;
#endif
	Background: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 H6_section_number:
	BEGIN
	Content: (Value(H2Counter, Arabic) Text '.'
		  Value(H3Counter, Arabic) Text '.'
		  Value(H4Counter, Arabic) Text '.'
		  Value(H5Counter, Arabic) Text '.'
		  Value(H6Counter, Arabic) Text '  ');
	Visibility: Creator =;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: Creator =;
#ifdef PAGE
	Foreground: Creator =;
#else
	Foreground: ATTR_Color;
#endif
	Background: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 H6_section_number_right:
	BEGIN
	Content: (Text '  ' Value(H2Counter, Arabic) Text '.'
		  Value(H3Counter, Arabic) Text '.'
		  Value(H4Counter, Arabic) Text '.'
		  Value(H5Counter, Arabic) Text '.'
		  Value(H6Counter, Arabic));
	Visibility: Creator =;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: Creator =;
#ifdef PAGE
	Foreground: Creator =;
#else
	Foreground: ATTR_Color;
#endif
	Background: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 ElementName: BEGIN
        Content: (ElemName);
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 VerticalLine: BEGIN
	Content: Graphics 'W';
	Visibility: 0;
	IN Structure_view BEGIN
		VertPos: Top = Creator . Top;
		Height: Creator . Height;
		Width: 1.1;
		LineWeight: 1 px;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 AttrName: BEGIN
	Content: (Text ' ' AttributeName Text '=');
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 AttrValue: BEGIN
	Content: (AttributeValue);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 AttrNameOnly: BEGIN
	Content: (Text ' ' AttributeName);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 AttrNameAndValue: BEGIN
	Content: (Text ' ' AttributeName Text '=' AttributeValue);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_REL_ANCH: BEGIN
	Content: Text ' rel=';
	Visibility: 0;
	IN Links_view BEGIN
#ifdef PAGE
		Style: ATTR_Style_Links_view;
#else
		Foreground: ATTR_Color;
#endif
		Visibility: 5;
		END;
	END;
 VALUE_REL_ANCH: BEGIN
	Content: (REL);
	Visibility: 0;
	IN Links_view
		Visibility: 5;
	END;

 ATTR_REV_ANCH: BEGIN
	Content: Text ' rev=';
	Visibility: 0;
	IN Links_view BEGIN
#ifdef PAGE
		Style: ATTR_Style_Links_view;
#else
		Foreground: ATTR_Color;
#endif
		Visibility: 5;
		END;
	END;
 VALUE_REV_ANCH: BEGIN
	Content: (REV);
	Visibility: 0;
	IN Links_view BEGIN
		Visibility: 5;
		Foreground: ATTRVALUE_Color;
		END;
	END;

 VAL_ATTR_PROMPT: BEGIN
	Content: (Prompt);
	VertPos: Top = Previous . Bottom;
	IN Structure_view
		Visibility: 0;	
	END;

 INDEX_TXT:  BEGIN
	Content: Text 'This is a searchable index.';
	VertPos: Top = Previous . Bottom;
	IN Structure_view
		Visibility: 0;
	END;

 ATTR_ID_ANCH: BEGIN
	Content: Text ' id=';
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Links_view BEGIN
#ifdef PAGE
		Style: ATTR_Style_Links_view;
#else
		Foreground: ATTR_Color;
#endif
		Visibility: 5;
		END;
	END;
 VALUE_ID_ANCH: BEGIN
	Content: (ID);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Links_view BEGIN
		Visibility: 5;
		Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_FRAMENAME: BEGIN
	Content: Text ' name= ';
	Style: Bold;
	IN Links_view BEGIN
		Style: Enclosing =;
#ifndef PAGE
		Foreground: ATTR_Color;
#endif
		END;
	IN Structure_view
		Visibility: 0;
	IN Table_of_contents
	        Visibility: 0;
	END;

 VALUE_FRAMENAME: BEGIN
	Content: (FrameName);
	IN Structure_view
		Visibility: 0;
	IN Table_of_contents
	        Visibility: 0;
	END;

 ATTR_FRAMESRC: BEGIN
	Content: Text ' src=';
	Style: Bold;
	IN Links_view BEGIN
		Style: Enclosing =;
#ifndef PAGE
		Foreground: ATTR_Color;
#endif
		END;
	IN Structure_view
		Visibility: 0;
	IN Table_of_contents
	        Visibility: 0;
	END;

 VALUE_FRAMESRC: BEGIN
	Content: (FrameSrc);
	Foreground: LINK_Color;
	IN Links_view BEGIN
		Foreground: ATTRVALUE_Color;
#ifdef PAGE
		Style: ATTR_Style_Links_view;
#endif
		END;
	IN Alternate_view BEGIN
		Foreground: Enclosing =;
		Underline: Underlined;
		END;
	IN Structure_view
		Visibility: 0;
	IN Table_of_contents
	        Visibility: 0;
	END;

 VALUE_Invalid_attribute: BEGIN
	Content: (Invalid_attribute);
	Visibility: 0;
	Underline: CrossedOut;
	Foreground: INVALID_Color;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Visibility: Creator =;
		Size: TAG_FONTSIZE;
		Style: INVALID_Style;
		END;
	END;

 VALUE_Unknown_attribute: BEGIN
	Content: (Unknown_attribute);
	Visibility: 0;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Visibility: Creator =;
		Size: TAG_FONTSIZE;
		Style: INVALID_Style;
	        Foreground: UNKNOWNTAG_Color;
		END;	
	END;

{ LC 22/08/01
 VALUE_EntityName: BEGIN
        Content: (EntityName);
        Visibility: 0;
        IN Structure_view BEGIN
                Visibility: ATTR_Visibility;	
		Size: DOC_FONTSIZE;
		Foreground: TAG_Color;
		if not within Comment_line and not within PI_line
		   BEGIN
		   HorizPos: Left = Enclosing . Left;
		   VertPos: Top = Previous . Bottom;
		   END;
		if within Comment_line 
		   HorizPos: Left = Previous . Right;
		if within PI_line 
		   HorizPos: Left = Previous . Right;
                END;
        END;
}

 IMG_type_image: BEGIN
	Content: Text ' type=image';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_Checkbox: BEGIN
	Content: Text ' type=checkbox';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 CHECKBOX_ALT: BEGIN
	Content: Text '[ ]';
	Visibility: 0;
	IN Alternate_view
		Visibility: Creator =;
	END;

 CHECKBOXCHECKED_ALT: BEGIN
	Content: Text '[X]';
	Visibility: 0;
	IN Alternate_view
		Visibility: Creator =;
	END;

 RADIO_ALT: BEGIN
	Content: Text '( )';
	Visibility: 0;
	IN Alternate_view
		Visibility: Creator =;
	END;

 RADIOCHECKED_ALT: BEGIN
	Content: Text '(*)';
	Visibility: 0;
	IN Alternate_view
		Visibility: Creator =;
	END;

 INSERTED_ALT: BEGIN
	Content: Text ' __________________ ';
	Visibility: 0;
	IN Alternate_view BEGIN
		Visibility: Creator =;
		HorizPos: Left = Enclosing . Left;
		VertPos: Top = Enclosing . Top;
		END;
	END;

 INSERTED_TEXTAREA_ALT: BEGIN
	Content: Text ' _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ ';
	Visibility: 0;
	IN Alternate_view BEGIN
		Visibility: Creator =;
		HorizPos: Left = Enclosing . Left;
		VertPos: Top = Enclosing . Top;
		END;
	END;

 NEW_LINE: BEGIN
	Content: Text '\12';
	Visibility: 0;
	IN Alternate_view BEGIN
		Visibility: Creator =;
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		END;
	END;

 START_SELECT_ALT: BEGIN
	Content: Text '[';
	Visibility: 0;
	IN Alternate_view BEGIN
		Visibility: Creator =;
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		END;
	END;
 END_SELECT_ALT: BEGIN
	Content: Text ']';
	Visibility: 0;
	IN Alternate_view BEGIN
		Visibility: Creator =;
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		END;
	END;

 ATTR_Radio: BEGIN
	Content: Text ' type=radio';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_Text: BEGIN
	Content: Text ' type=text';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 BrowseLabel: BEGIN
	Content: Text 'Browse...';
	VertPos: Top = Creator . Top;
	HorizPos: Left = Creator . Right;
	Width: Enclosed . Width;
	Height: Enclosed . Height;
	PaddingTop: 1 px;
	PaddingBottom: 1 px;
	PaddingLeft: 0.3;
	PaddingRight: 0.3;
	BorderTopWidth: 1 px;
	BorderLeftWidth: 1 px;
	BorderBottomWidth: 1 px;
	BorderRightWidth: 1 px;
	BorderTopColor: LightGrey1;
	BorderLeftColor: LightGrey1;
	BorderBottomColor: DarkGrey3;
	BorderRightColor: DarkGrey3;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderBottomStyle: Solid;
	BorderRightStyle: Solid;
	Visibility: Creator =;
#ifndef BLACK_WHITE
	Background : Grey;
#endif
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

#ifndef PAGE
 Target_gif: BEGIN
	Content: Picture 'target.gif';
	HorizPos: Left = Enclosing . Left;
	VertPos: Top = Enclosing . Top;
	Visibility: 4;
	Depth: Creator - 2;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 5;
	IN Table_of_contents
		Visibility: 5;
	END;
#endif

 Option_gif_left: BEGIN
	Content: Picture 'option.gif';
	HorizPos: Right = Previous . Left;
	VertPos: HMiddle = Enclosing . Top + 0.5;
        HorizRef: * . Bottom;	
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;
 Option_gif_right: BEGIN
	Content: Picture 'option.gif';
	HorizPos: Left = Previous . Right;
	VertPos: HMiddle = Enclosing . Top + 0.5;
        HorizRef: * . Bottom;	
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

 IMG_in_S: BEGIN
	Content: Text 'input ';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

 UNKNOWN_E: BEGIN
        Content: Text '>';
        IN Structure_view BEGIN
                HorizPos: Left = Previous . Right;
                VertPos: HRef = Previous . HRef;
                Size: TAG_FONTSIZE;
                Style: INVALID_Style;
#ifdef BLACK_WHITE
                Underline: CrossedOut;
#else
                Foreground: Creator =;
#endif
                END;
        END;

 COMMENT_S: BEGIN
	Content: Text '<!--';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Foreground: TAG_Color;
		END;
	END;

 COMMENT_E: BEGIN
	Content: Text '-->';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		VertPos: HRef = Previous . HRef;
		HorizPos: Left = Previous . Right;
		Foreground: TAG_Color;
		END;
	END;

 PI_S: BEGIN
	Content: Text '<?';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Foreground: TAG_Color;
		END;
	END;

 PI_E: BEGIN
	Content: Text '?>';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		VertPos: HRef = Previous . HRef;
		HorizPos: Left = Previous . Right;
		Foreground: TAG_Color;
		END;
	END;

 CDATA_S: BEGIN
	Content: Text '<![CDATA[';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Foreground: TAG_Color;
		END;
	END;

 CDATA_E: BEGIN
	Content: Text ']]>';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Foreground: TAG_Color;
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		END;
	END;

 SHOW_IMG: BEGIN
	Visibility: Enclosing =;
	Content: Text '<img>';
	Foreground: TAG_Color;
	MarginTop: 1 px;
	MarginLeft: 3 px;
	MarginBottom: 1 px;
	MarginRight: 3 px;
	LineBreak: No;
	IN Structure_view BEGIN
		Visibility: 0;
		END;
	IN Alternate_view BEGIN
		Visibility: 0;
		END;
	IN Links_view BEGIN
		Visibility: 0;
		END;
	IN Table_of_contents BEGIN
		Visibility: 0;
		END;
	END;

 SHOW_ALT: BEGIN
	Visibility: Enclosing =;
	Content: (ALT);
	IN Structure_view BEGIN
		Visibility: 0;
		END;
	IN Alternate_view BEGIN
		Visibility: 0;
		END;
	IN Links_view BEGIN
		Visibility: Enclosing =;
		END;
	IN Table_of_contents BEGIN
		Visibility: 0;
		END;
	END;

 IMG_ALT: BEGIN
	Visibility: 0;
	Content: (Text ' ' ALT);
{****	IN Links_view
		Visibility: 7; ****}
	IN Alternate_view
		Visibility: 7;
	END;

 SPACE: BEGIN
	Visibility: 0;
	Content: Text ' ';
	IN Links_view
		Visibility: 7;
	IN Alternate_view
		Visibility: 7;
	END;

 AREA_ALT: BEGIN
	Visibility: 0;
	Content: (ALT);
	IN Links_view
		Visibility: 7;
	IN Alternate_view BEGIN
		Visibility: 7;
		Underline: Underlined;
		END;
	END;

 AREA_NO_ALT: BEGIN
	Visibility: 0;
	Content: Text 'area';
	IN Links_view BEGIN
		Visibility: Enclosing =;
                Foreground: TAG_Color;
	        END;
	IN Alternate_view BEGIN
		Visibility: Enclosing =;
		Underline: Underlined;
		END;
	END;

 VALUE_ALT: BEGIN
	Visibility: 0;
	Content: (ALT);
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_Hidden: BEGIN
	Content: Text ' type=hidden';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_File: BEGIN
	Content: Text ' type=file';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_Password: BEGIN
	Content: Text ' type=password';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_Reset: BEGIN
	Content: Text ' type=reset';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_Submit: BEGIN
	Content: Text ' type=submit';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_Button: BEGIN
	Content: Text ' type=button';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 BUTTON_ALT: BEGIN
	Content: Text '[BUTTON] ';
	Visibility: 0;
	IN Alternate_view BEGIN
		Visibility: Creator =;
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		END;
	END;
	
 Value_Box: BEGIN
	Content: (Value_);
	HorizPos: Left = Enclosing . Left;
	VertPos: Top = Enclosing . Top;
	Background: Creator =;
	Foreground: Creator =;
	FillPattern: backgroundcolor;
	Depth: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

 Value_Box_Alt: BEGIN
	Content: (Text '[' Value_ Text ']');
	Visibility: 0;
	IN Alternate_view BEGIN
		Visibility: Enclosing =;
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		END;
	END;

 SelectedInAltView: BEGIN
        Content: Text '[X] ';
	Visibility: 0;
	IN Alternate_view BEGIN
		Visibility: Enclosing =;
		END;
	END;

 UnselectedInAltView: BEGIN
        Content: Text '[ ] ';
	Visibility: 0;
	IN Alternate_view BEGIN
		Visibility: Enclosing =;
		END;
	END;

 Toggle_gif: BEGIN
	Content: Picture 'toggle.gif';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

 ToggleS_gif: BEGIN
	Content: Picture 'toggle-s.gif';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

 Radio_gif: BEGIN
	Content: Picture 'radio.gif';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;	
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 RadioS_gif: BEGIN
	Content: Picture 'radio-s.gif';
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 DOUBLE_QUOTE: BEGIN
	Content: Text '"';
	VertPos: HRef = Previous . Href;
	HorizPos:  Left = Previous . Right;
	IN Structure_view
		Visibility: 0;
	END;

 QUOTE: BEGIN
	Content: Text '''';
	VertPos: HRef = Previous . Href;
	HorizPos:  Left = Previous . Right;
	IN Structure_view
		Visibility: 0;
	END;

#ifndef PAGE
 FRAME_Label: BEGIN
	Content: Text 'frame';
	Style: Bold;
	IN Structure_view
		Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	END;

 NOFRAMES_Sep1: BEGIN
	Content: Graphics 'h';
	LineWeight: 1 px;
	Width: Enclosing . Width;
	Height: 0.5;
	IN Structure_view
		Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;

 NOFRAMES_Sep2: BEGIN
	Content: Graphics 'h';
	LineWeight: 1 px;
	Width: Enclosing . Width;
	Height: 0.5;
	IN Structure_view
		Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	END;
#endif

 OpeningParen: BEGIN
	Content: Text '[';
	Visibility: 0;
	IN Alternate_view BEGIN
		Visibility: Enclosing =;
	  	HorizPos: Left = Previous . Right;
	   	VertPos: HRef = Previous . HRef;
		END;
	END;
	
 ClosingParen: BEGIN
	Content: Text ']';
	Visibility: 0;
	IN Alternate_view BEGIN
		Visibility: Enclosing =;
	  	HorizPos: Left = Previous . Right;
	   	VertPos: HRef = Previous . HRef;
		END;
	END;
	
 ATTR_NAME_ANCH: BEGIN
	Content: Text ' name=';
	Visibility: 0;
	IN Links_view BEGIN
#ifdef PAGE
		Style: ATTR_Style_Links_view;
#else
		Foreground: ATTR_Color;
#endif
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Visibility: 5;
		END;
	END;
 VALUE_NAME_ANCH: BEGIN
	Content: (NAME);
	Visibility: 0;
	Style: Bold;
	IN Links_view BEGIN
		Style: Enclosing =;
#ifndef PAGE
		Foreground: ATTR_Color;
#endif
		Visibility: 5;
		END;
	END;

 ATTR_HREF_LINKS_VIEW: BEGIN
#ifdef PAGE
	Content: Text ': ';
#else
	Content: Text ' href=';
#endif
	Visibility: 0;
	IN Links_view BEGIN
#ifndef PAGE
		Foreground: ATTR_Color;
#endif
		Visibility: 5;
		END;
	END;

 VALUE_HREF_LINKS_VIEW: BEGIN
	Content: (HREF_);
	Visibility: 0;
	IN Links_view BEGIN
		Visibility: 5;
		Foreground: ATTRVALUE_Color;
		END;
	END;

 ATTR_CITE_LINKS_VIEW: BEGIN
	Content: Text ' cite=';
	Visibility: 0;
	IN Links_view BEGIN
#ifdef PAGE
		Style: ATTR_Style_Links_view;
#else
		Foreground: ATTR_Color;
#endif
		Visibility: 5;
		END;
	END;

 VALUE_CITE_LINKS_VIEW: BEGIN
	Content: (cite);
	Visibility: 0;
	IN Links_view
		Visibility: 5;
	END;

 ATTR_TITLE_ANCH: BEGIN
	Content: Text ' title=';
	Visibility: 0;
	IN Links_view BEGIN
#ifdef PAGE
		Style: ATTR_Style_Links_view;
#else
		Foreground: ATTR_Color;
#endif
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Visibility: 5;
		END;
	END;

 VALUE_TITLE_ANCH: BEGIN
	Content: (Title);
	Visibility: 0;
	IN Links_view BEGIN
		Visibility: 5;
		Foreground: ATTRVALUE_Color;
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		END;
	END;

 ATTR_TITLE_FRAME: BEGIN
	Content: Text ' title=';
	Style: Bold;
	IN Structure_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	END;

 VALUE_TITLE_FRAME: BEGIN
	Content: (Title);
	IN Structure_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	END;

 UL_DISC_LEFT: BEGIN
	Content: Graphics 'c';
	Height: 0.4;
	Width: 0.4;
	Size: Creator =;
	LineWeight: 1 px;
	Foreground: Creator =;
	FillPattern: foregroundcolor;
	VertPos: Bottom = Creator . HRef;
	HorizPos: Left = Enclosing . Left;
	MarginLeft: Creator =;
	Visibility: Creator =;
	IN Structure_view
		Visibility: 0;
	END;
 UL_DISC_RIGHT: BEGIN
	Content: Graphics 'c';
	Height: 0.4;
	Width: 0.4;
	Size: Creator =;
	LineWeight: 1 px;
	Foreground: Creator =;
	FillPattern: foregroundcolor;
	VertPos: Bottom = Creator . HRef;
	HorizPos: Right = Enclosing . Right;
	MarginRight: Creator =;
	Visibility: Creator =;
	IN Structure_view
		Visibility: 0;
	END;
 UL_SQUARE_LEFT: BEGIN
	Content: Graphics 'R';
	Height: 0.4;
	Width: 0.4;
	Size: Creator =;
	LineWeight: 1 px;
	Foreground: Creator =;
	VertPos: Bottom = Creator . HRef;
	HorizPos: Left = Enclosing . Left;
	MarginLeft: Creator =;
	Visibility: Creator =;
	IN Structure_view
		Visibility: 0;
	END;
 UL_SQUARE_RIGHT: BEGIN
	Content: Graphics 'R';
	Height: 0.4;
	Width: 0.4;
	Size: Creator =;
	LineWeight: 1 px;
	Foreground: Creator =;
	VertPos: Bottom = Creator . HRef;
	HorizPos: Right = Enclosing . Right;
	MarginRight: Creator =;
	Visibility: Creator =;
	IN Structure_view
		Visibility: 0;
	END;
 UL_CIRCLE_LEFT: BEGIN
	Content: Graphics 'c';
	Height: 0.4;
	Width: 0.4;
	Size: Creator =;
	LineWeight: 1 px;
	Foreground: Creator =;
	VertPos: Bottom = Creator . HRef;
	HorizPos: Left = Enclosing . Left;
	MarginLeft: Creator =;
	Visibility: Creator =;
	IN Structure_view
		Visibility: 0;
	END;
 UL_CIRCLE_RIGHT: BEGIN
	Content: Graphics 'c';
	Height: 0.4;
	Width: 0.4;
	Size: Creator =;
	LineWeight: 1 px;
	Foreground: Creator =;
	VertPos: Bottom = Creator . HRef;
	HorizPos: Right = Enclosing . Right;
	MarginRight: Creator =;
	Visibility: Creator =;
	IN Structure_view
		Visibility: 0;
	END;

 OL_NUM_ARABIC_LEFT:
	BEGIN
	Content: (Value(ItemCounter, Arabic) Text '. ');
	VertPos: HRef = Creator . HRef;
	HorizPos: Right = Next . VRef - LIST_NUMBER_WIDTH;
	Visibility: Creator =;
	Foreground: Creator =;
	Size: Creator =;
	Style: Creator =;
	Weight: Creator =;
	IN Structure_view
		Visibility: 0;
	END;
 OL_NUM_ARABIC_RIGHT:
	BEGIN
	Content: (Value(ItemCounter, Arabic) Text '. ');
	VertPos: HRef = Creator . HRef;
	HorizPos: Left = Next . VRef + LIST_NUMBER_WIDTH;
	Visibility: Creator =;
	Foreground: Creator =;
	Size: Creator =;
	Style: Creator =;
	Weight: Creator =;
	IN Structure_view
		Visibility: 0;
	END;
 OL_NUM_LALPHA_LEFT:
	BEGIN
	Content: (Value(ItemCounter, lowercase) Text '. ');
	VertPos: HRef = Creator . HRef;
	HorizPos: Right = Next . VRef - LIST_NUMBER_WIDTH;
	Visibility: Creator =;
	Foreground: Creator =;
	Size: Creator =;
	Style: Creator =;
	Weight: Creator =;
	IN Structure_view
		Visibility: 0;
	END;
 OL_NUM_LALPHA_RIGHT:
	BEGIN
	Content: (Value(ItemCounter, lowercase) Text '. ');
	VertPos: HRef = Creator . HRef;
	HorizPos: Left = Next . VRef + LIST_NUMBER_WIDTH;
	Visibility: Creator =;
	Foreground: Creator =;
	Size: Creator =;
	Style: Creator =;
	Weight: Creator =;
	IN Structure_view
		Visibility: 0;
	END;
 OL_NUM_UALPHA_LEFT:
	BEGIN
	Content: (Value(ItemCounter, Uppercase) Text '. ');
	VertPos: HRef = Creator . HRef;
	HorizPos: Right = Next . VRef - LIST_NUMBER_WIDTH;
	Visibility: Creator =;
	Foreground: Creator =;
	Size: Creator =;
	Style: Creator =;
	Weight: Creator =;
	IN Structure_view
		Visibility: 0;
	END;
 OL_NUM_UALPHA_RIGHT:
	BEGIN
	Content: (Value(ItemCounter, Uppercase) Text '. ');
	VertPos: HRef = Creator . HRef;
	HorizPos: Left = Next . VRef + LIST_NUMBER_WIDTH;
	Visibility: Creator =;
	Foreground: Creator =;
	Size: Creator =;
	Style: Creator =;
	Weight: Creator =;
	IN Structure_view
		Visibility: 0;
	END;
 OL_NUM_LROMAN_LEFT:
	BEGIN
	Content: (Value(ItemCounter, lRoman) Text '. ');
	VertPos: HRef = Creator . HRef;
	HorizPos: Right = Next . VRef - LIST_NUMBER_WIDTH;
	Visibility: Creator =;
	Foreground: Creator =;
	Size: Creator =;
	Style: Creator =;
	Weight: Creator =;
	IN Structure_view
		Visibility: 0;
	END;
 OL_NUM_LROMAN_RIGHT:
	BEGIN
	Content: (Value(ItemCounter, lRoman) Text '. ');
	VertPos: HRef = Creator . HRef;
	HorizPos: Left = Next . VRef + LIST_NUMBER_WIDTH;
	Visibility: Creator =;
	Foreground: Creator =;
	Size: Creator =;
	Style: Creator =;
	Weight: Creator =;
	IN Structure_view
		Visibility: 0;
	END;
 OL_NUM_UROMAN_LEFT:
	BEGIN
	Content: (Value(ItemCounter, URoman) Text '. ');
	VertPos: HRef = Creator . HRef;
	HorizPos: Right = Next . VRef - LIST_NUMBER_WIDTH;
	Visibility: Creator =;
	Foreground: Creator =;
	Size: Creator =;
	Style: Creator =;
	Weight: Creator =;
	IN Structure_view
		Visibility: 0;
	END;
 OL_NUM_UROMAN_RIGHT:
	BEGIN
	Content: (Value(ItemCounter, URoman) Text '. ');
	VertPos: HRef = Creator . HRef;
	HorizPos: Left = Next . VRef + LIST_NUMBER_WIDTH;
	Visibility: Creator =;
	Foreground: Creator =;
	Size: Creator =;
	Style: Creator =;
	Weight: Creator =;
	IN Structure_view
		Visibility: 0;
	END;

 ISINDEX_Graph1: BEGIN
	Content: Graphics 'b';
	HorizPos: Left = Enclosing . Left;
	Width: Enclosing . Width;
	Height: 1;
	Foreground: Black;
	LineWeight: 1 px;
	Visibility: Creator =;
	IN Structure_view BEGIN
		Visibility: 0;
		END;
	END;

#ifdef PAGE
 HR_Print: BEGIN
	Content: Graphics 'h';
	HorizPos: Left = Enclosing . Left;
	VertPos: Top = Enclosing . Top;
	Width: Enclosing . Width;
	Height: Enclosed . Height;
	Foreground: Black;
	LineWeight: Creator =;
	Visibility: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		LineWeight: 1 px;
	END;
#else
 HR_Alt: BEGIN
	Content: Graphics 'h';
	HorizPos: Left = Enclosing . Left;
	VertPos: Top = Enclosing . Top;
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	Foreground: Black;
	LineWeight: 1 px;
	Visibility: 0;
	IN Alternate_view
	      Visibility: Creator =;
	END;

 HR_Graph1: BEGIN
	Content: Text ' ';
	HorizPos: Left = Enclosing . Left;
	VertPos: Top = Enclosing . Top;
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	LineWeight: Creator =;
	Visibility: Creator =;
	BorderTopWidth: 1 px;
	BorderLeftWidth: 1 px;
	BorderBottomWidth: 1 px;
	BorderRightWidth: 1 px;
	BorderTopColor: DarkGrey2;
	BorderLeftColor: DarkGrey2;
	BorderBottomColor: LightGrey1;
	BorderRightColor: LightGrey1;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderBottomStyle: Solid;
	BorderRightStyle: Solid;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

 ISINDEX_Graph2: BEGIN
	Content: Graphics 't';
	HorizPos: Left = Enclosing . Left;
	Width: Enclosing . Width;
	Height:  1;
	Foreground: White;
	LineWeight: 1 px;
	Visibility: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

 ISINDEX_Graph2A: BEGIN
	Content: Graphics 't';
	HorizPos: Left = Enclosing . Left;
	Width: Enclosing . Width;
	Height:  1;
	Foreground: White;
	LineWeight: 1 px;
	Visibility: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;
#endif

{ ---- Table ---- }

 CellExtFrame: BEGIN
	Content: Graphics '0';
	ShowBox;
	VertPos: Top = Enclosing . Top;
	HorizPos: Left = Creator . Left;
	Width: Creator . Width;
	Height: Bottom = Referred Table_row . Bottom;
	VertOverflow : Yes;
	BorderTopWidth: Creator =;
	BorderRightWidth: Creator =;
	BorderBottomWidth: Creator =;
	BorderLeftWidth: Creator =;
	BorderTopColor: Creator =;
	BorderRightColor: Creator =;
	BorderBottomColor: Creator =;
	BorderLeftColor: Creator =;
	BorderTopStyle: Creator =;
	BorderRightStyle: Creator =;
	BorderBottomStyle: Creator =;
	BorderLeftStyle: Creator =;
	Foreground: Creator =;
	Background: Creator =;
	FillPattern: Creator =;
	Depth: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

 CellFrame: BEGIN
	Content: Graphics '0';
	ShowBox;
	VertPos: Top = Enclosing . Top;
	HorizPos: Left = Creator . Left;
	Width: Creator . Width;
	Height: Enclosing . Height;
	BorderTopWidth: Creator =;
	BorderRightWidth: Creator =;
	BorderBottomWidth: Creator =;
	BorderLeftWidth: Creator =;
	BorderTopColor: Creator =;
	BorderRightColor: Creator =;
	BorderBottomColor: Creator =;
	BorderLeftColor: Creator =;
	BorderTopStyle: Creator =;
	BorderRightStyle: Creator =;
	BorderBottomStyle: Creator =;
	BorderLeftStyle: Creator =;
	Foreground: Creator =;
	Background: Creator =;
	Depth: Creator =;
	FillPattern: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

 MAP_dummy: BEGIN
	Content: Graphics ' ';
	Width: 0;
	Height: 0;
	VertPos: Top = Previous not MAP . Bottom;
	HorizPos: Left = Enclosing . Left;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

{ ---- Pages ---- }

#ifdef PAGE
#ifndef LANDSCAPE
  TitleHead:
	BEGIN
	Visibility: 0;
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Underline: NoUnderline;
	Copy (TITLE);
	Adjust: Left;
	HorizPos: Left = Previous PAGE_BREAK . Left;
	VertPos: Top = Previous PAGE_BREAK . Bottom + 0.2 cm;
	Height:  Enclosed . Height;
	Size : 11 pt;
	Font: times;
	Style: Italics;	
	Weight: Normal;
	END;
#endif

  URLhead:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Underline: NoUnderline;
	Copy (Document_URL);
	Adjust: Left;
	HorizPos: Left = Previous PAGE_BREAK . Left;
#ifdef US_PAPER
#ifdef LANDSCAPE
	Height:   0.6 cm;
	VertPos: Top = Previous PAGE_BREAK . Bottom + 0.1 cm;
#else
	VertPos: Top = Previous PAGE_BREAK . Bottom + 0.2 cm;
	Height:   1 cm;
#endif
#else
#ifdef LANDSCAPE
	Height:   0.8 cm;
	VertPos: Top = Previous PAGE_BREAK . Bottom + 0.3 cm;
#else
	VertPos: Top = Previous PAGE_BREAK . Bottom + 0.7 cm;
	Height:   1.2 cm;
#endif
#endif
	Size : 8 pt;
	Font: times;
	Style: Roman;	
	Weight: Normal;
	END;

  Spacehead:
	BEGIN
#ifdef LANDSCAPE
	Visibility: 0;
#endif
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Underline: NoUnderline;
	Content: Text ' ';
	Adjust: Left;
	HorizPos: Left = Previous PAGE_BREAK . Left;
	VertPos: Top = Previous PAGE_BREAK . Bottom + 0.7 cm;
	Height:   1.2 cm;
	Size : 8 pt;
	Font: times;
	Style: Roman;
	Weight: Normal;
	END;

#ifndef LANDSCAPE
  PageNum:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Underline: NoUnderline;
	Content: (Value (CptPage, Arabic));
	HorizPos: VMiddle = Next PAGE_BREAK . VMiddle;
	VertPos: Top = Next PAGE_BREAK . Top - 0.5 cm;
	Height:   1.6 cm;
	Size : 11 pt;
	Font: times;
	Style: Roman;
	Weight: Normal;
	END;
#endif

  LinksPageNum:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Underline: NoUnderline;
	Content: (Value (CptLinksPage, lroman));
	HorizPos: VMiddle = Next PAGE_BREAK . VMiddle;
#ifdef LANDSCAPE
	VertPos: Top = Next PAGE_BREAK . Top - 0.3 cm;
	Height:   1 cm;
#else
	VertPos: Top = Next PAGE_BREAK . Top - 0.5 cm;
	Height:   1.6 cm;
#endif
	Size : 11 pt;
	Font: times;
	Style: Roman;
	Weight: Normal;
	END;

  ToCPageNum:
	BEGIN
	Background : White;
	Foreground : Black;
	FillPattern : nopattern;
	Underline: NoUnderline;
	Content: (Value (CptToCPage, Uroman));
	HorizPos: VMiddle = Next PAGE_BREAK . VMiddle;
#ifdef LANDSCAPE
	VertPos: Top = Next PAGE_BREAK . Top - 0.3 cm;
	Height:   1 cm;
#else
	VertPos: Top = Next PAGE_BREAK . Top - 0.5 cm;
	Height:   1.6 cm;
#endif
	Size : 11 pt;
	Font: times;
	Style: Roman;
	Weight: Normal;
	END;

  BottomSpace:
	BEGIN
	Background : White;
	Foreground : Black;
	FillPattern: backgroundcolor;
#ifdef LANDSCAPE
	Height:   1 cm;
#else
	Height:   1.4 cm;
#endif
	Width: 1 pt;
	Underline: NoUnderline;
	VertPos: Bottom = Next PAGE_BREAK . Top;
	HorizPos: Left = Next PAGE_BREAK . Left;
	Content: (Graphics ' ');
	END;

  ThePage:
	BEGIN
	Background : White;
	Foreground : Black;
	FillPattern: backgroundcolor;
	ShowBox;
#ifdef US_PAPER
#ifdef LANDSCAPE
	Width: 25 cm;
	Height: 18.4 cm;
	VertPos: Top = Enclosing . Top;
	HorizPos: Left = Enclosing . Left + 1.5 cm;
#else
	Width: 17 cm;
	Height: 25 cm;
	VertPos: Top = Enclosing . Top;
	HorizPos: Left = Enclosing . Left + 2.5 cm;
#endif
#else
#ifdef LANDSCAPE
	Width: 26.9 cm;
	Height: 17.6 cm;
	VertPos: Top = Enclosing . Top + 1.7 cm;
	HorizPos: Left = Enclosing . Left + 1.7 cm;
#else
	Width: 15.6 cm;
	Height: 25.9 cm;
	VertPos: Top = Enclosing . Top + 1.7 cm;
	HorizPos: Left = Enclosing . Left + 2.7 cm;
#endif
#endif
#ifndef LANDSCAPE
	if not One(CptPage) CreateAfter (TitleHead);
#endif
	CreateAfter (Spacehead);
	if PrintURL CreateAfter (URLhead);
#ifndef LANDSCAPE
	if not One(CptPage) CreateBefore (PageNum);
	if not One(CptPage) CreateBefore (BottomSpace);
#endif
	Underline: NoUnderline;
	END;

  LinksPage:
	BEGIN
#ifdef US_PAPER
#ifdef LANDSCAPE
	Width: 24 cm;
	Height: 18.4 cm;
	VertPos: Top = Enclosing . Top;
	HorizPos: Left = Enclosing . Left + 1.5 cm;
#else
	Width: 17 cm;
	Height: 25 cm;
	VertPos: Top = Enclosing . Top;
	HorizPos: Left = Enclosing . Left + 2.5 cm;
#endif
#else
#ifdef LANDSCAPE
	Width: 25.9 cm;
	Height: 17.6 cm;
	VertPos: Top = Enclosing . Top + 1.7 cm;
	HorizPos: Left = Enclosing . Left + 2.7 cm;
#else
	Width: 15.6 cm;
	Height: 25.9 cm;
	VertPos: Top = Enclosing . Top + 1.7 cm;
	HorizPos: Left = Enclosing . Left + 2.7 cm;
#endif 
#endif
#ifndef LANDSCAPE
	CreateAfter (TitleHead);
#endif
	CreateAfter (Spacehead);
	if PrintURL
	   CreateAfter (URLhead);
	if not One(CptLinksPage) CreateBefore (LinksPageNum);
	if Not One(CptLinksPage) CreateBefore (BottomSpace);
	Underline: NoUnderline;
	END;

  ToCPage:
	BEGIN
	Background : White;
	Foreground : Black;
	ShowBox;
#ifdef US_PAPER
#ifdef LANDSCAPE
	Width: 25 cm;
	Height: 18.4 cm;
	VertPos: Top = Enclosing . Top;
	HorizPos: Left = Enclosing . Left + 1.5 cm;
#else
	Width: 17 cm;
	Height: 25 cm;
	VertPos: Top = Enclosing . Top;
	HorizPos: Left = Enclosing . Left + 2.5 cm;
#endif
#else
#ifdef LANDSCAPE
	Width: 25.9 cm;
	Height: 17.6 cm;
	VertPos: Top = Enclosing . Top + 1.7 cm;
	HorizPos: Left = Enclosing . Left + 2.7 cm;
#else
	Width: 15.6 cm;
	Height: 25.9 cm;
	VertPos: Top = Enclosing . Top + 1.7 cm;
	HorizPos: Left = Enclosing . Left + 2.7 cm;
#endif
#endif
#ifndef LANDSCAPE
	CreateAfter (TitleHead);
#endif
	if PrintURL CreateAfter (URLhead);
	if not One(CptToCPage) CreateBefore (ToCPageNum);
	if Not One(CptToCPage) CreateBefore (BottomSpace);
	Underline: NoUnderline;
	END;

  HeadingPageNumberRight:
	BEGIN
	Visibility: 0;
	IN Table_of_contents
	   BEGIN
	   Visibility: Creator =;
	   VertPos: Bottom = Previous . Bottom;
	   HorizPos: Right = Enclosing . Right;
	   Content: (Value (PageNumber(Formatted_view), Arabic));
	   Underline: NoUnderline;
	   END;
	END;

  HeadingPageNumberLeft:
	BEGIN
	Visibility: 0;
	IN Table_of_contents
	   BEGIN
	   Visibility: Creator =;
	   VertPos: Bottom = Previous . Bottom;
	   HorizPos: Left = Enclosing . Left;
	   Content: (Value (PageNumber(Formatted_view), Arabic));
	   Underline: NoUnderline;
	   END;
	END;

  LinkPageNumber:
	BEGIN
	Visibility: 0;
	IN Links_view
	   BEGIN
	   Visibility: Creator =;
	   VertPos: Bottom = Creator . Bottom;
	   HorizPos: Right = Enclosing . Right;
	   Content: (Value (PageNumber(Formatted_view), Arabic));
	   Underline: NoUnderline;
	   END;
	END;
#endif

#ifndef PAGE
 IndexBox: BEGIN
	Content: Picture 'AmayaSrcSyncIndex.gif';
	HorizPos: Left = Root . Left;
	VertPos: Top = Creator . Top;
	VertOverflow : Yes;
	HorizOverflow : Yes;
	Inline: No;
	Visibility: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	END;
#endif

RULES

 Document:
	BEGIN
	Depth: 0;
	Direction: ltr;
	Adjust: Left;
	Indent: 0;
	Font: Times;
	Style: Roman;
	Weight: Normal;
	LineWeight: 0;
	Width: Enclosing . Width;
#ifdef PAGE
	Size: 11 pt;
	{HorizPos: VMiddle = Enclosing.VMiddle;}
	Page(ThePage);
#else
	Height: Enclosing . Height min;
	Size: DOC_FONTSIZE;
#endif
	HorizPos: Left = Enclosing . Left;
	VertPos: Top = Enclosing . Top;
	PaddingBottom: 2 cm;
	IN Structure_view BEGIN
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left;
		PaddingLeft: 0.4;
		Font: Helvetica;
		END;
	IN Links_view BEGIN
#ifdef PAGE
		Page(LinksPage);
#endif
		Height: Enclosed . Height;
		Visibility: 10;
		END;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Page(ToCPage);
#endif
		Height: Enclosed . Height;
		Visibility: 10;
		END;
	IN Alternate_view BEGIN
		Font: Courier;
		Height: Enclosed . Height;
		END;
	END;

 HTML:	BEGIN
	Width: Enclosing . Width;
	CreateBefore(ElementName);
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		Width: Enclosing . Width - 1;
		HorizPos: Left = Enclosing . Left + 1;
		END;
	END;

 HEAD:	BEGIN
	Visibility: 0;
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	END;

 BODY:	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	if not within NOFRAMES BEGIN
	        MarginLeft: 0.5;
	        MarginRight: 0.5;
		VertPos: Top = Previous AnyElem . Bottom;
		END;
	if within NOFRAMES BEGIN
		CreateWith(VerticalLine);
		VertPos: Top = Previous . Bottom;
		END;
	Width: Enclosing . Width;
#ifdef PAGE
	Adjust: Justify;
	Hyphenate: Yes;
#else
	HorizPos: Left = Enclosing . Left;
	Hyphenate: No;
	Adjust: Left;
#endif
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
                HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		MarginLeft: 0;
		MarginRight: 0;
#ifdef PAGE
		Adjust: Left;
#else
                Width: Enclosing . Width - STRUCT_INDENT;
#endif
		END;
	IN Links_view BEGIN
#ifdef PAGE
		Adjust: Left;
#endif
		PaddingTop: 0;
		PaddingLeft: 0.5;
		PaddingRight: 0;
		Visibility: Enclosing =;
		END;
	IN Table_of_contents BEGIN
		Visibility: 0;
		END;
	END;

 Document_URL:	BEGIN
#ifndef PAGE
	Visibility: 0;
#else
	IN Structure_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
#endif
	END;

 TITLE:	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
#ifndef PAGE
	Visibility: 0;
#endif
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		FillPattern: nopattern;
		Visibility: Enclosing =;
		END;
	IN Table_of_contents
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

 ISINDEX: BEGIN
	CreateBefore(ElementName);
	CreateBefore(ISINDEX_Graph1);
#ifndef PAGE
	CreateBefore(ISINDEX_Graph2);
#endif
	if not Prompt
	    CreateFirst(INDEX_TXT);
	CreateFirst(VAL_ATTR_PROMPT);
	CreateAfter(ISINDEX_Graph1);
#ifndef PAGE
	CreateAfter(ISINDEX_Graph2A);
#endif
	IN Structure_view BEGIN
		VertPos: Top = Previous ElementName . Top;
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Weight: TAG_Weight;
		Visibility: Enclosing =;
                Foreground: TAG_Color;
		END;
	END;

 BASE:	BEGIN
	CreateBefore(ElementName);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
#ifndef BLACK_WHITE
	Foreground: Blue;
#endif
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Foreground: ATTR_Color;
		Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: Enclosing =;
		Size: TAG_FONTSIZE;
		END;
	IN Links_view
		Visibility: 0;
	END;

 STYLE_: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Visibility: 0;
	Line;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Visibility: Enclosing =;
		END;
	END;

 SCRIPT_: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Visibility: 0;
	Line;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Foreground: Enclosing =;
		Visibility: Enclosing =;
		END;		
	END;

 META:  BEGIN
	CreateBefore(ElementName);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous ElementName . Top;
		Foreground: Enclosing =;
		Visibility: Enclosing =;
		END;		
	END;

 LINK:	BEGIN
	CreateBefore(ElementName);
#ifndef BLACK_WHITE
	Foreground: Blue;
#endif
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous ElementName . Top;
		Foreground: Enclosing =;
		Visibility: Enclosing =;
		END;
	END;

 C_Empty: BEGIN
	Width: 0;
	Height: 0;
	Visibility: 0;
	FillPattern: nopattern;
	IN Structure_view
	   BEGIN
	   if within ISINDEX
		Height: Enclosed . Height;
	   END;
	END;

 H1:	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Line;
	LineBreak: No;
#ifdef PAGE
	NoBreak1 : 2;
	NoBreak2 : 2;
#endif
	VertPos: Top = Previous not MAP . Bottom;
	MarginTop: VSpaceBeforeH1;
	MarginBottom: 0.2;
	Width: Enclosing . Width;
	Size: Enclosing + 6 pt;
	Weight: Bold;
	Hyphenate: No;
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		MarginTop: 0;
		MarginBottom: 0;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		Size: Enclosing =;
		Weight: Enclosing =;
		NoLine;
		END;
	IN Alternate_view BEGIN
		MarginTop: 0;
		MarginBottom: 0;
		Size: Enclosing =;
		Weight: Enclosing =;
		Adjust: VMiddle;
		VertPos: Top = Previous . Bottom;
		END;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Adjust: VMiddle;
		HorizPos: Left = Enclosing . Left;
#else
		HorizPos: Left = Enclosing . Left + 1;
		Width: Enclosing . Width - 1.2;
#endif
		MarginTop: VSpaceInToC;
		Size: Enclosing + 2 pt;
		Visibility: 10;
		END;
	IN Links_view
		Visibility: 0;
	END;

 H2:	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Line;
	LineBreak: No;
#ifdef PAGE
	NoBreak1 : 2;
	NoBreak2 : 2;
#endif
	VertPos: Top = Previous not MAP . Bottom;
	MarginTop: VSpaceBeforeH2;
	Width: Enclosing . Width;
	Size: Enclosing + 4 pt;
	Weight: Bold;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		MarginTop: 0;
		Size: Enclosing =;
		Weight: Enclosing =;
		NoLine;
		END;
	IN Alternate_view BEGIN
		Size: Enclosing =;
		Weight: Enclosing =;
		VertPos: Top = Previous . Bottom;
		END;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Adjust: LeftWithDots;
		Width: Right = Enclosing . Right - 28 pt;
#else
		Width: Enclosing . Width - 1.2;
#endif
		HorizPos: Left = Enclosing . Left + 1;
		Size: Enclosing =;
		Weight: Enclosing =;
		Visibility: 9;
		MarginTop: VSpaceInToC;
		END;
	IN Links_view
		Visibility: 0;
	END;

 H3:	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Line;
	LineBreak: No;
#ifdef PAGE
	NoBreak1 : 2;
	NoBreak2 : 2;
#endif
	VertPos: Top = Previous not MAP . Bottom;
	MarginTop: VSpaceBeforeH3;
	Width: Enclosing . Width;
	Size: Enclosing + 2 pt;
	Weight: Bold;
	IN Structure_view BEGIN
		MarginTop: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Size: Enclosing =;
		Weight: Enclosing =;
		NoLine;
		END;
	IN Alternate_view BEGIN
		MarginTop: 0;
		Size: Enclosing =;
		Weight: Enclosing =;
		VertPos: Top = Previous . Bottom;
		END;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Adjust: LeftWithDots;
		Width: Right = Enclosing . Right - 28 pt;
#else
		Width: Enclosing . Width - 2.2;
#endif
		HorizPos: Left = Enclosing . Left + 2;
		Size: Enclosing =;
		Weight: Enclosing =;
		Visibility: 8;
		MarginTop: VSpaceInToC;
		END;
	IN Links_view
		Visibility: 0;
	END;

 H4:	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Line;
	LineBreak: No;
#ifdef PAGE
	NoBreak1 : 2;
	NoBreak2 : 2;
#endif
	VertPos: Top = Previous not MAP . Bottom;
	MarginTop: VSpaceBeforeH4;
	Width: Enclosing . Width;
	Size: Enclosing =;
	Weight: Bold;
	IN Structure_view BEGIN
		MarginTop: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Size: Enclosing =;
		Weight: Enclosing =;
		NoLine;
		END;
	IN Alternate_view BEGIN
		MarginTop: 0;
		Weight: Enclosing =;
		Size: Enclosing =;
		VertPos: Top = Previous . Bottom;
		END;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Adjust: LeftWithDots;
		Width: Right = Enclosing . Right - 28 pt;
#else
		Width: Enclosing . Width - 3.2;
#endif
		MarginTop: 0;
		HorizPos: Left = Enclosing . Left + 3;
		Size: Enclosing =;
		Weight: Enclosing =;
		Visibility: 7;
		END;
	IN Links_view
		Visibility: 0;
	END;

 H5:	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Line;
	LineBreak: No;
#ifdef PAGE
	NoBreak1 : 2;
	NoBreak2 : 2;
#endif
	VertPos: Top = Previous not MAP . Bottom;
	MarginTop: VSpaceBeforeH5;
	Width: Enclosing . Width;
	Size: Enclosing - 2 pt;
	Weight: Bold;
	IN Structure_view BEGIN
		MarginTop: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Size: Enclosing =;
		Weight: Enclosing =;
		NoLine;
		END;
	IN Alternate_view BEGIN
		Size: Enclosing =;
		Weight: Enclosing =;
		VertPos: Top = Previous . Bottom;
		END;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Adjust: LeftWithDots;
		Width: Right = Enclosing . Right - 28 pt;
#else
		Width: Enclosing . Width - 4.2;
#endif
		MarginTop: 0;
		HorizPos: Left = Enclosing . Left + 4;
		Size: Enclosing =;
		Weight: Enclosing =;
		Visibility: 6;
		END;
	IN Links_view
		Visibility: 0;
	END;

 H6:	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Line;
	LineBreak: No;
#ifdef PAGE
	NoBreak1 : 2;
	NoBreak2 : 2;
#endif
	Width: Enclosing . Width;
	VertPos: Top = Previous not MAP . Bottom;
	MarginTop: VSpaceBeforeH6;
	Size: Enclosing - 4 pt;
	Weight: Bold;
	IN Structure_view BEGIN
		MarginTop: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Size: Enclosing =;
		Weight: Enclosing =;
		NoLine;
		END;
	IN Alternate_view BEGIN
		Size: Enclosing =;
		Weight: Enclosing =;
		VertPos: Top = Previous . Bottom;
		END;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Adjust: LeftWithDots;
		Width: Right = Enclosing . Right - 28 pt;
#else
		Width: Enclosing . Width - 5.2;
#endif
		MarginTop: 0;
		HorizPos: Left = Enclosing . Left + 5;
		Size: Enclosing =;
		Weight: Enclosing =;
		Visibility: 5;
		END;
	IN Links_view
		Visibility: 0;
	END;

 BaseFont:
	BEGIN
	CreateBefore(ElementName);
	Visibility: 0;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous ElementName . Top;
		Foreground: Enclosing =;
		Visibility: Enclosing =;
		END;		
	END;
 BR:
	BEGIN
	CreateBefore(ElementName);
	LineBreak: Yes;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Links_view
		Visibility: 0;
	END;

 Italic_text:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Style: Italics;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Style: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;
 Bold_text:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Weight: Bold;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Weight: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;
 Teletype_text:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Font: Courier;
#ifdef PAGE
	Size: Enclosing - 1;
#endif
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: Enclosing =;
		VertPos: Top = Previous . Bottom;
		END;
	END;
 Underlined_text:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Underline: Underlined;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Underline: NoUnderline;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;
 Struck_text:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Underline: CrossedOut;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Underline: NoUnderline;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;
 Big_text:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Size: 6;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Alternate_view
		Size: Enclosing =;
	END;
 Small_text:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Size: 3;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Alternate_view
		Size: Enclosing =;
	END;
 Subscript:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: No;
	Size: Enclosing * 60 %;
	HorizRef: Enclosed . HRef - 0.3;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: Enclosing =;
		HorizRef: Enclosed . HRef;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Alternate_view BEGIN
		Size: Enclosing =;
		HorizRef: Enclosed . HRef - 1;
		END;
	END;
 Superscript:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: No;
	Size: Enclosing * 60 %;
	HorizRef: Enclosed . HRef + 0.4;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Size: Enclosing =;
		HorizRef: Enclosed . HRef;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Alternate_view BEGIN
		Size: Enclosing =;
		HorizRef: Enclosed . HRef + 1;
		END;
	END;

 Emphasis:
	BEGIN	
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Style: Italics;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Style: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;

 Strong:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Weight: Bold;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Weight: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;
 Def:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Style: Italics;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Style: Enclosing =;
		END;
	END;
 Code:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Font: Courier;
#ifdef PAGE
	Size: Enclosing - 1;
#endif
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Font: Enclosing =;
		END;
	END;
 Sample:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Font: Courier;
#ifdef PAGE
	Size: Enclosing - 1;
#endif
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Font: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;
 Keyboard:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Font: Courier;
#ifdef PAGE
	Size: Enclosing - 1;
#endif
	Style: Oblique;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Font: Enclosing =;
		Style: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;
 Variable_:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Style: Oblique;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Style: Enclosing =;
		END;
	IN Alternate_view
		Style: Enclosing =;
	END;
 Cite:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	Font: Times;
	Style: Italics;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Font: Enclosing =;
		Style: Enclosing =;
		END;
	IN Alternate_view
		Font: Enclosing =;
	END;

 ABBR:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;

 ACRONYM:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;

 Font_: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: Yes;
	HorizPos: Left = Enclosing . Left;
	VertPos: Top = Previous not MAP . Bottom + 0.4;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;

 Applet: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Width: Enclosing . Width;
	VertPos: Top = Previous not MAP . Bottom;
	MarginTop: 0.4;
	IN Structure_view BEGIN
		MarginTop: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;	
	IN Links_view
		Visibility: 0;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;

 Parameter: BEGIN
	CreateBefore(ElementName);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous ElementName . Top;
		Foreground: Enclosing =;
		Visibility: Enclosing =;
		END;		
	END;

 Object: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	if within HEAD
		Visibility: 0;
	VertPos: Top = Previous not MAP . Bottom;
	LineBreak: No;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;	
	IN Alternate_view BEGIN
		VertPos: Top = Previous . Bottom;
		Height: Enclosed . Height;
		END;
	IN Links_view
		Visibility: 0;
	END;

 Object_Content: BEGIN
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	VertPos: Top = Enclosing . Top;
	HorizPos: Left = Enclosing . Left;
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Width: Enclosing . Width;
		Height: Enclosed . Height;
		VertPos: Top = Previous . Bottom;
		END;
	IN Alternate_view BEGIN
		Visibility: Enclosing =;
		Width: Enclosing . Width;
		Height: Enclosed . Height;
		VertPos: Top = Enclosing . Top;
		END;
	END;

 Quotation: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	if not within Quotation
		BEGIN
		CreateBefore(DOUBLE_QUOTE);
		CreateAfter(DOUBLE_QUOTE);
		END;
	if within Quotation
		BEGIN
		CreateBefore(QUOTE);
		CreateAfter(QUOTE);
		END;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;

 INS:	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Style: Italics;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Style: Enclosing =;
		END;
	END;

 DEL:	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	Underline: CrossedOut;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Underline: Enclosing =;
		END;
	END;

 Span:	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;

 BDO:	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	UnicodeBidi: Override;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;

 HTMLfragment:
	BEGIN
	Width: Enclosing . Width;
	Depth: Enclosing =;
	Adjust: Left;
	END;

 Paragraph: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Line;
	LineBreak: No;
#ifdef PAGE
	NoBreak1 : 2;
	NoBreak2 : 2;
#endif
	Width: Enclosing . Width;
	VertPos: Top = Previous not MAP . Bottom;
	{MarginTop: 1 em;
	MarginBottom: 1 em;}
	if not within List_Item BEGIN
	    MarginTop: 0.2;
	    MarginBottom: 0.4;
	    END;
	IN Structure_view BEGIN
		MarginTop: 0;
		MarginBottom: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		NoLine;
		END;
	IN Links_view
		Visibility: 0;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;

 Pseudo_paragraph: BEGIN
	Line;
	LineBreak: Yes;
#ifdef PAGE
	NoBreak1 : 2;
	NoBreak2 : 2;
#endif
	Width: Enclosing . Width;
	VertPos: Top = Previous not MAP . Bottom;
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		NoLine;
		END;
	IN Links_view
		Visibility: 0;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;

 Definition_List: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: No;
	Width: Enclosing . Width;
	VertPos: Top = Previous not MAP . Bottom;
	MarginTop: 0.4;
	IN Structure_view BEGIN
		MarginTop: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Links_view
		Visibility: 0;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;

 Definition_Item: BEGIN
	Width: Enclosing . Width;
	END;

 Term_List: BEGIN
	Width: Enclosing . Width;
	END;

 Term:	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Line;
#ifdef PAGE
	NoBreak1 : 2;
	NoBreak2 : 2;
#endif
	Width: Enclosing . Width;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		NoLine;
		END;
	END;

 Definitions: BEGIN
	Width: Enclosing . Width;
	END;

 Definition: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	MarginLeft: DEFINITION_INDENT;
	Width: Enclosing . Width;
	HorizPos: Left = Enclosing . Left;
	IN Structure_view BEGIN
		MarginLeft: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	END;

 Unnumbered_List: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: No;
	Width: Enclosing . Width;
	{PaddingLeft: 0.5 em;}
	VertPos: Top = Previous not MAP . Bottom;
	if not within Definition and not within List_Item
	        MarginTop: 0.5;
	IN Structure_view BEGIN
		MarginTop: 0;
		PaddingLeft: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Links_view
		Visibility: 0;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;

 Numbered_List:	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: No;
	Width: Enclosing . Width;
	{PaddingLeft: 0.5 em;}
	VertPos: Top = Previous not MAP . Bottom;
	if not within Definition and not within List_Item
	        MarginTop: 0.5;
	IN Structure_view BEGIN
		MarginTop: 0;
		PaddingLeft: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Links_view
		Visibility: 0;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;

 Address: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Line;
	LineBreak: No;
	Style: Italics;
	Width: Enclosing . Width;
	VertPos: Top = Previous not MAP . Bottom;
	MarginTop: 0.5;
	HorizPos: Left = Enclosing . Left;
	IN Structure_view BEGIN
		MarginTop: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Style: Enclosing =;
		VertPos: Top = Previous . Bottom;
		NoLine;
		END;
	IN Links_view
		Visibility: 0;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;

 Menu:	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: No;
	Width: Enclosing . Width;
	VertPos: Top = Previous not MAP . Bottom;
	MarginTop: 0.5;
	IN Structure_view BEGIN
		MarginTop: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Links_view
		Visibility: 0;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;

 Directory: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: No;
	Width: Enclosing . Width;
	VertPos: Top = Previous not MAP . Bottom;
	MarginTop: 0.5;
	IN Structure_view BEGIN
		MarginTop: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Links_view
		Visibility: 0;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;

 List_Item: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: No;
	VertRef: * . Left;
	MarginLeft: LIST_INDENT;
	HorizPos: Left = Enclosing . Left + LIST_SHIFT;
	Width: Enclosing . Width - LIST_SHIFT;
	VertPos: Top = Previous AnyElem . Bottom;
	IN Structure_view
		BEGIN
		MarginLeft: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;

 Preformatted: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: No;
	VertPos: Top = Previous not MAP . Bottom;
	MarginTop: 0.4;
	Width: Enclosed . Width;
	if within Center
	   HorizPos: VMiddle = Enclosing . VMiddle;
	Adjust: Left;
	Font: Courier;
	Line;
#ifdef PAGE
	Size: Enclosing - 1;
#endif
	IN Structure_view BEGIN
		MarginTop: 0;
		NoLine;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Font: Enclosing =;
		END;
	IN Links_view
		Visibility: 0;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;

 Horizontal_Rule: BEGIN
	CreateBefore(ElementName);
#ifdef PAGE
	CreateLast(HR_Print);
#else
	CreateLast(HR_Alt);
	CreateLast(HR_Graph1);
#endif
	Width: Enclosing . Width;
	Height: 2 px;
	HorizPos: VMiddle = Enclosing . VMiddle;
	VertPos: Top = Previous . Bottom;
	MarginTop: 0.5;
	MarginBottom: 0.5;
	Clear: Both;
	LineWeight: 1 px;
	Foreground: Black;
	LineBreak: No;
	IN Alternate_view
		BEGIN
		Height: 1;
		MarginTop: 0;
		MarginBottom: 0;
		VertPos: Top = Previous . Bottom;
		END;
	IN Structure_view
		BEGIN
		MarginTop: 0;
		MarginBottom: 0;
		Height: 0;
		END;
	IN Links_view
		Visibility: 0;
	END;

 Form:	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Width: Enclosing . Width;
	VertPos: Top = Previous not MAP . Bottom;
	Gather: Yes;
	MarginTop: 0.2;
	MarginBottom: 0.2;
	IN Structure_view BEGIN
	        Gather: No;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		MarginTop: 0;
		MarginBottom: 0;
		END;
	IN Links_view
		Visibility: 0;
	IN Alternate_view
		BEGIN
		VertPos: Top = Previous . Bottom;
		MarginTop: 0;
		MarginBottom: 0;
		END;
	END;

 Option_Menu: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	if not Multiple BEGIN
		CreateBefore(START_SELECT_ALT);
		CreateAfter(END_SELECT_ALT);
		END;
	if Multiple BEGIN
        	CreateBefore(NEW_LINE);
		CreateAfter(NEW_LINE);
		END;
	ShowBox;
	Background : White;
	Foreground : Black;
	FillPattern: backgroundcolor;
	PaddingTop: 1 px;
	PaddingLeft: 0;
	PaddingRight: 0;
	PaddingBottom: 1 px;
	BorderTopWidth: 1 px;
	BorderRightWidth: 1 px;
	BorderBottomWidth: 1 px;
	BorderLeftWidth: 1 px;
	BorderTopColor: DarkGrey3;
	BorderRightColor: LightGrey1;
	BorderBottomColor: LightGrey1;
	BorderLeftColor: DarkGrey3;
	BorderTopStyle: Solid;
	BorderRightStyle: Solid;
	BorderBottomStyle: Solid;
	BorderLeftStyle: Solid;
	Width: Enclosed . Width;
	Height: Enclosed . Height;
	LineBreak: No;
	HorizPos: Left = Previous . Right;	
	VertPos: HRef = Previous . HRef;
	HorizRef: Enclosed . HRef;
	IN Structure_view BEGIN
		Background : Enclosing =;
		Foreground : Enclosing =;
		PaddingTop: 0;
		PaddingLeft: 0;
		PaddingBottom: 0;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Alternate_view BEGIN
		Background : Enclosing =;
		Foreground : Enclosing =;
		PaddingTop: 0;
		PaddingLeft: 0;
		PaddingBottom: 0;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		END;
	END;

 Option_item: BEGIN
	Visibility: 0;
	END;
	
 Option: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Visibility: 0;	{ attribute Selected or ShowMe makes it visible }
	PaddingLeft: 0.2;
	PaddingRight: 0.2;
	HorizRef: Enclosed . HRef;
	LineBreak: No;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		PaddingLeft: 0;
		PaddingRight: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view BEGIN
		PaddingLeft: 0;
		PaddingRight: 0;		
		HorizPos: Left = Enclosing . Left;
		END;
	END;

 OptGroup: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Alternate_view
		Visibility: Enclosing =;
	END;

 Text_Area: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
        CreateBefore(NEW_LINE);
	CreateAfter(NEW_LINE);
	BorderTopWidth: 1 px;
	BorderLeftWidth: 1 px;
	BorderBottomWidth: 1 px;
	BorderRightWidth: 1 px;
	BorderTopColor: DarkGrey3;
	BorderLeftColor: DarkGrey3;
	BorderBottomColor: LightGrey1;
	BorderRightColor: LightGrey1;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderBottomStyle: Solid;
	BorderRightStyle: Solid;
	Background: White;
	FillPattern: backgroundcolor;
	ShowBox;
	Width: 20 ex;
	Height: 2 Min;
	Font: INPUT_Font;
	LineBreak: No;
	Depth: Enclosing - 1;
	HorizRef: * . Bottom - 0.3;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		Depth: 0;
		END;
	IN Alternate_view BEGIN
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		Height: Enclosed . Height;
		Depth: 0;
		END;	
	END;

 FIELDSET: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Width: Enclosing . Width;
	VertPos: Top = Previous not MAP . Bottom + 0.6;
	MarginTop: 0.5;
	MarginBottom: 0.5;
	BorderTopColor: DarkGrey2;
	BorderRightColor: DarkGrey2;
	BorderBottomColor: DarkGrey2;
	BorderLeftColor: DarkGrey2;
	BorderTopStyle: Solid;
	BorderRightStyle: Solid;
	BorderBottomStyle: Solid;
	BorderLeftStyle: Solid;
	BorderTopWidth: 1 px;
	BorderRightWidth: 1 px;
	BorderBottomWidth: 1 px;
	BorderLeftWidth: 1 px;
        PaddingRight: 0.6;
        PaddingBottom: 0.4;
        PaddingLeft: 0.6;
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		MarginTop: 0;
		MarginBottom: 0;
		PaddingTop: 0;
		PaddingLeft: 0;
		PaddingBottom: 0;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		END;
	IN Links_view
		Visibility: 0;
	IN Alternate_view BEGIN
		VertPos: Top = Previous . Bottom + 0.8;
		MarginBottom: 0.8;
		MarginTop: 0;
		PaddingTop: 0;
		PaddingLeft: 0;
	        PaddingBottom: 0.;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;		
		END;
	END;

 LEGEND: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Width: Enclosed . Width;
	VertPos: Top = Enclosing . Top - 0.6;
	HorizPos: Left = Enclosing . Left;
        PaddingLeft: 0.3;
        PaddingRight: 0.3;
	MarginBottom: 0.5;
	Background: Enclosing =;
        Showbox;
	FillPattern: backgroundcolor;
        Depth: Enclosing - 2;
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
        	PaddingLeft: 0;
        	PaddingRight: 0;
		MarginBottom: 0;
		NoLine;
		END;
	IN Alternate_view BEGIN
		VertPos: Top = Enclosing . Top;
       		PaddingLeft: 0;
        	PaddingRight: 0;
		MarginBottom: 0.8;
		END;
	END;

 Inserted_Text: BEGIN
	IF within Text_Area
		CreateLast (INSERTED_TEXTAREA_ALT);
	IF not within Text_Area
		CreateLast (INSERTED_ALT);
	Line;
	Adjust: Left;
	VertPos: Top = Enclosing . Top;
	HorizPos: Left = Enclosing . Left + 0.3;
	Width: Enclosing . Width - 0.5;
	Background: Enclosing =;
	FillPattern: nopattern;
        Foreground: Black;
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left;
		Width: Enclosing . Width;
		END;
	IN Alternate_view BEGIN
		IF within Text_Area
		    Width: Enclosing . Width;
		IF not within Text_Area
		    Width: Enclosed . Width;
		HorizPos: Left = Enclosing . Left;
		END;
	END;

 Checkbox_Input: BEGIN
	{ attribute Checked generates the right picture }
	CreateBefore(ElementName);
	CreateBefore(ATTR_Checkbox);
	MarginLeft: 3 px;
	MarginRight: 3 px;
	LineBreak: No;
	In Structure_view BEGIN
		Visibility: Enclosing =;
		MarginLeft: 0;
		MarginRight: 0;
		Width: 0;
		Height: 0;
		END;
	IN Alternate_view BEGIN
		MarginLeft: 0;
		MarginRight: 0;
		END;
	END;

 Radio_Input: BEGIN
	{ attribute Checked generates the right picture }
	CreateBefore(ElementName);
	CreateBefore(ATTR_Radio);
	MarginLeft: 3 px;
	MarginRight: 3 px;
	LineBreak: No;
	In Structure_view BEGIN
		Visibility: Enclosing =;
		MarginLeft: 0;
		MarginRight: 0;
		Width: 0;
		Height: 0;
		END;
	IN Alternate_view BEGIN
		MarginLeft: 0;
		MarginRight: 0;
		END;
	END;

 Text_Input: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	CreateBefore(ATTR_Text);
	MarginLeft: 2 px;
	MarginRight: 2 px;
	PaddingTop: 1 px;
	PaddingBottom: 1 px;
	BorderTopWidth: 1 px;
	BorderLeftWidth: 1 px;
	BorderBottomWidth: 1 px;
	BorderRightWidth: 1 px;
	BorderTopColor: DarkGrey3;
	BorderLeftColor: DarkGrey3;
	BorderBottomColor: LightGrey1;
	BorderRightColor: LightGrey1;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderBottomStyle: Solid;
	BorderRightStyle: Solid;
	Background: White;
	FillPattern: backgroundcolor;
	ShowBox;
	Width: 20 ex Min;
	Font: INPUT_Font;
	Depth: Enclosing - 1;
	LineBreak: No;
	Adjust: Left;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		MarginLeft: 0;
		MarginRight: 0;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		Depth: 0;
		END;
	IN Alternate_view BEGIN
		Width: Enclosed . Width;
		Height: Enclosed . Height;
		MarginLeft: 0;
		MarginRight: 0;
		PaddingTop: 0;
		PaddingBottom: 0;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		Background: Enclosing =;
		FillPattern: nopattern;
		Depth: Enclosing =;
		END;	
	END;

 File_Input: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	CreateBefore(ATTR_File);
	CreateAfter(BrowseLabel);
	PaddingTop: 1 px;
	BorderTopWidth: 1 px;
	BorderLeftWidth: 1 px;
	BorderBottomWidth: 1 px;
	BorderRightWidth: 1 px;
	BorderTopColor: DarkGrey3;
	BorderLeftColor: DarkGrey3;
	BorderBottomColor: LightGrey1;
	BorderRightColor: LightGrey1;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderBottomStyle: Solid;
	BorderRightStyle: Solid;
	Background: White;
	FillPattern: backgroundcolor;
	ShowBox;
	Width: 20 ex Min;
	Font: INPUT_Font;
	Depth: Enclosing - 2;
	LineBreak: No;
	Adjust: Left;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		PaddingTop: 0;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		Depth: 0;
		END;
	IN Alternate_view BEGIN
		Width: Enclosed . Width;
		Height: Enclosed . Height;
		PaddingTop: 0;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		Background: Enclosing =;
		FillPattern: nopattern;
		Depth: Enclosing =;
		END;
	END;

 Hidden_Input: BEGIN
	CreateBefore(ElementName);
	CreateBefore(ATTR_Hidden);
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Height: 0;
		END;
	END;

 Password_Input: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	CreateBefore(ATTR_Password);
	MarginLeft: 2 px;
	MarginRight: 2 px;
	PaddingTop: 1 px;
	PaddingBottom: 1 px;
	BorderTopWidth: 1 px;
	BorderLeftWidth: 1 px;
	BorderBottomWidth: 1 px;
	BorderRightWidth: 1 px;
	BorderTopColor: DarkGrey3;
	BorderLeftColor: DarkGrey3;
	BorderBottomColor: LightGrey1;
	BorderRightColor: LightGrey1;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderBottomStyle: Solid;
	BorderRightStyle: Solid;
	Background: White;
	FillPattern: backgroundcolor;
	ShowBox;
	Width: 20 ex Min;
	Font: INPUT_Font;
	Depth: Enclosing - 1;
	LineBreak: No;
	Adjust: Left;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		MarginLeft: 0;
		MarginRight: 0;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		Depth: 0;
		END;
	IN Alternate_view BEGIN
		Width: Enclosed . Width;
		Height: Enclosed . Height;
		MarginLeft: 0;
		MarginRight: 0;
		PaddingTop: 0;
		PaddingBottom: 0;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		Background: Enclosing =;
		FillPattern: nopattern;
		Depth: Enclosing =;
		END;
	END;

 Reset_Input: BEGIN
	CreateBefore(ElementName);
	CreateBefore(ATTR_Reset);
	CreateFirst(Value_Box);
	CreateFirst(Value_Box_Alt);
	PaddingTop: 1 px;
	PaddingLeft: 0.3;
	PaddingBottom: 1 px;
	PaddingRight: 0.3;
	BorderTopWidth: 1 px;
	BorderLeftWidth: 1 px;
	BorderBottomWidth: 1 px;
	BorderRightWidth: 1 px;
	BorderTopColor: LightGrey1;
	BorderLeftColor: LightGrey1;
	BorderBottomColor: DarkGrey3;
	BorderRightColor: DarkGrey3;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderBottomStyle: Solid;
	BorderRightStyle: Solid;
	Depth: Enclosing - 1;
#ifndef BLACK_WHITE
	Background : Grey;
#endif
	FillPattern: backgroundcolor;
	ShowBox;
	LineBreak: No;
	HorizPos: Left = Previous . Right;	
	HorizRef: Enclosed . HRef;
	IN Structure_view BEGIN
		PaddingTop: 0;
		PaddingLeft: 0;
		PaddingBottom: 0;
		PaddingRight: 0;
		BorderTopWidth: 0;
		BorderLeftWidth: 0;
		BorderBottomWidth: 0;
		BorderRightWidth: 0;
	        VertPos: Top = Previous . Bottom;
		Visibility: Enclosing =;
		Width: 0;
		Height: 0;
		Depth: 0;
		END;
	IN Alternate_view BEGIN
		PaddingTop: 0;
		PaddingLeft: 0;
		PaddingBottom: 0;
		PaddingRight: 0;
		BorderTopWidth: 0;
		BorderLeftWidth: 0;
		BorderBottomWidth: 0;
		BorderRightWidth: 0;
		END;
	END;

 Submit_Input: BEGIN
	CreateBefore(ElementName);
	CreateBefore(ATTR_Submit);
	CreateFirst(Value_Box);
	CreateFirst(Value_Box_Alt);
	PaddingTop: 1 px;
	PaddingLeft: 0.3;
	PaddingBottom: 1 px;
	PaddingRight: 0.3;
	BorderTopWidth: 1 px;
	BorderLeftWidth: 1 px;
	BorderBottomWidth: 1 px;
	BorderRightWidth: 1 px;
	BorderTopColor: LightGrey1;
	BorderLeftColor: LightGrey1;
	BorderBottomColor: DarkGrey3;
	BorderRightColor: DarkGrey3;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderBottomStyle: Solid;
	BorderRightStyle: Solid;
	Depth: Enclosing - 1;
#ifndef BLACK_WHITE
	Background: Grey;
#endif
	Foreground: Black;
	FillPattern: backgroundcolor;
	ShowBox;
	LineBreak: No;
	VertPos: HRef = Previous . HRef;
	HorizRef: Enclosed . HRef;
	IN Structure_view BEGIN
		PaddingTop: 0;
		PaddingLeft: 0;
		PaddingBottom: 0;
		PaddingRight: 0;
		BorderTopWidth: 0;
		BorderLeftWidth: 0;
		BorderBottomWidth: 0;
		BorderRightWidth: 0;
	        VertPos: Top = Previous . Bottom;
		Visibility: Enclosing =;
		Width: 0;
		Height: 0;
		Depth: 0;
		END;
	IN Alternate_view BEGIN
		PaddingTop: 0;
		PaddingLeft: 0;
		PaddingBottom: 0;
		PaddingRight: 0;
		BorderTopWidth: 0;
		BorderLeftWidth: 0;
		BorderBottomWidth: 0;
		BorderRightWidth: 0;
		END;
	END;

 Button_Input: BEGIN
	CreateBefore(ElementName);
	CreateBefore(ATTR_Button);
	CreateFirst(Value_Box);
	CreateFirst(Value_Box_Alt);
	PaddingTop: 1 px;
	PaddingBottom: 1 px;
	PaddingLeft: 0.3;
	PaddingRight: 0.3;
	BorderTopWidth: 1 px;
	BorderLeftWidth: 1 px;
	BorderBottomWidth: 1 px;
	BorderRightWidth: 1 px;
	BorderTopColor: LightGrey1;
	BorderLeftColor: LightGrey1;
	BorderBottomColor: DarkGrey3;
	BorderRightColor: DarkGrey3;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderBottomStyle: Solid;
	BorderRightStyle: Solid;
	Depth: Enclosing - 1;
#ifndef BLACK_WHITE
	Background : Grey;
#endif
	FillPattern: backgroundcolor;
	ShowBox;
	LineBreak: No;
	HorizPos: Left = Previous . Right;	
	VertPos: HRef = Previous . HRef;
	HorizRef: Enclosed . HRef;
	IN Structure_view BEGIN
	        VertPos: Top = Previous . Bottom;
		Visibility: Enclosing =;
		Width: 0;
		Height: DOC_FONTSIZE;
		Depth: 0;
		END;
	IN Alternate_view BEGIN
		PaddingTop: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		PaddingRight: 0;
		BorderTopWidth: 0;
		BorderLeftWidth: 0;
		BorderBottomWidth: 0;
		BorderRightWidth: 0;
		END;
	END;

 LABEL: BEGIN
 	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Links_view
		Visibility: 0;
	END;

 BUTTON_: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
        CreateBefore(BUTTON_ALT);
	MarginLeft: 2 px;
	MarginRight: 2 px;
	PaddingTop: 1 px;
	PaddingLeft: 0.3;
	PaddingBottom: 1 px;
	PaddingRight: 0.3;
	BorderTopWidth: 1 px;
	BorderLeftWidth: 1 px;
	BorderBottomWidth: 1 px;
	BorderRightWidth: 1 px;
	BorderTopColor: LightGrey1;
	BorderLeftColor: LightGrey1;
	BorderBottomColor: DarkGrey3;
	BorderRightColor: DarkGrey3;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderBottomStyle: Solid;
	BorderRightStyle: Solid;
#ifndef BLACK_WHITE
	Background: Grey;
#endif
	FillPattern: backgroundcolor;
	ShowBox;
	LineBreak: No;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		MarginLeft: 0;
		MarginRight: 0;
		PaddingTop: 0;
		PaddingLeft: 0;
		PaddingBottom: 0;
		PaddingRight: 0;
		BorderTopWidth: 0;
		BorderLeftWidth: 0;
		BorderBottomWidth: 0;
		BorderRightWidth: 0;
		END;
	IN Alternate_view BEGIN
		MarginLeft: 0;
		MarginRight: 0;
		PaddingTop: 0;
		PaddingLeft: 0;
		PaddingBottom: 0;
		PaddingRight: 0;
		BorderTopWidth: 0;
		BorderLeftWidth: 0;
		BorderBottomWidth: 0;
		BorderRightWidth: 0;
		END;
	IN Links_view
		Visibility: 0;
	END;

 Block_Quote: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	HorizPos: Left = Enclosing . Left + 2;	
	VertPos: Top = Previous AnyElem . Bottom;
	MarginTop: 0.4;
	Width: Enclosing . Width - 4;
	IN Structure_view BEGIN
		MarginTop: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Links_view
		BEGIN
		Visibility: 0;	{ attribute "cite" changes visibility }
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left;
		Line;
		MarginLeft: 2;
		Indent: -2;
#ifdef PAGE
		Adjust: LeftWithDots;
		Width: Enclosing . Width - 28 pt;
#else
		Width: Enclosing . Width;
#endif
		END;
	END;

 PICTURE_UNIT: BEGIN
	if ALT
	        CreateBefore(IMG_ALT);
	if IsInput BEGIN
		CreateBefore(IMG_in_S);
		CreateBefore(IMG_type_image);
	        END;
	if not Immediately within Object and not IsInput
		CreateBefore(ElementName);
	LineBreak: No;
	PageBreak: No;
	HorizRef: * . Bottom;
	IN Structure_view BEGIN
		Height: 0;
		Width: 0;
		if not within Object
		   Visibility: 1;
		if within Object
		   Visibility: 0;
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left;
		END;
	IN Alternate_view BEGIN
		Height: 0;
		Width: 0;
		if not Immediately within Object
		   Visibility: 1;
		if Immediately within Object
		   Visibility: 0;
		END;
	IN Links_view
#ifndef PAGE
		if Immediately within BODY
#endif
		   Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	END;

 External_Object: BEGIN
	if ALT
	        CreateBefore(IMG_ALT);
	if IsInput
		CreateBefore(IMG_in_S);
	if not Immediately within Object and not IsInput
		CreateBefore(ElementName);
	LineBreak: No;
	PageBreak: No;
	if Immediately within Object BEGIN
		Width: Enclosing . Width;
		Height: Enclosing . Height;
		VertPos: Top = Enclosing . Top;
		END;
	HorizRef: * . Bottom;
	IN Structure_view BEGIN
		Height: 0;
		Width: 0;
		if not Immediately within Object
		   Visibility: 1;
		if Immediately within Object
		   Visibility: 0;
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left;
		END;
	IN Alternate_view BEGIN
		Height: 0;
		Width: 0;
		if not Immediately within Object
		   Visibility: 1;
		if Immediately within Object
		   Visibility: 0;
		END;
	IN Links_view
#ifndef PAGE
		if Immediately within BODY
#endif
		   Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	END;

 External_Object_Content: BEGIN
	LineBreak: No;
	PageBreak: No;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	END;

 Embed_: BEGIN
	if not Immediately within Object and not IsInput
		CreateBefore(ElementName);
	LineBreak: No;
	PageBreak: No;
	if Immediately within Object BEGIN
		Width: Enclosing . Width;
		Height: Enclosing . Height;
		VertPos: Top = Enclosing . Top;
		END;
	HorizRef: * . Bottom;
	IN Structure_view BEGIN
		Height: 0;
		Width: 0;
		if not Immediately within Object
		   Visibility: 1;
		if Immediately within Object
		   Visibility: 0;
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left;
		END;
	IN Alternate_view BEGIN
		Height: 0;
		Width: 0;
		if not Immediately within Object
		   Visibility: 1;
		if Immediately within Object
		   Visibility: 0;
		END;
	IN Links_view
#ifndef PAGE
		if Immediately within BODY
#endif
		   Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	END;

 Embed_Content: BEGIN
	LineBreak: No;
	PageBreak: No;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	END;


 Anchor: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
#ifdef PAGE
	CreateAfter(LinkPageNumber);
#endif
	IN Structure_view BEGIN
		Foreground: Enclosing =;
		Underline: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Alternate_view BEGIN
		Foreground: Enclosing =;
		Underline: Underlined;
		END;
	IN Links_view BEGIN
		VertPos : Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left;
		Line;
		MarginLeft: 2;
		Indent: -2;
#ifdef PAGE
		Visibility: 0;	{ attribute HREF_ changes visibility }
		Adjust: LeftWithDots;
		Width: Enclosing . Width - 28 pt;
#else
		Visibility: 7;
		Width: Enclosing . Width;
#endif
		END;
	END;

 TEXT_UNIT:
	BEGIN
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	if within Inserted_Text
		Depth: Enclosing - 1;
	IN Structure_view BEGIN
		if not within Comment_line and not within PI_line and
	           not within DOCTYPE_line and not within CDATA_line
		   BEGIN
		   HorizPos: Left = Enclosing . Left;
		   VertPos: Top = Previous . Bottom;
		   END;
		if not within Invalid_element and not within Unknown_namespace
		and not within XHTML_Unknown_namespace
		   Style: Enclosing =;
		if within Comment_line
		   HorizPos: Left = Previous . Right;
		if within PI_line
		   HorizPos: Left = Previous . Right;
		if within DOCTYPE_line
                   BEGIN
		   HorizPos: Left = Previous . Right;
                   END;
		if within CDATA_line
                   BEGIN
		   HorizPos: Left = Previous . Right;
                   END;
		if within Preformatted
		   Font: Courier;
		Depth: 0;
		END;
	END;

 SYMBOL_UNIT:
	BEGIN
	{IN Structure_view BEGIN}
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		{END;}		
	END;

#ifdef PAGE
 PAGE_BREAK:
	BEGIN
	HorizOverflow : Yes;
	Underline: NoUnderline;
	Visibility: 10;
	END;
#endif

 MAP:	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	CreateAfter(MAP_dummy);
	Depth: Enclosing + 8;
	LineBreak: No;
	Visibility: 0;
	Gather: Yes;
	InLine: No;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
	        Gather: No;
		Font: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Depth: 0;
		END;
	IN Alternate_view BEGIN
		Visibility: 10;
	        Gather: No;
		Width: Enclosing . Width;
		Height: Enclosed . Height;
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left;
		Depth: 0;
		Line;
		END;
	END;

 map:	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: No;
	MarginTop: 0; {VSpaceBeforeH2}
	Width: Enclosing . Width;
	VertPos: Top = Previous not MAP . Bottom;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Font: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Links_view
		Visibility: 0;
	IN Alternate_view BEGIN
		VertPos: Top = Previous . Bottom;
		Line;
		END;
	END;

 AREA:	BEGIN
	CreateBefore(ElementName);
	if ALT
	    CreateFirst (AREA_ALT);
	if not ALT
	    CreateFirst (AREA_NO_ALT);
	CreateLast (SPACE);
 	HorizPos: Left = Enclosing . Left UserSpecified;
 	VertPos: Top = Enclosing . Top UserSpecified;
	Width: 5 pt UserSpecified;
	Height: 5 pt UserSpecified;
	Depth: Enclosing - 9;
	FillPattern: nopattern;
	IN Structure_view BEGIN
		Font: Enclosing =;
		Width: 0;
		Height:  Enclosed . Height;
		VertPos: Top = Previous ElementName . Top;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Depth: 0;
		END;
	IN Alternate_view BEGIN
		Height: Enclosed . Height;
		Width: Enclosed . Width;
		VertPos: HRef = Previous . HRef;
		HorizPos: Left = Previous . Right;
		END;
	IN Links_view BEGIN
		Visibility: 7;
		VertPos : Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left;
		Height: Enclosed . Height;
		Width: Enclosing . Width;
		Line;
		MarginLeft: 2;
		Indent: -2;
		END;
	END;

 GRAPHICS_UNIT : BEGIN
	Visibility: Enclosing =;
	Height: Enclosing . Height;
	Width: Enclosing . Width;	
	IN Structure_view
	   Visibility: 0;
	IN Alternate_view
	   Visibility: 0;
        IN Links_view
           if within AREA Visibility: 0;
	END;

{ ---- Table ---- }

 Table:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Gather: Yes;
	LineBreak: No;
	Adjust: Left;
#ifdef PAGE
	PageBreak: Yes;
	NoBreak1 : 3;
	NoBreak2 : 1;
#endif
	VertPos: Top = Previous not MAP . Bottom;
	{MarginTop: 0.5;}
	if within Center
		HorizPos: VMiddle = Enclosing . VMiddle;
	Width: Enclosing . Width;
	Height: Enclosed . Height;
	IN Structure_view BEGIN
		Gather: No;
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		END;
	IN Alternate_view BEGIN
		VertPos: Top = Previous . Bottom;
		Gather: No;
		END;
        IN Table_of_contents
		Gather: No;
	IN Links_view BEGIN
		Gather: No;
		Visibility: 0;
		END;
	END;

 CAPTION:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Line;
#ifdef PAGE
	PageBreak: No;
	NoBreak1 : 2;
	NoBreak2 : 2;
#endif
	Adjust: VMiddle;
	if within Table
	   BEGIN
	   Width: Enclosing . Width;
	   HorizPos: Left = Enclosing . Left;
	   VertPos: Bottom = Table_head . Top - cellspacing px;
	   END;
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		Adjust: Left;
		NoLine;
		END;
	END;

 Cols:  BEGIN
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		END;
	END;

 COLGROUP:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Visibility: 1;
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		Adjust: Left;
		Visibility: Enclosing =;
		END;
	END;

 COL:
	BEGIN
	CreateBefore(ElementName);
	Visibility: 1;
	IN Structure_view BEGIN
		Height: 0;
		Visibility: Enclosing =;
		END;
	END;

 Table_head:
	BEGIN
	HorizRef: * . Top;
	HorizPos: Left = Enclosing . Left;
	Width: Enclosed . Width;
	VertPos: nil;
#ifdef PAGE
	PageBreak: No;
#endif
	IN Structure_view BEGIN
		Visibility: 0;
		END;
	IN Alternate_view BEGIN
		Visibility: 0;
		END;
	END;

 Column_head:
	BEGIN
	HorizRef: * . Top;
	HorizPos: Left = Previous . Right;
	VertPos: Top = Enclosing . Top;
	Width: Enclosed . Width;
	Height: 0;
	END;

 C_Head:
	BEGIN
	HorizRef: * . Top;
	VertPos : Top = Enclosing . Top;
	Width: 20 px;
	Height: 0;
	FillPattern: nopattern;
	END;

 thead:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderRightStyle: Solid;
	BorderBottomStyle: Solid;
#ifdef PAGE
	PageBreak: No;
#endif
	VertPos: Top = Previous . Bottom;
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Width: Enclosing . Width - STRUCT_INDENT;
		END;
	IN Alternate_view BEGIN
		HorizPos: Left = Enclosing . Left;
		VertPos: Top = Previous . Bottom;
		Width: Enclosing . Width;
		END;
	END;

 tfoot:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
#ifdef PAGE
	PageBreak: No;
#endif
	VertPos: Top = Previous . Bottom + 0.1;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderRightStyle: Solid;
	BorderBottomStyle: Solid;
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Width: Enclosing . Width - STRUCT_INDENT;
		END;
	IN Alternate_view BEGIN
		HorizPos: Left = Enclosing . Left;
		VertPos: Top = Previous . Bottom;
		Width: Enclosing . Width;
		END;
	END;

 Table_body:
	BEGIN
#ifdef PAGE
	PageBreak: Yes;
#endif
	VertPos: Top = Previous . Bottom + 0.1;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderRightStyle: Solid;
	BorderBottomStyle: Solid;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		VertPos: Top = Previous . Bottom;
		Width: Enclosing . Width;
		END;
	IN Alternate_view BEGIN
		Visibility: Enclosing =;
		VertPos: Top = Previous . Bottom;
		Width: Enclosing . Width;
		END;
	END;

 tbody:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
#ifdef PAGE
	PageBreak: Yes;
#endif
	VertPos: Top = Previous . Bottom + 0.1;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderRightStyle: Solid;
	BorderBottomStyle: Solid;
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Width: Enclosing . Width - STRUCT_INDENT;
		END;
	IN Alternate_view BEGIN
		HorizPos: Left = Enclosing . Left;
		VertPos: Top = Previous . Bottom;
		Width: Enclosing . Width;
		END;
	END;

 Table_row:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	VertPos: Top = Previous . Bottom;
#ifdef PAGE
	{**** the next rule should be deleted, but deleting it causes
	      the print program to crash when formatting a very high
	      table row *****}
	{PageBreak: No;}
#endif
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		END;
	IN Alternate_view BEGIN
		HorizPos: Left = Enclosing . Left;
		Width: Enclosing . Width;
		END;
	END;

 Data_cell:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	if not RowExt and  immediately within Table_row
	  CreateBefore(CellFrame);
	VertPos : Top = Enclosing . Top;
	HorizPos: Left = Previous Table_cell . Right;
	Width: Enclosed . Width {20 px};
	Adjust: Enclosing =;
	PaddingTop: 0.2;
	PaddingRight: 0.2;
	PaddingBottom: 0.2;
	PaddingLeft: 0.2;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderRightStyle: Solid;
	BorderBottomStyle: Solid;
	IN Structure_view BEGIN
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		END;	
	IN Alternate_view BEGIN
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		VertPos : Top = Previous . Bottom;
		HorizPos: Left = Previous Table_cell . Left + STRUCT_INDENT;
		Width: Right = Enclosing . Right;
		END;
	END;

 Heading_cell:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	if not RowExt
	  CreateBefore(CellFrame);
	VertPos : Top = Enclosing . Top;
	HorizPos: Left = Previous Table_cell . Right;
	Width: Enclosed . Width{20 px};
	Weight: Bold;
	Adjust: VMiddle;
	PaddingTop: 0.2;
	PaddingLeft: 0.2;
	PaddingBottom: 0.2;
	PaddingRight: 0.2;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderRightStyle: Solid;
	BorderBottomStyle: Solid;
	IN Structure_view BEGIN
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		Weight: Enclosing =;
		Adjust: Enclosing =;
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		END;	
	IN Alternate_view BEGIN
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Previous Table_cell . Left + STRUCT_INDENT;
		Width: Right = Enclosing . Right;
		END;
	END;

 Table_foot:
	BEGIN
	Width: Previous . Width;
	VertPos: Bottom = Previous . Bottom;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view BEGIN
		Visibility: 0;
		END;
	END;

 C_Foot:
	BEGIN
	Height: 0;
	FillPattern: nopattern;
	END;

 Division:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Width: Enclosing . Width;
	VertPos: Top = Previous not MAP . Bottom;
        MarginTop: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		MarginTop: 0;	
		END;
	IN Links_view
		Visibility: 0;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;

  Center:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Width: Enclosing . Width;
	VertPos: Top = Previous not MAP . Bottom + 0.4;
	Adjust: VMiddle;
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		Adjust: Enclosing =;	
		END;
	IN Alternate_view BEGIN
		VertPos: Top = Previous . Bottom;
		Adjust: Left;
		END;
	IN Links_view
		Visibility: 0;
	END;

  NOSCRIPT:
	BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Width: Enclosing . Width;
	VertPos: Top = Previous not MAP . Bottom;
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Width: Enclosing . Width - STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Links_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

  Invalid_element:
	BEGIN
	Visibility: 0;
	Underline: CrossedOut;
#ifndef BLACK_WHITE
	Foreground: INVALID_Color;
#endif
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Size: TAG_FONTSIZE;
		Style: INVALID_Style; Weight: INVALID_Weight;
		Font: INVALID_Font;
		END;
	END;

  Unknown_namespace:
	BEGIN
	Visibility: 0;
#ifdef BLACK_WHITE
	Underline: Underlined;
#else
	Underline: NoUnderline;
	Foreground: INVALID_Color;
#endif
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Size: TAG_FONTSIZE;
		Style: INVALID_Style; Weight: INVALID_Weight;
		Font: INVALID_Font;
		END;
	END;

  XHTML_Unknown_namespace:
        BEGIN
        Visibility: 0;
        if not AnyAttributes
           CreateAfter(UNKNOWN_E);
        IN Structure_view BEGIN
		Visibility: Enclosing =;
                Size: TAG_FONTSIZE;
                Style: INVALID_Style; Weight: INVALID_Weight;
#ifdef BLACK_WHITE
                Underline: CrossedOut;
#else
                Foreground: INVALID_Color;
#endif
                Font: INVALID_Font;
                END;
        END;

  Comment\240:
	BEGIN
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Font: COMMENT_Font;
		Style: COMMENT_Style; Weight: COMMENT_Weight;
		Width: Enclosing . Width;
		VertPos: Top = Previous . Bottom;
		END;
	END;

  Comment_line:
	BEGIN
	if First CreateFirst(COMMENT_S);
	if Last CreateLast(COMMENT_E);
	IN Structure_view BEGIN
		Width: Enclosed . Width;
		VertPos: Top = Previous . Bottom + 0.2;
		END;
	END;

  XMLPI:
	BEGIN
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Font: COMMENT_Font;
		Style: COMMENT_Style; Weight: COMMENT_Weight;
		Width: Enclosing . Width;
		END;
	END;

  PI_line:
	BEGIN
	if First CreateFirst(PI_S);
	if Last CreateLast(PI_E);
	IN Structure_view BEGIN
		Width: Enclosed . Width;
		VertPos: Top = Previous . Bottom + 0.2;
		END;
	END;

  DOCTYPE:
	BEGIN
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Width: Enclosing . Width;
                Foreground: TAG_Color;
		END;
	END;

  DOCTYPE_line:
	BEGIN
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Width: Enclosed . Width;
		VertPos: Top = Previous . Bottom;
		END;
	END;

  CDATA:
	BEGIN
	Visibility: Enclosing =;
        LineBreak: no;
	MarginBottom: 0.4;
	IN Structure_view BEGIN
		Width: Enclosing . Width;
	        MarginBottom: 0;
		END;
	END;

  CDATA_line:
	BEGIN
	Visibility: Enclosing =;
	HorizPos: Left = Enclosing . Left;
	IF First CreateFirst(CDATA_S);
	IF Last CreateLast(CDATA_E);
	IN Structure_view BEGIN
		Width: Enclosed . Width;
		END;
	END;

  FRAMESET: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
#ifdef PAGE
	Width: Enclosing . Width;
#else
	if within FRAMESET
		Width: Enclosing . Width;
	if not within FRAMESET
		BEGIN
		HorizPos: Left = Enclosing . Left + 0.5 cm;
		Width: Enclosing . Width - 1 cm;
		END;
#endif
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;		
	END;

  Frames: BEGIN
        Width: Enclosing . Width;
        END;

  NOFRAMES: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	VertPos: Top = Previous AnyElem . Bottom;
	Width: Enclosing . Width;
#ifdef PAGE
	Hyphenate: Yes;
#else
	CreateFirst(NOFRAMES_Sep1);
	CreateLast(NOFRAMES_Sep2);
	Height: Enclosing . Height min;
	Hyphenate: No;
#endif
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
#ifndef PAGE
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
#endif
		END;
	IN Links_view BEGIN
		Visibility: Enclosing =;
		Height: Enclosed . Height;
		END;
	IN Table_of_contents BEGIN
		Visibility: 0;
		Height: Enclosed . Height;
		END;
	END;

  FRAME: BEGIN
	CreateBefore(ElementName);
#ifdef PAGE
	Visibility: 0;
#else
	CreateFirst (FRAME_Label);
#endif
	Line;
	MarginLeft: 3;
	Indent: -3;
	Width: Enclosing . Width;
	IN Structure_view BEGIN
		Visibility: 1;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		NoLine;
		END;		
	IN Table_of_contents
		Visibility: 0;
	END;

  IFRAME: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	HorizPos: Left = Previous . Left;
	VertPos: Top = Previous . Bottom;
	HorizRef: * . Bottom;
	Width: Enclosing . Width;
	Line;
	LineBreak: No;
	MarginLeft: 3 px;
	MarginRight: 3 px;
	PaddingTop: 0.2;
	PaddingLeft: 0.3;
	PaddingBottom: 0.2;
	PaddingRight: 0.3;
	BorderTopWidth: 1 px;
	BorderLeftWidth: 1 px;
	BorderBottomWidth: 1 px;
	BorderRightWidth: 1 px;
	BorderTopColor: Black;
	BorderLeftColor: Black;
	BorderBottomColor: Grey;
	BorderRightColor: Grey;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderBottomStyle: Solid;
	BorderRightStyle: Solid;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
	        HorizRef: Enclosed . HRef;
		NoLine;
		MarginLeft: 0;
		MarginRight: 0;
		PaddingTop: 0;
		PaddingLeft: 0;
		PaddingBottom: 0;
		PaddingRight: 0;
		BorderTopWidth: 0;
		BorderLeftWidth: 0;
		BorderBottomWidth: 0;
		BorderRightWidth: 0;
		BorderTopStyle: none;
	        BorderLeftStyle: none;
	        BorderBottomStyle: none;
	        BorderRightStyle: none;
		END;		
	IN Alternate_view BEGIN
		MarginLeft: 0;
		MarginRight: 0;
		PaddingTop: 0;
		PaddingLeft: 0;
		PaddingBottom: 0;
		PaddingRight: 0;
		BorderTopWidth: 0;
		BorderLeftWidth: 0;
		BorderBottomWidth: 0;
		BorderRightWidth: 0;
		BorderTopStyle: none;
	        BorderLeftStyle: none;
	        BorderBottomStyle: none;
	        BorderRightStyle: none;
		LineBreak: Yes;
		END;
	END;

 Iframe_Content: BEGIN
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	VertPos: Top = Enclosing . Top;
	HorizPos: Left = Enclosing . Left;
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Width: Enclosing . Width;
		Height: Enclosed . Height;
		VertPos: Top = Previous . Bottom;
		END;
	IN Alternate_view BEGIN
		Visibility: Enclosing =;
		Width: Enclosing . Width;
		Height: Enclosed . Height;
		VertPos: Top = Enclosing . Top;
		END;
	END;

 Iframe_Src_Content: BEGIN
	LineBreak: No;
	PageBreak: No;
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	VertPos: Top = Enclosing . Top;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	IN Links_view
		Visibility: 0;
	IN Table_of_contents
		Visibility: 0;
	END;

  simple_ruby: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: No;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Weight: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Alternate_view BEGIN
		LineBreak: Yes;
		END;
	END;

  complex_ruby: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	LineBreak: No;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Structure_view BEGIN
		Weight: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Alternate_view BEGIN
		LineBreak: Yes;
		END;
	END;

  rb:   BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	if immediately within rbc
	   BEGIN
	   HorizPos: Left = Previous . Right;
	   VertPos: HRef = Previous . HRef;
	   END;
	if not immediately within rbc
	   BEGIN
	   HorizPos: Nil;
	   VertPos: Nil;
	   END;
	IN Structure_view BEGIN
		Weight: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;

  rt:   BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	if immediately within simple_ruby and last
	   BEGIN
           CreateBefore (OpeningParen);
	   CreateAfter (ClosingParen);
	   END;
	if immediately within rtc1
	   BEGIN
	   Size: Enclosing =;
	   HorizPos: Left = Previous . Right;
	   VertPos: HRef = Previous . HRef;
	   END;
	if immediately within rtc2
	   BEGIN
	   Size: Enclosing =;
	   HorizPos: Left = Previous . Right;
	   VertPos: HRef = Previous . HRef;
	   END;
	otherwise
	   BEGIN
	   Size: Enclosing * 70 %;
	   HorizPos: VMiddle = rb . VMiddle;
	   VertPos: Bottom = rb . Top + 0.2;
	   END;
	IN Structure_view BEGIN
		Weight: Enclosing =;
		Size: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Alternate_view BEGIN
		Size: Enclosing =;
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		END;
	END;

  rp:   BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	Visibility: 0;
	IN Structure_view BEGIN
		Weight: Enclosing =;
		Visibility: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Alternate_view BEGIN
		Visibility: Enclosing =;
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		END;
	END;

  rbc:  BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	HorizPos: Nil;
	VertPos: Nil;
	IN Structure_view BEGIN
		Weight: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	END;

  rtc1: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
        CreateFirst (OpeningParen);
	CreateLast (ClosingParen);
	Size: Enclosing * 70 %;
	HorizPos: VMiddle = rbc . VMiddle;
	VertPos: Bottom = rbc . Top + 0.2;
	IN Structure_view BEGIN
		Weight: Enclosing =;
		Size: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Alternate_view BEGIN
		Size: Enclosing =;
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		END;
	END;

  rtc2: BEGIN
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
        CreateFirst (OpeningParen);
	CreateLast (ClosingParen);
	Size: Enclosing * 70 %;
	HorizPos: VMiddle = rbc . VMiddle;
	VertPos: Top = rbc . Bottom - 0.2;
	IN Structure_view BEGIN
		Weight: Enclosing =;
		Size: Enclosing =;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		VertPos: Top = Previous . Bottom;
		END;
	IN Alternate_view BEGIN
		Size: Enclosing =;
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		END;
	END;

ATTRIBUTES
 NoImages(PICTURE_UNIT*):
	BEGIN
	Visibility: 1;
	if ALT and not within Object and not within Embed_
            CreateBefore(SHOW_ALT);
	if Not ALT and not within Object and not within Embed_
	    CreateBefore(SHOW_IMG);
	IN Alternate_view
		Visibility: Enclosing =;
	IN Links_view
		Visibility: Enclosing =;
	END;
 NoImages(map):
	BEGIN
	Visibility: 0;
	IN Structure_view
		Visibility: Enclosing =;
	IN Alternate_view
		Visibility: Enclosing =;
	IN Table_of_contents
		Visibility: 0;
	IN Links_view
		Visibility: Enclosing =;
	END;
 NoImages(MAP):
	BEGIN
	Visibility: 0;
	IN Structure_view
		Visibility: Enclosing =;
	IN Alternate_view
		Visibility: Enclosing =;
	IN Table_of_contents
		Visibility: 0;
	IN Links_view
		Visibility: Enclosing =;
	END;

 NoObjects(PICTURE_UNIT*):
	BEGIN
	if within Object
	    Visibility: 0;
	if within Embed_
	    Visibility: 0;
	END;
 NoObjects(Object_Content):
	BEGIN
 	  if not within HEAD
	    Visibility: Enclosing =;
	END;

 Language:
	BEGIN
        IF HTML and RealLang
	    BEGIN
            CreateBefore(AttrName);
	    CreateBefore(AttrValue);
	    END;
        IF not HTML
	    BEGIN
            CreateBefore(AttrName);
	    CreateBefore(AttrValue);
	    END;
	END;

 HREF_:
	BEGIN
        CreateBefore(AttrName);
        CreateBefore(AttrValue);
	if Anchor
	   BEGIN
	   CreateLast(ATTR_HREF_LINKS_VIEW);
	   CreateLast(VALUE_HREF_LINKS_VIEW);
	   END;
        if AREA
	   BEGIN
	   CreateLast(ATTR_HREF_LINKS_VIEW);
	   CreateLast(VALUE_HREF_LINKS_VIEW);
	   END;
#ifdef LINK_NUMBER
        if Anchor and not InternalLink
           BEGIN
           CreateFirst(AnchorNumInLinkView);
           CreateAfter(AnchorNumInFormattedView);
           END;
#endif
#ifdef PAGE
	IN Links_view
		if Anchor
		   BEGIN
		   Visibility: 7;
		   Underline: Enclosing =;
		   END;
#else
#ifdef BLACK_WHITE
	if Anchor
	   Underline: Underlined;
#endif
	IN Links_view
		Foreground: ATTRVALUE_Color;
#endif
	IN Structure_view BEGIN
		Foreground: Enclosing =;
		Underline: Enclosing =;
		END;	
	IN Alternate_view BEGIN
		Foreground: Enclosing =;
		Underline: Underlined;
		END;
	END;

 charset: BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 hreflang: BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 media: BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 target_: BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 cite:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	CreateLast(ATTR_CITE_LINKS_VIEW);
	CreateLast(VALUE_CITE_LINKS_VIEW);
#ifdef LINK_NUMBER
	if not InternalLink
	   CreateFirst(AnchorNumInLinkView);
        if not InternalLink and not Block_Quote
           CreateAfter(AnchorNumInFormattedView);
	if not InternalLink and Block_Quote
           CreateBefore(BlockNumInFormattedView);
#endif
#ifdef PAGE
	CreateAfter(LinkPageNumber);
#endif
	IN Links_view BEGIN
		Visibility: 7;
		VertPos : Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left;
		Line;
		MarginLeft: 2;
		Indent: -2;
#ifdef PAGE
		Adjust: LeftWithDots;
		Width: Enclosing . Width - 28 pt;
#else
		Width: Enclosing . Width;
		Foreground: ATTRVALUE_Color;
#endif
		END;
	END;

 datetime:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 ShowAreas (AREA):
	LineWeight: 2 pt;

 Namespaces:
	BEGIN
	END;

 InternalLink:
        BEGIN
#ifdef LINK_NUMBER
        CreateAfter(SeeTargetPage);
#endif
#ifdef PAGE
        IN Links_view
           Visibility: 0;
#endif
        END;
 
#ifndef PAGE
#ifndef BLACK_WHITE
 PseudoClass = 'link':
	BEGIN
	Foreground: LINK_Color;
	IN Structure_view
		Foreground: Enclosing =;
	IN Alternate_view
		Foreground: Enclosing =;
	IN Links_view
		Foreground: Enclosing =;
	END;
 PseudoClass = 'visited':
	BEGIN
	Foreground: DarkBlue3;
	IN Structure_view
		Foreground: Enclosing =;
	IN Alternate_view
		Foreground: Enclosing =;
	END;
 PseudoClass = 'active':
	BEGIN
        Foreground: Red;
	IN Structure_view
		Foreground: Enclosing =;
	IN Alternate_view
		Foreground: Enclosing =;
	END;
#endif
#endif

 content_type: BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 script_src: BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 script_language: BEGIN
        CreateBefore(AttrName);
        CreateBefore(AttrValue);
     	END;

 defer:
	CreateBefore(AttrNameOnly);

 event: BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 for_:	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 http_equiv: BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 meta_name: BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 meta_content: BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 scheme: BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 USEMAP: BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 ALT:   BEGIN
	CreateBefore(AttrName);
	CreateBefore(VALUE_ALT);
	END;

 longdesc: BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 Title:	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	CreateLast(ATTR_TITLE_ANCH);
	CreateLast(VALUE_TITLE_ANCH);
	if FRAME
		BEGIN
		CreateLast (ATTR_TITLE_FRAME);
		CreateLast (VALUE_TITLE_FRAME);
		END;
	END;

 accesskey: BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 tabindex: BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 Associated_control: BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 Button_type:
	CreateBefore (AttrNameAndValue);

 NAME:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	if MAP CreateLast(ATTR_NAME_ANCH);
	if MAP CreateLast(VALUE_NAME_ANCH);
	if map CreateLast(ATTR_NAME_ANCH);
	if map CreateLast(VALUE_NAME_ANCH);
	if Anchor CreateLast(ATTR_NAME_ANCH);
	if Anchor CreateLast(VALUE_NAME_ANCH);
#ifdef LINK_NUMBER
        if Anchor CreateAfter(TargetPageNumber);
#endif
#ifndef PAGE
	if Anchor and not ID
		CreateFirst(Target_gif);
	if map and not ID
	 	CreateFirst(Target_gif);
	if MAP and not ID
		CreateFirst(Target_gif);
#ifdef BLACK_WHITE
	if Anchor Underline: Underlined;
	if MAP Underline: Underlined;
	if map Underline: Underlined;
#else
	if MAP Foreground: LINK_Color;
#endif
#endif
	IN Structure_view BEGIN
		Foreground: Enclosing =;
		Underline: Enclosing =;
		END;
	IN Alternate_view BEGIN
		Foreground: Enclosing =;
		Underline: Enclosing =;
		END;
	END;

 Script_URL:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;
 METHOD:
	CreateBefore(AttrNameAndValue);
 ENCTYPE:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;
 accept_charset:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 COMPACT:
	BEGIN
	CreateBefore(AttrNameOnly);
	END;

 REL:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	CreateLast(ATTR_REL_ANCH);
	CreateLast(VALUE_REL_ANCH);
	END;

 REV:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	CreateLast(ATTR_REV_ANCH);
	CreateLast(VALUE_REV_ANCH);
	END;

 SRC:   BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 Width__:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 IntWidthPxl:
	BEGIN
	if AREA
	   Width: IntWidthPxl px UserSpecified;
	if not AREA
	   Width: IntWidthPxl px;
	IN Structure_view BEGIN
	   if not PICTURE_UNIT and not AREA
	   	Width: Enclosing . Width;
	   if PICTURE_UNIT
		Width: 0;
	   if AREA
		Width: 0;
	   END;
	IN Alternate_view BEGIN
	   Width: Enclosing . Width;
	   END;
	END;

 IntWidthPercent:
	BEGIN
	Width: Enclosing . Width * IntWidthPercent %;
	IN Structure_view BEGIN
	   if not PICTURE_UNIT
	   	Width: Enclosing . Width;
	   if PICTURE_UNIT
		Width: 0;
	   END;
	IN Alternate_view BEGIN
	  if Data_cell  BEGIN
		VertPos : Top = Previous . Bottom;
		HorizPos: Left = Previous Table_cell . Left + STRUCT_INDENT;
		Width: Right = Enclosing . Right;
		END;
	  if Heading_cell  BEGIN
		VertPos : Top = Previous . Bottom;
		HorizPos: Left = Previous Table_cell . Left + STRUCT_INDENT;
		Width: Right = Enclosing . Right;
		END;
	  if not Data_cell and not Heading_cell
	   Width: Enclosing . Width;
	   END;
	END;

 Height_:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 IntHeightPxl:
	BEGIN
	if Data_cell
	   Height: IntHeightPxl px min;
        if Heading_cell
	   Height: IntHeightPxl px min;
	if AREA
	   Height: IntHeightPxl px UserSpecified;
	if not AREA and not Data_cell and not Heading_cell
	   Height: IntHeightPxl px;
	IN Structure_view BEGIN
	   if PICTURE_UNIT
	        Height: 0;
	   if not PICTURE_UNIT
		Height: Enclosed . Height;
	   END;
	IN Alternate_view BEGIN
	   if PICTURE_UNIT
	        Height: 0;
	   if not PICTURE_UNIT
		Height: Enclosed . Height;
	   END;
	END;

 IntHeightPercent:
	BEGIN
	Height: Enclosing . Height * IntHeightPercent %;
	IN Structure_view BEGIN
	   if not PICTURE_UNIT
	   	Height: Enclosed . Height;
	   if PICTURE_UNIT
		Height: 0;
	   END;
	IN Alternate_view BEGIN
	  if Data_cell  BEGIN
		VertPos : Top = Previous . Bottom;
		HorizPos: Left = Previous Table_cell . Left + STRUCT_INDENT;
		Width: Right = Enclosing . Right;
		END;
	  if Heading_cell  BEGIN
		VertPos : Top = Previous . Bottom;
		HorizPos: Left = Previous Table_cell . Left + STRUCT_INDENT;
		Width: Right = Enclosing . Right;
		END;
	  if not Data_cell and not Heading_cell
	   Height: Enclosed . Height;
	   END;
	END;


 hspace:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	MarginLeft: hspace pt;
	MarginRight: hspace pt;
	IN Structure_view BEGIN
		MarginLeft: 0;
		MarginRight: 0;
		END;
	END;

 vspace:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	MarginTop: vspace pt;
	MarginBottom: vspace pt;
	In Structure_view BEGIN
		MarginTop: 0;
		MarginBottom: 0;
		VertPos: Top = Previous . Bottom;
		END;
	END;

 declare:
	CreateBefore (AttrNameOnly);

 codebase:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 code:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 object:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 applet_name:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 Param_name:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 Param_value:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 valuetype:
	CreateBefore(AttrNameAndValue);

 Param_type:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 classid:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 data:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 Object_type:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 Embed_type:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 pluginspage:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 pluginurl:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 Link_type:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 codetype:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 archive:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 standby:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 Img_border:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	BorderTopWidth: Img_border px;
	BorderLeftWidth: Img_border px;
	BorderBottomWidth: Img_border px;
	BorderRightWidth: Img_border px;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderBottomStyle: Solid;
	BorderRightStyle: Solid;
	IN Structure_view BEGIN
		BorderTopWidth: 0;
		BorderLeftWidth: 0;
		BorderBottomWidth: 0;
		BorderRightWidth: 0;
		END;
	IN Alternate_view BEGIN
		BorderTopWidth: 0;
		BorderLeftWidth: 0;
		BorderBottomWidth: 0;
		BorderRightWidth: 0;
		END;
	END;

 NoShade:
	CreateBefore(AttrNameOnly);

 Size_ < 2:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	Height: 2 pt;
#ifdef PAGE
	LineWeight: Size_ pt;
#endif
	IN Alternate_view
		BEGIN
		Height: 1;
		LineWeight: 1 pt;
		END;
	IN Structure_view
		Height: 0;
	END;

 Size_ > 1:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	Height: Size_ pt;
#ifdef PAGE
	LineWeight: Size_ pt;
#endif
	IN Alternate_view
		BEGIN
		Height: 1;
		LineWeight: 1 pt;
		END;
	IN Structure_view
		Height: 0;
	END;

 NumberStyle:
	CreateBefore(AttrNameAndValue);

 BulletStyle:
	CreateBefore(AttrNameAndValue);

 ItemStyle:
	CreateBefore(AttrNameAndValue);

 Start:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 Clear_:
	CreateBefore(AttrNameAndValue);

 Alignment = Top_:
	BEGIN
	CreateBefore(AttrNameAndValue);
	HorizRef: * . Top + 0.7;
	IN Alternate_view
		HorizRef: Enclosed . HRef;
	END;
 Alignment = Middle_:
	BEGIN
	CreateBefore(AttrNameAndValue);
	HorizRef: * . HMiddle + 0.2;
	IN Alternate_view
		HorizRef: Enclosed . HRef;
	END;
 Alignment = Bottom_:
	BEGIN
	CreateBefore(AttrNameAndValue);
	HorizRef: * . Bottom;
	IN Alternate_view
		HorizRef: Enclosed . HRef;
	END;
 Alignment = Left_:
	BEGIN
	CreateBefore(AttrNameAndValue);
	HorizPos: Left = Enclosing . Left;
	Adjust: Left;
	Float: Left;
	END;
 Alignment = Right_:
	BEGIN
	CreateBefore(AttrNameAndValue);
	HorizPos: Right = Enclosing . Right;
	Adjust: Left;
	Float: Right;
	IN Alternate_view BEGIN
		HorizPos: Left = Enclosing . Left;
		Adjust: Left;
		END;
	END;

 Align = left_:
	BEGIN
	CreateBefore(AttrNameAndValue);
	HorizPos: Left = Enclosing . Left;
	In Structure_view
	   HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
	   HorizPos: Left = Enclosing . Left;
	END;
 Align = center_:
	BEGIN
	CreateBefore(AttrNameAndValue);
	HorizPos: VMiddle = Enclosing . VMiddle;
	In Structure_view
	   HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
	   HorizPos: Left = Enclosing . Left;
	END;
 Align = right_:
	BEGIN
	CreateBefore(AttrNameAndValue);
	HorizPos: Right = Enclosing . Right;
	In Structure_view
	   HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
	   HorizPos: Left = Enclosing . Left;
	END;

 TextAlign = left_:
	BEGIN
	CreateBefore(AttrNameAndValue);
	Adjust: Left;
	END;
 TextAlign = center_:
	BEGIN
	CreateBefore(AttrNameAndValue);
	if Table
	  HorizPos: VMiddle = Enclosing . VMiddle;
	if NOT Table
	  Adjust: VMiddle;	
	In Structure_view BEGIN
	   Adjust: Left;
	   HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	   END;
	IN Alternate_view
	   HorizPos: Left = Enclosing . Left;
	END;
 TextAlign = right_:
	BEGIN
	CreateBefore(AttrNameAndValue);
	if Table
	   HorizPos: Right = Enclosing . Right;
	if NOT Table
	   Adjust: Right;
	In Structure_view BEGIN
	   HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	   Adjust: Left;
	   END;
	IN Alternate_view
	   HorizPos: Left = Enclosing . Left;
	END;
 TextAlign = justify_:
	BEGIN
	CreateBefore(AttrNameAndValue);
	Adjust: Justify;
	In Structure_view
	   Adjust: Enclosing =;
	END;

 ISMAP:
	CreateBefore(AttrNameOnly);

 BaseFontSize:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;
 BaseFontColor:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;
 BaseFontFace:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 Font_size:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;
 face:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;
 IntSizeIncr:
	BEGIN
	Size: Enclosing + IntSizeIncr;
	In Structure_view
	    Size: Enclosing =;
	In Links_view
	    Size: Enclosing =;
	In Alternate_view
	    Size: Enclosing =;
	END;
 IntSizeDecr:
	BEGIN
	Size: Enclosing - IntSizeDecr;
	In Structure_view
	    Size: Enclosing =;
	In Links_view
	    Size: Enclosing =;
	In Alternate_view
	    Size: Enclosing =;
	END;
 IntSizeRel:
	BEGIN
	Size: IntSizeRel;
	In Structure_view
	    Size: Enclosing =;
	In Links_view
	    Size: Enclosing =;
	In Alternate_view
	    Size: Enclosing =;
	END;

 color:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 background_:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 BackgroundColor:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 TextColor:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 LinkColor:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 VisitedLinkColor:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 ActiveLinkColor:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 Value_:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	IN Structure_view BEGIN
	    if not Option BEGIN
	       HorizPos: Left = Previous . Right;
	       VertPos: HRef = Previous . HRef;
	       END;
	    END;
	END;
 Multiple:
	CreateBefore(AttrNameOnly);
 Multiple (Option_Menu):
	IN Alternate_view
		LineBreak: No;
 Multiple (Option):
	BEGIN
	IF not Selected
	        CreateFirst (UnselectedInAltView);
	IN Alternate_view BEGIN
		Visibility: Enclosing =;
		END;
	END;

 MenuSize:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 ShowMe:
	BEGIN
	if within OptGroup
		Visibility: GrandFather =;
	if not within OptGroup
		Visibility: Enclosing =;
	END;

 Selected:
	BEGIN
	CreateBefore(AttrNameOnly);
	IF inherited Multiple
	        CreateFirst (SelectedInAltView);
	if within OptGroup
		Visibility:GrandFather =;
	if not within OptGroup
		Visibility: Enclosing =;
	IN Structure_view
		Visibility: Enclosing =;
	IN Links_view
		Visibility: Enclosing =;
	IN Alternate_view
		Visibility: Enclosing =;
	IN Table_of_contents
		Visibility: Enclosing =;
	END;

 Checked = Yes_:
	BEGIN
	if Checkbox_Input BEGIN
	   CreateFirst(CHECKBOXCHECKED_ALT);
	   CreateFirst(ToggleS_gif);
	   end;
	if Radio_Input BEGIN
	   CreateFirst(RADIOCHECKED_ALT);
	   CreateFirst(RadioS_gif);
	   END;
	CreateBefore(AttrNameOnly);
	END;
 Checked = No_:
	BEGIN
	if Checkbox_Input BEGIN
	   CreateFirst(CHECKBOX_ALT);
	   CreateFirst(Toggle_gif);
	   END;
	if Radio_Input BEGIN
	   CreateFirst(RADIO_ALT);
	   CreateFirst(Radio_gif);
	   END;
	END;

 disabled:
	CreateBefore(AttrNameOnly);

 readonly:
	CreateBefore (AttrNameOnly);

 label:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 accept:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 LAlign = Top_:
	BEGIN
	CreateBefore(AttrNameAndValue);
	VertPos: Top = Enclosing . Top;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	END;
 LAlign = Bottom_:
	BEGIN
	CreateBefore(AttrNameAndValue);
	END;
 LAlign = Left_:
	BEGIN
	CreateBefore(AttrNameAndValue);
	Adjust: Left;
	IN Structure_view
		Adjust: Enclosing =;
	END;
 LAlign = Right_:
	BEGIN
	CreateBefore(AttrNameAndValue);
	Adjust: Right;
	IN Structure_view
		Adjust: Enclosing =;
	END;

 Area_Size:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 IntAreaSize:
	BEGIN
	Width: IntAreaSize;
	IN Structure_view BEGIN
	   Width: 0;
	   Height: 0;
	   END;
	IN Alternate_view BEGIN
	   Width: Enclosing . Width;
	   END;
	END;

 MaxLength:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;
 Rows:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	Height: Rows Min;
	IN Structure_view
		BEGIN
		VertPos: HRef = Previous . HRef;
		HorizPos: Left = Previous . Right;
		Height: Enclosed . Height;
		END;
	END;
 Columns:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	if Text_Area
	   Width: Columns ex;
	IN Structure_view
	    BEGIN
	    if Text_Area
		BEGIN
		VertPos: HRef = Previous . HRef;
		HorizPos: Left = Previous . Right;
		Width: Enclosed . Width;
		END;
	    END;
	END;

{ ---- Table ---- }

 summary:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 frame:
	CreateBefore(AttrNameAndValue);

 rules_:
	CreateBefore(AttrNameAndValue);

 cellspacing (Table_head) > 0:
	BEGIN
	PaddingLeft: cellspacing px;	
	PaddingRight: cellspacing px;
	BorderRightWidth: Border px;
	END;
 cellspacing (Column_head):
	BEGIN
	HorizPos: Left = Previous . Right + cellspacing px;
	IN Structure_view
	   VertPos: Top = Previous . Bottom;
	END;
 cellspacing (Column_head) > 0:
	BorderRightWidth: Border px;
 cellspacing (thead) > 0:
	BEGIN
	VertPos: Top = Previous . Bottom + cellspacing px;
	BorderTopWidth: Border px;
	BorderRightWidth: Border px;
	PaddingTop: cellspacing px;
	PaddingRight: cellspacing px;
	PaddingBottom: cellspacing px;
	PaddingLeft: cellspacing px;
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		END;
	IN  Alternate_view BEGIN
		VertPos: Top = Previous . Bottom;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		END;
	END;
 cellspacing (Table_body):
	BEGIN
	VertPos: Top = Previous . Bottom + cellspacing px;
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		END;
	IN  Alternate_view BEGIN
		VertPos: Top = Previous . Bottom;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		END;
	END;
 cellspacing (tbody) > 0:
	BEGIN
	VertPos: Top = Previous tbody . Bottom + cellspacing px;
	BorderTopWidth: Border px;
	BorderRightWidth: Border px;
	PaddingTop: cellspacing px;
	PaddingRight: cellspacing px;
	PaddingBottom: cellspacing px;
	PaddingLeft: cellspacing px;
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		END;
	IN  Alternate_view BEGIN
		VertPos: Top = Previous . Bottom;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		END;
	END;
 cellspacing (tfoot) > 0:
	BEGIN
	VertPos: Top = Previous . Bottom + cellspacing px;
	BorderTopWidth: Border px;
	BorderRightWidth: Border px;
	PaddingTop: cellspacing px;
	PaddingRight: cellspacing px;
	PaddingBottom: cellspacing px;
	PaddingLeft: cellspacing px;
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		END;
	IN  Alternate_view BEGIN
		VertPos: Top = Previous . Bottom;
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		END;
	END;
 cellspacing (Table_row):
	BEGIN
	VertPos: Top = Previous Table_row . Bottom + cellspacing px;
	IN Structure_view
	   VertPos: Top = Previous . Bottom;
	IN Alternate_view
	   VertPos: Top = Previous . Bottom;
	END;
 cellspacing (Heading_cell) > 0:
	BEGIN
	BorderBottomWidth: Border px;
	BorderLeftWidth: Border px;
	IN Structure_view BEGIN
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		END;
	IN Alternate_view BEGIN
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		END;
	END;
 cellspacing (Data_cell) > 0:
	BEGIN
	BorderBottomWidth: Border px;
	BorderLeftWidth: Border px;
	IN Structure_view BEGIN
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		END;
	IN Alternate_view BEGIN
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		END;
	END;
 cellspacing:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 cellpadding (Data_cell):
	BEGIN
	PaddingTop: cellpadding px;
	PaddingRight: cellpadding px;
	PaddingBottom: cellpadding px;
	PaddingLeft: cellpadding px;
	IN Structure_view BEGIN
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		END;
	IN Alternate_view BEGIN
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		END;
	END;

 cellpadding (Heading_cell):
	BEGIN
	PaddingTop: cellpadding px;
	PaddingRight: cellpadding px;
	PaddingBottom: cellpadding px;
	PaddingLeft: cellpadding px;	
	IN Structure_view BEGIN
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		END;
	IN Alternate_view BEGIN
		PaddingTop: 0;
		PaddingRight: 0;
		PaddingBottom: 0;
		PaddingLeft: 0;
		END;
	END;
 cellpadding:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 Border (Table_head)> 0:
	BEGIN
	MarginLeft: Border px;
	IN Structure_view 
		MarginLeft: 0;
	END;
 Border (Column_head)> 0:
	BEGIN
	MarginRight: Border px;
	IN Structure_view 
		MarginRight: 0;
	END;
 Border (thead)> 0:
	BEGIN
	BorderBottomWidth: Border px;
	BorderLeftWidth: Border px;
	IN Structure_view BEGIN
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		END;
	IN Alternate_view BEGIN
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		END;
	END;
 Border (tbody) > 0:
	BEGIN
	BorderBottomWidth: Border px;
	BorderLeftWidth: Border px;
	IN Structure_view BEGIN
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		END;
	IN Alternate_view BEGIN
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		END;
	END;
 Border (tfoot) > 0:
	BEGIN
	BorderBottomWidth: Border px;
	BorderLeftWidth: Border px;
	IN Structure_view BEGIN
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		END;
	IN Alternate_view BEGIN
		BorderBottomWidth: 0;
		BorderLeftWidth: 0;
		END;
	END;
 Border (Heading_cell) > 0:
	BEGIN
	BorderTopWidth: Border px;
	BorderRightWidth: Border px;
	IN Structure_view BEGIN
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		END;
	IN Alternate_view BEGIN
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		END;
	END;
 Border (Data_cell) > 0:
	BEGIN
	BorderTopWidth: Border px;
	BorderRightWidth: Border px;
	IN Structure_view BEGIN
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		END;
	IN Alternate_view BEGIN
		BorderTopWidth: 0;
		BorderRightWidth: 0;
		END;
	END;
 Border:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 datapagesize:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 Ref_column:
	BEGIN
        Width: Referred . Width;
	HorizPos: Left = Referred . Left;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view BEGIN
		Width: Right = Enclosing . Right;
		HorizPos: Left = Previous . Left + STRUCT_INDENT;
		END;
	END;

 ColExt:
	BEGIN
	Width: Right = Referred . Right;
	IN Structure_view
		Width: Enclosing . Width;
	IN Alternate_view BEGIN
		Width: Right = Enclosing . Right;
		HorizPos: Left = Previous . Left + STRUCT_INDENT;
		END;
	END;

 RowExt:
	BEGIN
	CreateBefore(CellExtFrame);
	Depth: Enclosing - 1;
	VertOverflow: Yes;
	IN Structure_view BEGIN
		Height: Enclosed . Height;
		VertOverflow: No;
		Depth: 0;
		END;	
	IN Alternate_view BEGIN
		Height: Enclosed . Height;
		VertOverflow: No;
		Depth: 0;
		END;	
	END;

 abbr:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 axis:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 headers:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 scope:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 span_:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 rowspan_:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 colspan_:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 Position = Position_top :
	BEGIN
	CreateBefore(AttrNameAndValue);
	VertPos: Bottom = Table_head . Top - cellspacing px;
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		END;
	END;

 Position = Position_bottom :
	BEGIN
	CreateBefore(AttrNameAndValue);
	VertPos: Top = Table_foot . Bottom + cellspacing px;
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		END;
	END;

 Position = Position_left :
	BEGIN
	CreateBefore(AttrNameAndValue);
	VertPos: Bottom = Table_head . Top - cellspacing px;
	Adjust: Left;
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		END;
	END;

 Position = Position_right :
	BEGIN
	CreateBefore(AttrNameAndValue);
	VertPos: Bottom = Table_head . Top - cellspacing px;
	Adjust: Right;
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		Adjust: Left;
		END;
	END;

 Cell_align = Cell_left :
	BEGIN
	CreateBefore(AttrNameAndValue);
	Adjust: Left;
	IN Structure_view BEGIN
		Adjust: Enclosing =;
		END;
	END;
	
 Cell_align = Cell_center :
	BEGIN
	CreateBefore(AttrNameAndValue);
	Adjust: VMiddle;
	IN Structure_view BEGIN
		Adjust: Enclosing =;
		END;
	IN Alternate_view BEGIN
	   	Adjust: Left;
		END;
	END;

 Cell_align = Cell_right :
	BEGIN
	CreateBefore(AttrNameAndValue);
	Adjust: Right;
	IN Structure_view BEGIN
		Adjust: Enclosing =;
		END;
	IN Alternate_view BEGIN
	   	Adjust: Left;
		END;
	END;

 Cell_align = Cell_justify :
	BEGIN
	CreateBefore(AttrNameAndValue);
	Adjust: Justify;
	IN Structure_view
		Adjust: Enclosing =;
	IN Alternate_view
	   	Adjust: Left;
	END;

 Cell_align = Cell_char :
	BEGIN
	CreateBefore(AttrNameAndValue);
	Adjust: Right;
	IN Structure_view BEGIN
		Adjust: Enclosing =;
		END;
	IN Alternate_view BEGIN
	   	Adjust: Left;
		END;
	END;

 char:
  	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 charoff:
  	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 Row_valign (Data_cell) = Row_top :
	BEGIN
	VertPos : Top = Previous AnyBox . Top;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;
 Row_valign (Heading_cell) = Row_top :
	BEGIN
	VertPos : Top = Previous AnyBox . Top;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;
 Row_valign = Row_top :
	CreateBefore(AttrNameAndValue);

 Row_valign (Data_cell) = Row_middle :
	BEGIN
	VertPos : HMiddle = Previous AnyBox . HMiddle;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;
 Row_valign (Heading_cell) = Row_middle :
	BEGIN
	VertPos : HMiddle = Previous AnyBox . HMiddle;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;
 Row_valign = Row_middle :
	CreateBefore(AttrNameAndValue);

 Row_valign (Data_cell) = Row_bottom :
	BEGIN
	VertPos : Bottom = Previous AnyBox . Bottom;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;
 Row_valign (Heading_cell) = Row_bottom :
	BEGIN
	VertPos : Bottom = Previous AnyBox . Bottom;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;
 Row_valign = Row_bottom :
	CreateBefore(AttrNameAndValue);

 Row_valign (Data_cell) = Row_baseline :
	BEGIN
	VertPos : HRef = Previous AnyElem . HRef;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	END;
 Row_valign (Heading_cell) = Row_baseline :
	BEGIN
	VertPos : HRef = Previous AnyElem . HRef;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;
 Row_valign = Row_baseline :
	CreateBefore(AttrNameAndValue);

 Cell_valign = Cell_top :
	BEGIN
	CreateBefore(AttrNameAndValue);
	VertPos : Top = Previous AnyBox . Top;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;

 Cell_valign = Cell_middle :
	BEGIN
	CreateBefore(AttrNameAndValue);
	VertPos : HMiddle = Previous AnyBox . HMiddle;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;

 Cell_valign = Cell_bottom :
	BEGIN
	CreateBefore(AttrNameAndValue);
	VertPos : Bottom = Previous AnyBox . Bottom;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;

 Cell_valign = Cell_baseline :
	BEGIN
	CreateBefore(AttrNameAndValue);
	VertPos : HRef = Previous AnyElem . HRef;
	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;

 No_wrap = no_wrap :
	BEGIN
	CreateBefore(AttrNameOnly);
	Hyphenate: No;
	END;

 Ref_IMG:
	BEGIN
	Visibility: Enclosing =;
	VertPos: Top = Refered . Top;
	HorizPos: Left = Refered . Left;
	Width: Refered . Width;
	Height: Refered . Height;
	IN Structure_view BEGIN
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view BEGIN
		Visibility: 10;
		Width: Enclosing . Width;
		VertPos: Top = Previous . Bottom;
		Depth: 0;
		END;
	IN Links_view
		 Visibility: 0;
	END;

 AreaRef_IMG:
	BEGIN
	VertPos: Top = Refered . Top;
	HorizPos: Left = Refered . Left;
	Width: Refered . Width;
	Height: Refered . Height;
	IN Structure_view BEGIN
		Width: Enclosed . Width;
		Height: Enclosed . Height;
		VertPos: Top = Previous ElementName . Top;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	END;

 x_coord:
	BEGIN
 	HorizPos: Left = Enclosing . Left + x_coord px UserSpecified;
	IN Structure_view
	   HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	END;
 y_coord:
	BEGIN
 	VertPos: Top = Enclosing . Top + y_coord px UserSpecified;
	IN Structure_view
 	   VertPos: Top = Previous ElementName . Top;
	END;

  shape:
	CreateBefore(AttrNameAndValue);

  coords:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  nohref:
	CreateBefore(AttrNameOnly);

  Style\240:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  profile:
  	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  Prompt:
  	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  Notation:
  	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  Class:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

 ID:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
#ifndef PAGE
	if PICTURE_UNIT
		CreateBefore(Target_gif);
	if not PICTURE_UNIT
	   	CreateFirst(Target_gif);
#endif
	if Anchor BEGIN
	   CreateLast(ATTR_ID_ANCH);
	   CreateLast(VALUE_ID_ANCH);
#ifdef LINK_NUMBER
           CreateAfter(TargetPageNumber);
#endif
#ifndef PAGE
#ifdef BLACK_WHITE
	   Underline: Underlined;
#endif
#endif
	   END;
	IN Structure_view
           BEGIN
	   if Anchor BEGIN
		Foreground: Enclosing =;
		Underline: Enclosing =;
		END;
	   END;
	IN Alternate_view
	   BEGIN
	   if Anchor BEGIN
		Foreground: Enclosing =;
		Underline: Enclosing =;
		END;
	   END;
	END;

  dir = ltr_:
	BEGIN
	if not Document
	    CreateBefore(AttrNameAndValue);
	Direction: ltr;
	Adjust: Left;
	END;
  dir = rtl_:
	BEGIN
        if not Document
	    CreateBefore(AttrNameAndValue);
	Direction: rtl;
	Adjust: Right;
	IN Structure_view
	    Adjust: Left;
	END;
  dir (Embed_*) = ltr_:
	BEGIN
	if not Immediately within Object
	   HorizPos: Left = Enclosing . Left;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	END;
  dir (Embed_*) = rtl_:
	BEGIN
	if not Immediately within Object
	   HorizPos: Right = Enclosing . Right;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	END;
  dir (Paragraph*) = ltr_:
	BEGIN
	HorizPos: Left = Enclosing . Left;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Left = Enclosing . Left;
	END;
  dir (Paragraph *) = rtl_:
	BEGIN
	HorizPos: Right = Enclosing . Right;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Right = Enclosing . Right;
	END;
  dir (Pseudo_paragraph*) = ltr_:
	BEGIN
	HorizPos: Left = Enclosing . Left;
	IN Alternate_view
		HorizPos: Left = Enclosing . Left;
	END;
  dir (Pseudo_paragraph*) = rtl_:
	BEGIN
	HorizPos: Right = Enclosing . Right;
	IN Structure_view
		HorizPos: Left = Enclosing . Left;
	IN Alternate_view
		HorizPos: Right = Enclosing . Right;
	END;
  dir (H1*) = ltr_:
	BEGIN
	HorizPos: Left = Enclosing . Left;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Left = Enclosing . Left;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Adjust: VMiddle;
		HorizPos: Left = Enclosing . Left;
#else
		HorizPos: Left = Enclosing . Left + 1;
#endif
		END;
	END;
  dir (H1*) = rtl_:
	BEGIN
	HorizPos: Right = Enclosing . Right;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Right = Enclosing . Right;
	IN Table_of_contents
#ifdef PAGE
		HorizPos: Right = Enclosing . Right;
#else
		HorizPos: Right = Enclosing . Right - 1;
#endif
	END;
  dir (H2*) = ltr_:
	BEGIN
#ifdef PAGE
	CreateAfter (HeadingPageNumberRight);
#endif
	if inherited SectionNumbering
	   CreateFirst(H2_section_number);
	HorizPos: Left = Enclosing . Left;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Left = Enclosing . Left;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Adjust: LeftWithDots;
		Width: Right = Enclosing . Right - 28 pt;
#endif
		HorizPos: Left = Enclosing . Left + 1;
		END;
	END;
  dir (H2*) = rtl_:
	BEGIN
#ifdef PAGE
	CreateAfter (HeadingPageNumberLeft);
#endif
	if inherited SectionNumbering
	   CreateLast(H2_section_number_right);
	HorizPos: Right = Enclosing . Right;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Right = Enclosing . Right;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Width: Left = Enclosing . Left + 28 pt;
#endif
		HorizPos: Right = Enclosing . Right - 1;
		END;
	END;
  dir (H3*) = ltr_:
	BEGIN
#ifdef PAGE
	CreateAfter (HeadingPageNumberRight);
#endif
	if inherited SectionNumbering
	   CreateFirst(H3_section_number);
	HorizPos: Left = Enclosing . Left;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Left = Enclosing . Left;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Adjust: LeftWithDots;
		Width: Right = Enclosing . Right - 28 pt;
#endif
		HorizPos: Left = Enclosing . Left + 2;
		END;
	END;
  dir (H3*) = rtl_:
	BEGIN
#ifdef PAGE
	CreateAfter (HeadingPageNumberLeft);
#endif
	if inherited SectionNumbering
	   CreateLast(H3_section_number_right);
	HorizPos: Right = Enclosing . Right;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Right = Enclosing . Right;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Width: Left = Enclosing . Left + 28 pt;
#endif
		HorizPos: Right = Enclosing . Right - 2;
		END;
	END;
  dir (H4*) = ltr_:
	BEGIN
#ifdef PAGE
	CreateAfter (HeadingPageNumberRight);
#endif
	if inherited SectionNumbering
	   CreateFirst(H4_section_number);
	HorizPos: Left = Enclosing . Left;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Left = Enclosing . Left;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Adjust: LeftWithDots;
		Width: Right = Enclosing . Right - 28 pt;
#endif
		HorizPos: Left = Enclosing . Left + 3;
		END;
	END;
  dir (H4*) = rtl_:
	BEGIN
#ifdef PAGE
	CreateAfter (HeadingPageNumberLeft);
#endif
	if inherited SectionNumbering
	   CreateLast(H4_section_number_right);
	HorizPos: Right = Enclosing . Right;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Right = Enclosing . Right;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Width: Left = Enclosing . Left + 28 pt;
#endif
		HorizPos: Right = Enclosing . Right - 3;
		END;
	END;
  dir (H5*) = ltr_:
	BEGIN
#ifdef PAGE
	CreateAfter (HeadingPageNumberRight);
#endif
	if inherited SectionNumbering
	   CreateFirst(H5_section_number);
	HorizPos: Left = Enclosing . Left;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Left = Enclosing . Left;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Adjust: LeftWithDots;
		Width: Right = Enclosing . Right - 28 pt;
#endif
		HorizPos: Left = Enclosing . Left + 4;
		END;
	END;
  dir (H5*) = rtl_:
	BEGIN
#ifdef PAGE
	CreateAfter (HeadingPageNumberLeft);
#endif
	if inherited SectionNumbering
	   CreateLast(H5_section_number_right);
	HorizPos: Right = Enclosing . Right;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Right = Enclosing . Right;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Width: Left = Enclosing . Left + 28 pt;
#endif
		HorizPos: Right = Enclosing . Right - 4;
		END;
	END;
  dir (H6*) = ltr_:
	BEGIN
#ifdef PAGE
	CreateAfter (HeadingPageNumberRight);
#endif
	if inherited SectionNumbering
	   CreateFirst(H6_section_number);
	HorizPos: Left = Enclosing . Left;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Left = Enclosing . Left;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Adjust: LeftWithDots;
		Width: Right = Enclosing . Right - 28 pt;
#endif
		HorizPos: Left = Enclosing . Left + 5;
		END;
	END;
  dir (H6*) = rtl_:
	BEGIN
#ifdef PAGE
	CreateAfter (HeadingPageNumberLeft);
#endif
	if inherited SectionNumbering
	   CreateLast(H6_section_number_right);
	HorizPos: Right = Enclosing . Right;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Right = Enclosing . Right;
	IN Table_of_contents BEGIN
#ifdef PAGE
		Width: Left = Enclosing . Left + 28 pt;
#endif
		HorizPos: Right = Enclosing . Right - 5;
		END;
	END;
  dir (Preformatted*) = ltr_:
	BEGIN
	HorizPos: Left = Enclosing . Left;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Left = Enclosing . Left;
	END;
  dir (Preformatted*) = rtl_:
	BEGIN
	HorizPos: Right = Enclosing . Right;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Right = Enclosing . Right;
	END;
  dir (Object*) = ltr_:
	BEGIN
	HorizPos: Left = Enclosing . Left;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Left = Enclosing . Left;
	END;
  dir (Object*) = rtl_:
	BEGIN
	HorizPos: Right = Enclosing . Right;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Right = Enclosing . Right;
	END;
  dir (Unnumbered_List*) = ltr_:
	BEGIN
	HorizPos: Left = Enclosing . Left;
	{PaddingLeft: 0.5 em;}
	PaddingRight: 0;
	IN Structure_view BEGIN
		PaddingLeft: 0;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view
		HorizPos: Left = Enclosing . Left;
	END;
  dir (Unnumbered_List*) = rtl_:
	BEGIN
	HorizPos: Right = Enclosing . Right;
	PaddingLeft: 0;
	{PaddingRight: 0.5 em;}
	IN Structure_view BEGIN
		PaddingRight: 0;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view
		HorizPos: Right = Enclosing . Right;
	END;
  dir (Numbered_List*) = ltr_:
	BEGIN
	HorizPos: Left = Enclosing . Left;
	{PaddingLeft: 0.5 em;}
	PaddingRight: 0;
	IN Structure_view BEGIN
		PaddingLeft: 0;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view
		HorizPos: Left = Enclosing . Left;
	END;
  dir (Numbered_List*) = rtl_:
	BEGIN
	HorizPos: Right = Enclosing . Right;
	PaddingLeft: 0;
	PaddingRight: 1 em;
	IN Structure_view BEGIN
		PaddingRight: 0;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view
		HorizPos: Right = Enclosing . Right;
	END;
  dir (List_Item*) = ltr_:
	BEGIN
	MarginLeft: LIST_INDENT;
	HorizPos: Left = Enclosing . Left + LIST_SHIFT;
	if IntItemStyle = disc
	   CreateBefore(UL_DISC_LEFT);
	if IntItemStyle = square
	   CreateBefore(UL_SQUARE_LEFT);
	if IntItemStyle = circle
	   CreateBefore(UL_CIRCLE_LEFT);
 	if IntItemStyle = Arabic_
	   CreateBefore(OL_NUM_ARABIC_LEFT);
	if IntItemStyle = LowerAlpha
	   CreateBefore(OL_NUM_LALPHA_LEFT);
	if IntItemStyle = UpperAlpha
	   CreateBefore(OL_NUM_UALPHA_LEFT);
	if IntItemStyle = LowerRoman
	   CreateBefore(OL_NUM_LROMAN_LEFT);
	if IntItemStyle = UpperRoman
	   CreateBefore(OL_NUM_UROMAN_LEFT);
	IN Structure_view BEGIN
		MarginLeft: 0;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view BEGIN
		MarginLeft: 0;
		HorizPos: Left = Enclosing . Left + LIST_INDENT;
		END;
	END;
  dir (List_Item*) = rtl_:
	BEGIN
	MarginRight: LIST_INDENT;
	VertRef: * . Right;
	HorizPos: Right = Enclosing . Right - LIST_SHIFT;
	if IntItemStyle = disc
	   CreateBefore(UL_DISC_RIGHT);
	if IntItemStyle = square
	   CreateBefore(UL_SQUARE_RIGHT);
	if IntItemStyle = circle
	   CreateBefore(UL_CIRCLE_RIGHT);
 	if IntItemStyle = Arabic_
	   CreateBefore(OL_NUM_ARABIC_RIGHT);
	if IntItemStyle = LowerAlpha
	   CreateBefore(OL_NUM_LALPHA_RIGHT);
	if IntItemStyle = UpperAlpha
	   CreateBefore(OL_NUM_UALPHA_RIGHT);
	if IntItemStyle = LowerRoman
	   CreateBefore(OL_NUM_LROMAN_RIGHT);
	if IntItemStyle = UpperRoman
	   CreateBefore(OL_NUM_UROMAN_RIGHT);
	IN Structure_view BEGIN

		MarginRight: 0;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view BEGIN
		MarginRight: 0;
		HorizPos: Right = Enclosing . Right - LIST_INDENT;
		END;
	END;

  dir (Term*) = ltr_:
	BEGIN
	HorizPos: Left = Enclosing . Left;
	IN Structure_view BEGIN
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view BEGIN
		HorizPos: Left = Enclosing . Left;
		END;
	END;
  dir (Term*) = rtl_:
	BEGIN
	HorizPos: Right = Enclosing . Right;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Right = Enclosing . Right;
	END;
  dir (Definition*) = ltr_:
	BEGIN
	MarginLeft: DEFINITION_INDENT;
	HorizPos: Left = Enclosing . Left;
	IN Structure_view BEGIN
		MarginLeft: 0;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view BEGIN
		MarginLeft: 0;
		HorizPos: Left = Enclosing . Left + DEFINITION_INDENT;
		END;
	END;
  dir (Definition*) = rtl_:
	BEGIN
	MarginRight: DEFINITION_INDENT;
	HorizPos: Right = Enclosing . Right;
	IN Structure_view BEGIN
		MarginRight: 0;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view BEGIN
		MarginRight: 0;
		HorizPos: Right = Enclosing . Right - DEFINITION_INDENT;
		END;
	END;
  dir (LEGEND*) = ltr_:
	HorizPos: Left = Enclosing . Left;
  dir (LEGEND*) = rtl_:
	HorizPos: Right = Enclosing . Right;
  dir (Option_Menu*) = ltr_:
	CreateLast(Option_gif_right);
  dir (Option_Menu*) = rtl_:
	CreateLast(Option_gif_left);
  dir (Option*) = ltr_:
	BEGIN
	HorizPos: Left = Enclosing . Left + 0.2;	
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Left = Enclosing . Left + 1;
	END;
  dir (Option*) = rtl_:
	BEGIN
	HorizPos: Right = Enclosing . Right - 0.2;	
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Right = Enclosing . Right - 1;
	END;
  dir (Table*) = ltr_:
	BEGIN
	if within Center
		HorizPos: VMiddle = Enclosing . VMiddle;
	if not within Center
	        HorizPos: Left = Enclosing . Left;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	END;
  dir (Table*) = rtl_:
	BEGIN
	if within Center
		HorizPos: VMiddle = Enclosing . VMiddle;
	if not within Center
	        HorizPos: Right = Enclosing . Right;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view BEGIN
		if within Center
			HorizPos: VMiddle = Enclosing . VMiddle;
		if not within Center
	        	HorizPos: Right = Enclosing . Right;
		END;
	END;
  dir (Table_head*) = ltr_:
	HorizPos: Left = Enclosing . Left;
  dir (Table_head*) = rtl_:
	HorizPos: Right = Enclosing . Right;
  dir (Column_head*) = ltr_:
	HorizPos: Left = Previous . Right;
  dir (Column_head*) = rtl_:
	HorizPos: Right = Previous . Left;
  dir (thead*) = ltr_:
	BEGIN
	HorizPos: Left = Enclosing . Left;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Left = Enclosing . Left;
	END;
  dir (thead*) = rtl_:
	BEGIN
	HorizPos: Right = Enclosing . Right;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Right = Enclosing . Right;
	END;
  dir (Table_body*) = ltr_:
	BEGIN
	HorizPos: Left = Enclosing . Left;
	IN Structure_view
		HorizPos: Left = Enclosing . Left;
	IN Alternate_view
		HorizPos: Left = Enclosing . Left;
	END;
  dir (Table_body*) = rtl_:
	BEGIN
	HorizPos: Right = Enclosing . Right;
	IN Structure_view
		HorizPos: Right = Enclosing . Right;
	IN Alternate_view
		HorizPos: Right = Enclosing . Right;
	END;
  dir (tbody*) = ltr_:
	BEGIN
	HorizPos: Left = Enclosing . Left;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Left = Enclosing . Left;
	END;
  dir (tbody*) = rtl_:
	BEGIN
	HorizPos: Right = Enclosing . Right;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Right = Enclosing . Right;
	END;
  dir (Table_row*) = ltr_:
	BEGIN
	HorizPos: Left = Enclosing . Left;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Left = Enclosing . Left;
	END;
  dir (Table_row*) = rtl_:
	BEGIN
	HorizPos: Right = Enclosing . Right;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Right = Enclosing . Right;
	END;
  dir (tfoot*) = ltr_:
	BEGIN
	HorizPos: Left = Enclosing . Left;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Left = Enclosing . Left;
	END;
  dir (tfoot*) = rtl_:
	BEGIN
	HorizPos: Right = Enclosing . Right;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Right = Enclosing . Right;
	END;
  dir (Data_cell*) = ltr_:
	IN Alternate_view
	   HorizPos: Left = Previous Table_cell . Left + STRUCT_INDENT;
  dir (Data_cell*) = rtl_:
	IN Alternate_view
	   HorizPos: Right = Previous Table_cell . Right - STRUCT_INDENT;
  dir (Heading_cell*) = ltr_:
	IN Alternate_view
	   HorizPos: Left = Previous Table_cell . Left + STRUCT_INDENT;
  dir (Heading_cell*) = rtl_:
	IN Alternate_view
	   HorizPos: Right = Previous Table_cell . Right - STRUCT_INDENT;
  dir (Table_foot*) = ltr_:
	HorizPos: Left = Enclosing . Left;
  dir (Table_foot*) = rtl_:
	HorizPos: Right = Enclosing . Right;

  onclick:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  ondblclick:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  onmousedown:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  onmouseup:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  onmouseover:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  onmousemove:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  onmouseout:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  onkeypress:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  onkeydown:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  onkeyup:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  onload:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  onunload:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  onfocus:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  onblur:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  onsubmit:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  onreset:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  onselect:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  onchange:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  RowHeight:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  ColWidth:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  FrameName:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	CreateLast (ATTR_FRAMENAME);
	CreateLast (VALUE_FRAMENAME);
	END;

  FrameSrc:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	if FRAME
	   BEGIN
	   CreateLast (ATTR_FRAMESRC);
	   CreateLast (VALUE_FRAMESRC);
	   END;
	END;

  frameborder:
	CreateBefore(AttrNameAndValue);

  marginwidth:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  marginheight:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  no_resize:
	CreateBefore(AttrNameOnly);

  scrolling:
	CreateBefore(AttrNameAndValue);

  rbspan:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  EmbedHidden:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  EmbedName:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  Invalid_attribute:
	BEGIN
	if TEXT_UNIT
	   CreateBefore(VALUE_Invalid_attribute);
	if PICTURE_UNIT
	   CreateBefore(VALUE_Invalid_attribute);
	if Invalid_element
	   CreateAfter(VALUE_Invalid_attribute);
	if Unknown_namespace
	   CreateAfter(VALUE_Invalid_attribute);
	if Anchor
	   CreateBefore(VALUE_Invalid_attribute);
	if not TEXT_UNIT and not PICTURE_UNIT and not Invalid_element and not Unknown_namespace and not Anchor
	   CreateBefore(VALUE_Invalid_attribute);
	END;

  Unknown_attribute:
	BEGIN
	if TEXT_UNIT
	   CreateBefore(VALUE_Unknown_attribute);
	if PICTURE_UNIT
	   CreateBefore(VALUE_Unknown_attribute);
	if Invalid_element
	   CreateAfter(VALUE_Unknown_attribute);
	if Unknown_namespace
	   CreateAfter(VALUE_Unknown_attribute);
        if XHTML_Unknown_namespace
           CreateAfter(VALUE_Unknown_attribute);
        if XHTML_Unknown_namespace and LastAttr
           CreateAfter(UNKNOWN_E);
	if Anchor
	   CreateBefore(VALUE_Unknown_attribute);
	if not TEXT_UNIT and not PICTURE_UNIT and not Invalid_element and not Anchor and not XHTML_Unknown_namespace
	   CreateBefore(VALUE_Unknown_attribute);
	END;

{ LC 22/08/01
  EntityName:
	BEGIN
	CreateBefore(VALUE_EntityName);
	IN Structure_view
		Visibility: 1;
	END;
}

  xml_space:
	CreateBefore(AttrNameAndValue);

#ifndef PAGE
  Highlight:
	BEGIN
        if TEXT_UNIT
	   CreateAfter (IndexBox);
	if not TEXT_UNIT
	   CreateLast (IndexBox);
	END;
#endif

END
