/* $Id: wmgroup.c,v 1.18 2000/03/03 18:39:08 komatsu Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "wmgroup.h"
#include "wmmain.h"
#include "wmbutton.h"
#include "wmmisc.h"
#include "wmmenu.h"

static void wm_group_free(WmGroup *group);

void wm_group_append(WmGroup *group, WmClient *client)
{
    wm_message("WmGroup: wm_group_append\n");

    if(!g_list_find(group->list, (gpointer)client)) {
	group->list   = g_list_append(group->list,   (gpointer)client);
	client->group = g_list_append(client->group, (gpointer)group);
    }
}

void wm_group_destroy(WmGroup *group)
{
    if(group) {
	wm_message("WmGroup[%s]: wm_group_destroy\n", group->title);

	group->auto_destroy = TRUE;
	if(group->list) {
	    while(wm_group_remove(group, group->list->data)) {
		wm_message("WmGroup: wm_group_destroy - Loop\n");
	    }
	} else {
	    wm_group_free(group);
	}
    } else {
	wm_message("WmGroup: wm_group_destroy -- group is NULL\n");
    }
}

/* Ĥεưʬˤ */
gint wm_group_remove(WmGroup *group, WmClient *client)
{
    if(group) {
	wm_message("WmGroup[%s]: wm_group_remove\n", group->title);
	client->group = g_list_remove(client->group, (gpointer *)group);
	group->list   = g_list_remove(group->list,   (gpointer *)client);
	group->withdrawns =
	    g_list_remove(group->withdrawns,   (gpointer *)client);
	if(group->list == NULL && group->auto_destroy) {
	    wm_group_free(group);
	    return FALSE;
	}
	if(client->target == group) {
	    client->target = all_clients;
	}
    } else {
	wm_message("WmGroup: wm_group_remove -- group is NULL\n");
    }
    return TRUE;
}

static void wm_group_free(WmGroup *group)
{
    GList *list;

    wm_message("WmGroup[%s]: wm_group_free\n", group->title);

    for(list = group->withdrawns; list; list = list->next) {
	WM_CLIENT_GROUP(list->data) = 
	    g_list_remove(WM_CLIENT_GROUP(list->data), group);
    }
    all_groups = g_list_remove(all_groups, group);
    g_list_free(group->list);
    g_free(group->title);
    g_free(group);
}

WmGroup *wm_group_new(gchar *title, WmClient *client, Window leader, 
		      gboolean auto_destroy)
{
    WmGroup *group;

    wm_message("WmGroup[%s]: wm_group_new\n", title);

    group = (WmGroup *)g_malloc(sizeof(WmGroup));
    group->title = g_strdup(title);
    group->withdrawns   = NULL;
    group->auto_destroy = auto_destroy;
    if(client) {
	group->list   = g_list_append(NULL, client);
	group->leader = leader;
	client->group = g_list_append(client->group, group);
    } else {
	group->list = NULL;
    }
    return group;
}

WmGroup *wm_group_find_leader(Window leader)
{
    GList *list;

    wm_message("WmGroup: wm_group_find_leader [%x]\n", leader);
    if(!leader) { return NULL; }

    for(list = all_groups; list; list = list->next) {
	if(WM_GROUP_LEADER(list->data) == leader) {
	    wm_message("WmGroup: wm_group_find_leader found!\n");
	    return list->data;
	}
    }
    return NULL;
}

/* ---------------------------------------------------------------------- */
#include "wmtitle.h"
#include "wmdesign.h"

struct _WmGroupTmpStruct {
    WmClient *client;
    WmGroup  *group;
};
typedef struct _WmGroupTmpStruct WmGroupTmpStruct;

static void wm_group_menu_target_change(GtkWidget *widget,
					WmGroupTmpStruct *ts);
static void wm_group_menu_append(GtkWidget *widget, WmGroupTmpStruct *ts);
static void wm_group_menu_remove(GtkWidget *widget, WmGroupTmpStruct *ts);
static void wm_group_menu_signal_connect(GtkWidget *widget, GtkSignalFunc func,
					 WmClient *client, WmGroup *group);

static void wm_group_menu_target_change(GtkWidget *widget,WmGroupTmpStruct *ts)
{
    wm_message("WmGroup: wm_group_menu_target_change\n");
    if(GTK_CHECK_MENU_ITEM(widget)->active) {
	WM_CLIENT_TARGET(ts->client) = ts->group;
    }
}

static void wm_group_menu_append(GtkWidget *widget, WmGroupTmpStruct *ts)
{
    wm_message("WmGroup: wm_group_menu_append\n");
    wm_group_append(ts->group, ts->client);
}

static void wm_group_menu_remove(GtkWidget *widget, WmGroupTmpStruct *ts)
{
    wm_message("WmGroup: wm_group_menu_remove\n");
    wm_group_remove(ts->group, ts->client);
}

static void wm_group_menu_signal_connect(GtkWidget *widget, GtkSignalFunc func,
					 WmClient *client, WmGroup *group)
{
    WmGroupTmpStruct *tmp_struct;

    tmp_struct = g_malloc(sizeof(WmGroupTmpStruct));
    tmp_struct->client = client;
    tmp_struct->group  = group;
    wm_signal_connect_with_struct(GTK_OBJECT(widget), "toggled",
				  func, tmp_struct);
}


GtkWidget *wm_group_menu_target(WmClient *client)
{
    GtkWidget *menu, *item;
    GList  *list;
    GSList *radio;

    menu  = gtk_menu_new();
    radio = NULL;
    for(list = WM_CLIENT_GROUP(client); list; list = list->next) {
	item = gtk_radio_menu_item_new_with_label(radio,
						  WM_GROUP_TITLE(list->data));
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(item), TRUE);
	radio = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(item));
	wm_group_menu_signal_connect(item, wm_group_menu_target_change,
				     client, list->data);

	if(WM_CLIENT_TARGET(client) == list->data) {
	    gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(item), TRUE);
	} else {
	    gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(item), FALSE);
	}
	gtk_menu_append(GTK_MENU(menu), item);
	gtk_widget_show(item);
    }
    return menu;
}

/* ٤ƤΥ饤Ȥ, Ϳ줿롼פ°ƤΡ°Ƥʤ
 * Τνɽ, åܥåˤäƤν°ѹ 
 */
GtkWidget* wm_group_menu_clients(WmGroup *group) 
{
    GtkWidget *menu;
    GtkWidget *client;
    GList *list, *all;

    menu = gtk_menu_new();

    all = g_list_copy(all_clients->list);
    for(list = group->list; list; list = list->next) {
	client = 
	    gtk_check_menu_item_new_with_label(wm_title_parse(list->data));
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(client), TRUE);
	gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(client), TRUE);
	wm_group_menu_signal_connect(client, wm_group_menu_remove,
				     list->data, group);
	gtk_menu_append(GTK_MENU(menu), client);
	gtk_widget_show(client);
	all = g_list_remove(all, list->data);
    }
#if 0
    client = gtk_menu_item_new(); /* ѥ졼 */
    gtk_menu_append(GTK_MENU(menu), client);
    gtk_widget_show(client);
#endif
    for(list = all; list; list = list->next) {
	client =
	    gtk_check_menu_item_new_with_label(wm_title_parse(list->data));
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(client), TRUE);
	gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(client), FALSE);

	wm_group_menu_signal_connect(client, wm_group_menu_append,
				     list->data, group);
	gtk_menu_append(GTK_MENU(menu), client);
	gtk_widget_show(client);
    }
    g_list_free(all);
    return menu;
}

/* 饤ȤȤоݥ롼פɽ뤿Υ˥塼 */
GtkWidget* wm_group_menu_clients2(void) 
{
    GtkWidget *menu, *submenu;
    GtkWidget *client;
    GList *list;

    menu = gtk_menu_new();

    for(list = all_clients->list; list; list = list->next) {
	client = gtk_menu_item_new_with_label(WM_CLIENT_TITLE(list->data));
	submenu = wm_group_menu_target(list->data);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(client), submenu);
	gtk_menu_append(GTK_MENU(menu), client);
	gtk_widget_show(client);
    }

    return menu;
}

/* ٤ƤΥ롼פ, Ϳ줿饤Ȥ°ƤΡ°Ƥʤ
 * Τɽ, åܥåˤäƤν°ѹ 
 */
GtkWidget* wm_group_menu_groups(WmClient *client)
{
    GtkWidget *menu;
    GtkWidget *group;
    GList *list;

    menu = gtk_menu_new();

    for(list = all_groups; list; list = list->next) {
	group = gtk_check_menu_item_new_with_label(WM_GROUP_TITLE(list->data));
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(group), TRUE);
	if(g_list_find(WM_GROUP_LIST(list->data), client)) {
	    gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(group), TRUE);
	    wm_group_menu_signal_connect(group, wm_group_menu_remove,
					 client, list->data);
	} else {
	    gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(group), FALSE);
	    wm_group_menu_signal_connect(group, wm_group_menu_append,
					 client, list->data);
	}
	gtk_menu_append(GTK_MENU(menu), group);
	gtk_widget_show(group);
    }
    return menu;
}

/* 롼פȤν°饤Ȥɽ뤿Υ˥塼 */
GtkWidget* wm_group_menu_groups2(void)
{
    GtkWidget *menu, *gmenu, *group, *item;
    GList *list;

    menu = gtk_menu_new();

    for(list = all_groups; list; list = list->next) {
	group = gtk_menu_item_new_with_label(WM_GROUP_TITLE(list->data));
	gmenu = wm_group_menu_clients(list->data);

	item = gtk_menu_item_new(); /* ѥ졼 */
	gtk_menu_prepend(GTK_MENU(gmenu), item);
	gtk_widget_show(item);

	item = gtk_menu_item_new_with_label("Destroy group ...");
	gtk_signal_connect(GTK_OBJECT(item), "activate",
			   wm_group_dialog_destroy, list->data);
	gtk_menu_prepend(GTK_MENU(gmenu), item);
	gtk_widget_show(item);

	item = gtk_menu_item_new_with_label("Rename group ...");
	gtk_signal_connect(GTK_OBJECT(item), "activate",
			   wm_group_dialog, list->data);
	gtk_menu_prepend(GTK_MENU(gmenu), item);
	gtk_widget_show(item);

	gtk_menu_item_set_submenu(GTK_MENU_ITEM(group), gmenu);
	gtk_menu_append(GTK_MENU(menu), group);
	gtk_widget_show(group);
	gtk_widget_show(gmenu);
    }
    return menu;
}

/* ---------------------------------------------------------------------- */

void wm_group_press1(GtkWidget *widget,GdkEventButton *event,WmClient *client);
void wm_group_press1(GtkWidget *widget,GdkEventButton *event,WmClient *client)
{
    wm_menu_popup_temporarily(GTK_MENU(wm_group_menu_target(client)),
			      NULL, NULL, NULL, NULL,
			      event->button, event->time);
}

void wm_group_press2(GtkWidget *widget,GdkEventButton *event,WmClient *client);
void wm_group_press2(GtkWidget *widget,GdkEventButton *event,WmClient *client)
{
    wm_menu_popup_temporarily(GTK_MENU(wm_group_menu_groups(client)),
			      NULL, NULL, NULL, NULL,
			      event->button, event->time);
}


GtkWidget *wm_group_button_new(GtkWidget *client)
{
    GtkWidget *group;

    wm_message("WmGroup: button_new \n");

    group = wm_button_new_default(client);
    gtk_signal_connect(GTK_OBJECT(group), "press1", 
		       GTK_SIGNAL_FUNC(wm_group_press1), client);
    gtk_signal_connect(GTK_OBJECT(group), "press2", 
		       GTK_SIGNAL_FUNC(wm_group_press2), client);
    return group;
}

GtkWidget *wm_group_button_new_with_xpm(GtkWidget *client, gchar *filename)
{
    GtkWidget *group;

    group = wm_group_button_new(client);
    wm_design_xpm_pack(group, filename);

    return group;
}

GtkWidget *wm_group_button_new_default(GtkWidget *client)
{
    GtkWidget *group;

    group = wm_group_button_new(client);
    wm_design_label_pack(group, "G");

    return group;
}

/* ---------------------------------------------------------------------- */
#include <stdio.h> /* snprintf */

struct _WmGroupDialog {
    WmGroup  *group;
    GtkCombo *combo;
};
typedef struct _WmGroupDialog WmGroupDialog;

static void wm_group_dialog_ok(GtkWidget *widget, WmGroupDialog *data);
static void wm_group_dialog_cancel(GtkWidget *widget, gpointer data);
static void wm_group_dialog_destroy_ok(GtkWidget *widget, gpointer data);
GList *wm_group_name_list;

/* å wm_dialog_ok_cancel ʤɤȤƥѲ */
void wm_group_dialog(GtkWidget *widget, WmGroup *group)
{
    GtkWidget *combo, *frame, *dialog;
    GtkWidget *button_ok, *button_cancel;
    WmGroupDialog *data;

    data   = g_malloc(sizeof(WmGroupDialog));
    combo  = gtk_combo_new();
    GTK_WIDGET_SET_FLAGS(combo, GTK_CAN_DEFAULT);

    data->group = group;
    data->combo = GTK_COMBO(combo);

    gtk_combo_set_popdown_strings(GTK_COMBO(combo), wm_group_name_list);
    if(group) {
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry), group->title);
    } else {
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry), "");
    }

    frame  = gtk_frame_new("Group Name");
    dialog = gtk_dialog_new();
    gtk_container_border_width(GTK_CONTAINER(GTK_DIALOG(dialog)), 5);
    gtk_container_add(GTK_CONTAINER(frame), combo);

    button_ok     = gtk_button_new_with_label("OK");
    GTK_WIDGET_SET_FLAGS(button_ok, GTK_CAN_DEFAULT);
    wm_signal_connect_with_struct(GTK_OBJECT(button_ok), "clicked",
				  wm_group_dialog_ok, data);
    gtk_signal_connect_object(GTK_OBJECT(button_ok), "clicked",
			      gtk_widget_destroy, GTK_OBJECT(dialog));

    button_cancel = gtk_button_new_with_label("Cancel");
    GTK_WIDGET_SET_FLAGS(button_cancel, GTK_CAN_DEFAULT);
    gtk_signal_connect_object(GTK_OBJECT(button_cancel), "clicked",
			      gtk_widget_destroy, GTK_OBJECT(dialog));
    gtk_widget_grab_default(button_ok);

    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		       frame, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		       button_ok, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		       button_cancel, TRUE, TRUE, 0);

    gtk_widget_show(combo);
    gtk_widget_show(frame);
    gtk_widget_show(button_ok);
    gtk_widget_show(button_cancel);
    gtk_window_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);
    gtk_widget_show(dialog);

    gdk_keyboard_grab(dialog->window, TRUE, CurrentTime);
    gtk_grab_add(dialog);
    gtk_signal_connect_object(GTK_OBJECT(dialog), "destroy",
			      gtk_grab_remove, GTK_OBJECT(dialog));
}

void wm_group_dialog_destroy(GtkWidget *widget, WmGroup *group)
{
    char message[200];
    GtkWidget *label, *dialog;
    GtkWidget *button_ok, *button_cancel;

    if(snprintf(message, 200, 
		"Really delete the group '%s'?", group->title) == -1) {
	message[199] = '\0';
    }
    label = gtk_label_new(message);
    dialog = gtk_dialog_new();
    gtk_container_border_width(GTK_CONTAINER(GTK_DIALOG(dialog)), 5);

    button_ok     = gtk_button_new_with_label("OK");
    GTK_WIDGET_SET_FLAGS(button_ok, GTK_CAN_DEFAULT);
    gtk_signal_connect(GTK_OBJECT(button_ok), "clicked",
		       wm_group_dialog_destroy_ok, group);
    gtk_signal_connect_object(GTK_OBJECT(button_ok), "clicked",
			      gtk_widget_destroy, GTK_OBJECT(dialog));

    button_cancel = gtk_button_new_with_label("Cancel");
    GTK_WIDGET_SET_FLAGS(button_cancel, GTK_CAN_DEFAULT);
    gtk_signal_connect_object(GTK_OBJECT(button_cancel), "clicked",
			      gtk_widget_destroy, GTK_OBJECT(dialog));
    gtk_widget_grab_default(button_ok);

    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		       label, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		       button_ok, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		       button_cancel, TRUE, TRUE, 0);

    gtk_widget_show(label);
    gtk_widget_show(button_ok);
    gtk_widget_show(button_cancel);
    gtk_window_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);
    gtk_widget_show(dialog);

    gtk_grab_add(dialog);
    gtk_signal_connect_object(GTK_OBJECT(dialog), "destroy",
			      gtk_grab_remove, GTK_OBJECT(dialog));
}

static void wm_group_dialog_ok(GtkWidget *widget, WmGroupDialog *data)
{
    gchar   *name;
    WmGroup *group;
    GList   *list;

    name = 
	gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(data->combo)->entry));
    if(!g_str_equal(name, "")) {
	if(data->group) {
	    g_free(WM_GROUP_TITLE(data->group));
	    WM_GROUP_TITLE(data->group) = g_strdup(name);
	} else {
	    group = wm_group_new(name, NULL, WM_GROUP_NO_LEADER, FALSE);
	    /* group_new Ǥ٤ */
	    all_groups = g_list_prepend(all_groups, group);
	}
	for(list = wm_group_name_list; list; list = list->next) {
	    if(g_str_equal(name, list->data)) {
		return;
	    }
	}
	/* 롼פ̾ΤǤ, wm_group_name_list ˲ä */
	wm_group_name_list = g_list_append(wm_group_name_list, g_strdup(name));
    }
}

static void wm_group_dialog_cancel(GtkWidget *widget, gpointer data)
{
    gtk_widget_destroy(GTK_WIDGET(data));
}

static void wm_group_dialog_destroy_ok(GtkWidget *widget, gpointer data)
{
    wm_group_destroy((WmGroup *)data);
}
