/* $Id: wmerror.c,v 1.19 2000/03/03 18:39:07 komatsu Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "wmmain.h"
#include "wmerror.h"
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */
#include <signal.h>
#include <sys/wait.h>

#if defined(SIGFPE) || defined(SIGBUS) || defined(SIGSEGV)
#define NEED_SIGNAL_HANDLER_ABORT	1
#endif
#if defined(SIGINT) || defined(SIGQUIT) || defined(SIGTERM) || defined(SIGPWR)
#define NEED_SIGNAL_HANDLER_EXIT	1
#endif
#if defined(SIGHUP)
#define NEED_SIGNAL_HANDLER_RESTART	1
#endif
#if defined(SIGCHLD)
#define NEED_SIGNAL_HANDLER_SIGCHLD	1
#endif

static wmErrorIgnoreMask ignoreMask;

static int wm_error_handler(Display *display, XErrorEvent *event);
#ifdef NEED_SIGNAL_HANDLER_ABORT
static RETSIGTYPE signal_handler_abort(int signum);
#endif
#ifdef NEED_SIGNAL_HANDLER_EXIT
static RETSIGTYPE signal_handler_exit(int signum);
#endif
#ifdef NEED_SIGNAL_HANDLER_RESTART
static RETSIGTYPE signal_handler_restart(int signum);
#endif
#ifdef NEED_SIGNAL_HANDLER_SIGCHLD
static RETSIGTYPE signal_handler_sigchld(int signum);
#endif
  
wmErrorIgnoreMask wm_error_get_ignore_mask(void)
{
    return ignoreMask;
}

void wm_error_set_ignore_mask(wmErrorIgnoreMask mask)
{
    XSync(GDK_DISPLAY(), FALSE);
    ignoreMask = mask;
}

static int wm_error_handler(Display *display, XErrorEvent *event)
{
    char string[200];
    XGetErrorText(GDK_DISPLAY(), event->error_code, string, sizeof(string));
    wm_message("WmError[%x]: X Error -- %s\n", event->resourceid, string);

    if(ignoreMask & (1 << event->error_code)) {
	return 0;
    } else if(WM_ERROR_BAD_ACCESS & (1 << event->error_code) &&
	      event->resourceid == GDK_ROOT_WINDOW()) {
	g_error("WM ERROR: another window manager running?\n");
	wm_main_exit(1);
    } else {
	/* ΤޤȤ˼ʤȤ͡ */
	g_error("WM Fatal Error.\n Catch X Error.\n");
	wm_main_exit(1);
    }
    return 1;
}

#ifdef NEED_SIGNAL_HANDLER_ABORT
static RETSIGTYPE signal_handler_abort(int signum)
{
    wm_message("WmError: signal trapped: %s\n", g_strsignal(signum));
    abort();
}
#endif

#ifdef NEED_SIGNAL_HANDLER_EXIT
static RETSIGTYPE signal_handler_exit(int signum)
{
    wm_message("WmError: signal trapped: %s\n", g_strsignal(signum));
    wm_main_exit(0);
}
#endif

#ifdef NEED_SIGNAL_HANDLER_RESTART
static RETSIGTYPE signal_handler_restart(int signum)
{
    wm_message("WmError: signal trapped: %s\n", g_strsignal(signum));
    wm_main_restart(NULL);
}
#endif

#ifdef NEED_SIGNAL_HANDLER_SIGCHLD
static RETSIGTYPE signal_handler_sigchld(int signum)
{
    wm_message("WmError: signal trapped: %s\n", g_strsignal(signum));
    while(waitpid(-1, NULL, WNOHANG) > 0) {
	/* empty */ ;
    }
    signal(SIGCHLD, signal_handler_sigchld);
}
#endif

void wm_error_init(void)
{
    /*  mask ꤹ٤ǤϤʤ */
    ignoreMask = WM_ERROR_BAD_WINDOW | WM_ERROR_BAD_DRAWABLE | 
	WM_ERROR_BAD_MATCH | 0;

    XSetErrorHandler(wm_error_handler);

#ifdef SIGHUP
    signal(SIGHUP,  signal_handler_restart);
#endif
#ifdef SIGINT
    signal(SIGINT,  signal_handler_exit);
#endif
#ifdef SIGQUIT
    signal(SIGQUIT, signal_handler_exit);
#endif
#ifdef SIGFPE
    signal(SIGFPE,  signal_handler_abort);
#endif
#ifdef SIGBUS
    signal(SIGBUS,  signal_handler_abort);
#endif
#ifdef SIGSEGV
    signal(SIGSEGV, signal_handler_abort);
#endif
#ifdef SIGTERM
    signal(SIGTERM, signal_handler_exit);
#endif
#ifdef SIGCHLD
    signal(SIGCHLD, signal_handler_sigchld);
#endif
#ifdef SIGPWR
    signal(SIGPWR,  signal_handler_exit);
#endif
}
