package provide easyxml 1.0

namespace eval easyxml {
	namespace eval parsers {}
	variable defaults [list -start-tag "" -end-tag "" -comment "" -instruction ""]
	interp alias {} [namespace current]::unescape {} string map\
		{ &lt; < &gt; > &amp; & &quot; \" &apos; ' }
	proc valid-xml-name {str} { return 1 }
	proc parser {name args} {
		if {[info commands $name]==$name} {
			return -code error "Command $name already exists"
		}
		interp alias {} $name {} [namespace current]::_parser $name
		variable defaults
		array set parsers::$name $defaults
		public:reset $name
		eval [list public:configure $name] $args
		set name
	}
	proc _parser {id cmd args} {
		set call [namespace current]::public:$cmd
		if {[info commands $call]!=$call} {
			return -code error "Invalid method $cmd"
		}
		eval [list $call $id] $args 
	}
}

proc easyxml::starttag {id all} { 
	upvar 0 parsers::$id data
	set name [lindex $all 0]
	set all [string trimleft [string range $all [string length $name] end]]
	set attrs [list]
	while {[set pos [string first = $all]]!=-1} {
		set key [string trimright [string range $all 0 [expr $pos-1]]]
		if {[valid-xml-name $key]} { lappend attrs $key }
		set all [string trimleft [string range $all [expr $pos+1] end]]
		set delim [string index $all 0]
		set pos [string first $delim $all 1]
		if {$pos!=-1} {
			lappend attrs [unescape\
				[string range $all 1 [expr $pos-1]]]
			set all [string trimleft [string range $all\
				[expr $pos+1] end]]
		} else break
	}
	lappend data(stack) [list $name $attrs $data(raw)]
	set data(raw) ""
	if {$data(-start-tag)!=""} {
		if {[catch { eval $data(-start-tag) [list $name $attrs] } r]} {
			puts $r
		}
		
	}
}
proc easyxml::endtag {id name} { 
	upvar 0 parsers::$id data
	set val [unescape $data(raw)]
	foreach {tag attrs data(raw)} [lindex $data(stack) end] break
	if {![info exists tag]} {
		return -code error "Closing tag $name without opening $name"
	}
	if {$tag!=$name} {
		return -code error\
			"Closing $name while $tag is not closed"
	}
	set data(stack) [lrange $data(stack) 0 end-1]
	if {$data(-end-tag)!=""} {
		catch { eval $data(-end-tag) [list $name $attrs $val] }
	}
}

proc easyxml::emptytag {name all} {
	starttag $name $all
	endtag $name [lindex $all 0]
}

proc easyxml::_raw {param id all} {
	upvar 0 parsers::$id data
	if {$data($param)!=""} { catch { eval $data($param) [list $all] } }
}

foreach x {comment instruction} {
	interp alias {} easyxml::$x {} easyxml::_raw -$x
}

# Incremental parsing
proc easyxml::public:parse {name chunk} {
	upvar 0 parsers::$name data
	append data(xml) $chunk
	while 1 {
		set start [string first < $data(xml)]
		if {$start==-1} return
		set end [string first > $data(xml) $start]
		if {$end==-1} return
		append data(raw) [string range $data(xml) 0 [expr $start-1]]
		set content [string range $data(xml)\
			[expr $start+1] [expr $end-1]]
		if {[string first < $content]!=-1} {
			return -code error "Invalid XML"
		}
		set data(xml) [string range $data(xml) [expr $end+1] end]
		if {[string index $content 0]=="/"} {
			set content [string range $content 1 end]
			set cmd endtag
		} elseif {[string index $content end]=="/"} {
			set content [string range $content 0 end-1]
			set cmd emptytag
		} elseif { [string index $content end]=="?" &&
		           [string index $content 0]=="?"} {
			set content [string range $content 1 end-1]
			set cmd instruction
		} elseif { [string index $content 0]=="!"} {
			set content [string range $content 1 end]
			if {[string match --*-- $content]} {
				set cmd comment
				set content [string range $content 2 end-2]
			} else { set cmd }
		} else { set cmd starttag }
		$cmd $name $content
	}
}

# Set external hooks for start tag and end tag events
proc easyxml::public:configure {name args} {
	upvar 0 parsers::$name data
	foreach {key val} $args {
		if {![string match -* $key] || ![info exists data($key)]} {
			return -code error "Unknown option $key"
		}
		set data($key) $val
	}
}

proc easyxml::public:reset {name} {
	array set parsers::$name [list stack [list] raw "" xml ""]
}
# Delete parser
proc easyxml::public:delete {name} {
	unset parsers::$name
	interp alias {} $name {}
}

