// ---------------------------------------------------------------------------
// - Qarray.hpp                                                              -
// - standard object library - quark dynamic array class definition          -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_QARRAY_HPP
#define  ALEPH_QARRAY_HPP

#ifndef  ALEPH_STRING_HPP
#include "String.hpp"
#endif

namespace aleph {

  /// The Qarray class implements a quark dynamic array which is faster 
  /// than the standard vector implementation with objects. The quark array
  /// provides the same funcionality than the Vector class except that it 
  /// works with quarks only.
  /// @author amaury darsch

  class Qarray {
  private:
    /// current size
    long  d_length;
    /// the size of allocation
    long  d_size;
    /// the allocated array
    long* p_array;

  public:
    /// create an empty quark array
    Qarray (void);

    /// create a quark array with a predefined size
    /// @param size the requested size  
    Qarray (const long size);
  
    /// copy constructor for this quark array
    /// @param that the quark array to copy
    Qarray (const Qarray& that);

    /// destroy this quark array
    ~Qarray (void);

    /// add a quark in this array
    /// @param quark the quark to add
    void add (const long quark);

    /// set a quark at a given position
    /// @param index the array index
    /// @param quark the quark to set
    void set (const long index, const long quark);

    /// get a quark at a certain index
    /// @param index the vector index
    long get (const long index) const;

    /// @return the number of elements
    long length (void) const {
      return d_length;
    }

    /// @return true if the quark exists
    bool exists (const long quark) const;

    /// search for a quark in the quark array or throw an exception
    /// @param quark the quark to search
    long index (const long quark) const;
    
    /// search for a key in the string vector or return -1
    /// @param quark the quark to search
    long lookup (const long quark) const;
  };
}

#endif
