// ---------------------------------------------------------------------------
// - cthr.hxx                                                                -
// - standard system library - c thread function platform definitions        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

// check for unknown platform
#if (ALEPH_PLATFORM_PLATID == ALEPH_PLATFORM_UNKNOWN)
#error "unknown platform type"
#endif

// check for unknown processor
#if (ALEPH_PLATFORM_PROCID == ALEPH_PROCTYPE_UNKNOWN)
#error "unknown processor type"
#endif

// linux platform
#if (ALEPH_PLATFORM_PLATID == ALEPH_PLATFORM_LINUX)
#include <pthread.h>
#define  ALEPH_PTHREAD_ONCE_INIT         PTHREAD_ONCE_INIT
#define  ALEPH_PTHREAD_MUTEX_INITIALIZER PTHREAD_MUTEX_INITIALIZER
#define  ALEPH_PTHREAD_COND_INITIALIZER  PTHREAD_COND_INITIALIZER
#endif

// solaris platform - the initializers are a mess
#if (ALEPH_PLATFORM_PLATID == ALEPH_PLATFORM_SOLARIS)
#include <pthread.h>
#ifdef  __GNUC__
#define  ALEPH_PTHREAD_ONCE_INIT         {PTHREAD_ONCE_INIT}
#if (ALEPH_PLATFORM_MAJOR == 5) && (ALEPH_PLATFORM_MINOR < 7)
#define  ALEPH_PTHREAD_MUTEX_INITIALIZER {{PTHREAD_MUTEX_INITIALIZER}}
#define  ALEPH_PTHREAD_COND_INITIALIZER  {{PTHREAD_COND_INITIALIZER}}
#else
#define  ALEPH_PTHREAD_MUTEX_INITIALIZER PTHREAD_MUTEX_INITIALIZER
#define  ALEPH_PTHREAD_COND_INITIALIZER  PTHREAD_COND_INITIALIZER
#endif
#else
#define  ALEPH_PTHREAD_ONCE_INIT         PTHREAD_ONCE_INIT
#define  ALEPH_PTHREAD_MUTEX_INITIALIZER PTHREAD_MUTEX_INITIALIZER
#define  ALEPH_PTHREAD_COND_INITIALIZER  PTHREAD_COND_INITIALIZER
#endif
#endif

// freebsd platform
#if (ALEPH_PLATFORM_PLATID == ALEPH_PLATFORM_FREEBSD)
#include <pthread.h>
#define  ALEPH_PTHREAD_ONCE_INIT         PTHREAD_ONCE_INIT
#define  ALEPH_PTHREAD_MUTEX_INITIALIZER PTHREAD_MUTEX_INITIALIZER
#define  ALEPH_PTHREAD_COND_INITIALIZER  PTHREAD_COND_INITIALIZER
#endif
