# ---------------------------------------------------------------------------
# - t_8002.als                                                              -
# - aleph:odb library test module                                           -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2003 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   table test module
# @author amaury darsch

# ethernix-library
interp:library "aleph-odb"

# create a new table
const tbl (aleph:odb:Table)

# set and check name
tbl:set-name    "table"
assert "table"  (tbl:get-name)

# add some info and check
tbl:add-info "info" 2000 0.0 't' true
trans  cell   (tbl:get-info 0)
assert "info" (cell:get)
assert "info" (tbl:eval-info 0)
trans  cell   (tbl:get-info 1)
assert 2000   (cell:get)
assert 2000   (tbl:eval-info 1)
trans  cell   (tbl:get-info 2)
assert 0.0    (cell:get)
assert 0.0    (tbl:eval-info 2)
trans  cell   (tbl:get-info 3)
assert 't'    (cell:get)
assert 't'    (tbl:eval-info 3)
trans  cell   (tbl:get-info 4)
assert true   (cell:get)
assert true   (tbl:eval-info 4)

# add in the table header and check
tbl:add-header "info" 2000
trans  cell   (tbl:get-header 0)
assert "info" (cell:get)
assert "info" (tbl:eval-header 0)
trans  cell   (tbl:get-header 1)
assert 2000   (cell:get)
assert 2000   (tbl:eval-header 1)

# add in the table footer and check
tbl:add-footer 2000 "info"
trans  cell   (tbl:get-footer 0)
assert 2000   (cell:get)
assert 2000   (tbl:eval-footer 0)
trans  cell   (tbl:get-footer 1)
assert "info" (cell:get)
assert "info" (tbl:eval-footer 1)

# add data to the table
tbl:add  "hello" "world"
assert 1 (tbl:length)
tbl:add  2000 2001
assert 2 (tbl:length)
