//==================================================================
/**
 *  @file  RUK_Handler.h
 *
 *  RUK_Handler.h,v 1.1 2004/07/01 21:00:24 jai Exp
 *
 *  @author Emre Turkay  <turkaye@dre.vanderbilt.edu>
 */
//=====================================================================

#ifndef RUK_HANDLER_H
#define RUK_HANDLER_H
#include /**/ "ace/pre.h"

#include "DeploymentC.h"
#include "Config_Handler_export.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
#pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "ace/SString.h"
#include <xercesc/util/XercesDefs.hpp>
#include <xercesc/dom/DOM.hpp>
#include "XercesString.h"

using Config_Handler::XStr;
using xercesc::XMLUni;
using xercesc::XMLString;
using xercesc::XMLException;
using xercesc::DOMException;
using xercesc::DOMBuilder;
using xercesc::DOMImplementationRegistry;
using xercesc::DOMImplementationLS;
using xercesc::DOMImplementation;
using xercesc::DOMText;
using xercesc::DOMNamedNodeMap;
using xercesc::DOMLocator;
using xercesc::DOMError;
using xercesc::DOMDocument;
using xercesc::DOMDocumentTraversal;
using xercesc::DOMNodeIterator;
using xercesc::DOMNode;
using xercesc::DOMNodeFilter;

namespace CIAO 
{
  namespace Config_Handler
  {

    /**
     * @class RUK_Handler
     *
     * @brief Handler class for <ResourceUsageKind> type
     *
     * This class defines handler methods to parse ResourceUsage
     * Kind types in the descriptor files. The corresponding
     * CORBA IDL type for the schema element is returned.
     *
     */

    class Config_Handler_Export RUK_Handler {
    public:

      /// Process elements of type ResourceUsageKind definitions in
      /// the description files.
      static void
	process_ResourceUsageKind (DOMNodeIterator *iter, ::Deployment::ResourceUsageKind &kind);
    };
    
  }

}

#include /**/ "ace/post.h"

#endif /* RUK_HANDLER_H */
