/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.util.Vector;

public class MultiColumn
extends BorderPanel
implements CbScrollbarCallback {
    MultiColumnCallback callback;
    String[] title;
    boolean adjustable = true;
    boolean drawlines = true;
    Color[][] colors = null;
    boolean enabled = true;
    boolean multiselect = false;
    int[] cpos;
    float[] cwidth;
    Vector[] list;
    CbScrollbar sb;
    int width;
    int height;
    Insets in;
    int sbwidth;
    int th;
    Image bim;
    Graphics bg;
    Font font = new Font("timesRoman", 0, 12);
    FontMetrics fnm;
    int coldrag = -1;
    int sel = -1;
    int[] sels = new int[0];
    int top = 0;
    long last;
    int rowh = 16;
    Event last_event;
    int sortcol;
    int sortdir;

    MultiColumn(String[] stringArray) {
        super(3, Util.dark_edge_hi, Util.body_hi);
        this.title = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            this.title[n] = stringArray[n];
            ++n;
        }
        this.list = new Vector[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.list[n2] = new Vector();
            ++n2;
        }
        this.cwidth = new float[stringArray.length];
        int n3 = 0;
        while (n3 < stringArray.length) {
            this.cwidth[n3] = 1.0f / (float)stringArray.length;
            ++n3;
        }
        this.cpos = new int[stringArray.length + 1];
        this.setLayout(null);
        this.sb = new CbScrollbar(0, this);
        this.add(this.sb);
    }

    MultiColumn(String[] stringArray, MultiColumnCallback multiColumnCallback) {
        this(stringArray);
        this.callback = multiColumnCallback;
    }

    void addItem(Object[] objectArray) {
        int n = 0;
        while (n < this.title.length) {
            this.list[n].addElement(objectArray[n]);
            ++n;
        }
        this.repaint();
        this.compscroll();
    }

    void addItems(Object[][] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            int n2 = 0;
            while (n2 < this.title.length) {
                this.list[n2].addElement(objectArray[n][n2]);
                ++n2;
            }
            ++n;
        }
        this.repaint();
        this.compscroll();
    }

    void modifyItem(Object[] objectArray, int n) {
        int n2 = 0;
        while (n2 < this.title.length) {
            this.list[n2].setElementAt(objectArray[n2], n);
            ++n2;
        }
        this.repaint();
        this.compscroll();
    }

    Object[] getItem(int n) {
        Object[] objectArray = new Object[this.title.length];
        int n2 = 0;
        while (n2 < this.title.length) {
            objectArray[n2] = this.list[n2].elementAt(n);
            ++n2;
        }
        return objectArray;
    }

    int selected() {
        return this.sel;
    }

    void select(int n) {
        this.sel = n;
        this.sels = new int[1];
        this.sels[0] = n;
        this.repaint();
    }

    void select(int[] nArray) {
        if (nArray.length == 0) {
            this.sel = -1;
            this.sels = new int[0];
        } else {
            this.sel = nArray[0];
            this.sels = nArray;
        }
        this.repaint();
    }

    int[] allSelected() {
        return this.sels;
    }

    void scrollto(int n) {
        int n2 = this.rows();
        if (n < this.top || n >= this.top + n2) {
            this.top = n - 1;
            if (this.top > this.list[0].size() - n2) {
                this.top = this.list[0].size() - n2;
            }
            this.sb.setValue(this.top);
            this.repaint();
        }
    }

    void deleteItem(int n) {
        int n2 = 0;
        while (n2 < this.title.length) {
            this.list[n2].removeElementAt(n);
            ++n2;
        }
        if (n == this.sel) {
            this.sel = -1;
        }
        int n3 = 0;
        while (n3 < this.sels.length) {
            if (this.sels[n3] == n) {
                int[] nArray = new int[this.sels.length - 1];
                if (nArray.length <= 0) break;
                System.arraycopy(this.sels, 0, nArray, 0, n3);
                System.arraycopy(this.sels, n3 + 1, nArray, n3, nArray.length - n3);
                this.sel = nArray[0];
                break;
            }
            ++n3;
        }
        this.repaint();
        this.compscroll();
    }

    void clear() {
        int n = 0;
        while (n < this.title.length) {
            this.list[n].removeAllElements();
            ++n;
        }
        this.sel = -1;
        this.sels = new int[0];
        this.top = 0;
        this.repaint();
        this.sb.setValues(0, 1, 0);
    }

    void setWidths(float[] fArray) {
        int n = 0;
        while (n < this.title.length) {
            this.cwidth[n] = fArray[n];
            ++n;
        }
        this.respace();
        this.repaint();
    }

    void setAdjustable(boolean bl) {
        this.adjustable = bl;
    }

    void setDrawLines(boolean bl) {
        this.drawlines = bl;
    }

    void setColors(Color[][] colorArray) {
        this.colors = colorArray;
        this.repaint();
    }

    void setMultiSelect(boolean bl) {
        this.multiselect = bl;
    }

    public void enable() {
        this.enabled = true;
        this.sb.enable();
        this.repaint();
    }

    public void disable() {
        this.enabled = false;
        this.sb.disable();
        this.repaint();
    }

    public void sortingArrow(int n, int n2) {
        this.sortcol = n;
        this.sortdir = n2;
        this.repaint();
    }

    public void setFont(Font font) {
        this.font = font;
        this.bim = null;
        this.repaint();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (n3 != this.width + this.sbwidth || n4 != this.height) {
            this.in = this.insets();
            this.sbwidth = this.sb.minimumSize().width;
            this.width = n3 - this.sbwidth - (this.in.left + this.in.right);
            this.height = n4 - (this.in.top + this.in.bottom);
            this.sb.reshape(this.width + this.in.left, this.in.top, this.sbwidth, this.height);
            this.respace();
            this.bim = null;
            this.repaint();
            this.compscroll();
        }
        super.reshape(n, n2, n3, n4);
    }

    void respace() {
        this.cpos[0] = 0;
        int n = 0;
        while (n < this.title.length) {
            this.cpos[n + 1] = this.cpos[n] + (int)((float)this.width * this.cwidth[n]);
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.bim == null) {
            this.bim = this.createImage(this.width, this.height);
            this.bg = this.bim.getGraphics();
            this.bg.setFont(this.font);
            this.fnm = this.bg.getFontMetrics();
            this.th = this.fnm.getHeight() + 4;
            this.render();
            this.compscroll();
        }
        graphics.drawImage(this.bim, this.in.left, this.in.top, this);
    }

    public void update(Graphics graphics) {
        if (this.fnm != null) {
            this.render();
            this.paint(graphics);
        }
    }

    void render() {
        int n;
        int n2 = this.fnm.getHeight();
        int n3 = this.fnm.getDescent();
        int n4 = this.fnm.getAscent();
        int n5 = Math.min(this.top + this.rows() - 1, this.list[0].size() - 1);
        this.bg.setColor(Util.body);
        this.bg.fillRect(0, 0, this.width, this.th);
        this.bg.setColor(Util.light_bg);
        this.bg.fillRect(0, this.th, this.width, this.height - this.th);
        Color color = Util.body_hi;
        if (this.enabled) {
            n = 0;
            while (n < this.sels.length) {
                if (this.sels[n] >= this.top && this.sels[n] <= n5) {
                    this.bg.setColor(this.sels[n] == this.sel ? Util.body : color);
                    this.bg.fillRect(0, this.th + (this.sels[n] - this.top) * this.rowh, this.width, this.rowh);
                }
                ++n;
            }
        }
        n = 0;
        while (n < this.title.length) {
            int n6 = this.cpos[n];
            int n7 = this.cpos[n + 1] - n6 - 1;
            this.bg.setColor(Util.light_edge);
            this.bg.drawLine(n6, 0, n6 + n7, 0);
            this.bg.drawLine(n6, 1, n6 + n7 - 1, 1);
            this.bg.drawLine(n6, 0, n6, this.th - 1);
            this.bg.drawLine(n6 + 1, 0, n6 + 1, this.th - 2);
            this.bg.setColor(Util.dark_edge);
            this.bg.drawLine(n6, this.th - 1, n6 + n7, this.th - 1);
            this.bg.drawLine(n6, this.th - 2, n6 + n7 - 1, this.th - 2);
            this.bg.drawLine(n6 + n7, this.th - 1, n6 + n7, 0);
            this.bg.drawLine(n6 + n7 - 1, this.th - 1, n6 + n7 - 1, 1);
            int n8 = this.fnm.stringWidth(this.title[n]);
            if (n8 < n7 - 6) {
                this.bg.drawString(this.title[n], n6 + (n7 - n8) / 2, this.th - n3 - 2);
            }
            int n9 = this.th - 8;
            if (this.sortcol == n && this.sortdir == 1) {
                this.bg.setColor(Util.light_edge);
                this.bg.drawLine(n6 + 4, this.th - 5, n6 + 4 + n9, this.th - 5);
                this.bg.drawLine(n6 + 4 + n9, this.th - 5, n6 + 4 + n9 / 2, this.th - 5 - n9);
                this.bg.setColor(Util.dark_edge);
                this.bg.drawLine(n6 + 4 + n9 / 2, this.th - 5 - n9, n6 + 4, this.th - 5);
            } else if (this.sortcol == n && this.sortdir == 2) {
                this.bg.setColor(Util.light_edge);
                this.bg.drawLine(n6 + 4 + n9 / 2, this.th - 5, n6 + 4 + n9, this.th - 5 - n9);
                this.bg.setColor(Util.dark_edge);
                this.bg.drawLine(n6 + 4, this.th - 5 - n9, n6 + 4 + n9, this.th - 5 - n9);
                this.bg.drawLine(n6 + 4, this.th - 5 - n9, n6 + 4 + n9 / 2, this.th - 5);
            }
            if (this.drawlines) {
                this.bg.setColor(Util.body);
                this.bg.drawLine(n6 + n7 - 1, this.th, n6 + n7 - 1, this.height);
                this.bg.setColor(Util.dark_edge);
                this.bg.drawLine(n6 + n7, this.th, n6 + n7, this.height);
            }
            int n10 = this.top;
            while (n10 <= n5) {
                Object object;
                Object e = this.list[n].elementAt(n10);
                if (e instanceof String) {
                    object = (String)e;
                    while (this.fnm.stringWidth((String)object) > n7 - 3) {
                        object = ((String)object).substring(0, ((String)object).length() - 1);
                    }
                    if (!this.enabled) {
                        this.bg.setColor(Util.body);
                    } else if (this.colors != null) {
                        this.bg.setColor(this.colors[n10][n]);
                    }
                    this.bg.drawString((String)object, n6 + 1, this.th + (n10 + 1 - this.top) * this.rowh - n3);
                } else if (e instanceof Image) {
                    object = (Image)e;
                    this.bg.drawImage((Image)object, n6 + 1, this.th + (n10 - this.top) * this.rowh, this);
                }
                ++n10;
            }
            ++n;
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (!this.enabled) {
            return true;
        }
        n -= this.in.left;
        this.coldrag = -1;
        if ((n2 -= this.in.top) < this.th) {
            int n3 = 0;
            while (n3 < this.title.length) {
                if (this.adjustable && n3 > 0 && Math.abs(this.cpos[n3] - n) < 3) {
                    this.coldrag = n3;
                } else if (n >= this.cpos[n3] && n < this.cpos[n3 + 1]) {
                    this.callback.headingClicked(this, n3);
                }
                ++n3;
            }
        } else {
            int n4 = (n2 - this.th) / this.rowh + this.top;
            if (n4 < this.list[0].size()) {
                boolean bl = false;
                if (event.when - this.last < 1000L && this.sel == n4) {
                    bl = true;
                } else {
                    this.last = event.when;
                }
                if (event.shiftDown() && this.multiselect && this.sel != -1) {
                    int n5 = this.sels[0];
                    if (n5 < n4) {
                        this.sels = new int[n4 - n5 + 1];
                        int n6 = n5;
                        while (n6 <= n4) {
                            this.sels[n6 - n5] = n6;
                            ++n6;
                        }
                    } else {
                        this.sels = new int[n5 - n4 + 1];
                        int n7 = n5;
                        while (n7 >= n4) {
                            this.sels[n5 - n7] = n7;
                            --n7;
                        }
                    }
                } else if (event.controlDown() && this.multiselect) {
                    int[] nArray = new int[this.sels.length + 1];
                    System.arraycopy(this.sels, 0, nArray, 0, this.sels.length);
                    nArray[this.sels.length] = n4;
                    this.sels = nArray;
                } else {
                    this.sels = new int[1];
                    this.sels[0] = n4;
                }
                this.sel = n4;
                this.repaint();
                this.last_event = event;
                if (this.callback != null) {
                    if (bl) {
                        this.callback.doubleClick(this, n4);
                    } else {
                        this.callback.singleClick(this, n4);
                    }
                } else {
                    this.getParent().postEvent(new Event(this, 1001, bl ? "Double" : "Single"));
                }
            }
        }
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (!this.enabled) {
            return true;
        }
        n2 -= this.in.top;
        if (this.coldrag != -1 && (n -= this.in.left) > this.cpos[this.coldrag - 1] + 3 && n < this.cpos[this.coldrag + 1] - 3) {
            this.cpos[this.coldrag] = n;
            this.cwidth[this.coldrag - 1] = (float)(this.cpos[this.coldrag] - this.cpos[this.coldrag - 1]) / (float)this.width;
            this.cwidth[this.coldrag] = (float)(this.cpos[this.coldrag + 1] - this.cpos[this.coldrag]) / (float)this.width;
            this.repaint();
        }
        return true;
    }

    public void moved(CbScrollbar cbScrollbar, int n) {
        this.moving(cbScrollbar, n);
    }

    public void moving(CbScrollbar cbScrollbar, int n) {
        this.top = this.sb.getValue();
        this.compscroll();
        this.repaint();
    }

    private void compscroll() {
        if (this.fnm == null) {
            return;
        }
        int n = this.rows();
        int n2 = this.list[0].size() - n;
        this.sb.setValues(this.top, n == 0 ? 1 : n, this.list[0].size());
    }

    private int rows() {
        return Math.min(this.height / this.rowh - 1, this.list[0].size());
    }

    public Dimension minimumSize() {
        return new Dimension(400, 100);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }
}

