/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import org.apache.xmlrpc.Base64;
import org.apache.xmlrpc.Formatter;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class XmlRpc
extends HandlerBase {
    public static final String version = "Apache XML-RPC 1.0";
    String methodName;
    private static Class parserClass;
    private static Hashtable saxDrivers;
    Stack values;
    Value currentValue;
    static Formatter dateformat;
    StringBuffer cdata;
    boolean readCdata;
    static final int STRING = 0;
    static final int INTEGER = 1;
    static final int BOOLEAN = 2;
    static final int DOUBLE = 3;
    static final int DATE = 4;
    static final int BASE64 = 5;
    static final int STRUCT = 6;
    static final int ARRAY = 7;
    int errorLevel;
    String errorMsg;
    static final int NONE = 0;
    static final int RECOVERABLE = 1;
    static final int FATAL = 2;
    static boolean keepalive;
    public static boolean debug;
    static final String[] types;
    static String encoding;
    static Properties encodings;

    public static void setDriver(String string) throws ClassNotFoundException {
        String string2 = null;
        try {
            string2 = (String)saxDrivers.get(string);
            if (string2 == null) {
                string2 = string;
            }
            parserClass = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClassNotFoundException("SAX driver not found: " + string2);
        }
    }

    public static void setDriver(Class clazz) {
        parserClass = clazz;
    }

    public static void setEncoding(String string) {
        encoding = string;
    }

    public String getEncoding() {
        return encodings.getProperty(encoding, encoding);
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    public static void setKeepAlive(boolean bl) {
        keepalive = bl;
    }

    public static boolean getKeepAlive() {
        return keepalive;
    }

    synchronized void parse(InputStream inputStream) throws Exception {
        this.errorLevel = 0;
        this.errorMsg = null;
        this.values = new Stack();
        if (this.cdata == null) {
            this.cdata = new StringBuffer(128);
        } else {
            this.cdata.setLength(0);
        }
        this.readCdata = false;
        this.currentValue = null;
        long l = System.currentTimeMillis();
        if (parserClass == null) {
            XmlRpc.setDriver(System.getProperty("sax.driver", "uk.co.wilson.xml.MinML"));
        }
        Parser parser = null;
        try {
            parser = (Parser)parserClass.newInstance();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new Exception("Can't create Parser: " + parserClass);
        }
        parser.setDocumentHandler(this);
        parser.setErrorHandler(this);
        parser.parse(new InputSource(inputStream));
        if (debug) {
            System.err.println("Spent " + (System.currentTimeMillis() - l) + " millis parsing");
        }
    }

    void writeObject(Object object, XmlWriter xmlWriter) {
        xmlWriter.startElement("value");
        if (object == null) {
            throw new RuntimeException("null value not supported by XML-RPC");
        }
        if (object instanceof String) {
            xmlWriter.chardata(object.toString());
        } else if (object instanceof Integer) {
            xmlWriter.startElement("int");
            xmlWriter.write(object.toString());
            xmlWriter.endElement("int");
        } else if (object instanceof Boolean) {
            xmlWriter.startElement("boolean");
            xmlWriter.write((Boolean)object != false ? "1" : "0");
            xmlWriter.endElement("boolean");
        } else if (object instanceof Double || object instanceof Float) {
            xmlWriter.startElement("double");
            xmlWriter.write(object.toString());
            xmlWriter.endElement("double");
        } else if (object instanceof Date) {
            xmlWriter.startElement("dateTime.iso8601");
            Date date = (Date)object;
            xmlWriter.write(dateformat.format(date));
            xmlWriter.endElement("dateTime.iso8601");
        } else if (object instanceof byte[]) {
            xmlWriter.startElement("base64");
            xmlWriter.write(Base64.encode((byte[])object));
            xmlWriter.endElement("base64");
        } else if (object instanceof Vector) {
            xmlWriter.startElement("array");
            xmlWriter.startElement("data");
            Vector vector = (Vector)object;
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                this.writeObject(vector.elementAt(n2), xmlWriter);
                ++n2;
            }
            xmlWriter.endElement("data");
            xmlWriter.endElement("array");
        } else if (object instanceof Hashtable) {
            xmlWriter.startElement("struct");
            Hashtable hashtable = (Hashtable)object;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object v = hashtable.get(string);
                xmlWriter.startElement("member");
                xmlWriter.startElement("name");
                xmlWriter.write(string);
                xmlWriter.endElement("name");
                this.writeObject(v, xmlWriter);
                xmlWriter.endElement("member");
            }
            xmlWriter.endElement("struct");
        } else {
            throw new RuntimeException("unsupported Java type: " + object.getClass());
        }
        xmlWriter.endElement("value");
    }

    abstract void objectParsed(Object var1);

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.readCdata) {
            return;
        }
        this.cdata.append(cArray, n, n2);
    }

    public void endElement(String string) throws SAXException {
        int n;
        if (debug) {
            System.err.println("endElement: " + string);
        }
        if (this.currentValue != null && this.readCdata) {
            this.currentValue.characterData(this.cdata.toString());
            this.cdata.setLength(0);
            this.readCdata = false;
        }
        if ("value".equals(string) && ((n = this.values.size()) < 2 || this.values.elementAt(n - 2).hashCode() != 6)) {
            Value value = this.currentValue;
            this.values.pop();
            if (n < 2) {
                this.objectParsed(value.value);
                this.currentValue = null;
            } else {
                this.currentValue = (Value)this.values.peek();
                this.currentValue.endElement(value);
            }
        }
        if ("member".equals(string)) {
            Value value = this.currentValue;
            this.values.pop();
            this.currentValue = (Value)this.values.peek();
            this.currentValue.endElement(value);
        } else if ("methodName".equals(string)) {
            this.methodName = this.cdata.toString();
            this.cdata.setLength(0);
            this.readCdata = false;
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (debug) {
            System.err.println("startElement: " + string);
        }
        if ("value".equals(string)) {
            Value value = new Value();
            this.values.push(value);
            this.currentValue = value;
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("methodName".equals(string)) {
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("name".equals(string)) {
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("string".equals(string)) {
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("i4".equals(string) || "int".equals(string)) {
            this.currentValue.setType(1);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("boolean".equals(string)) {
            this.currentValue.setType(2);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("double".equals(string)) {
            this.currentValue.setType(3);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("dateTime.iso8601".equals(string)) {
            this.currentValue.setType(4);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("base64".equals(string)) {
            this.currentValue.setType(5);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("struct".equals(string)) {
            this.currentValue.setType(6);
        } else if ("array".equals(string)) {
            this.currentValue.setType(7);
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        System.err.println("Error parsing XML: " + sAXParseException);
        this.errorLevel = 1;
        this.errorMsg = sAXParseException.toString();
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.err.println("Fatal error parsing XML: " + sAXParseException);
        this.errorLevel = 2;
        this.errorMsg = sAXParseException.toString();
    }

    static {
        saxDrivers = new Hashtable();
        saxDrivers.put("xerces", "org.apache.xerces.parsers.SAXParser");
        saxDrivers.put("xp", "com.jclark.xml.sax.Driver");
        saxDrivers.put("ibm1", "com.ibm.xml.parser.SAXDriver");
        saxDrivers.put("ibm2", "com.ibm.xml.parsers.SAXParser");
        saxDrivers.put("aelfred", "com.microstar.xml.SAXDriver");
        saxDrivers.put("oracle1", "oracle.xml.parser.XMLParser");
        saxDrivers.put("oracle2", "oracle.xml.parser.v2.SAXParser");
        saxDrivers.put("openxml", "org.openxml.parser.XMLSAXParser");
        dateformat = new Formatter();
        keepalive = false;
        debug = false;
        types = new String[]{"String", "Integer", "Boolean", "Double", "Date", "Base64", "Struct", "Array"};
        encoding = "UTF8";
        encodings = new Properties();
        ((Hashtable)encodings).put("UTF8", "UTF-8");
        ((Hashtable)encodings).put("ISO8859_1", "ISO-8859-1");
    }

    class XmlWriter {
        StringBuffer buf;
        String enc;

        public XmlWriter(StringBuffer stringBuffer) {
            this(stringBuffer, encoding);
        }

        public XmlWriter(StringBuffer stringBuffer, String string) {
            this.buf = stringBuffer;
            this.enc = string;
            String string2 = encodings.getProperty(string, string);
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"" + string2 + "\"?>");
        }

        public void startElement(String string) {
            this.buf.append("<");
            this.buf.append(string);
            this.buf.append(">");
        }

        public void endElement(String string) {
            this.buf.append("</");
            this.buf.append(string);
            this.buf.append(">");
        }

        public void emptyElement(String string) {
            this.buf.append("<");
            this.buf.append(string);
            this.buf.append("/>");
        }

        public void chardata(String string) {
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                switch (c) {
                    case '<': {
                        this.buf.append("&lt;");
                        break;
                    }
                    case '>': {
                        this.buf.append("&gt;");
                        break;
                    }
                    case '&': {
                        this.buf.append("&amp;");
                        break;
                    }
                    default: {
                        this.buf.append(c);
                    }
                }
                ++n2;
            }
        }

        public void write(char[] cArray) {
            this.buf.append(cArray);
        }

        public void write(String string) {
            this.buf.append(string);
        }

        public String toString() {
            return this.buf.toString();
        }

        public byte[] getBytes() throws UnsupportedEncodingException {
            return this.buf.toString().getBytes(this.enc);
        }
    }

    class Value {
        int type = 0;
        Object value;
        String nextMemberName;
        Hashtable struct;
        Vector array;

        public void endElement(Value value) {
            if (this.type == 7) {
                this.array.addElement(value.value);
            } else if (this.type == 6) {
                this.struct.put(this.nextMemberName, value.value);
            }
        }

        public void setType(int n) {
            this.type = n;
            if (n == 7) {
                this.value = this.array = new Vector();
            }
            if (n == 6) {
                this.value = this.struct = new Hashtable();
            }
        }

        public void characterData(String string) {
            switch (this.type) {
                case 1: {
                    this.value = new Integer(string.trim());
                    break;
                }
                case 2: {
                    this.value = new Boolean("1".equals(string.trim()));
                    break;
                }
                case 3: {
                    this.value = new Double(string.trim());
                    break;
                }
                case 4: {
                    try {
                        this.value = dateformat.parse(string.trim());
                        break;
                    }
                    catch (ParseException parseException) {
                        throw new RuntimeException(parseException.getMessage());
                    }
                }
                case 5: {
                    this.value = Base64.decode(string.toCharArray());
                    break;
                }
                case 0: {
                    this.value = string;
                    break;
                }
                case 6: {
                    this.nextMemberName = string;
                }
            }
        }

        public int hashCode() {
            return this.type;
        }

        public String toString() {
            return types[this.type] + " element " + this.value;
        }
    }
}

