/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.oscache.base;

import com.opensymphony.module.oscache.base.EntryRefreshPolicy;
import java.io.Serializable;

public class CacheEntry
implements Serializable {
    private static final byte NOT_YET = -1;
    private String key;
    private Object content = null;
    private EntryRefreshPolicy policy = null;
    private long lastUpdate = -1L;
    private long created = -1L;
    private boolean wasFlushed = false;

    public String getKey() {
        return this.key;
    }

    public Object getContent() {
        return this.content;
    }

    public synchronized void setContent(Object object) {
        this.content = object;
        this.lastUpdate = System.currentTimeMillis();
        this.wasFlushed = false;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(long l) {
        this.lastUpdate = l;
    }

    public long getCreated() {
        return this.created;
    }

    public boolean needsRefresh(int n) {
        boolean bl = this.lastUpdate == -1L ? true : (this.wasFlushed ? true : (this.policy != null ? this.policy.needsRefresh(this) : System.currentTimeMillis() >= this.lastUpdate + (long)(n * 1000)));
        return bl;
    }

    public void flush() {
        this.wasFlushed = true;
    }

    public CacheEntry(String string) {
        this(string, null);
    }

    public CacheEntry(String string, EntryRefreshPolicy entryRefreshPolicy) {
        this.key = string;
        this.policy = entryRefreshPolicy;
        this.created = System.currentTimeMillis();
    }
}

