
/**************************************************************************
 *                                                                        *
 *  BTools - Miscellaneous Java utility classes                           *
 *                                                                        *
 *  Copyright (c) 1998-2001, Ben Burton                                   *
 *  For further details contact Ben Burton (benb@acm.org).                *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or         *
 *  modify it under the terms of the GNU General Public License as        *
 *  published by the Free Software Foundation; either version 2 of the    *
 *  License, or (at your option) any later version.                       *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful, but   *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *  General Public License for more details.                              *
 *                                                                        *
 *  You should have received a copy of the GNU General Public             *
 *  License along with this program; if not, write to the Free            *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,        *
 *  MA 02111-1307, USA.                                                   *
 *                                                                        *
 **************************************************************************/

/* end stub */

package org.gjt.btools.gui.dialog;

import java.awt.*;
import javax.swing.*;
import org.gjt.btools.gui.component.PaddedPane;

/**
 * A message box for long messages.
 * This message box uses a text area with scrollbars to display its
 * message.
 * <p>
 * For shorter messages that shouldn't require scrollbars,
 * consider using class <tt>MessageBox</tt> instead.
 * <p>
 * For ease of use, several static methods are provided:  Methods
 * <tt>bgNote()</tt>, <tt>fgNote()</tt> and <tt>confirm()</tt> all accept
 * just a string message and
 * parent window as arguments.  An appropriate message box is automatically
 * created and, if appropriate, the corresponding button pressed is returned.
 *
 * @see org.gjt.btools.gui.dialog.MessageBoxBase
 * @see org.gjt.btools.gui.dialog.MessageBox
 */
public class LongMessageBox extends MessageBoxBase {
    /**
     * Number of rows in the text area.
     */
    public static final int rows = 6;

    /**
     * Number of columns in the text area.
     */
    public static final int cols = 80;

    /**
     * Creates a new message box with the given message and
     * title, and containing the specified set of buttons.
     * The buttons are specified by a bitwise OR-ing of the
     * predefined constants <tt>YES</tt>, <tt>NO</tt>,
     * <tt>OK</tt>, <tt>CANCEL</tt>.
     *
     * @param parent the parent window for the new dialog box.
     * @param title the title of the message box
     * @param msg the message to display in the message box.
     * @param buttons the set of buttons to be displayed.
     */
    public LongMessageBox(Frame parent, String title, String msg,
            int buttons) {
        super(parent, title, msg, buttons);
    }

    /**
     * Creates a new message box with the given message and
     * title, and containing the specified set of buttons.
     * The buttons are specified by a bitwise OR-ing of the
     * predefined constants <tt>YES</tt>, <tt>NO</tt>,
     * <tt>OK</tt>, <tt>CANCEL</tt>.
     *
     * @param parent the parent window for the new dialog box.
     * @param title the title of the message box
     * @param msg the message to display in the message box.
     * @param buttons the set of buttons to be displayed.
     */
    public LongMessageBox(Dialog parent, String title, String msg,
            int buttons) {
        super(parent, title, msg, buttons);
    }

    /**
     * Displays a message box with the given message and an <i>OK</i>
     * button, allowing the parent window to continue receiving input
     * as per normal.  This method displays the message box and returns
     * immediately, without waiting for the user to press a button.
     * <p>
     * This method uses <tt>runBoxBg()</tt> to display its message box.
     *
     * @param parent the parent window for the new dialog box.
     * @param msg the message to display in the message box.
     */
    public static void bgNote(Frame parent, String msg)    {
        new LongMessageBox(parent, "Note", msg, OK).runBoxBg();
    }

    /**
     * Displays a message box with the given message and an <i>OK</i>
     * button, allowing the parent window to continue receiving input
     * as per normal.  This method displays the message box and returns
     * immediately, without waiting for the user to press a button.
     * <p>
     * This method uses <tt>runBoxBg()</tt> to display its message box.
     *
     * @param parent the parent window for the new dialog box.
     * @param msg the message to display in the message box.
     */
    public static void bgNote(Dialog parent, String msg)    {
        new LongMessageBox(parent, "Note", msg, OK).runBoxBg();
    }

    /**
     * Displays a message box with the given message and <i>Yes/No</i>
     * buttons, blocking all input from the parent window until the
     * message box is closed.  This method does not return until a
     * button is pressed and the message box is closed.
     * <p>
     * This method uses <tt>runBox()</tt> to display its message box.
     *
     * @param parent the parent window for the new dialog box.
     * @param msg the message to display in the message box.
     * @return <tt>true</tt> if <i>Yes</i> was pressed;
     * <tt>false</tt> if <i>No</i> was pressed.
     */
    public static boolean confirm(Frame parent, String msg) {
        return (new LongMessageBox(parent, "Please Confirm",
            msg, YES | NO).runBox() == YES);
    }

    /**
     * Displays a message box with the given message and <i>Yes/No</i>
     * buttons, blocking all input from the parent window until the
     * message box is closed.  This method does not return until a
     * button is pressed and the message box is closed.
     * <p>
     * This method uses <tt>runBox()</tt> to display its message box.
     *
     * @param parent the parent window for the new dialog box.
     * @param msg the message to display in the message box.
     * @return <tt>true</tt> if <i>Yes</i> was pressed;
     * <tt>false</tt> if <i>No</i> was pressed.
     */
    public static boolean confirm(Dialog parent, String msg) {
        return (new LongMessageBox(parent, "Please Confirm",
            msg, YES | NO).runBox() == YES);
    }

    /**
     * Displays a message box with the given message and an <i>OK</i>
     * button, blocking all input from the parent window until the
     * message box is closed.  This method does not return until a
     * button is pressed and the message box is closed.
     * <p>
     * This method uses <tt>runBox()</tt> to display its message box.
     *
     * @param parent the parent window for the new dialog box.
     * @param msg the message to display in the message box.
     */
    public static void fgNote(Frame parent, String msg) {
        new LongMessageBox(parent, "Note", msg, OK).runBox();
    }

    /**
     * Displays a message box with the given message and an <i>OK</i>
     * button, blocking all input from the parent window until the
     * message box is closed.  This method does not return until a
     * button is pressed and the message box is closed.
     * <p>
     * This method uses <tt>runBox()</tt> to display its message box.
     *
     * @param parent the parent window for the new dialog box.
     * @param msg the message to display in the message box.
     */
    public static void fgNote(Dialog parent, String msg) {
        new LongMessageBox(parent, "Note", msg, OK).runBox();
    }

    protected Component initInformationComponent(String msg) {
        JTextArea text = new JTextArea(msg, rows, cols);
        text.setCaretPosition(0);
        text.setEditable(false);
        return new PaddedPane(new JScrollPane(text), 5);
    }
}

