/****************************************************************************
 *                                                                          *
 * Copyright 1999-2005 ATI Technologies Inc., Markham, Ontario, CANADA.     *
 * All Rights Reserved.                                                     *
 *                                                                          *
 * Your use and or redistribution of this software in source and \ or       *
 * binary form, with or without modification, is subject to: (i) your       *
 * ongoing acceptance of and compliance with the terms and conditions of    *
 * the ATI Technologies Inc. software End User License Agreement; and (ii)  *
 * your inclusion of this notice in any version of this software that you   *
 * use or redistribute.  A copy of the ATI Technologies Inc. software End   *
 * User License Agreement is included with this software and is also        *
 * available by contacting ATI Technologies Inc. at http://www.ati.com      *
 *                                                                          *
 ****************************************************************************/

/** \file fglrx_dm_proto.h
 * \brief Protocol definitions for the ATI Display Management extension
 */

#ifndef __FGLRX_DM_PROTO_H
#define __FGLRX_DM_PROTO_H

#ifndef XREP_SZ
#define XREP_SZ(name)       sizeof(x##name##Reply)
#endif
#ifndef XREQ_SZ
#define XREQ_SZ(name)       sizeof(x##name##Req)
#endif

#define X_FGLDALCWDDE                  16
#define X_FGLDALGetDTypesFromDVector   17
#define X_FGLEnableDisplays            18

/*****************************************************************************
 * FGLCWDDE headers
 *
 * These are variable size!
 */

/* requests must be multiple of 4 */
typedef struct _FGLDALCWDDE {
    CARD8   reqType;
    CARD8   fireglReqType;
    CARD16  length B16;
    /* specific */
    CARD32  screen B32;
    CARD32  escape B32;         /* command escape code */
    CARD32  index B32;          /* used as controller index by some commands */
    CARD32  driver B32;         /* used as driver index by some commands */
    CARD32  inputSize B32;      /* input size without command headers */
    CARD32  outputSize B32;     /* maximum expected output size */
    /* CWDDE input structure follows */
} xFGLDALCWDDEReq;

//  replies must be ...
//      - 4 byte alligned, 
//      - minimum 32 bytes (pad the structure)
typedef struct {
    BYTE    type;
    BYTE    pad1;
    CARD16  sequenceNumber B16;
    CARD32  length B32;
    /* specific */
    CARD32  infoSize B32;       /* produced output size */
    CARD32  ret B32;            /* CWDDE return code */
    CARD32  pad4 B32;
    CARD32  pad5 B32;
    CARD32  pad6 B32;
    CARD32  pad7 B32;
    /* CWDDE output structure follows */
} xFGLDALCWDDEReply;

#define sz_xFGLDALCWDDEReq      XREQ_SZ(FGLDALCWDDE)
#define sz_xFGLDALCWDDEReply    XREP_SZ(FGLDALCWDDE)

/*****************************************************************************
 * ProcFGLDALGetDTypesFromDVector
 */
typedef struct _FGLDALGetDTypesFromDVector {
    CARD8   reqType;
    CARD8   fireglReqType;
    CARD16  length B16;
    /* specific */
    CARD32  screen B32;
    CARD32  displayVector B32;
    CARD32  expansion B32;
} xFGLDALGetDTypesFromDVectorReq;

typedef struct {
    BYTE    type;
    BYTE    pad1;
    CARD16  sequenceNumber B16;
    CARD32  length B32;
    /* specific */
    CARD32  displayTypes B32;
    CARD32  pad3 B32;
    CARD32  pad4 B32;
    CARD32  pad5 B32;
    CARD32  pad6 B32;
    CARD32  pad7 B32;
} xFGLDALGetDTypesFromDVectorReply;

#define sz_xFGLDALGetDTypesFromDVectorReq    XREQ_SZ(FGLDALGetDTypesFromDVector)
#define sz_xFGLDALGetDTypesFromDVectorReply  XREP_SZ(FGLDALGetDTypesFromDVector)

/*****************************************************************************
 * ProcFGLEnableDisplays
 */
typedef struct _FGLEnableDisplays {
    CARD8   reqType;
    CARD8   fireglReqType;
    CARD16  length B16;
    /* specific */
    CARD32  screen B32;
    CARD32  primary B32;
    CARD32  secondary B32;
} xFGLEnableDisplaysReq;

typedef struct {
    BYTE    type;
    BYTE    pad1;
    CARD16  sequenceNumber B16;
    CARD32  length B32;
    /* specific */
    CARD32  result B32;
    CARD32  pad3 B32;
    CARD32  pad4 B32;
    CARD32  pad5 B32;
    CARD32  pad6 B32;
    CARD32  pad7 B32;
} xFGLEnableDisplaysReply;

#define sz_xFGLEnableDisplaysReq    XREQ_SZ(FGLEnableDisplays)
#define sz_xFGLEnableDisplaysReply  XREP_SZ(FGLEnableDisplays)

#endif /* __FGLRX_DM_PROTO_H */
