#include "FireGLControl.h"


#ifdef DEBUG_PANEL
#define DEB(s)  s
#else
#define DEB(s)
#endif /* DEBUG_PANEL */


extern bool bHasSecondary;
extern unsigned long ulDesktopSetup;


Page::Page( QWidget *parent, int Type, bool is_firegl ) : QWidget( parent, (const char *)0 )
{
  QFrame *Frame ;
  int     Cnt ;

  Frame = new QFrame ( this ) ;
  Frame->setGeometry ( 3, 3, PANEL_WIDTH - 24, PANEL_HEIGHT - 94 ) ;
  Frame->setFrameStyle ( QFrame::Panel | QFrame::Sunken ) ;

  DEB(printf("Type %d\n",Type)); 
  switch ( Type )
  {
    case INFO_PAGE :
    {
      QFrame   *pFrame1 ;
      InfoPage *pInfo ;

      pFrame1 = new QFrame ( Frame ) ;
      pFrame1->setGeometry ( 3, 3, PANEL_WIDTH - 24 - 6, PANEL_HEIGHT - 94 - 6 ) ;
      pFrame1->setFrameStyle ( QFrame::Panel | QFrame::Raised ) ;

      pInfo = new InfoPage ( (QWidget *)pFrame1, is_firegl ) ;
      pInfo->setGeometry ( 3, 3, PANEL_WIDTH - 24 - 12, PANEL_HEIGHT - 94 - 12 ) ;

      connect( parent, SIGNAL( Activate( int ) ), pInfo, SLOT( OnActivate( int ) ) );
      ((Sheet *)parent)->addTab ( (QWidget *)this, tr("Information") ) ;
      break ;
    }
    case DUALSCREEN_PAGE :
    {
      QFrame         *pFrame1 ;
      DualScreenPage *pDual ;

      pFrame1 = new QFrame ( Frame ) ;
      pFrame1->setGeometry ( 3, 3, PANEL_WIDTH - 24 - 6, PANEL_HEIGHT - 94 - 6 ) ;
      pFrame1->setFrameStyle ( QFrame::Panel | QFrame::Raised ) ;

      pDual = new DualScreenPage ( (QWidget *)pFrame1 ) ;
      pDual->setGeometry ( 3, 3, PANEL_WIDTH - 24 - 12, PANEL_HEIGHT - 94 - 12 ) ;

      connect( parent, SIGNAL( Activate( int ) ), pDual, SLOT( OnActivate( int ) ) );
      connect( parent, SIGNAL( Apply( int * ) ), pDual, SLOT( OnApply( int * ) ) );
      ((Sheet *)parent)->addTab ( (QWidget *)this, tr("DualScreen") ) ;
      break ;
    }
    case ADJUST_PAGE :
    {
      QTabWidget *pTab ;
      int iScreens = 1;

      if ((bHasSecondary) || (ulDesktopSetup))
      {
          iScreens = 2;
      }
      else
          iScreens = 1;

      pTab = new QTabWidget ( Frame ) ;
      pTab->setGeometry ( 3, 3, PANEL_WIDTH - 24 - 6, PANEL_HEIGHT - 94 -6 ) ;
      for ( Cnt = 0; Cnt < iScreens; Cnt++ )
      {
        AdjustPage *pAdjust ;
        QString     MonitorName ;

        MonitorName.sprintf ( tr("Screen %d"), Cnt + 1 ) ;
        pAdjust = new AdjustPage ( (QWidget *)pTab, Cnt ) ;
        pTab->addTab ( ( QWidget *)pAdjust, MonitorName ) ;
        connect ( parent, SIGNAL( Activate ( int ) ), pAdjust, SLOT(OnActivate( int ) ) );
        connect( parent, SIGNAL( Apply( int * ) ), pAdjust, SLOT( OnApply( int * ) ) );
        connect( parent, SIGNAL( Cancel( ) ), pAdjust, SLOT( OnCancel( ) ) );
      }
#if 0 // to get rid of the Monitor tags ...
    // new dual head mode (mjg,2002/06/18)
    AdjustPage *pAdjust ;
    QString     MonitorName ;
    MonitorName.sprintf ( tr("Monitor %d"), Cnt + 1 ) ;
    // mjg, 2002/06/18: 
    // to adjust the right monitor we have to insert the display instead of cnt.
    // how to get it?

    pAdjust = new AdjustPage ( (QWidget *)pTab, Cnt ) ;
    pTab->addTab ( ( QWidget *)pAdjust, MonitorName ) ;
    connect ( parent, SIGNAL( Activate ( int ) ), pAdjust, SLOT(OnActivate( int ) ) );
    connect( parent, SIGNAL( Apply( int * ) ), pAdjust, SLOT( OnApply( int * ) ) );
    connect( parent, SIGNAL( Cancel( ) ), pAdjust, SLOT( OnCancel( ) ) );
#endif // alternate path
      ((Sheet *)parent)->addTab ( (QWidget *)this, tr("Adjustment") ) ;
      break ;
    }

#ifdef FGL_TVOUT
    case ATITVO_PAGE: 
    {
      QFrame   *pFrame1 ;
      TVoutAdjustPage *pTVout ;

      pFrame1 = new QFrame ( Frame ) ;
      pFrame1->setGeometry ( 3, 3, PANEL_WIDTH - 24 - 6, PANEL_HEIGHT - 94 - 6 ) ;
      pFrame1->setFrameStyle ( QFrame::Panel | QFrame::Raised ) ;

      pTVout = new TVoutAdjustPage ( (QWidget *)pFrame1 ) ;
      pTVout->setGeometry ( 3, 3, PANEL_WIDTH - 24 - 12, PANEL_HEIGHT - 94 - 12 ) ;

      connect( parent, SIGNAL( Activate ( int ) ), pTVout, SLOT(OnActivate( int ) ) );
      connect( parent, SIGNAL( Apply( int * ) ), pTVout, SLOT( OnApply( int * ) ) );
      connect( parent, SIGNAL( Cancel( ) ), pTVout, SLOT( OnCancel( ) ) );
      ((Sheet *)parent)->addTab ( (QWidget *)this, tr("TV Out") ) ;
      break ;
    }
#endif // FGL_TVOUT
  }
}

// ### EOF ###
