#ifndef _FGLRX_EXTENSIONS_
#define _FGLRX_EXTENSIONS_
// === file FGLRXextensions.h ===

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

#include <X11/Xlib.h>

typedef struct {
    int             majorVersion;
    int             minorVersion;
    int             patchlevel;
    char            usBIOSVersionMajor;
    char            usBIOSVersionMinor;
    char            HasSecondary;
    int             BoardType;
    int             ChipType;
    int             VideoRam;
    char            sATiRevID[17]; // 1+16, for alignment
    char            usAGPTransferMode;
    unsigned int    uiAGPCapPtr;
    unsigned int    uiAGPStatus;
    unsigned int    uiAGPCommand;
    unsigned long   ulGamma1;
    unsigned long   ulGamma2;
    unsigned long   ulDriverType;
    unsigned long   ulDesktopSetup;
    unsigned long   ulPrimary;
} FGLRXDriverDataRec, *FGLRXDriverDataPtr;

extern Bool ExtGetDriverData(FGLRXDriverDataPtr pDriverData);


typedef struct {
    int Primary;
    int Desktop;
} FGLRXDisplaySettingsRec, *FGLRXDisplaySettingsPtr;

extern Bool ExtGetDisplaySettings(FGLRXDisplaySettingsPtr pDisplaySettings);
extern Bool ExtSetDisplaySettings(FGLRXDisplaySettingsPtr pDisplaySettings);


typedef struct {
    int             Monitor;
    unsigned long   ulGamma;
} FGLRXGammaSettingsRec, *FGLRXGammaSettingsPtr;

extern Bool ExtSetGamma(FGLRXGammaSettingsPtr pGammaSettings);


typedef struct {
    unsigned int    uCurCRTC, uPrevCRTC;
} FGLRXOverlayCRTCSettingsRec, *FGLRXOverlayCRTCSettingsPtr;

extern Bool ExtSetOverlayCRTC(FGLRXOverlayCRTCSettingsPtr pOverlayCRTCSettings);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif // _FGLRX_EXTENSIONS_
