/**********************************************************************
 * File:						coutln.c      (Formerly:  coutline.c)
 * Description: Code for the C_OUTLINE class.
 * Author:					Ray Smith
 * Created:					Mon Oct 07 16:01:57 BST 1991
 *
 * (C) Copyright 1991, Hewlett-Packard Ltd.
 ** Licensed under the Apache License, Version 2.0 (the "License");
 ** you may not use this file except in compliance with the License.
 ** You may obtain a copy of the License at
 ** http://www.apache.org/licenses/LICENSE-2.0
 ** Unless required by applicable law or agreed to in writing, software
 ** distributed under the License is distributed on an "AS IS" BASIS,
 ** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 ** See the License for the specific language governing permissions and
 ** limitations under the License.
 *
 **********************************************************************/

#ifndef           COUTLN_H
#define           COUTLN_H

#include          "grphics.h"
#include          "crakedge.h"
#include          "mod128.h"
#include          "bits16.h"
#include          "rect.h"
#include          "blckerr.h"

#define INTERSECTING    MAX_INT16//no winding number

                                 //mask to get step
#define STEP_MASK       (3<<(DIRBITS-1))
                                 //mask to get gradient
#define GRAD_MASK       ((1<<(DIRBITS-1))-1)

enum C_OUTLINE_FLAGS
{
  COUT_INVERSE                   //White on black blob
};

class DLLSYM C_OUTLINE;          //forward declaration

ELISTIZEH_S (C_OUTLINE)
class DLLSYM C_OUTLINE:public ELIST_LINK
{
  friend class C_OUTLINE_FRAG;
  public:
    C_OUTLINE() {  //empty constructor
      steps = NULL;
    }
    C_OUTLINE(                     //constructor
              CRACKEDGE *startpt,  //from edge detector
              ICOORD bot_left,     //bounding box //length of loop
              ICOORD top_right,
              INT16 length);
    C_OUTLINE(ICOORD startpt,    //start of loop
              UINT8 *new_steps,  //steps in loop
              INT16 length);     //length of loop
                                 //outline to copy
    C_OUTLINE(C_OUTLINE *srcline, FCOORD rotation);  //and rotate
    ~C_OUTLINE () {              //destructor
      if (steps != NULL)
        free_mem(steps); 
      steps = NULL;
    }

    BOOL8 flag(                               //test flag
               C_OUTLINE_FLAGS mask) const {  //flag to test
      return flags.bit (mask);
    }
    void set_flag(                       //set flag value
                  C_OUTLINE_FLAGS mask,  //flag to test
                  BOOL8 value) {         //value to set
      flags.set_bit (mask, value);
    }

    C_OUTLINE_LIST *child() {  //get child list
      return &children;
    }

                                 //access function
    const BOX &bounding_box() const { 
      return box;
    }
    void set_step(                    //set a step
                  INT16 stepindex,    //index of step
                  INT8 stepdir,       //chain code
                  DIR128 gradient) {  //gradient dir
                                 //difference
      gradient = gradient - (stepdir << (DIRBITS - 2));
      if (gradient.get_dir () >= MODULUS / 2) {
        ILLEGAL_GRADIENT.error ("C_OUTLINE::set_step", ABORT,
          "%d", gradient.get_dir ());
      }
      steps[stepindex] = (stepdir << (DIRBITS - 1)) | gradient.get_dir ();
      //squeeze into byte
    }
    void set_step(                    //set a step
                  INT16 stepindex,    //index of step
                  DIR128 stepdir,     //direction
                  DIR128 gradient) {  //gradient dir
                                 //clean it
      stepdir = stepdir.get_dir () & (STEP_MASK >> 1);
                                 //difference
      gradient = gradient - stepdir;
      if (gradient.get_dir () >= MODULUS / 2) {
        ILLEGAL_GRADIENT.error ("C_OUTLINE::set_step", ABORT,
          "%d", gradient.get_dir ());
      }
      steps[stepindex] = (stepdir.get_dir () << 1) | gradient.get_dir ();
      //squeeze into byte
    }

                                 //get start position
    const ICOORD &start_pos() const { 
      return start;
    }
    INT32 pathlength() const {  //get path length
      return stepcount;
    }
    DIR128 step_dir(                          //get step direction
                    INT16 stepindex) const {  //index of step
                                 //as a direction
      return DIR128 ((INT16) ((steps[stepindex] & STEP_MASK) >> 1));
    }
    ICOORD step(                         //get step vector
                INT16 stepindex) const;  //index of step
    DIR128 gradient(                          //get gradient vector
                    INT16 stepindex) const {  //index of step
      return DIR128 ((INT16) (((steps[stepindex] & STEP_MASK) >> 1)
        + (steps[stepindex] & GRAD_MASK)));
    }
    INT32 area();  //return area
    INT32 outer_area();  //return area
    INT32 count_transitions(                   //count maxima
                            INT32 threshold);  //size threshold

    BOOL8 operator< (            //containment test
      const C_OUTLINE & other) const;
    BOOL8 operator> (            //containment test
      C_OUTLINE & other) const
    {
      return other < *this;      //use the < to do it
    }
    INT16 winding_number(                       //get winding number
                         ICOORD testpt) const;  //around this point
                                 //get direction
    INT16 turn_direction() const; 
    void reverse();  //reverse direction

    void move(                    // reposition outline
              const ICOORD vec);  // by vector

    void plot(                       //draw one
              WINDOW window,         //window to draw in
              COLOUR colour) const;  //colour to draw it
    void plot_dirs(                       //draw one
                   WINDOW window,         //window to draw in
                   COLOUR colour) const;  //colour to draw it

    void prep_serialise() {  //set ptrs to counts
      children.prep_serialise ();
    }

    void dump(  //write external bits
              FILE *f) {
                                 //stepcount = # bytes
      serialise_bytes (f, (void *) steps, stepcount);
      children.dump (f);
    }

    void de_dump(  //read external bits
                 FILE *f) {
      steps = (UINT8 *) de_serialise_bytes (f, stepcount);
      children.de_dump (f);
    }

                                 //assignment
    make_serialise (C_OUTLINE) C_OUTLINE & operator= (
      const C_OUTLINE & source); //from this

  private:
    BOX box;                     //boudning box
    ICOORD start;                //start coord
    UINT8 *steps;                //step array
    INT16 stepcount;             //no of steps
    BITS16 flags;                //flags about outline
    C_OUTLINE_LIST children;     //child elements
    static ICOORD step_coords[4];
};
#endif
