# the schleuder config class - a simple container
module Schleuder
  # Provides schleuder.conf as object, contains default values for most settings
  class SchleuderConfig < Storage
    # Outgoing SMTP server address
    attr_accessor :smtp_host
    # Used as sender-address ans for determining the own gpg-key
    attr_accessor :myaddr
    # The address to which SchleuderLogger#fatal messages (and possibly also
    # SchleuderLogger#error messages) are reported 
    attr_accessor :superadminaddr
    # Name of the list-unspecific logfile (until the list object is instantiated)
    attr_accessor :logfile
    # Global loglevel: (ERROR || WARN || INFO || DEBUG)
    attr_accessor :loglevel
    # Directory which holds plugin-files
    attr_accessor :plugins_dir
    # Directory which holds one subdirectory for each list
    attr_accessor :lists_dir
    # Name of the list-specific file that holds the list configuration (YAML-formatted)
    attr_accessor :lists_configfile
    # Name of the list-specific logfile
    attr_accessor :lists_logfile
    # Name of the file that holds the members (YAML-formatted)
    attr_accessor :lists_memberfile
    # Name of the file that holds default settings for all lists (YAML-formatted)
    attr_accessor :lists_default_conf
    # GPG-Key type. Default: RSA
    attr_accessor :gpg_key_type
    # GPG-Key length. Default: 2048
    attr_accessor :gpg_key_length
    # GPG-Sub-Key type. Default: RSA
    attr_accessor :gpg_subkey_type
    # GPG-Sub-Key length. Default: 2048
    attr_accessor :gpg_subkey_length
    
    # Intantiate object, assign default values and overload with config-file
    def initialize(config_file=nil)
      conf_dir = '/etc/schleuder'
      config_file = conf_dir + '/schleuder.conf' unless config_file
      base = File.expand_path(File.dirname(__FILE__) + '/../..')
      # These are some "vendor defaults".
      # If you need to change these, put them into schleuder.conf
      @smtp_host = 'localhost'
      @myaddr = 'schleuder@localhost'
      @superadminaddr = 'root@localhost'
      @logfile = '/var/log/schleuder/schleuder.log'
      @loglevel = 'ERROR'
      @plugins_dir = base + '/plugins'
      @lists_dir = '/var/schleuderlists'
      @lists_configfile = 'list.conf'
      @lists_logfile = 'list.log'
      @lists_memberfile = 'members.conf'
      @lists_default_conf = conf_dir + '/default-list.conf'

      @gpg_key_type = 'RSA'
      @gpg_key_length = 2048
      @gpg_subkey_type = 'RSA'
      @gpg_subkey_length = 2048

      # overload with config_file 
      super config_file
    end
  end
end
