/* $Cambridge: hermes/src/prayer/utils/prayer-sem-prune.c,v 1.2 2008/05/19 15:56:03 dpc22 Exp $ */

/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2004 */
/* See the file NOTICE for conditions of use and distribution. */

#include "shared.h"

#ifdef MUTEX_SEMAPHORE

#include <sys/types.h>
#include <sys/ipc.h>
#ifndef __USE_GNU
#define __USE_GNU       /* Evil hack to get prototype for semtimedop */
#include <sys/sem.h>
#undef __USE_GNU
#endif

union semun {
    int val;
    struct semid_ds *buf;
    ushort *array;
};

static int
isinteger(char *s)
{
    if ((s == NULL) || (*s == '\0'))
        return(0);

    while (*s) {
        if (!isdigit(*s))
            return(0);
        s++;
    }
    return(1);
}

int
main(int argc, char *argv[])
{
    union semun ick;
    int sem_id;
    int i;

    if (argc < 2) {
        fprintf(stderr, "Arg: semaphore id (see ipcs -s)\n");
        exit(1);
    }

    for (i = 1 ; i < argc ; i++) {
        if (!isinteger(argv[i]))
            continue;

        sem_id = atoi(argv[i]);

        printf("Removing %d\n", sem_id);

        ick.val = 0;
        semctl(sem_id, 0, IPC_RMID, ick);
    }

    exit(0);
}

#else

int
main(int argc, char *argv[])
{
    exit(0);
}
#endif
