/* $Cambridge: hermes/src/prayer/cmd/cmd_init.c,v 1.2 2008/05/19 15:55:54 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

void cmd_init(struct session *session)
{
    struct config *config = session->config;
    struct request *request = session->request;
    struct options *options = session->options;
    MAILSTREAM *stream = session->stream;
    struct msgmap *zm = session->zm;
    struct prefs *prefs;
    char *body;
    unsigned long size;
    char *ua;
    char *hostname;
    char *name;
    char *pname;

    /* Record sucessful user login */
    if (!(ua = assoc_lookup(request->hdrs, "user-agent")))
        ua = "Unknown";

    if (config->log_name_nets &&
        ipaddr_compare_list(session->ipaddr, config->log_name_nets))
        hostname = ipaddr_name(session->ipaddr);
    else
        hostname = ipaddr_text(session->ipaddr);

    session_log(session, ("[cmd_init] User login "
                          "[Client: %s] [IMAP server: %s] [User agent: %s]"),
                hostname, session->imapd_server, ua);

    /* Read in and parse user preferences file */

    pname = session_mailbox_prefs(session, request->pool);
    stream = ml_open(session, stream, pname, OP_READONLY);

    if (stream && (stream->nmsgs >= 1)
        && (body = ml_fetch_body(session, stream, 1, "1", &size, 0))) {
        if (!options_parse(options, body, session)) {
            session_message(session,
                            "Invalid or obsolete preferences file");
            session_log(session,
                        "[cmd_init] Invalid or obsolete preferences file");
            options->save = T;
        }
    } else {
        session_message(session,
                        "No saved user preferences: using defaults");
        session_log(session,
                    "[cmd_init] No saved user preferences: using defaults");
    }

    prefs = options->prefs;

    /* Make session adopt user preferences */
    session_use_prefs(session, prefs, T);

    name = session_mailbox(session, request->pool, "inbox");
    /* Open inbox, reusing initial stream */
    if (!(stream = ml_open(session, stream, name, 0))) {
        /* Should be impossible */
        session_message(session, "Couldn't open inbox folder");
        session_log(session, "[cmd_init] Couldn't open inbox folder");
        session_redirect(session, request, "restart");
        return;
    }

    string_strdup(&session->foldername, "INBOX");
    session->stream = session->inbox_stream = stream;
    session->inbox_last_ping_time = time(NIL);

    /* Set up initial msgmap */
    msgmap_associate(zm, session, stream);
    msgmap_update(zm);

    /* Set current and last_displayed message to last or first in zoommap
     * (cmd_welcome may override with this last unread message) */
    if (zm->nmsgs > 0) {
        if (zm->sort_reverse)
            session->current = msgmap_value(zm, 1);
        else
            session->current = msgmap_value(zm, zm->nmsgs);
    } else
        session->current = 0;

    session->last_displayed = session->current;

    /* Define sane last_cmd: don't want to end up back here! */
    session_record_last_cmd(session, "list");

    if (session->user_agent->use_cookie)
        session_make_session_cookie_redirect(session, request,
                                             "check_cookie");
    else
        session_redirect(session, request, "welcome");
}
