// test_get_cnf_value.cpp : Defines the entry point for the console application.
//

#include "stdio.h"
#include "stdlib.h"
#include "myx_admin_public_interface.h"

void print_usage()
{
  printf("usage : test_get_cnf_value.exe <filename> <query_file>\n");
}

int main(int argc, char* argv[])
{
  if (argc<3)
  {
    print_usage();
  }
  else
  {
    MYX_ADMIN_LIB_ERROR error_code;

    FILE *query_file= fopen(argv[2],"r");
    if (!query_file)
    {
      fprintf(stderr,"can't open query file \"%s\"\n",
              argv[2]);
    }
    else
    {
      char section[200];
      char name[200];
      while (fgets(section, sizeof(section), query_file) &&
             fgets(name, sizeof(name), query_file))
      {
        size_t section_len= strlen(section);
        size_t name_len= strlen(name);
        if (name[name_len-1]!='\n' || section[section_len-1]!='\n')
          break;
        name[name_len-1]= 0;
        section[section_len-1]= 0;
        printf("\"%s\" / \"%s\" = ",section,name);
        const char * value= myx_get_cnf_value(argv[1], section,
                                              name, &error_code);
        if (!value)
        {
          printf("#error#(%d)\n",(int)error_code);
        }
        else
        {
          printf("\"%s\"\n",value);
        }
      }
      fclose(query_file);
    }
  }
  return 0;
}

