/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// autogenerated file with codegen.pl

#include "preextstl.h"
#include "cppunit/TestAssert.h"
#include "cppunit/TestFixture.h"
#include "cppunit/extensions/HelperMacros.h"
#include "postextstl.h"

#include <basegfx/vector/b2isize.hxx>
#include <basegfx/point/b2ipoint.hxx>

#include <basebmp/color.hxx>
#include <basebmp/scanlineformats.hxx>
#include <basebmp/bitmapdevice.hxx>
#include <basebmp/debug.hxx>
#include "tools.hxx"

#include <iostream>
#include <fstream>

using namespace ::basebmp;

namespace
{
/*
  std::ofstream output("32bpp_test.dump");
  debugDump( mpDevice32bpp, output );
*/

class LineTest : public CppUnit::TestFixture
{
private:
    BitmapDeviceSharedPtr mpDevice1bpp;
    BitmapDeviceSharedPtr mpDevice32bpp;

    void implTestBasicDiagonalLines(const BitmapDeviceSharedPtr& rDevice)
    {
        rDevice->clear(Color(0));

        const basegfx::B2IPoint aPt1(1,1);
        const basegfx::B2IPoint aPt2(9,9);
        const Color aCol(0xFFFFFFFF);
        rDevice->drawLine( aPt1, aPt2, aCol, DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("first pixel set",
                               rDevice->getPixel(aPt1) == aCol);
        CPPUNIT_ASSERT_MESSAGE("last pixel set",
                               rDevice->getPixel(aPt2) == aCol);
        const basegfx::B2IPoint aPt3(0,0);
        CPPUNIT_ASSERT_MESSAGE("topmost pixel not set",
                               rDevice->getPixel(aPt3) != aCol);
        const basegfx::B2IPoint aPt4(10,10);
        CPPUNIT_ASSERT_MESSAGE("bottommost pixel not set",
                               rDevice->getPixel(aPt4) != aCol);

        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 9",
                               countPixel( rDevice, aCol ) == 9);

        rDevice->drawLine( aPt2, aPt1, aCol, DrawMode_PAINT );

        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel after "
                               "reversed paint is not 9",
                               countPixel( rDevice, aCol ) == 9);
    }

    void implTestBasicHorizontalLines(const BitmapDeviceSharedPtr& rDevice)
    {
        rDevice->clear(Color(0));

        const basegfx::B2IPoint aPt1(10,10);
        const basegfx::B2IPoint aPt2(0,10);
        const Color aCol(0xFFFFFFFF);
        rDevice->drawLine( aPt1, aPt2, aCol, DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("first pixel set",
                               rDevice->getPixel(aPt1) == aCol);
        CPPUNIT_ASSERT_MESSAGE("last pixel set",
                               rDevice->getPixel(aPt2) == aCol);
        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 11",
                               countPixel( rDevice, aCol ) == 11);

        rDevice->clear(Color(0));
        rDevice->drawLine( aPt2, aPt1, aCol, DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("first pixel set",
                               rDevice->getPixel(aPt1) == aCol);
        CPPUNIT_ASSERT_MESSAGE("last pixel set",
                               rDevice->getPixel(aPt2) == aCol);
        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 11",
                               countPixel( rDevice, aCol ) == 11);
    }

    void implTestBasicVerticalLines(const BitmapDeviceSharedPtr& rDevice)
    {
        rDevice->clear(Color(0));

        const basegfx::B2IPoint aPt1(1,1);
        const basegfx::B2IPoint aPt2(1,9);
        const Color aCol(0xFFFFFFFF);
        rDevice->drawLine( aPt1, aPt2, aCol, DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("first pixel set",
                               rDevice->getPixel(aPt1) == aCol);
        CPPUNIT_ASSERT_MESSAGE("last pixel set",
                               rDevice->getPixel(aPt2) == aCol);
        const basegfx::B2IPoint aPt3(0,0);
        CPPUNIT_ASSERT_MESSAGE("topmost pixel not set",
                               rDevice->getPixel(aPt3) != aCol);
        const basegfx::B2IPoint aPt4(0,10);
        CPPUNIT_ASSERT_MESSAGE("bottommost pixel not set",
                               rDevice->getPixel(aPt4) != aCol);

        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 9",
                               countPixel( rDevice, aCol ) == 9);
    }

    // test pixel rounding (should always tend towards start point of
    // the line)
    void implTestTieBreaking(const BitmapDeviceSharedPtr& rDevice)
    {
        rDevice->clear(Color(0));

        const basegfx::B2IPoint aPt1(1,1);
        const basegfx::B2IPoint aPt2(3,2);
        const Color aCol(0xFFFFFFFF);
        rDevice->drawLine( aPt1, aPt2, aCol, DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("first pixel set",
                               rDevice->getPixel(aPt1) == aCol);
        CPPUNIT_ASSERT_MESSAGE("second pixel set",
                               rDevice->getPixel(basegfx::B2IPoint(2,1)) == aCol);
        CPPUNIT_ASSERT_MESSAGE("last pixel set",
                               rDevice->getPixel(aPt2) == aCol);
        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel after "
                               "reversed paint is not 3",
                               countPixel( rDevice, aCol ) == 3);

        rDevice->drawLine( aPt2, aPt1, aCol, DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("alternate second pixel set",
                               rDevice->getPixel(basegfx::B2IPoint(2,2)) == aCol);

        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel after "
                               "reversed paint is not 4",
                               countPixel( rDevice, aCol ) == 4);
    }

public:
    void setUp()
    {
        const basegfx::B2ISize aSize(11,11);
        mpDevice1bpp = createBitmapDevice( aSize,
                                           true,
                                           Format::ONE_BIT_MSB_PAL );
        mpDevice32bpp = createBitmapDevice( aSize,
                                           true,
                                           Format::THIRTYTWO_BIT_TC_MASK );
    }

    void testBasicDiagonalLines()
    {
        implTestBasicDiagonalLines( mpDevice1bpp );
        implTestBasicDiagonalLines( mpDevice32bpp );
    }

    void testBasicHorizontalLines()
    {
        implTestBasicHorizontalLines( mpDevice1bpp );
        implTestBasicHorizontalLines( mpDevice32bpp );
    }

    void testBasicVerticalLines()
    {
        implTestBasicVerticalLines( mpDevice1bpp );
        implTestBasicVerticalLines( mpDevice32bpp );
    }

    // test pixel rounding (should always tend towards start point of
    // the line)
    void testTieBreaking()
    {
        implTestTieBreaking( mpDevice1bpp );
        implTestTieBreaking( mpDevice32bpp );
    }

    // Change the following lines only, if you add, remove or rename
    // member functions of the current class,
    // because these macros are need by auto register mechanism.

    CPPUNIT_TEST_SUITE(LineTest);
    CPPUNIT_TEST(testBasicDiagonalLines);
    CPPUNIT_TEST(testBasicHorizontalLines);
    CPPUNIT_TEST(testBasicVerticalLines);
    CPPUNIT_TEST(testTieBreaking);
    CPPUNIT_TEST_SUITE_END();
};

// -----------------------------------------------------------------------------
CPPUNIT_TEST_SUITE_REGISTRATION(LineTest);
}


// -----------------------------------------------------------------------------

// this macro creates an empty function, which will called by the RegisterAllFunctions()
// to let the user the possibility to also register some functions by hand.
//NOADDITIONAL;

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
