/**
 * \file FormBrowser.C
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author John Levon
 *
 * Full author contact details are available in file CREDITS.
 */

#include <config.h>

#include "FormBrowser.h"
#include "forms/form_browser.h"
#include "xformsBC.h"

using std::string;

namespace lyx {
namespace frontend {

FormBrowser::FormBrowser(Dialog & parent,
			 string const & title, bool allowResize)
	: FormView<FD_browser>(parent, title, allowResize)
{}


void FormBrowser::build()
{
	dialog_.reset(build_browser(this));

	// Manage the close button
	bcview().setCancel(dialog_->button_close);
}

} // namespace frontend
} // namespace lyx
