/***************************************************************************
                          systemtraywidget.cpp  -  description
                             -------------------
    begin                : Sun Dec 29 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "systemtraywidget.h"

#include <kdebug.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <kiconloader.h>

#include "currentaccount.h"

// The constructor
SystemTrayWidget::SystemTrayWidget(QWidget *parent, const char *name )
 : KSystemTray(parent,name)
{
}



// The destructor
SystemTrayWidget::~SystemTrayWidget()
{
#ifdef KMESSDEBUG_SYSTEMTRAY
  kdDebug() << "DESTROYED SystemTrayWidget" << endl;
#endif
}



// Initialize the class
bool SystemTrayWidget::initialize()
{
  currentAccount_ = CurrentAccount::instance();
  connect( currentAccount_, SIGNAL( changedStatus() ),
           this,            SLOT  ( statusChanged() ) );
  return true;
}



// Return the context menu
KPopupMenu* SystemTrayWidget::menu() const
{
  return contextMenu();
}



// Change the icon when the user's status changes
void SystemTrayWidget::statusChanged()
{
  QString     iconName;
  KIconLoader *loader = KGlobal::iconLoader();
  QString     status;

  status = currentAccount_->getStatus();
  // Update the onlineStatusLabel and pixmap
  if ( status == "AWY" )
  {
    iconName = "away";
  }
  else if ( status == "BRB" )
  {
    iconName = "berightback";
  }
  else if ( status == "BSY" )
  {
    iconName = "busy";
  }
  else if ( status == "FLN" )
  {
    iconName = "offline";
  }
  else if ( status == "HDN" )
  {
    iconName = "invisible";
  }
  else if ( status == "IDL" )
  {
    iconName = "away";
  }
  else if ( status == "LUN" )
  {
    iconName = "lunch";
  }
  else if ( status == "NLN" )
  {
    iconName = "online";
  }
  else if ( status == "PHN" )
  {
    iconName = "onthephone";
  }
  else
  {
    kdDebug() << "KMessView - statusChanged() - The account had the invalid status " << status << "." << endl;
    return;
  }
  setPixmap( loader->loadIcon( iconName, KIcon::User ) );
}

#include "systemtraywidget.moc"
