#include "ssocket.h"
#include <openssl/rand.h>


SSocket::SSocket(QObject* parent): QObject(parent)
{
	connect(&socl,	SIGNAL(error(int)),	SLOT(onError(int)));
	connect(&socl,	SIGNAL(connected()),	SLOT(onConnected()));
	connect(&socl,	SIGNAL(readyRead()),	SLOT(onReadyRead()));
#if 0
	SSL_library_init();

	// z libgadu
	if (!RAND_status()) {
		char rdata[1024];
		struct {
			time_t time;
			void *ptr;
		} rstruct;

		time(&rstruct.time);
		rstruct.ptr = (void *) &rstruct;			

		RAND_seed((void *) rdata, sizeof(rdata));
		RAND_seed((void *) &rstruct, sizeof(rstruct));
	}
#endif

}
void SSocket::onError(int x)
{
	emit error(x);
}

void SSocket::onConnected()
{
	int err;
#if 0
	if(stype!=WithoutEncryption){

		ctx=SSL_CTX_new(TLSv1_client_method());
		// XXX - zrobić to lepiej
		SSL_CTX_set_verify(ctx, SSL_VERIFY_NONE, NULL);
		ssl=SSL_new(ctx);

		if(stype==StartTLS)
			socl.writeBlock("STLS", strlen("STLS"));
	}
#endif

	emit connected();
}

void SSocket::onReadyRead()
{
	emit readyRead();
}

void SSocket::setType(SecureType type)
{
	stype=type;
}

SecureType SSocket::getType()
{
	return stype;
}


QString SSocket::readLine()
{
	return socl.readLine();
}

void SSocket::flush()
{
	socl.flush();
}

void SSocket::close()
{
	socl.close();
}

Q_LONG SSocket::writeBlock(const char* data, Q_ULONG len)
{
	socl.writeBlock(data, len);
}

void SSocket::connectToHost(const QString& host, Q_UINT16 port)
{
	socl.connectToHost(host, port);
}

