dnl autoconf macfro for KADU
dnl author:
dnl Michal Podsiadlik <michal at kernel-panic.cjb.net>

AC_DEFUN(AM_PATH_KADU, [
AC_ARG_WITH(kadu-prefix,
	[  --with-kadu=PREFIX   Prefix where KADU is installed (optional)],
	kadu_prefix="$withval", kadu_prefix="")
AC_ARG_WITH(kadu-config,
	[  --with-kadu-config=PREFIX   Patch to kadu-config (optional)],
	kadu_config="$withval", kadu_prefix="")

if test "x$kadu_config" != "x" ; then
	KADU_CONFIG="$kadu_config"
elif test "x$kadu_prefix" != "x" ; then
	KADU_CONFIG="$kadu_prefix/bin/kadu-config"
else
	KADU_CONFIG="kadu-config"
fi

AC_MSG_CHECKING(for kadu)

kadu_version=`$KADU_CONFIG --version`

KADU_LIBS=`$KADU_CONFIG --libs`
KADU_CFLAGS=`$KADU_CONFIG --cflags`
KADU_DATA_DIR=`$KADU_CONFIG --data-dir`
KADU_MODULES_DIR=`$KADU_CONFIG --modules-dir`
KADU_MOC_DIR=`$KADU_CONFIG --qt-moc-dir`

if test "x$kadu_version" != "x" ; then
	AC_MSG_RESULT(yes)
	AC_SUBST(KADU_LIBS)
	AC_SUBST(KADU_CFLAGS)
	AC_SUBST(KADU_DATA_DIR)
	AC_SUBST(KADU_MODULES_DIR)
	AC_SUBST(KADU_MOC_DIR)
	ifelse([$2], , :, [$2])
else
	AC_MSG_RESULT(no)
	ifelse([$3], , :, [$3])
fi
])
