#ifndef KADU_AO_SOUND_H
#define KADU_AO_SOUND_H
#include <qobject.h>
#include <qstring.h>
#include <qthread.h>
#include <qmutex.h>
#include <qsemaphore.h>
#include <qvaluelist.h>

class SndParams2
{
	public:
		SndParams2(QString fm, bool volCntrl=false, float vol=1);
		SndParams2(const SndParams2 &p);
		SndParams2();

		QString filename;
		bool volumeControl;
		float volume;
};

class AOPlayThread : public QThread
{
	public:
		QMutex mutex;
		QSemaphore *semaphore; //suy do powiadamiania o dwiku w kolejce
		bool end;
		QValueList<SndParams2> list;
		
		AOPlayThread();
		~AOPlayThread();
		void run();
	private:
		static bool play(const char *path, bool &checkAgain, bool volCntrl=false, float vol=1);
};

class AOPlayerSlots : public QObject
{
	Q_OBJECT
	private:
		AOPlayThread *thread;
	public:
		AOPlayerSlots(QObject *parent=0, const char *name=0);
		~AOPlayerSlots();
		bool isOk();
	private slots:
		void playSound(const QString &s, bool volCntrl, double vol);
};

extern AOPlayerSlots *ao_player_slots;

#endif

