#ifndef XOSD_NOTIFY_H
#define XOSD_NOTIFY_H

#include <xosd.h>

#include <qobject.h>
#include <qtimer.h>
#include <qvaluelist.h>

#include "../notify/notify.h"
#include "xlfd_chooser.h"

class XOSDNotify : public Notifier
{
	Q_OBJECT
	private:
		struct OSDLine
		{
			xosd *handle;
			QString text;
			int timeout;
			QColor font_color;
			QColor outline_color;
			QColor shadow_color;
			QString font;

			int font_size;//warto pomocnicza
		};

		struct TestConfig
		{
			QString type;
			int position;
			QColor font_color, outline_color, shadow_color;
			QString font;
			int timeout;
			int shadow_offset, outline_offset;

			int font_size;//warto pomocnicza
		};
		QMap<QString, TestConfig> configs;

		struct offset
		{
			int x,y;
		} offsets[9];

		QValueList<OSDLine> lines[9];

		QTimer *timer;

		QString currentOptionPrefix;
		QStringList optionPrefixes;

		/**
			przeksztaca pozycj - liczb z zakresu 0..8 na zmienne typw
			xosd_pos(XOSD_left, XOSD_center, XOSD_right) i xosd_align(XOSD_top, XOSD_middle, XOSD_bottom)
		**/
		void position2PosAlign(int position, xosd_pos &pos, xosd_align &align);

		/**
			sprawdza rozmiar czcionki wedug XLFD,
			jeeli znajdzie odpowiednie pole to zwraca rozmiar czcionki,
			jeeli nie, to zwraca -1
		**/
		int getFontSize(const QString &xlfd);

		xosd *testXOSD;
	private slots:
		void oneSecond();
		/**
			odwiea wszystkie dymki na pozycji "position"
		**/
		void refresh(int position);

	public:
		XOSDNotify(QObject *parent=0, const char *name=0);
		~XOSDNotify();

	public slots:
		/**
			dodaj now lini tekstu na pozycji "position" (0..8) o czasie znikania "timeout"
			czcionce "font", kolorze "font_color", kolorze cienia "shadow_color" i przesuniciu "shadow_offset",
			kolorze obramwki "outline_color" i przesuniciu obramwki "outline_offset"
		**/
		void addLine(int position, const QString &text, int timeout,
					const QString &font=QString::null, const QColor &font_color=QColor(),
					const QColor &shadow_color=QColor(), int shadow_offset=0,
					const QColor &outline_color=QColor(), int outline_offset=0);

		void newChat(Protocol *protocol, UserListElements senders, const QString &msg, time_t t);
		void newMessage(Protocol *protocol, UserListElements senders, const QString &msg, time_t t, bool &grab);
		void connectionError(Protocol *protocol, const QString &message);
		void userChangedStatusToAvailable(const QString &protocolName, UserListElement);
		void userChangedStatusToBusy(const QString &protocolName, UserListElement);
		void userChangedStatusToInvisible(const QString &protocolName, UserListElement);
		void userChangedStatusToNotAvailable(const QString &protocolName, UserListElement);

		void userStatusChanged(UserListElement ule, QString protocolName, const UserStatus &oldStatus);

		/* inna informacja do powiadomienia */
		/* jeeli parameters == NULL, to brane s domylne ustawienia dla typu message
		 * w przeciwnym razie z mapy brane s nastpujce wartoci:
		 *		"Position"         - int
		 *		"Timeout"          - int
		 *		"Font"             - QString
		 *		"FontColor"        - QColor
		 *		"ShadowColor"      - QColor
		 *		"ShadowOffset"     - int
		 *		"OutlineColor"     - QColor
		 *		"OutlineOffset"    - int
		 *		"ShowSource"       - bool
		 * jeeli ktra z wartoci jest nieokrelona, to dla niej brana jest warto domylna
		 */
		void message(const QString &from, const QString &message, const QMap<QString, QVariant> *parameters, const UserListElement *ule);

		virtual void externalEvent(const QString &notifyType, const QString &msg, const UserListElements &ules);

	private slots:
		void test(const QString &text, const struct TestConfig &config);
		void destroyTest();

		void toggled_SetAll(bool);
		void clicked_Type(int);

		void clicked_Positions(int);
		void changed_Timeout(int);
		void changed_OutlineOffset(int);
		void changed_ShadowOffset(int);
		void clicked_ChangeFgColor();
		void clicked_ChangeOutlineColor();
		void clicked_ChangeShadowColor();
		void clicked_ChangeFont();
		void fontSelected(const QString &name);
		void clicked_Test();

		void clicked_Positions2(int);
		void changed_XOffset(int);
		void changed_YOffset(int);

		void toggled_ShowMessageContent(bool);
		void toggled_UseNotifySyntax(bool);

		void onCreateConfigDialog();
		void onApplyConfigDialog();
		void onCloseConfigDialog();
};

extern XLFDChooser *main_xlfd_chooser;
extern XOSDNotify *xosd_notify;
#endif
